/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.grammar.xmlschema;

import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.NameClass;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.xmlschema.LaxDefaultNameClass;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.grammar.xmlschema.XMLSchemaSchema;
import java.util.Iterator;

public class AttributeWildcard {
    private NameClass name;
    private int processMode;
    public static final int SKIP = 0;
    public static final int LAX = 1;
    public static final int STRICT = 2;

    public AttributeWildcard(NameClass nameClass, int n) {
        this.name = nameClass;
        this.processMode = n;
    }

    public NameClass getName() {
        return this.name;
    }

    public int getProcessMode() {
        return this.processMode;
    }

    public AttributeWildcard copy() {
        return new AttributeWildcard(this.name, this.processMode);
    }

    public Expression createExpression(XMLSchemaGrammar xMLSchemaGrammar) {
        ExpressionPool expressionPool = xMLSchemaGrammar.pool;
        switch (this.processMode) {
            case 0: {
                return expressionPool.createZeroOrMore(expressionPool.createAttribute(this.name));
            }
            case 1: 
            case 2: {
                Expression expression = Expression.epsilon;
                LaxDefaultNameClass laxDefaultNameClass = new LaxDefaultNameClass(this.name);
                Iterator iterator = xMLSchemaGrammar.iterateSchemas();
                while (iterator.hasNext()) {
                    XMLSchemaSchema xMLSchemaSchema = (XMLSchemaSchema)iterator.next();
                    if (!this.name.accepts(xMLSchemaSchema.targetNamespace, "*")) continue;
                    ReferenceExp[] referenceExpArray = xMLSchemaSchema.attributeDecls.getAll();
                    int n = 0;
                    while (n < referenceExpArray.length) {
                        expression = expressionPool.createSequence(expressionPool.createOptional(referenceExpArray[n]), expression);
                        laxDefaultNameClass.addName(xMLSchemaSchema.targetNamespace, referenceExpArray[n].name);
                        ++n;
                    }
                }
                if (this.processMode == 2) {
                    return expression;
                }
                return expressionPool.createSequence(expressionPool.createZeroOrMore(expressionPool.createAttribute(laxDefaultNameClass)), expression);
            }
        }
        throw new Error("undefined process mode:" + this.processMode);
    }
}

