/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd.datetime;

import com.sun.msv.datatype.xsd.datetime.BigTimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.IDateTimeValueType;
import com.sun.msv.datatype.xsd.datetime.ITimeDurationValueType;
import com.sun.msv.datatype.xsd.datetime.TimeZone;
import com.sun.msv.datatype.xsd.datetime.Util;
import java.math.BigDecimal;
import java.math.BigInteger;

public class BigDateTimeValueType
implements IDateTimeValueType {
    private BigInteger year;
    private Integer month;
    private Integer day;
    private Integer hour;
    private Integer minute;
    private BigDecimal second;
    private TimeZone zone;
    private IDateTimeValueType normalizedValue = null;

    public BigInteger getYear() {
        return this.year;
    }

    public Integer getMonth() {
        return this.month;
    }

    public Integer getDay() {
        return this.day;
    }

    public Integer getHour() {
        return this.hour;
    }

    public Integer getMinute() {
        return this.minute;
    }

    public BigDecimal getSecond() {
        return this.second;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    public BigDateTimeValueType(BigDateTimeValueType bigDateTimeValueType, TimeZone timeZone) {
        this(bigDateTimeValueType.year, bigDateTimeValueType.month, bigDateTimeValueType.day, bigDateTimeValueType.hour, bigDateTimeValueType.minute, bigDateTimeValueType.second, timeZone);
    }

    public BigDateTimeValueType(BigInteger bigInteger, int n, int n2, int n3, int n4, BigDecimal bigDecimal, TimeZone timeZone) {
        this(bigInteger, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), bigDecimal, timeZone);
    }

    public BigDateTimeValueType(BigInteger bigInteger, Integer n, Integer n2, Integer n3, Integer n4, BigDecimal bigDecimal, TimeZone timeZone) {
        this.year = bigInteger;
        this.month = n;
        this.day = n2;
        this.hour = n3;
        this.minute = n4;
        this.second = bigDecimal;
        this.zone = timeZone;
    }

    public BigDateTimeValueType() {
    }

    public BigDateTimeValueType getBigValue() {
        return this;
    }

    public boolean equals(Object object) {
        return this.equals((IDateTimeValueType)object);
    }

    public boolean equals(IDateTimeValueType iDateTimeValueType) {
        if (!(iDateTimeValueType instanceof BigDateTimeValueType)) {
            iDateTimeValueType = iDateTimeValueType.getBigValue();
        }
        return this.equals(this, (BigDateTimeValueType)iDateTimeValueType);
    }

    public boolean equals(BigDateTimeValueType bigDateTimeValueType, BigDateTimeValueType bigDateTimeValueType2) {
        return BigDateTimeValueType.compare(bigDateTimeValueType, bigDateTimeValueType2) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.year != null) {
            stringBuffer.append(this.year);
        }
        stringBuffer.append('-');
        if (this.month != null) {
            stringBuffer.append(this.month + 1);
        }
        stringBuffer.append('-');
        if (this.day != null) {
            stringBuffer.append(this.day + 1);
        }
        stringBuffer.append('T');
        if (this.hour != null) {
            stringBuffer.append(this.hour);
        }
        stringBuffer.append(':');
        if (this.minute != null) {
            stringBuffer.append(this.minute);
        }
        stringBuffer.append(':');
        if (this.second != null) {
            stringBuffer.append(this.second);
        }
        if (this.zone != null) {
            if (this.zone.minutes == 0) {
                stringBuffer.append('Z');
            } else {
                if (this.zone.minutes < 0) {
                    stringBuffer.append('-');
                } else {
                    stringBuffer.append('+');
                }
                stringBuffer.append(Math.abs(this.zone.minutes / 60));
                stringBuffer.append(Math.abs(this.zone.minutes % 60));
            }
        }
        return new String(stringBuffer);
    }

    public int hashCode() {
        BigDateTimeValueType bigDateTimeValueType = (BigDateTimeValueType)this.normalize();
        return Util.objHashCode(bigDateTimeValueType.year) + Util.objHashCode(bigDateTimeValueType.month) + Util.objHashCode(bigDateTimeValueType.day) + Util.objHashCode(bigDateTimeValueType.hour) + Util.objHashCode(bigDateTimeValueType.minute) + Util.objHashCode(bigDateTimeValueType.second) + Util.objHashCode(bigDateTimeValueType.zone);
    }

    public int compare(IDateTimeValueType iDateTimeValueType) {
        if (!(iDateTimeValueType instanceof BigDateTimeValueType)) {
            iDateTimeValueType = iDateTimeValueType.getBigValue();
        }
        return BigDateTimeValueType.compare(this, (BigDateTimeValueType)iDateTimeValueType);
    }

    protected static int compare(BigDateTimeValueType bigDateTimeValueType, BigDateTimeValueType bigDateTimeValueType2) {
        bigDateTimeValueType = (BigDateTimeValueType)bigDateTimeValueType.normalize();
        bigDateTimeValueType2 = (BigDateTimeValueType)bigDateTimeValueType2.normalize();
        if (bigDateTimeValueType.zone != null && bigDateTimeValueType2.zone != null || bigDateTimeValueType.zone == null && bigDateTimeValueType2.zone == null) {
            if (!Util.objEqual(bigDateTimeValueType.year, bigDateTimeValueType2.year)) {
                return Util.objCompare(bigDateTimeValueType.year, bigDateTimeValueType2.year);
            }
            if (!Util.objEqual(bigDateTimeValueType.month, bigDateTimeValueType2.month)) {
                return Util.objCompare(bigDateTimeValueType.month, bigDateTimeValueType2.month);
            }
            if (!Util.objEqual(bigDateTimeValueType.day, bigDateTimeValueType2.day)) {
                return Util.objCompare(bigDateTimeValueType.day, bigDateTimeValueType2.day);
            }
            if (!Util.objEqual(bigDateTimeValueType.hour, bigDateTimeValueType2.hour)) {
                return Util.objCompare(bigDateTimeValueType.hour, bigDateTimeValueType2.hour);
            }
            if (!Util.objEqual(bigDateTimeValueType.minute, bigDateTimeValueType2.minute)) {
                return Util.objCompare(bigDateTimeValueType.minute, bigDateTimeValueType2.minute);
            }
            if (!Util.objEqual(bigDateTimeValueType.second, bigDateTimeValueType2.second)) {
                return Util.objCompare(bigDateTimeValueType.second, bigDateTimeValueType2.second);
            }
            return 0;
        }
        if (bigDateTimeValueType.zone == null) {
            int n = BigDateTimeValueType.compare((BigDateTimeValueType)new BigDateTimeValueType(bigDateTimeValueType, Util.timeZoneNeg14).normalize(), bigDateTimeValueType2);
            if (n == 0 || n == -1) {
                return -1;
            }
            n = BigDateTimeValueType.compare((BigDateTimeValueType)new BigDateTimeValueType(bigDateTimeValueType, Util.timeZonePos14).normalize(), bigDateTimeValueType2);
            if (n == 0 || n == 1) {
                return 1;
            }
            return 999;
        }
        int n = BigDateTimeValueType.compare(bigDateTimeValueType, new BigDateTimeValueType(bigDateTimeValueType2, Util.timeZonePos14));
        if (n == 0 || n == -1) {
            return -1;
        }
        n = BigDateTimeValueType.compare(bigDateTimeValueType, new BigDateTimeValueType(bigDateTimeValueType2, Util.timeZoneNeg14));
        if (n == 0 || n == 1) {
            return 1;
        }
        return 999;
    }

    public IDateTimeValueType normalize() {
        if (this.zone == null || this.zone.minutes == 0) {
            return this;
        }
        if (this.normalizedValue != null) {
            return this.normalizedValue;
        }
        this.normalizedValue = this.add(BigTimeDurationValueType.fromMinutes(-this.zone.minutes));
        ((BigDateTimeValueType)this.normalizedValue).zone = TimeZone.GMT;
        return this.normalizedValue;
    }

    private static BigInteger nullAs0(BigInteger bigInteger) {
        if (bigInteger != null) {
            return bigInteger;
        }
        return BigInteger.ZERO;
    }

    private static BigDecimal nullAs0(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return bigDecimal;
        }
        return Util.decimal0;
    }

    private static BigInteger[] divideAndRemainder(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
        if (bigIntegerArray[1].signum() < 0) {
            bigIntegerArray[1] = bigIntegerArray[1].add(bigInteger2);
            bigIntegerArray[0] = bigIntegerArray[0].subtract(BigInteger.ONE);
        }
        return bigIntegerArray;
    }

    public IDateTimeValueType add(ITimeDurationValueType iTimeDurationValueType) {
        if (iTimeDurationValueType instanceof BigTimeDurationValueType) {
            int n;
            BigTimeDurationValueType bigTimeDurationValueType = (BigTimeDurationValueType)iTimeDurationValueType;
            BigInteger[] bigIntegerArray = BigDateTimeValueType.divideAndRemainder(Util.int2bi(this.month).add(bigTimeDurationValueType.month), Util.the12);
            int n2 = bigIntegerArray[1].intValue();
            BigInteger bigInteger = bigIntegerArray[0].add(BigDateTimeValueType.nullAs0(this.year)).add(BigDateTimeValueType.nullAs0(bigTimeDurationValueType.year));
            BigDecimal bigDecimal = BigDateTimeValueType.nullAs0(this.second).add(BigDateTimeValueType.nullAs0(bigTimeDurationValueType.second));
            bigIntegerArray = BigDateTimeValueType.divideAndRemainder(bigDecimal.unscaledValue(), Util.the60.multiply(Util.the10.pow(bigDecimal.scale())));
            BigDecimal bigDecimal2 = new BigDecimal(bigIntegerArray[1], bigDecimal.scale());
            bigIntegerArray = BigDateTimeValueType.divideAndRemainder(bigIntegerArray[0].add(Util.int2bi(this.minute)).add(bigTimeDurationValueType.minute), Util.the60);
            int n3 = bigIntegerArray[1].intValue();
            bigIntegerArray = BigDateTimeValueType.divideAndRemainder(bigIntegerArray[0].add(Util.int2bi(this.hour)).add(bigTimeDurationValueType.hour), Util.the24);
            int n4 = bigIntegerArray[1].intValue();
            int n5 = Util.maximumDayInMonthFor(bigInteger, n2);
            int n6 = n = this.day != null ? this.day : 0;
            int n7 = n < 0 ? 0 : (n >= n5 ? n5 - 1 : n);
            BigInteger bigInteger2 = bigTimeDurationValueType.day.add(bigIntegerArray[0]).add(Util.int2bi(n7));
            while (true) {
                int n8;
                if (bigInteger2.signum() == -1) {
                    bigInteger2 = bigInteger2.add(Util.int2bi(Util.maximumDayInMonthFor(bigInteger, (n2 + 11) % 12)));
                    n8 = -1;
                } else {
                    BigInteger bigInteger3 = Util.int2bi(Util.maximumDayInMonthFor(bigInteger, n2));
                    if (bigInteger2.compareTo(bigInteger3) < 0) break;
                    bigInteger2 = bigInteger2.subtract(bigInteger3);
                    n8 = 1;
                }
                if ((n2 += n8) < 0) {
                    n2 += 12;
                    bigInteger = bigInteger.subtract(BigInteger.ONE);
                }
                bigInteger = bigInteger.add(Util.int2bi(n2 / 12));
                n2 %= 12;
            }
            return new BigDateTimeValueType(this.year != null ? bigInteger : null, this.month != null ? new Integer(n2) : null, this.day != null ? new Integer(bigInteger2.intValue()) : null, this.hour != null ? new Integer(n4) : null, this.minute != null ? new Integer(n3) : null, this.second != null ? bigDecimal2 : null, this.zone);
        }
        return this.add(iTimeDurationValueType.getBigValue());
    }
}

