/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.voice.internal;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.audio.AudioException;
import org.openhab.core.audio.AudioFormat;
import org.openhab.core.audio.AudioSink;
import org.openhab.core.audio.AudioStream;
import org.openhab.core.audio.UnsupportedAudioFormatException;
import org.openhab.core.audio.UnsupportedAudioStreamException;
import org.openhab.core.audio.utils.ToneSynthesizer;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.i18n.TranslationProvider;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.types.Command;
import org.openhab.core.voice.BasicDTService;
import org.openhab.core.voice.DTErrorEvent;
import org.openhab.core.voice.DTEvent;
import org.openhab.core.voice.DTException;
import org.openhab.core.voice.DTService;
import org.openhab.core.voice.DTServiceHandle;
import org.openhab.core.voice.DTTriggeredEvent;
import org.openhab.core.voice.DialogContext;
import org.openhab.core.voice.KSErrorEvent;
import org.openhab.core.voice.KSEvent;
import org.openhab.core.voice.KSException;
import org.openhab.core.voice.KSListener;
import org.openhab.core.voice.KSService;
import org.openhab.core.voice.KSpottedEvent;
import org.openhab.core.voice.RecognitionStartEvent;
import org.openhab.core.voice.RecognitionStopEvent;
import org.openhab.core.voice.STTEvent;
import org.openhab.core.voice.STTException;
import org.openhab.core.voice.STTListener;
import org.openhab.core.voice.STTServiceHandle;
import org.openhab.core.voice.SpeechRecognitionErrorEvent;
import org.openhab.core.voice.SpeechRecognitionEvent;
import org.openhab.core.voice.TTSException;
import org.openhab.core.voice.Voice;
import org.openhab.core.voice.internal.VoiceManagerImpl;
import org.openhab.core.voice.text.HumanLanguageInterpreter;
import org.openhab.core.voice.text.InterpretationException;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class DialogProcessor
implements KSListener,
STTListener {
    private final Logger logger = LoggerFactory.getLogger(DialogProcessor.class);
    private final WeakHashMap<String, DialogContext> activeDialogGroups;
    public final DialogContext dialogContext;
    private @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    ToneSynthesizer.Tone> listeningMelody;
    private final EventPublisher eventPublisher;
    private final TranslationProvider i18nProvider;
    private final Bundle bundle;
    private final @Nullable AudioFormat ksFormat;
    private final @Nullable AudioFormat sttFormat;
    private final @Nullable AudioFormat ttsFormat;
    private final DialogEventListener eventListener;
    private boolean processing = false;
    private boolean isSTTServerAborting = false;
    private @Nullable DTServiceHandle dtServiceHandle;
    private @Nullable STTServiceHandle sttServiceHandle;
    private @Nullable AudioStream streamKS;
    private @Nullable AudioStream streamSTT;
    private @Nullable ToneSynthesizer toneSynthesizer;

    public DialogProcessor(DialogContext context, DialogEventListener eventListener, EventPublisher eventPublisher, WeakHashMap<String, DialogContext> activeDialogGroups, TranslationProvider i18nProvider, Bundle bundle) {
        AudioFormat audioFormat;
        this.dialogContext = context;
        this.eventListener = eventListener;
        this.eventPublisher = eventPublisher;
        this.i18nProvider = i18nProvider;
        this.activeDialogGroups = activeDialogGroups;
        this.bundle = bundle;
        DTService dt = context.dt();
        if (dt instanceof KSService) {
            KSService ks = (KSService)dt;
            audioFormat = VoiceManagerImpl.getBestMatch(context.source().getSupportedFormats(), ks.getSupportedFormats());
        } else {
            audioFormat = null;
        }
        this.ksFormat = audioFormat;
        this.sttFormat = VoiceManagerImpl.getBestMatch(context.source().getSupportedFormats(), context.stt().getSupportedFormats());
        this.ttsFormat = VoiceManagerImpl.getBestMatch(context.tts().getSupportedFormats(), context.sink().getSupportedFormats());
        this.initToneSynthesizer(context.listeningMelody());
    }

    private void initToneSynthesizer(@Nullable String listeningMelodyText) {
        @Nullable List listeningMelody = null;
        ToneSynthesizer toneSynthesizer = null;
        if (listeningMelodyText != null && !listeningMelodyText.isBlank()) {
            try {
                listeningMelody = ToneSynthesizer.parseMelody((String)listeningMelodyText);
                AudioFormat synthesizerFormat = VoiceManagerImpl.getBestMatch(ToneSynthesizer.getSupportedFormats(), this.dialogContext.sink().getSupportedFormats());
                if (synthesizerFormat != null) {
                    toneSynthesizer = new ToneSynthesizer(synthesizerFormat);
                    this.logger.debug("Sounds enabled");
                } else {
                    this.logger.warn("Sounds disabled, synthesizer is not compatible with this sink");
                }
            }
            catch (ParseException e) {
                this.logger.warn("Sounds disabled, unable to parse 'listening' melody: {}", (Object)e.getMessage());
            }
        }
        this.toneSynthesizer = toneSynthesizer;
        this.listeningMelody = listeningMelody;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public @Nullable DTServiceHandle start() throws IllegalStateException {
        DTService dtService = this.dialogContext.dt();
        String keyword = this.dialogContext.keyword();
        if (dtService == null) throw new IllegalStateException("Unable to run persistent dialog ks service is not configured");
        if (keyword == null) throw new IllegalStateException("Unable to run persistent dialog ks service is not configured");
        this.abortKS();
        this.closeStreamKS();
        try {
            if (dtService instanceof KSService) {
                AudioStream stream;
                KSService ksService = (KSService)dtService;
                AudioFormat fmt = this.ksFormat;
                if (fmt == null) {
                    this.logger.warn("No compatible audio format found for ks '{}' and source '{}'", (Object)ksService.getId(), (Object)this.dialogContext.source().getId());
                    return null;
                }
                this.streamKS = stream = this.dialogContext.source().getInputStream(fmt);
                this.dtServiceHandle = ksService.spot(this, stream, this.dialogContext.locale(), keyword);
            } else if (dtService instanceof BasicDTService) {
                BasicDTService basicDTService = (BasicDTService)dtService;
                this.dtServiceHandle = basicDTService.registerListener(this);
            } else {
                this.logger.warn("Voice manager is not able to handle this DTService implementation '{}'", (Object)dtService.getClass().getName());
            }
            this.playStartSound();
            return this.dtServiceHandle;
        }
        catch (AudioException e) {
            this.logger.warn("Encountered audio error: {}", (Object)e.getMessage());
            return null;
        }
        catch (KSException e) {
            this.logger.warn("Encountered error calling spot: {}", (Object)e.getMessage());
            this.closeStreamKS();
            return null;
        }
        catch (DTException e) {
            this.logger.warn("Encountered error starting the dialog trigger: {}", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSimpleDialog() {
        block12: {
            WeakHashMap<String, DialogContext> weakHashMap = this.activeDialogGroups;
            synchronized (weakHashMap) {
                if (this.activeDialogGroups.containsKey(this.dialogContext.dialogGroup())) {
                    this.logger.warn("Ignoring keyword spotting event, dialog group '{}' running", (Object)this.dialogContext.dialogGroup());
                    return;
                }
                this.logger.debug("Acquiring dialog group '{}'", (Object)this.dialogContext.dialogGroup());
                this.activeDialogGroups.put(this.dialogContext.dialogGroup(), this.dialogContext);
            }
            this.closeStreamSTT();
            this.isSTTServerAborting = false;
            AudioFormat fmt = this.sttFormat;
            if (fmt == null) {
                this.logger.warn("No compatible audio format found for stt '{}' and source '{}'", (Object)this.dialogContext.stt().getId(), (Object)this.dialogContext.source().getId());
                return;
            }
            this.playOnListeningSound();
            try {
                AudioStream stream;
                this.streamSTT = stream = this.dialogContext.source().getInputStream(fmt);
                this.sttServiceHandle = this.dialogContext.stt().recognize(this, stream, this.dialogContext.locale(), new HashSet<String>());
                return;
            }
            catch (AudioException e) {
                this.logger.warn("Error creating the audio stream: {}", (Object)e.getMessage());
            }
            catch (STTException e) {
                this.closeStreamSTT();
                String msg = e.getMessage();
                String text = this.i18nProvider.getText(this.bundle, "error.stt-exception", null, this.dialogContext.locale());
                if (msg != null) {
                    this.say(text == null ? msg : text.replace("{0}", msg));
                }
                if (text == null) break block12;
                this.say(text.replace("{0}", ""));
            }
        }
        WeakHashMap<String, DialogContext> weakHashMap = this.activeDialogGroups;
        synchronized (weakHashMap) {
            this.logger.debug("Releasing dialog group '{}' due to errors", (Object)this.dialogContext.dialogGroup());
            this.activeDialogGroups.remove(this.dialogContext.dialogGroup());
        }
    }

    public void stop() {
        this.abortSTT();
        this.closeStreamSTT();
        this.abortKS();
        this.closeStreamKS();
        this.toggleProcessing(false);
        this.playStopSound();
        this.eventListener.onDialogStopped(this.dialogContext);
    }

    public DialogContext getContext() {
        return this.dialogContext;
    }

    public boolean isProcessing() {
        return this.processing;
    }

    private void abortKS() {
        DTServiceHandle handle = this.dtServiceHandle;
        if (handle != null) {
            handle.abort();
            this.dtServiceHandle = null;
        }
    }

    private void closeStreamKS() {
        AudioStream stream = this.streamKS;
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                this.logger.debug("IOException closing ks audio stream: {}", (Object)e.getMessage(), (Object)e);
            }
            this.streamKS = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortSTT() {
        STTServiceHandle handle = this.sttServiceHandle;
        if (handle != null) {
            handle.abort();
            this.sttServiceHandle = null;
        }
        this.isSTTServerAborting = true;
        WeakHashMap<String, DialogContext> weakHashMap = this.activeDialogGroups;
        synchronized (weakHashMap) {
            this.logger.debug("Releasing dialog group '{}'", (Object)this.dialogContext.dialogGroup());
            this.activeDialogGroups.remove(this.dialogContext.dialogGroup());
        }
    }

    private void closeStreamSTT() {
        AudioStream stream = this.streamSTT;
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                this.logger.debug("IOException closing stt audio stream: {}", (Object)e.getMessage(), (Object)e);
            }
            this.streamSTT = null;
        }
    }

    private void toggleProcessing(boolean value) {
        if (this.processing == value) {
            return;
        }
        this.processing = value;
        String item = this.dialogContext.listeningItem();
        if (item != null && ItemUtil.isValidItemName((String)item)) {
            this.eventPublisher.post((Event)ItemEventFactory.createCommandEvent((String)item, (Command)OnOffType.from((boolean)value)));
        }
    }

    @Override
    public void dtEventReceived(DTEvent dtEvent) {
        this.isSTTServerAborting = false;
        if (dtEvent instanceof DTTriggeredEvent) {
            this.logger.debug("{} event received", (Object)(dtEvent instanceof KSpottedEvent ? "KSpottedEvent" : "DTTriggeredEvent"));
            try {
                this.startSimpleDialog();
            }
            catch (IllegalStateException e) {
                this.logger.warn("{}", (Object)e.getMessage());
            }
        } else if (dtEvent instanceof DTErrorEvent) {
            DTErrorEvent dte = (DTErrorEvent)dtEvent;
            this.logger.debug("{} event received", (Object)(dte instanceof KSErrorEvent ? "KSErrorEvent" : "DTErrorEvent"));
            String text = this.i18nProvider.getText(this.bundle, "error.ks-error", null, this.dialogContext.locale());
            this.say(text == null ? dte.getMessage() : text.replace("{0}", dte.getMessage()));
        }
    }

    @Override
    public void ksEventReceived(KSEvent ksEvent) {
        this.dtEventReceived(ksEvent);
    }

    @Override
    public synchronized void sttEventReceived(STTEvent sttEvent) {
        if (sttEvent instanceof SpeechRecognitionEvent) {
            SpeechRecognitionEvent sre = (SpeechRecognitionEvent)sttEvent;
            this.logger.debug("SpeechRecognitionEvent event received");
            if (!this.isSTTServerAborting) {
                String question = sre.getTranscript();
                this.logger.debug("Text recognized: {}", (Object)question);
                this.toggleProcessing(false);
                this.eventListener.onBeforeDialogInterpretation(this.dialogContext);
                String answer = "";
                String error = null;
                for (HumanLanguageInterpreter interpreter : this.dialogContext.hlis()) {
                    try {
                        answer = interpreter.interpret(this.dialogContext.locale(), question, this.dialogContext);
                        this.logger.debug("Interpretation result: {}", (Object)answer);
                        error = null;
                        break;
                    }
                    catch (InterpretationException e) {
                        this.logger.debug("Interpretation exception: {}", (Object)e.getMessage());
                        error = Objects.requireNonNullElse(e.getMessage(), "Unexpected error");
                    }
                }
                this.say(error != null ? error : answer);
                this.abortSTT();
            }
        } else if (sttEvent instanceof RecognitionStartEvent) {
            this.logger.debug("RecognitionStartEvent event received");
            this.toggleProcessing(true);
        } else if (sttEvent instanceof RecognitionStopEvent) {
            this.logger.debug("RecognitionStopEvent event received");
            this.toggleProcessing(false);
        } else if (sttEvent instanceof SpeechRecognitionErrorEvent) {
            SpeechRecognitionErrorEvent sre = (SpeechRecognitionErrorEvent)sttEvent;
            String message = sre.getMessage();
            this.logger.debug("SpeechRecognitionErrorEvent event received: {}", (Object)message);
            if (!this.isSTTServerAborting) {
                this.abortSTT();
                this.toggleProcessing(false);
                if (!message.isEmpty()) {
                    this.say(message);
                }
            }
        }
    }

    protected void say(@Nullable String text) {
        block11: {
            if (text == null || text.isEmpty()) {
                this.logger.debug("Empty value, nothing to say");
                return;
            }
            try {
                Voice voice = null;
                for (Voice currentVoice : this.dialogContext.tts().getAvailableVoices()) {
                    if (!this.dialogContext.locale().getLanguage().equals(currentVoice.getLocale().getLanguage())) continue;
                    Voice prefVoice = this.dialogContext.voice();
                    if (voice != null && (prefVoice == null || !prefVoice.getUID().equals(currentVoice.getUID()))) continue;
                    voice = currentVoice;
                }
                if (voice == null) {
                    throw new TTSException("Unable to find a suitable voice");
                }
                AudioFormat audioFormat = this.ttsFormat;
                if (audioFormat == null) {
                    throw new TTSException("No compatible audio format found for TTS '" + this.dialogContext.tts().getId() + "' and sink '" + this.dialogContext.sink().getId() + "'");
                }
                AudioStream audioStream = this.dialogContext.tts().synthesize(text, voice, audioFormat);
                if (this.dialogContext.sink().getSupportedStreams().stream().anyMatch(clazz -> clazz.isInstance(audioStream))) {
                    try {
                        this.dialogContext.sink().process(audioStream);
                    }
                    catch (UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Error saying '{}': {}", new Object[]{text, e.getMessage(), e});
                            break block11;
                        }
                        this.logger.warn("Error saying '{}': {}", (Object)text, (Object)e.getMessage());
                    }
                    break block11;
                }
                this.logger.warn("Failed playing audio stream '{}' as audio doesn't support it.", (Object)audioStream);
            }
            catch (TTSException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Error saying '{}': {}", new Object[]{text, e.getMessage(), e});
                }
                this.logger.warn("Error saying '{}': {}", (Object)text, (Object)e.getMessage());
            }
        }
    }

    private void playStartSound() {
        this.playNotes(Stream.of(ToneSynthesizer.Note.G, ToneSynthesizer.Note.A, ToneSynthesizer.Note.B).map(note -> ToneSynthesizer.noteTone((ToneSynthesizer.Note)note, (long)100L)).toList());
    }

    private void playStopSound() {
        this.playNotes(Stream.of(ToneSynthesizer.Note.B, ToneSynthesizer.Note.A, ToneSynthesizer.Note.G).map(note -> ToneSynthesizer.noteTone((ToneSynthesizer.Note)note, (long)100L)).toList());
    }

    private void playOnListeningSound() {
        List<ToneSynthesizer.Tone> listeningMelody = this.listeningMelody;
        if (listeningMelody != null) {
            this.playNotes(listeningMelody);
        }
    }

    private void playNotes(List<ToneSynthesizer.Tone> notes) {
        ToneSynthesizer toneSynthesizer = this.toneSynthesizer;
        if (toneSynthesizer != null) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (AudioStream stream = toneSynthesizer.getStream(notes);){
                    AudioSink sink = this.dialogContext.sink();
                    if (sink.getSupportedStreams().stream().anyMatch(clazz -> clazz.isInstance(stream))) {
                        sink.process(stream);
                    } else {
                        this.logger.warn("Failed playing synthesizer sound as audio sink doesn't support it.");
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | UnsupportedAudioFormatException | UnsupportedAudioStreamException e) {
                this.logger.warn("{} playing synthesizer sound: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    public boolean isCompatible(DialogProcessor dialogProcessor) {
        return this.dialogContext.sink().equals(dialogProcessor.dialogContext.sink()) && this.dialogContext.source().equals(dialogProcessor.dialogContext.source()) && this.dialogContext.stt().equals(dialogProcessor.dialogContext.stt()) && this.dialogContext.tts().equals(dialogProcessor.dialogContext.tts()) && Objects.equals(this.dialogContext.voice(), dialogProcessor.dialogContext.voice()) && this.dialogContext.hlis().size() == dialogProcessor.dialogContext.hlis().size() && this.dialogContext.hlis().containsAll(dialogProcessor.dialogContext.hlis()) && this.dialogContext.locale().equals(dialogProcessor.dialogContext.locale()) && Objects.equals(this.dialogContext.listeningItem(), dialogProcessor.dialogContext.listeningItem());
    }

    public static interface DialogEventListener {
        public void onBeforeDialogInterpretation(DialogContext var1);

        public void onDialogStopped(DialogContext var1);
    }
}

