/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.rsa;

import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import javax.annotation.Nonnull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.rsa.RsaLength;

public class RSA
implements KeyType {
    private final RsaLength length;

    RSA(@Nonnull RsaLength length) {
        this.length = length;
    }

    public static RSA withLength(@Nonnull RsaLength length) {
        return new RSA(length);
    }

    @Override
    public String getName() {
        return "RSA";
    }

    @Override
    public PublicKeyAlgorithm getAlgorithm() {
        return PublicKeyAlgorithm.RSA_GENERAL;
    }

    @Override
    public int getBitStrength() {
        return this.length.getLength();
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmSpec() {
        return new RSAKeyGenParameterSpec(this.length.getLength(), RSAKeyGenParameterSpec.F4);
    }
}

