/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.datatypes;

import org.jivesoftware.smack.datatypes.Scalar;
import org.jivesoftware.smack.util.NumberUtil;

public final class UInt32
extends Scalar {
    private static final long serialVersionUID = 1L;
    private final long number;
    public static final long MIN_VALUE_LONG = 0L;
    public static final long MAX_VALUE_LONG = 0xFFFFFFFFL;
    public static final UInt32 MIN_VALUE = UInt32.from(0xFFFFFFFFL);
    public static final UInt32 MAX_VALUE = UInt32.from(0xFFFFFFFFL);

    private UInt32(long number) {
        super(NumberUtil.requireUInt32(number));
        this.number = number;
    }

    public long nativeRepresentation() {
        return this.number;
    }

    public static UInt32 from(long number) {
        return new UInt32(number);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.number);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof UInt32) {
            UInt32 otherUint32 = (UInt32)other;
            return this.number == otherUint32.number;
        }
        return super.equals(other);
    }

    @Override
    public UInt32 getMinValue() {
        return MIN_VALUE;
    }

    @Override
    public UInt32 getMaxValue() {
        return MAX_VALUE;
    }

    @Override
    public UInt32 incrementedByOne() {
        long incrementedValue = this.number < 0xFFFFFFFFL ? this.number + 1L : 0L;
        return UInt32.from(incrementedValue);
    }
}

