/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Pack;

public class SparkleEngine
implements AEADCipher {
    private String algorithmName;
    private boolean forEncryption;
    private final int[] state;
    private final int[] k;
    private final int[] npub;
    private byte[] tag;
    private boolean initialised;
    private boolean encrypted;
    private boolean aadFinished;
    private final ByteArrayOutputStream aadData = new ByteArrayOutputStream();
    private final ByteArrayOutputStream message = new ByteArrayOutputStream();
    private final int SCHWAEMM_KEY_LEN;
    private final int SCHWAEMM_NONCE_LEN;
    private final int SPARKLE_STEPS_SLIM;
    private final int SPARKLE_STEPS_BIG;
    private final int KEY_WORDS;
    private final int KEY_BYTES;
    private final int TAG_WORDS;
    private final int TAG_BYTES;
    private final int STATE_BRANS;
    private final int STATE_WORDS;
    private final int RATE_WORDS;
    private final int RATE_BYTES;
    private final int CAP_WORDS;
    private final int _A0;
    private final int _A1;
    private final int _M2;
    private final int _M3;
    private static final int[] RCON = new int[]{-1209970334, -1083090816, 951376470, 844003128, -1156479509, 1333558103, -809524792, -1028445891};

    public SparkleEngine(SparkleParameters sparkleParameters) {
        int n;
        int n2;
        int n3;
        switch (sparkleParameters) {
            case SCHWAEMM128_128: {
                this.SCHWAEMM_KEY_LEN = 128;
                this.SCHWAEMM_NONCE_LEN = 128;
                n3 = 128;
                n2 = 256;
                n = 128;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 10;
                this.algorithmName = "SCHWAEMM128-128";
                break;
            }
            case SCHWAEMM256_128: {
                this.SCHWAEMM_KEY_LEN = 128;
                this.SCHWAEMM_NONCE_LEN = 256;
                n3 = 128;
                n2 = 384;
                n = 128;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "SCHWAEMM256-128";
                break;
            }
            case SCHWAEMM192_192: {
                this.SCHWAEMM_KEY_LEN = 192;
                this.SCHWAEMM_NONCE_LEN = 192;
                n3 = 192;
                n2 = 384;
                n = 192;
                this.SPARKLE_STEPS_SLIM = 7;
                this.SPARKLE_STEPS_BIG = 11;
                this.algorithmName = "SCHWAEMM192-192";
                break;
            }
            case SCHWAEMM256_256: {
                this.SCHWAEMM_KEY_LEN = 256;
                this.SCHWAEMM_NONCE_LEN = 256;
                n3 = 256;
                n2 = 512;
                n = 256;
                this.SPARKLE_STEPS_SLIM = 8;
                this.SPARKLE_STEPS_BIG = 12;
                this.algorithmName = "SCHWAEMM256-256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid definition of SCHWAEMM instance");
            }
        }
        this.KEY_WORDS = this.SCHWAEMM_KEY_LEN >>> 5;
        this.KEY_BYTES = this.SCHWAEMM_KEY_LEN >>> 3;
        this.TAG_WORDS = n3 >>> 5;
        this.TAG_BYTES = n3 >>> 3;
        this.STATE_BRANS = n2 >>> 6;
        this.STATE_WORDS = n2 >>> 5;
        this.RATE_WORDS = this.SCHWAEMM_NONCE_LEN >>> 5;
        this.RATE_BYTES = this.SCHWAEMM_NONCE_LEN >>> 3;
        int n4 = n >>> 6;
        this.CAP_WORDS = n >>> 5;
        this._A0 = 1 << n4 << 24;
        this._A1 = (1 ^ 1 << n4) << 24;
        this._M2 = (2 ^ 1 << n4) << 24;
        this._M3 = (3 ^ 1 << n4) << 24;
        this.state = new int[this.STATE_WORDS];
        this.k = new int[this.KEY_WORDS];
        this.npub = new int[this.RATE_WORDS];
        this.initialised = false;
    }

    private int ROT(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    private int ELL(int n) {
        return this.ROT(n ^ n << 16, 16);
    }

    void sparkle_opt(int[] nArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4;
            int n5;
            nArray[1] = nArray[1] ^ RCON[i & 7];
            nArray[3] = nArray[3] ^ i;
            for (n5 = 0; n5 < 2 * n; n5 += 2) {
                int n6 = RCON[n5 >>> 1];
                int n7 = n5;
                nArray[n7] = nArray[n7] + this.ROT(nArray[n5 + 1], 31);
                int n8 = n5 + 1;
                nArray[n8] = nArray[n8] ^ this.ROT(nArray[n5], 24);
                int n9 = n5;
                nArray[n9] = nArray[n9] ^ n6;
                int n10 = n5;
                nArray[n10] = nArray[n10] + this.ROT(nArray[n5 + 1], 17);
                int n11 = n5 + 1;
                nArray[n11] = nArray[n11] ^ this.ROT(nArray[n5], 17);
                int n12 = n5;
                nArray[n12] = nArray[n12] ^ n6;
                int n13 = n5;
                nArray[n13] = nArray[n13] + nArray[n5 + 1];
                int n14 = n5 + 1;
                nArray[n14] = nArray[n14] ^ this.ROT(nArray[n5], 31);
                int n15 = n5;
                nArray[n15] = nArray[n15] ^ n6;
                int n16 = n5;
                nArray[n16] = nArray[n16] + this.ROT(nArray[n5 + 1], 24);
                int n17 = n5 + 1;
                nArray[n17] = nArray[n17] ^ this.ROT(nArray[n5], 16);
                int n18 = n5;
                nArray[n18] = nArray[n18] ^ n6;
            }
            int n19 = n4 = nArray[0];
            int n20 = n3 = nArray[1];
            for (n5 = 2; n5 < n; n5 += 2) {
                n19 ^= nArray[n5];
                n20 ^= nArray[n5 + 1];
            }
            n19 = this.ELL(n19);
            n20 = this.ELL(n20);
            for (n5 = 2; n5 < n; n5 += 2) {
                nArray[n5 - 2] = nArray[n5 + n] ^ nArray[n5] ^ n20;
                nArray[n5 + n] = nArray[n5];
                nArray[n5 - 1] = nArray[n5 + n + 1] ^ nArray[n5 + 1] ^ n19;
                nArray[n5 + n + 1] = nArray[n5 + 1];
            }
            nArray[n - 2] = nArray[n] ^ n4 ^ n20;
            nArray[n] = n4;
            nArray[n - 1] = nArray[n + 1] ^ n3 ^ n19;
            nArray[n + 1] = n3;
        }
    }

    private int CAP_INDEX(int n) {
        if (this.RATE_WORDS > this.CAP_WORDS) {
            return n & this.CAP_WORDS - 1;
        }
        return n;
    }

    void ProcessAssocData(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4 = this.aadData.size();
        if (this.aadFinished || n4 == 0) {
            return;
        }
        this.aadFinished = true;
        byte[] byArray = this.aadData.toByteArray();
        int n5 = 0;
        int[] nArray2 = Pack.littleEndianToInt(byArray, n5, byArray.length >>> 2);
        while (n4 > this.RATE_BYTES) {
            n3 = 0;
            n2 = this.RATE_WORDS / 2;
            while (n3 < this.RATE_WORDS / 2) {
                n = nArray[n3];
                nArray[n3] = nArray[n2] ^ nArray2[n3 + (n5 >> 2)] ^ nArray[this.RATE_WORDS + n3];
                int n6 = n2;
                nArray[n6] = nArray[n6] ^ (n ^ nArray2[n2 + (n5 >> 2)] ^ nArray[this.RATE_WORDS + this.CAP_INDEX(n2)]);
                ++n3;
                ++n2;
            }
            this.sparkle_opt(nArray, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            n4 -= this.RATE_BYTES;
            n5 += this.RATE_BYTES;
        }
        int n7 = this.STATE_WORDS - 1;
        nArray[n7] = nArray[n7] ^ (n4 < this.RATE_BYTES ? this._A0 : this._A1);
        int[] nArray3 = new int[this.RATE_WORDS];
        for (n3 = 0; n3 < n4; ++n3) {
            int n8 = n3 >>> 2;
            nArray3[n8] = nArray3[n8] | byArray[n5++] << ((n3 & 3) << 3);
        }
        if (n4 < this.RATE_BYTES) {
            int n9 = n3 >>> 2;
            nArray3[n9] = nArray3[n9] | 128 << ((n3 & 3) << 3);
        }
        n3 = 0;
        n2 = this.RATE_WORDS / 2;
        while (n3 < this.RATE_WORDS / 2) {
            n = nArray[n3];
            nArray[n3] = nArray[n2] ^ nArray3[n3] ^ nArray[this.RATE_WORDS + n3];
            int n10 = n2;
            nArray[n10] = nArray[n10] ^ (n ^ nArray3[n2] ^ nArray[this.RATE_WORDS + this.CAP_INDEX(n2)]);
            ++n3;
            ++n2;
        }
        this.sparkle_opt(nArray, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
    }

    private int ProcessPlainText(int[] nArray, byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        int[] nArray2 = Pack.littleEndianToInt(byArray2, n, byArray2.length >>> 2);
        int[] nArray3 = new int[byArray.length >>> 2];
        int n4 = 0;
        while (n2 > this.RATE_BYTES) {
            int n5 = 0;
            int n6 = this.RATE_WORDS / 2;
            while (n5 < this.RATE_WORDS / 2) {
                int n7 = nArray[n5];
                int n8 = nArray[n6];
                if (this.forEncryption) {
                    nArray[n5] = nArray[n6] ^ nArray2[n5 + (n >> 2)] ^ nArray[this.RATE_WORDS + n5];
                    int n9 = n6;
                    nArray[n9] = nArray[n9] ^ (n7 ^ nArray2[n6 + (n >> 2)] ^ nArray[this.RATE_WORDS + this.CAP_INDEX(n6)]);
                } else {
                    int n10 = n5;
                    nArray[n10] = nArray[n10] ^ (nArray[n6] ^ nArray2[n5 + (n >> 2)] ^ nArray[this.RATE_WORDS + n5]);
                    nArray[n6] = n7 ^ nArray2[n6 + (n >> 2)] ^ nArray[this.RATE_WORDS + this.CAP_INDEX(n6)];
                }
                nArray3[n5] = nArray2[n5] ^ n7;
                nArray3[n6] = nArray2[n6] ^ n8;
                ++n5;
                ++n6;
            }
            Pack.intToLittleEndian(nArray3, 0, this.RATE_WORDS, byArray, n3);
            this.sparkle_opt(nArray, this.STATE_BRANS, this.SPARKLE_STEPS_SLIM);
            n2 -= this.RATE_BYTES;
            n3 += this.RATE_BYTES;
            n += this.RATE_BYTES;
            n4 += this.RATE_BYTES;
            this.encrypted = true;
        }
        return n4;
    }

    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        if (!(cipherParameters instanceof ParametersWithIV)) {
            throw new IllegalArgumentException(this.algorithmName + " init parameters must include an IV");
        }
        ParametersWithIV parametersWithIV = (ParametersWithIV)cipherParameters;
        byte[] byArray = parametersWithIV.getIV();
        if (byArray == null || byArray.length != this.RATE_BYTES) {
            throw new IllegalArgumentException(this.algorithmName + " requires exactly " + this.RATE_BYTES + " bytes of IV");
        }
        Pack.littleEndianToInt(byArray, 0, this.npub, 0, this.RATE_WORDS);
        if (!(parametersWithIV.getParameters() instanceof KeyParameter)) {
            throw new IllegalArgumentException(this.algorithmName + " init parameters must include a key");
        }
        KeyParameter keyParameter = (KeyParameter)parametersWithIV.getParameters();
        byte[] byArray2 = keyParameter.getKey();
        if (byArray2.length != this.KEY_BYTES) {
            throw new IllegalArgumentException(this.algorithmName + " key must be " + this.KEY_BYTES + " bits long");
        }
        Pack.littleEndianToInt(byArray2, 0, this.k, 0, this.KEY_WORDS);
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, cipherParameters, Utils.getPurpose(bl)));
        this.initialised = true;
        this.reset();
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void processAADByte(byte by) {
        if (this.encrypted) {
            throw new IllegalArgumentException(this.algorithmName + ": AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        this.aadData.write(by);
    }

    public void processAADBytes(byte[] byArray, int n, int n2) {
        if (this.encrypted) {
            throw new IllegalArgumentException(this.algorithmName + ": AAD cannot be added after reading a full block(" + this.getBlockSize() + " bytes) of input for " + (this.forEncryption ? "encryption" : "decryption"));
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        this.aadData.write(byArray, n, n2);
    }

    public int processByte(byte by, byte[] byArray, int n) throws DataLengthException {
        return this.processBytes(new byte[]{by}, 0, 1, byArray, n);
    }

    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException {
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " Need call init function before encryption/decryption");
        }
        if (n + n2 > byArray.length) {
            throw new DataLengthException(this.algorithmName + " input buffer too short");
        }
        this.message.write(byArray, n, n2);
        n2 = 0;
        if (this.forEncryption && this.message.size() > this.getBlockSize() || !this.forEncryption && this.message.size() - this.TAG_BYTES > this.getBlockSize()) {
            n2 = this.message.size() - (this.forEncryption ? 0 : this.TAG_BYTES);
            if (n2 / this.RATE_BYTES * this.RATE_BYTES + n3 > byArray2.length) {
                throw new OutputLengthException(this.algorithmName + " output buffer is too short");
            }
            byte[] byArray3 = this.message.toByteArray();
            this.ProcessAssocData(this.state);
            if (n2 != 0) {
                n2 = this.ProcessPlainText(this.state, byArray2, byArray3, 0, n2);
            }
            this.message.reset();
            this.message.write(byArray3, n2, byArray3.length - n2);
        }
        return n2;
    }

    public int doFinal(byte[] byArray, int n) throws IllegalStateException, InvalidCipherTextException {
        int n2;
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " needs call init function before dofinal");
        }
        int n3 = this.message.size() - (this.forEncryption ? 0 : this.TAG_BYTES);
        if (this.forEncryption && n3 + this.TAG_BYTES + n > byArray.length || !this.forEncryption && n3 + n > byArray.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        this.ProcessAssocData(this.state);
        byte[] byArray2 = this.message.toByteArray();
        int n4 = 0;
        if (this.encrypted || n3 != 0) {
            int n5 = this.STATE_WORDS - 1;
            this.state[n5] = this.state[n5] ^ (n3 < this.RATE_BYTES ? this._M2 : this._M3);
            int[] nArray = new int[this.RATE_WORDS];
            for (n2 = 0; n2 < n3; ++n2) {
                int n6 = n2 >>> 2;
                nArray[n6] = nArray[n6] | (byArray2[n4++] & 0xFF) << ((n2 & 3) << 3);
            }
            if (n3 < this.RATE_BYTES) {
                if (!this.forEncryption) {
                    int n7 = (n2 & 3) << 3;
                    int n8 = n2 >>> 2;
                    nArray[n8] = nArray[n8] | this.state[n2 >>> 2] >>> n7 << n7;
                    n7 = (n2 >>> 2) + 1;
                    System.arraycopy(this.state, n7, nArray, n7, this.RATE_WORDS - n7);
                }
                int n9 = n2 >>> 2;
                nArray[n9] = nArray[n9] ^ 128 << ((n2 & 3) << 3);
            }
            n2 = 0;
            int n10 = this.RATE_WORDS / 2;
            while (n2 < this.RATE_WORDS / 2) {
                int n11 = this.state[n2];
                int n12 = this.state[n10];
                if (this.forEncryption) {
                    this.state[n2] = this.state[n10] ^ nArray[n2] ^ this.state[this.RATE_WORDS + n2];
                    int n13 = n10;
                    this.state[n13] = this.state[n13] ^ (n11 ^ nArray[n10] ^ this.state[this.RATE_WORDS + this.CAP_INDEX(n10)]);
                } else {
                    int n14 = n2;
                    this.state[n14] = this.state[n14] ^ (this.state[n10] ^ nArray[n2] ^ this.state[this.RATE_WORDS + n2]);
                    this.state[n10] = n11 ^ nArray[n10] ^ this.state[this.RATE_WORDS + this.CAP_INDEX(n10)];
                }
                int n15 = n2++;
                nArray[n15] = nArray[n15] ^ n11;
                int n16 = n10++;
                nArray[n16] = nArray[n16] ^ n12;
            }
            for (n2 = 0; n2 < n3; ++n2) {
                byArray[n++] = (byte)(nArray[n2 >>> 2] >>> ((n2 & 3) << 3));
            }
            this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
        }
        for (n2 = 0; n2 < this.KEY_WORDS; ++n2) {
            int n17 = this.RATE_WORDS + n2;
            this.state[n17] = this.state[n17] ^ this.k[n2];
        }
        this.tag = new byte[this.TAG_BYTES];
        Pack.intToLittleEndian(this.state, this.RATE_WORDS, this.TAG_WORDS, this.tag, 0);
        if (this.forEncryption) {
            System.arraycopy(this.tag, 0, byArray, n, this.TAG_BYTES);
            n3 += this.TAG_BYTES;
        } else {
            for (n2 = 0; n2 < this.TAG_BYTES; ++n2) {
                if (this.tag[n2] == byArray2[n3 + n2]) continue;
                throw new IllegalArgumentException(this.algorithmName + " mac does not match");
            }
        }
        this.reset(false);
        return n3;
    }

    public byte[] getMac() {
        return this.tag;
    }

    public int getUpdateOutputSize(int n) {
        return n;
    }

    public int getOutputSize(int n) {
        return n + this.TAG_BYTES;
    }

    public void reset() {
        if (!this.initialised) {
            throw new IllegalArgumentException(this.algorithmName + " needs call init function before reset");
        }
        this.reset(true);
    }

    private void reset(boolean bl) {
        if (bl) {
            this.tag = null;
        }
        System.arraycopy(this.npub, 0, this.state, 0, this.RATE_WORDS);
        System.arraycopy(this.k, 0, this.state, this.RATE_WORDS, this.KEY_WORDS);
        this.sparkle_opt(this.state, this.STATE_BRANS, this.SPARKLE_STEPS_BIG);
        this.aadData.reset();
        this.message.reset();
        this.encrypted = false;
        this.aadFinished = false;
    }

    public int getBlockSize() {
        return this.RATE_BYTES;
    }

    public int getKeyBytesSize() {
        return this.KEY_BYTES;
    }

    public int getIVBytesSize() {
        return this.RATE_BYTES;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SparkleParameters {
        SCHWAEMM128_128,
        SCHWAEMM256_128,
        SCHWAEMM192_192,
        SCHWAEMM256_256;

    }
}

