// WARNING: this file was generated by ../scripts/gen-unicode-norm-table.py

//! This module provides Unicode tables for canonical (de)composition.
//!
//! The current implementation is not the fastest one. Just good enough.

#[allow(dead_code)]
pub const UNICODE_VERSION: (u8, u8, u8) = (16, 0, 0);

// Rust support `Option<char>` layout optimization, so it will take only 4 bytes.
pub const DECOMPOSITION_TABLE: &[(char, char, Option<char>)] = &[
    ('\u{00C0}', '\u{0041}', Some('\u{0300}')),
    ('\u{00C1}', '\u{0041}', Some('\u{0301}')),
    ('\u{00C2}', '\u{0041}', Some('\u{0302}')),
    ('\u{00C3}', '\u{0041}', Some('\u{0303}')),
    ('\u{00C4}', '\u{0041}', Some('\u{0308}')),
    ('\u{00C5}', '\u{0041}', Some('\u{030A}')),
    ('\u{00C7}', '\u{0043}', Some('\u{0327}')),
    ('\u{00C8}', '\u{0045}', Some('\u{0300}')),
    ('\u{00C9}', '\u{0045}', Some('\u{0301}')),
    ('\u{00CA}', '\u{0045}', Some('\u{0302}')),
    ('\u{00CB}', '\u{0045}', Some('\u{0308}')),
    ('\u{00CC}', '\u{0049}', Some('\u{0300}')),
    ('\u{00CD}', '\u{0049}', Some('\u{0301}')),
    ('\u{00CE}', '\u{0049}', Some('\u{0302}')),
    ('\u{00CF}', '\u{0049}', Some('\u{0308}')),
    ('\u{00D1}', '\u{004E}', Some('\u{0303}')),
    ('\u{00D2}', '\u{004F}', Some('\u{0300}')),
    ('\u{00D3}', '\u{004F}', Some('\u{0301}')),
    ('\u{00D4}', '\u{004F}', Some('\u{0302}')),
    ('\u{00D5}', '\u{004F}', Some('\u{0303}')),
    ('\u{00D6}', '\u{004F}', Some('\u{0308}')),
    ('\u{00D9}', '\u{0055}', Some('\u{0300}')),
    ('\u{00DA}', '\u{0055}', Some('\u{0301}')),
    ('\u{00DB}', '\u{0055}', Some('\u{0302}')),
    ('\u{00DC}', '\u{0055}', Some('\u{0308}')),
    ('\u{00DD}', '\u{0059}', Some('\u{0301}')),
    ('\u{00E0}', '\u{0061}', Some('\u{0300}')),
    ('\u{00E1}', '\u{0061}', Some('\u{0301}')),
    ('\u{00E2}', '\u{0061}', Some('\u{0302}')),
    ('\u{00E3}', '\u{0061}', Some('\u{0303}')),
    ('\u{00E4}', '\u{0061}', Some('\u{0308}')),
    ('\u{00E5}', '\u{0061}', Some('\u{030A}')),
    ('\u{00E7}', '\u{0063}', Some('\u{0327}')),
    ('\u{00E8}', '\u{0065}', Some('\u{0300}')),
    ('\u{00E9}', '\u{0065}', Some('\u{0301}')),
    ('\u{00EA}', '\u{0065}', Some('\u{0302}')),
    ('\u{00EB}', '\u{0065}', Some('\u{0308}')),
    ('\u{00EC}', '\u{0069}', Some('\u{0300}')),
    ('\u{00ED}', '\u{0069}', Some('\u{0301}')),
    ('\u{00EE}', '\u{0069}', Some('\u{0302}')),
    ('\u{00EF}', '\u{0069}', Some('\u{0308}')),
    ('\u{00F1}', '\u{006E}', Some('\u{0303}')),
    ('\u{00F2}', '\u{006F}', Some('\u{0300}')),
    ('\u{00F3}', '\u{006F}', Some('\u{0301}')),
    ('\u{00F4}', '\u{006F}', Some('\u{0302}')),
    ('\u{00F5}', '\u{006F}', Some('\u{0303}')),
    ('\u{00F6}', '\u{006F}', Some('\u{0308}')),
    ('\u{00F9}', '\u{0075}', Some('\u{0300}')),
    ('\u{00FA}', '\u{0075}', Some('\u{0301}')),
    ('\u{00FB}', '\u{0075}', Some('\u{0302}')),
    ('\u{00FC}', '\u{0075}', Some('\u{0308}')),
    ('\u{00FD}', '\u{0079}', Some('\u{0301}')),
    ('\u{00FF}', '\u{0079}', Some('\u{0308}')),
    ('\u{0100}', '\u{0041}', Some('\u{0304}')),
    ('\u{0101}', '\u{0061}', Some('\u{0304}')),
    ('\u{0102}', '\u{0041}', Some('\u{0306}')),
    ('\u{0103}', '\u{0061}', Some('\u{0306}')),
    ('\u{0104}', '\u{0041}', Some('\u{0328}')),
    ('\u{0105}', '\u{0061}', Some('\u{0328}')),
    ('\u{0106}', '\u{0043}', Some('\u{0301}')),
    ('\u{0107}', '\u{0063}', Some('\u{0301}')),
    ('\u{0108}', '\u{0043}', Some('\u{0302}')),
    ('\u{0109}', '\u{0063}', Some('\u{0302}')),
    ('\u{010A}', '\u{0043}', Some('\u{0307}')),
    ('\u{010B}', '\u{0063}', Some('\u{0307}')),
    ('\u{010C}', '\u{0043}', Some('\u{030C}')),
    ('\u{010D}', '\u{0063}', Some('\u{030C}')),
    ('\u{010E}', '\u{0044}', Some('\u{030C}')),
    ('\u{010F}', '\u{0064}', Some('\u{030C}')),
    ('\u{0112}', '\u{0045}', Some('\u{0304}')),
    ('\u{0113}', '\u{0065}', Some('\u{0304}')),
    ('\u{0114}', '\u{0045}', Some('\u{0306}')),
    ('\u{0115}', '\u{0065}', Some('\u{0306}')),
    ('\u{0116}', '\u{0045}', Some('\u{0307}')),
    ('\u{0117}', '\u{0065}', Some('\u{0307}')),
    ('\u{0118}', '\u{0045}', Some('\u{0328}')),
    ('\u{0119}', '\u{0065}', Some('\u{0328}')),
    ('\u{011A}', '\u{0045}', Some('\u{030C}')),
    ('\u{011B}', '\u{0065}', Some('\u{030C}')),
    ('\u{011C}', '\u{0047}', Some('\u{0302}')),
    ('\u{011D}', '\u{0067}', Some('\u{0302}')),
    ('\u{011E}', '\u{0047}', Some('\u{0306}')),
    ('\u{011F}', '\u{0067}', Some('\u{0306}')),
    ('\u{0120}', '\u{0047}', Some('\u{0307}')),
    ('\u{0121}', '\u{0067}', Some('\u{0307}')),
    ('\u{0122}', '\u{0047}', Some('\u{0327}')),
    ('\u{0123}', '\u{0067}', Some('\u{0327}')),
    ('\u{0124}', '\u{0048}', Some('\u{0302}')),
    ('\u{0125}', '\u{0068}', Some('\u{0302}')),
    ('\u{0128}', '\u{0049}', Some('\u{0303}')),
    ('\u{0129}', '\u{0069}', Some('\u{0303}')),
    ('\u{012A}', '\u{0049}', Some('\u{0304}')),
    ('\u{012B}', '\u{0069}', Some('\u{0304}')),
    ('\u{012C}', '\u{0049}', Some('\u{0306}')),
    ('\u{012D}', '\u{0069}', Some('\u{0306}')),
    ('\u{012E}', '\u{0049}', Some('\u{0328}')),
    ('\u{012F}', '\u{0069}', Some('\u{0328}')),
    ('\u{0130}', '\u{0049}', Some('\u{0307}')),
    ('\u{0134}', '\u{004A}', Some('\u{0302}')),
    ('\u{0135}', '\u{006A}', Some('\u{0302}')),
    ('\u{0136}', '\u{004B}', Some('\u{0327}')),
    ('\u{0137}', '\u{006B}', Some('\u{0327}')),
    ('\u{0139}', '\u{004C}', Some('\u{0301}')),
    ('\u{013A}', '\u{006C}', Some('\u{0301}')),
    ('\u{013B}', '\u{004C}', Some('\u{0327}')),
    ('\u{013C}', '\u{006C}', Some('\u{0327}')),
    ('\u{013D}', '\u{004C}', Some('\u{030C}')),
    ('\u{013E}', '\u{006C}', Some('\u{030C}')),
    ('\u{0143}', '\u{004E}', Some('\u{0301}')),
    ('\u{0144}', '\u{006E}', Some('\u{0301}')),
    ('\u{0145}', '\u{004E}', Some('\u{0327}')),
    ('\u{0146}', '\u{006E}', Some('\u{0327}')),
    ('\u{0147}', '\u{004E}', Some('\u{030C}')),
    ('\u{0148}', '\u{006E}', Some('\u{030C}')),
    ('\u{014C}', '\u{004F}', Some('\u{0304}')),
    ('\u{014D}', '\u{006F}', Some('\u{0304}')),
    ('\u{014E}', '\u{004F}', Some('\u{0306}')),
    ('\u{014F}', '\u{006F}', Some('\u{0306}')),
    ('\u{0150}', '\u{004F}', Some('\u{030B}')),
    ('\u{0151}', '\u{006F}', Some('\u{030B}')),
    ('\u{0154}', '\u{0052}', Some('\u{0301}')),
    ('\u{0155}', '\u{0072}', Some('\u{0301}')),
    ('\u{0156}', '\u{0052}', Some('\u{0327}')),
    ('\u{0157}', '\u{0072}', Some('\u{0327}')),
    ('\u{0158}', '\u{0052}', Some('\u{030C}')),
    ('\u{0159}', '\u{0072}', Some('\u{030C}')),
    ('\u{015A}', '\u{0053}', Some('\u{0301}')),
    ('\u{015B}', '\u{0073}', Some('\u{0301}')),
    ('\u{015C}', '\u{0053}', Some('\u{0302}')),
    ('\u{015D}', '\u{0073}', Some('\u{0302}')),
    ('\u{015E}', '\u{0053}', Some('\u{0327}')),
    ('\u{015F}', '\u{0073}', Some('\u{0327}')),
    ('\u{0160}', '\u{0053}', Some('\u{030C}')),
    ('\u{0161}', '\u{0073}', Some('\u{030C}')),
    ('\u{0162}', '\u{0054}', Some('\u{0327}')),
    ('\u{0163}', '\u{0074}', Some('\u{0327}')),
    ('\u{0164}', '\u{0054}', Some('\u{030C}')),
    ('\u{0165}', '\u{0074}', Some('\u{030C}')),
    ('\u{0168}', '\u{0055}', Some('\u{0303}')),
    ('\u{0169}', '\u{0075}', Some('\u{0303}')),
    ('\u{016A}', '\u{0055}', Some('\u{0304}')),
    ('\u{016B}', '\u{0075}', Some('\u{0304}')),
    ('\u{016C}', '\u{0055}', Some('\u{0306}')),
    ('\u{016D}', '\u{0075}', Some('\u{0306}')),
    ('\u{016E}', '\u{0055}', Some('\u{030A}')),
    ('\u{016F}', '\u{0075}', Some('\u{030A}')),
    ('\u{0170}', '\u{0055}', Some('\u{030B}')),
    ('\u{0171}', '\u{0075}', Some('\u{030B}')),
    ('\u{0172}', '\u{0055}', Some('\u{0328}')),
    ('\u{0173}', '\u{0075}', Some('\u{0328}')),
    ('\u{0174}', '\u{0057}', Some('\u{0302}')),
    ('\u{0175}', '\u{0077}', Some('\u{0302}')),
    ('\u{0176}', '\u{0059}', Some('\u{0302}')),
    ('\u{0177}', '\u{0079}', Some('\u{0302}')),
    ('\u{0178}', '\u{0059}', Some('\u{0308}')),
    ('\u{0179}', '\u{005A}', Some('\u{0301}')),
    ('\u{017A}', '\u{007A}', Some('\u{0301}')),
    ('\u{017B}', '\u{005A}', Some('\u{0307}')),
    ('\u{017C}', '\u{007A}', Some('\u{0307}')),
    ('\u{017D}', '\u{005A}', Some('\u{030C}')),
    ('\u{017E}', '\u{007A}', Some('\u{030C}')),
    ('\u{01A0}', '\u{004F}', Some('\u{031B}')),
    ('\u{01A1}', '\u{006F}', Some('\u{031B}')),
    ('\u{01AF}', '\u{0055}', Some('\u{031B}')),
    ('\u{01B0}', '\u{0075}', Some('\u{031B}')),
    ('\u{01CD}', '\u{0041}', Some('\u{030C}')),
    ('\u{01CE}', '\u{0061}', Some('\u{030C}')),
    ('\u{01CF}', '\u{0049}', Some('\u{030C}')),
    ('\u{01D0}', '\u{0069}', Some('\u{030C}')),
    ('\u{01D1}', '\u{004F}', Some('\u{030C}')),
    ('\u{01D2}', '\u{006F}', Some('\u{030C}')),
    ('\u{01D3}', '\u{0055}', Some('\u{030C}')),
    ('\u{01D4}', '\u{0075}', Some('\u{030C}')),
    ('\u{01D5}', '\u{00DC}', Some('\u{0304}')),
    ('\u{01D6}', '\u{00FC}', Some('\u{0304}')),
    ('\u{01D7}', '\u{00DC}', Some('\u{0301}')),
    ('\u{01D8}', '\u{00FC}', Some('\u{0301}')),
    ('\u{01D9}', '\u{00DC}', Some('\u{030C}')),
    ('\u{01DA}', '\u{00FC}', Some('\u{030C}')),
    ('\u{01DB}', '\u{00DC}', Some('\u{0300}')),
    ('\u{01DC}', '\u{00FC}', Some('\u{0300}')),
    ('\u{01DE}', '\u{00C4}', Some('\u{0304}')),
    ('\u{01DF}', '\u{00E4}', Some('\u{0304}')),
    ('\u{01E0}', '\u{0226}', Some('\u{0304}')),
    ('\u{01E1}', '\u{0227}', Some('\u{0304}')),
    ('\u{01E2}', '\u{00C6}', Some('\u{0304}')),
    ('\u{01E3}', '\u{00E6}', Some('\u{0304}')),
    ('\u{01E6}', '\u{0047}', Some('\u{030C}')),
    ('\u{01E7}', '\u{0067}', Some('\u{030C}')),
    ('\u{01E8}', '\u{004B}', Some('\u{030C}')),
    ('\u{01E9}', '\u{006B}', Some('\u{030C}')),
    ('\u{01EA}', '\u{004F}', Some('\u{0328}')),
    ('\u{01EB}', '\u{006F}', Some('\u{0328}')),
    ('\u{01EC}', '\u{01EA}', Some('\u{0304}')),
    ('\u{01ED}', '\u{01EB}', Some('\u{0304}')),
    ('\u{01EE}', '\u{01B7}', Some('\u{030C}')),
    ('\u{01EF}', '\u{0292}', Some('\u{030C}')),
    ('\u{01F0}', '\u{006A}', Some('\u{030C}')),
    ('\u{01F4}', '\u{0047}', Some('\u{0301}')),
    ('\u{01F5}', '\u{0067}', Some('\u{0301}')),
    ('\u{01F8}', '\u{004E}', Some('\u{0300}')),
    ('\u{01F9}', '\u{006E}', Some('\u{0300}')),
    ('\u{01FA}', '\u{00C5}', Some('\u{0301}')),
    ('\u{01FB}', '\u{00E5}', Some('\u{0301}')),
    ('\u{01FC}', '\u{00C6}', Some('\u{0301}')),
    ('\u{01FD}', '\u{00E6}', Some('\u{0301}')),
    ('\u{01FE}', '\u{00D8}', Some('\u{0301}')),
    ('\u{01FF}', '\u{00F8}', Some('\u{0301}')),
    ('\u{0200}', '\u{0041}', Some('\u{030F}')),
    ('\u{0201}', '\u{0061}', Some('\u{030F}')),
    ('\u{0202}', '\u{0041}', Some('\u{0311}')),
    ('\u{0203}', '\u{0061}', Some('\u{0311}')),
    ('\u{0204}', '\u{0045}', Some('\u{030F}')),
    ('\u{0205}', '\u{0065}', Some('\u{030F}')),
    ('\u{0206}', '\u{0045}', Some('\u{0311}')),
    ('\u{0207}', '\u{0065}', Some('\u{0311}')),
    ('\u{0208}', '\u{0049}', Some('\u{030F}')),
    ('\u{0209}', '\u{0069}', Some('\u{030F}')),
    ('\u{020A}', '\u{0049}', Some('\u{0311}')),
    ('\u{020B}', '\u{0069}', Some('\u{0311}')),
    ('\u{020C}', '\u{004F}', Some('\u{030F}')),
    ('\u{020D}', '\u{006F}', Some('\u{030F}')),
    ('\u{020E}', '\u{004F}', Some('\u{0311}')),
    ('\u{020F}', '\u{006F}', Some('\u{0311}')),
    ('\u{0210}', '\u{0052}', Some('\u{030F}')),
    ('\u{0211}', '\u{0072}', Some('\u{030F}')),
    ('\u{0212}', '\u{0052}', Some('\u{0311}')),
    ('\u{0213}', '\u{0072}', Some('\u{0311}')),
    ('\u{0214}', '\u{0055}', Some('\u{030F}')),
    ('\u{0215}', '\u{0075}', Some('\u{030F}')),
    ('\u{0216}', '\u{0055}', Some('\u{0311}')),
    ('\u{0217}', '\u{0075}', Some('\u{0311}')),
    ('\u{0218}', '\u{0053}', Some('\u{0326}')),
    ('\u{0219}', '\u{0073}', Some('\u{0326}')),
    ('\u{021A}', '\u{0054}', Some('\u{0326}')),
    ('\u{021B}', '\u{0074}', Some('\u{0326}')),
    ('\u{021E}', '\u{0048}', Some('\u{030C}')),
    ('\u{021F}', '\u{0068}', Some('\u{030C}')),
    ('\u{0226}', '\u{0041}', Some('\u{0307}')),
    ('\u{0227}', '\u{0061}', Some('\u{0307}')),
    ('\u{0228}', '\u{0045}', Some('\u{0327}')),
    ('\u{0229}', '\u{0065}', Some('\u{0327}')),
    ('\u{022A}', '\u{00D6}', Some('\u{0304}')),
    ('\u{022B}', '\u{00F6}', Some('\u{0304}')),
    ('\u{022C}', '\u{00D5}', Some('\u{0304}')),
    ('\u{022D}', '\u{00F5}', Some('\u{0304}')),
    ('\u{022E}', '\u{004F}', Some('\u{0307}')),
    ('\u{022F}', '\u{006F}', Some('\u{0307}')),
    ('\u{0230}', '\u{022E}', Some('\u{0304}')),
    ('\u{0231}', '\u{022F}', Some('\u{0304}')),
    ('\u{0232}', '\u{0059}', Some('\u{0304}')),
    ('\u{0233}', '\u{0079}', Some('\u{0304}')),
    ('\u{0340}', '\u{0300}', None),
    ('\u{0341}', '\u{0301}', None),
    ('\u{0343}', '\u{0313}', None),
    ('\u{0344}', '\u{0308}', Some('\u{0301}')),
    ('\u{0374}', '\u{02B9}', None),
    ('\u{037E}', '\u{003B}', None),
    ('\u{0385}', '\u{00A8}', Some('\u{0301}')),
    ('\u{0386}', '\u{0391}', Some('\u{0301}')),
    ('\u{0387}', '\u{00B7}', None),
    ('\u{0388}', '\u{0395}', Some('\u{0301}')),
    ('\u{0389}', '\u{0397}', Some('\u{0301}')),
    ('\u{038A}', '\u{0399}', Some('\u{0301}')),
    ('\u{038C}', '\u{039F}', Some('\u{0301}')),
    ('\u{038E}', '\u{03A5}', Some('\u{0301}')),
    ('\u{038F}', '\u{03A9}', Some('\u{0301}')),
    ('\u{0390}', '\u{03CA}', Some('\u{0301}')),
    ('\u{03AA}', '\u{0399}', Some('\u{0308}')),
    ('\u{03AB}', '\u{03A5}', Some('\u{0308}')),
    ('\u{03AC}', '\u{03B1}', Some('\u{0301}')),
    ('\u{03AD}', '\u{03B5}', Some('\u{0301}')),
    ('\u{03AE}', '\u{03B7}', Some('\u{0301}')),
    ('\u{03AF}', '\u{03B9}', Some('\u{0301}')),
    ('\u{03B0}', '\u{03CB}', Some('\u{0301}')),
    ('\u{03CA}', '\u{03B9}', Some('\u{0308}')),
    ('\u{03CB}', '\u{03C5}', Some('\u{0308}')),
    ('\u{03CC}', '\u{03BF}', Some('\u{0301}')),
    ('\u{03CD}', '\u{03C5}', Some('\u{0301}')),
    ('\u{03CE}', '\u{03C9}', Some('\u{0301}')),
    ('\u{03D3}', '\u{03D2}', Some('\u{0301}')),
    ('\u{03D4}', '\u{03D2}', Some('\u{0308}')),
    ('\u{0400}', '\u{0415}', Some('\u{0300}')),
    ('\u{0401}', '\u{0415}', Some('\u{0308}')),
    ('\u{0403}', '\u{0413}', Some('\u{0301}')),
    ('\u{0407}', '\u{0406}', Some('\u{0308}')),
    ('\u{040C}', '\u{041A}', Some('\u{0301}')),
    ('\u{040D}', '\u{0418}', Some('\u{0300}')),
    ('\u{040E}', '\u{0423}', Some('\u{0306}')),
    ('\u{0419}', '\u{0418}', Some('\u{0306}')),
    ('\u{0439}', '\u{0438}', Some('\u{0306}')),
    ('\u{0450}', '\u{0435}', Some('\u{0300}')),
    ('\u{0451}', '\u{0435}', Some('\u{0308}')),
    ('\u{0453}', '\u{0433}', Some('\u{0301}')),
    ('\u{0457}', '\u{0456}', Some('\u{0308}')),
    ('\u{045C}', '\u{043A}', Some('\u{0301}')),
    ('\u{045D}', '\u{0438}', Some('\u{0300}')),
    ('\u{045E}', '\u{0443}', Some('\u{0306}')),
    ('\u{0476}', '\u{0474}', Some('\u{030F}')),
    ('\u{0477}', '\u{0475}', Some('\u{030F}')),
    ('\u{04C1}', '\u{0416}', Some('\u{0306}')),
    ('\u{04C2}', '\u{0436}', Some('\u{0306}')),
    ('\u{04D0}', '\u{0410}', Some('\u{0306}')),
    ('\u{04D1}', '\u{0430}', Some('\u{0306}')),
    ('\u{04D2}', '\u{0410}', Some('\u{0308}')),
    ('\u{04D3}', '\u{0430}', Some('\u{0308}')),
    ('\u{04D6}', '\u{0415}', Some('\u{0306}')),
    ('\u{04D7}', '\u{0435}', Some('\u{0306}')),
    ('\u{04DA}', '\u{04D8}', Some('\u{0308}')),
    ('\u{04DB}', '\u{04D9}', Some('\u{0308}')),
    ('\u{04DC}', '\u{0416}', Some('\u{0308}')),
    ('\u{04DD}', '\u{0436}', Some('\u{0308}')),
    ('\u{04DE}', '\u{0417}', Some('\u{0308}')),
    ('\u{04DF}', '\u{0437}', Some('\u{0308}')),
    ('\u{04E2}', '\u{0418}', Some('\u{0304}')),
    ('\u{04E3}', '\u{0438}', Some('\u{0304}')),
    ('\u{04E4}', '\u{0418}', Some('\u{0308}')),
    ('\u{04E5}', '\u{0438}', Some('\u{0308}')),
    ('\u{04E6}', '\u{041E}', Some('\u{0308}')),
    ('\u{04E7}', '\u{043E}', Some('\u{0308}')),
    ('\u{04EA}', '\u{04E8}', Some('\u{0308}')),
    ('\u{04EB}', '\u{04E9}', Some('\u{0308}')),
    ('\u{04EC}', '\u{042D}', Some('\u{0308}')),
    ('\u{04ED}', '\u{044D}', Some('\u{0308}')),
    ('\u{04EE}', '\u{0423}', Some('\u{0304}')),
    ('\u{04EF}', '\u{0443}', Some('\u{0304}')),
    ('\u{04F0}', '\u{0423}', Some('\u{0308}')),
    ('\u{04F1}', '\u{0443}', Some('\u{0308}')),
    ('\u{04F2}', '\u{0423}', Some('\u{030B}')),
    ('\u{04F3}', '\u{0443}', Some('\u{030B}')),
    ('\u{04F4}', '\u{0427}', Some('\u{0308}')),
    ('\u{04F5}', '\u{0447}', Some('\u{0308}')),
    ('\u{04F8}', '\u{042B}', Some('\u{0308}')),
    ('\u{04F9}', '\u{044B}', Some('\u{0308}')),
    ('\u{0622}', '\u{0627}', Some('\u{0653}')),
    ('\u{0623}', '\u{0627}', Some('\u{0654}')),
    ('\u{0624}', '\u{0648}', Some('\u{0654}')),
    ('\u{0625}', '\u{0627}', Some('\u{0655}')),
    ('\u{0626}', '\u{064A}', Some('\u{0654}')),
    ('\u{06C0}', '\u{06D5}', Some('\u{0654}')),
    ('\u{06C2}', '\u{06C1}', Some('\u{0654}')),
    ('\u{06D3}', '\u{06D2}', Some('\u{0654}')),
    ('\u{0929}', '\u{0928}', Some('\u{093C}')),
    ('\u{0931}', '\u{0930}', Some('\u{093C}')),
    ('\u{0934}', '\u{0933}', Some('\u{093C}')),
    ('\u{0958}', '\u{0915}', Some('\u{093C}')),
    ('\u{0959}', '\u{0916}', Some('\u{093C}')),
    ('\u{095A}', '\u{0917}', Some('\u{093C}')),
    ('\u{095B}', '\u{091C}', Some('\u{093C}')),
    ('\u{095C}', '\u{0921}', Some('\u{093C}')),
    ('\u{095D}', '\u{0922}', Some('\u{093C}')),
    ('\u{095E}', '\u{092B}', Some('\u{093C}')),
    ('\u{095F}', '\u{092F}', Some('\u{093C}')),
    ('\u{09CB}', '\u{09C7}', Some('\u{09BE}')),
    ('\u{09CC}', '\u{09C7}', Some('\u{09D7}')),
    ('\u{09DC}', '\u{09A1}', Some('\u{09BC}')),
    ('\u{09DD}', '\u{09A2}', Some('\u{09BC}')),
    ('\u{09DF}', '\u{09AF}', Some('\u{09BC}')),
    ('\u{0A33}', '\u{0A32}', Some('\u{0A3C}')),
    ('\u{0A36}', '\u{0A38}', Some('\u{0A3C}')),
    ('\u{0A59}', '\u{0A16}', Some('\u{0A3C}')),
    ('\u{0A5A}', '\u{0A17}', Some('\u{0A3C}')),
    ('\u{0A5B}', '\u{0A1C}', Some('\u{0A3C}')),
    ('\u{0A5E}', '\u{0A2B}', Some('\u{0A3C}')),
    ('\u{0B48}', '\u{0B47}', Some('\u{0B56}')),
    ('\u{0B4B}', '\u{0B47}', Some('\u{0B3E}')),
    ('\u{0B4C}', '\u{0B47}', Some('\u{0B57}')),
    ('\u{0B5C}', '\u{0B21}', Some('\u{0B3C}')),
    ('\u{0B5D}', '\u{0B22}', Some('\u{0B3C}')),
    ('\u{0B94}', '\u{0B92}', Some('\u{0BD7}')),
    ('\u{0BCA}', '\u{0BC6}', Some('\u{0BBE}')),
    ('\u{0BCB}', '\u{0BC7}', Some('\u{0BBE}')),
    ('\u{0BCC}', '\u{0BC6}', Some('\u{0BD7}')),
    ('\u{0C48}', '\u{0C46}', Some('\u{0C56}')),
    ('\u{0CC0}', '\u{0CBF}', Some('\u{0CD5}')),
    ('\u{0CC7}', '\u{0CC6}', Some('\u{0CD5}')),
    ('\u{0CC8}', '\u{0CC6}', Some('\u{0CD6}')),
    ('\u{0CCA}', '\u{0CC6}', Some('\u{0CC2}')),
    ('\u{0CCB}', '\u{0CCA}', Some('\u{0CD5}')),
    ('\u{0D4A}', '\u{0D46}', Some('\u{0D3E}')),
    ('\u{0D4B}', '\u{0D47}', Some('\u{0D3E}')),
    ('\u{0D4C}', '\u{0D46}', Some('\u{0D57}')),
    ('\u{0DDA}', '\u{0DD9}', Some('\u{0DCA}')),
    ('\u{0DDC}', '\u{0DD9}', Some('\u{0DCF}')),
    ('\u{0DDD}', '\u{0DDC}', Some('\u{0DCA}')),
    ('\u{0DDE}', '\u{0DD9}', Some('\u{0DDF}')),
    ('\u{0F43}', '\u{0F42}', Some('\u{0FB7}')),
    ('\u{0F4D}', '\u{0F4C}', Some('\u{0FB7}')),
    ('\u{0F52}', '\u{0F51}', Some('\u{0FB7}')),
    ('\u{0F57}', '\u{0F56}', Some('\u{0FB7}')),
    ('\u{0F5C}', '\u{0F5B}', Some('\u{0FB7}')),
    ('\u{0F69}', '\u{0F40}', Some('\u{0FB5}')),
    ('\u{0F73}', '\u{0F71}', Some('\u{0F72}')),
    ('\u{0F75}', '\u{0F71}', Some('\u{0F74}')),
    ('\u{0F76}', '\u{0FB2}', Some('\u{0F80}')),
    ('\u{0F78}', '\u{0FB3}', Some('\u{0F80}')),
    ('\u{0F81}', '\u{0F71}', Some('\u{0F80}')),
    ('\u{0F93}', '\u{0F92}', Some('\u{0FB7}')),
    ('\u{0F9D}', '\u{0F9C}', Some('\u{0FB7}')),
    ('\u{0FA2}', '\u{0FA1}', Some('\u{0FB7}')),
    ('\u{0FA7}', '\u{0FA6}', Some('\u{0FB7}')),
    ('\u{0FAC}', '\u{0FAB}', Some('\u{0FB7}')),
    ('\u{0FB9}', '\u{0F90}', Some('\u{0FB5}')),
    ('\u{1026}', '\u{1025}', Some('\u{102E}')),
    ('\u{1B06}', '\u{1B05}', Some('\u{1B35}')),
    ('\u{1B08}', '\u{1B07}', Some('\u{1B35}')),
    ('\u{1B0A}', '\u{1B09}', Some('\u{1B35}')),
    ('\u{1B0C}', '\u{1B0B}', Some('\u{1B35}')),
    ('\u{1B0E}', '\u{1B0D}', Some('\u{1B35}')),
    ('\u{1B12}', '\u{1B11}', Some('\u{1B35}')),
    ('\u{1B3B}', '\u{1B3A}', Some('\u{1B35}')),
    ('\u{1B3D}', '\u{1B3C}', Some('\u{1B35}')),
    ('\u{1B40}', '\u{1B3E}', Some('\u{1B35}')),
    ('\u{1B41}', '\u{1B3F}', Some('\u{1B35}')),
    ('\u{1B43}', '\u{1B42}', Some('\u{1B35}')),
    ('\u{1E00}', '\u{0041}', Some('\u{0325}')),
    ('\u{1E01}', '\u{0061}', Some('\u{0325}')),
    ('\u{1E02}', '\u{0042}', Some('\u{0307}')),
    ('\u{1E03}', '\u{0062}', Some('\u{0307}')),
    ('\u{1E04}', '\u{0042}', Some('\u{0323}')),
    ('\u{1E05}', '\u{0062}', Some('\u{0323}')),
    ('\u{1E06}', '\u{0042}', Some('\u{0331}')),
    ('\u{1E07}', '\u{0062}', Some('\u{0331}')),
    ('\u{1E08}', '\u{00C7}', Some('\u{0301}')),
    ('\u{1E09}', '\u{00E7}', Some('\u{0301}')),
    ('\u{1E0A}', '\u{0044}', Some('\u{0307}')),
    ('\u{1E0B}', '\u{0064}', Some('\u{0307}')),
    ('\u{1E0C}', '\u{0044}', Some('\u{0323}')),
    ('\u{1E0D}', '\u{0064}', Some('\u{0323}')),
    ('\u{1E0E}', '\u{0044}', Some('\u{0331}')),
    ('\u{1E0F}', '\u{0064}', Some('\u{0331}')),
    ('\u{1E10}', '\u{0044}', Some('\u{0327}')),
    ('\u{1E11}', '\u{0064}', Some('\u{0327}')),
    ('\u{1E12}', '\u{0044}', Some('\u{032D}')),
    ('\u{1E13}', '\u{0064}', Some('\u{032D}')),
    ('\u{1E14}', '\u{0112}', Some('\u{0300}')),
    ('\u{1E15}', '\u{0113}', Some('\u{0300}')),
    ('\u{1E16}', '\u{0112}', Some('\u{0301}')),
    ('\u{1E17}', '\u{0113}', Some('\u{0301}')),
    ('\u{1E18}', '\u{0045}', Some('\u{032D}')),
    ('\u{1E19}', '\u{0065}', Some('\u{032D}')),
    ('\u{1E1A}', '\u{0045}', Some('\u{0330}')),
    ('\u{1E1B}', '\u{0065}', Some('\u{0330}')),
    ('\u{1E1C}', '\u{0228}', Some('\u{0306}')),
    ('\u{1E1D}', '\u{0229}', Some('\u{0306}')),
    ('\u{1E1E}', '\u{0046}', Some('\u{0307}')),
    ('\u{1E1F}', '\u{0066}', Some('\u{0307}')),
    ('\u{1E20}', '\u{0047}', Some('\u{0304}')),
    ('\u{1E21}', '\u{0067}', Some('\u{0304}')),
    ('\u{1E22}', '\u{0048}', Some('\u{0307}')),
    ('\u{1E23}', '\u{0068}', Some('\u{0307}')),
    ('\u{1E24}', '\u{0048}', Some('\u{0323}')),
    ('\u{1E25}', '\u{0068}', Some('\u{0323}')),
    ('\u{1E26}', '\u{0048}', Some('\u{0308}')),
    ('\u{1E27}', '\u{0068}', Some('\u{0308}')),
    ('\u{1E28}', '\u{0048}', Some('\u{0327}')),
    ('\u{1E29}', '\u{0068}', Some('\u{0327}')),
    ('\u{1E2A}', '\u{0048}', Some('\u{032E}')),
    ('\u{1E2B}', '\u{0068}', Some('\u{032E}')),
    ('\u{1E2C}', '\u{0049}', Some('\u{0330}')),
    ('\u{1E2D}', '\u{0069}', Some('\u{0330}')),
    ('\u{1E2E}', '\u{00CF}', Some('\u{0301}')),
    ('\u{1E2F}', '\u{00EF}', Some('\u{0301}')),
    ('\u{1E30}', '\u{004B}', Some('\u{0301}')),
    ('\u{1E31}', '\u{006B}', Some('\u{0301}')),
    ('\u{1E32}', '\u{004B}', Some('\u{0323}')),
    ('\u{1E33}', '\u{006B}', Some('\u{0323}')),
    ('\u{1E34}', '\u{004B}', Some('\u{0331}')),
    ('\u{1E35}', '\u{006B}', Some('\u{0331}')),
    ('\u{1E36}', '\u{004C}', Some('\u{0323}')),
    ('\u{1E37}', '\u{006C}', Some('\u{0323}')),
    ('\u{1E38}', '\u{1E36}', Some('\u{0304}')),
    ('\u{1E39}', '\u{1E37}', Some('\u{0304}')),
    ('\u{1E3A}', '\u{004C}', Some('\u{0331}')),
    ('\u{1E3B}', '\u{006C}', Some('\u{0331}')),
    ('\u{1E3C}', '\u{004C}', Some('\u{032D}')),
    ('\u{1E3D}', '\u{006C}', Some('\u{032D}')),
    ('\u{1E3E}', '\u{004D}', Some('\u{0301}')),
    ('\u{1E3F}', '\u{006D}', Some('\u{0301}')),
    ('\u{1E40}', '\u{004D}', Some('\u{0307}')),
    ('\u{1E41}', '\u{006D}', Some('\u{0307}')),
    ('\u{1E42}', '\u{004D}', Some('\u{0323}')),
    ('\u{1E43}', '\u{006D}', Some('\u{0323}')),
    ('\u{1E44}', '\u{004E}', Some('\u{0307}')),
    ('\u{1E45}', '\u{006E}', Some('\u{0307}')),
    ('\u{1E46}', '\u{004E}', Some('\u{0323}')),
    ('\u{1E47}', '\u{006E}', Some('\u{0323}')),
    ('\u{1E48}', '\u{004E}', Some('\u{0331}')),
    ('\u{1E49}', '\u{006E}', Some('\u{0331}')),
    ('\u{1E4A}', '\u{004E}', Some('\u{032D}')),
    ('\u{1E4B}', '\u{006E}', Some('\u{032D}')),
    ('\u{1E4C}', '\u{00D5}', Some('\u{0301}')),
    ('\u{1E4D}', '\u{00F5}', Some('\u{0301}')),
    ('\u{1E4E}', '\u{00D5}', Some('\u{0308}')),
    ('\u{1E4F}', '\u{00F5}', Some('\u{0308}')),
    ('\u{1E50}', '\u{014C}', Some('\u{0300}')),
    ('\u{1E51}', '\u{014D}', Some('\u{0300}')),
    ('\u{1E52}', '\u{014C}', Some('\u{0301}')),
    ('\u{1E53}', '\u{014D}', Some('\u{0301}')),
    ('\u{1E54}', '\u{0050}', Some('\u{0301}')),
    ('\u{1E55}', '\u{0070}', Some('\u{0301}')),
    ('\u{1E56}', '\u{0050}', Some('\u{0307}')),
    ('\u{1E57}', '\u{0070}', Some('\u{0307}')),
    ('\u{1E58}', '\u{0052}', Some('\u{0307}')),
    ('\u{1E59}', '\u{0072}', Some('\u{0307}')),
    ('\u{1E5A}', '\u{0052}', Some('\u{0323}')),
    ('\u{1E5B}', '\u{0072}', Some('\u{0323}')),
    ('\u{1E5C}', '\u{1E5A}', Some('\u{0304}')),
    ('\u{1E5D}', '\u{1E5B}', Some('\u{0304}')),
    ('\u{1E5E}', '\u{0052}', Some('\u{0331}')),
    ('\u{1E5F}', '\u{0072}', Some('\u{0331}')),
    ('\u{1E60}', '\u{0053}', Some('\u{0307}')),
    ('\u{1E61}', '\u{0073}', Some('\u{0307}')),
    ('\u{1E62}', '\u{0053}', Some('\u{0323}')),
    ('\u{1E63}', '\u{0073}', Some('\u{0323}')),
    ('\u{1E64}', '\u{015A}', Some('\u{0307}')),
    ('\u{1E65}', '\u{015B}', Some('\u{0307}')),
    ('\u{1E66}', '\u{0160}', Some('\u{0307}')),
    ('\u{1E67}', '\u{0161}', Some('\u{0307}')),
    ('\u{1E68}', '\u{1E62}', Some('\u{0307}')),
    ('\u{1E69}', '\u{1E63}', Some('\u{0307}')),
    ('\u{1E6A}', '\u{0054}', Some('\u{0307}')),
    ('\u{1E6B}', '\u{0074}', Some('\u{0307}')),
    ('\u{1E6C}', '\u{0054}', Some('\u{0323}')),
    ('\u{1E6D}', '\u{0074}', Some('\u{0323}')),
    ('\u{1E6E}', '\u{0054}', Some('\u{0331}')),
    ('\u{1E6F}', '\u{0074}', Some('\u{0331}')),
    ('\u{1E70}', '\u{0054}', Some('\u{032D}')),
    ('\u{1E71}', '\u{0074}', Some('\u{032D}')),
    ('\u{1E72}', '\u{0055}', Some('\u{0324}')),
    ('\u{1E73}', '\u{0075}', Some('\u{0324}')),
    ('\u{1E74}', '\u{0055}', Some('\u{0330}')),
    ('\u{1E75}', '\u{0075}', Some('\u{0330}')),
    ('\u{1E76}', '\u{0055}', Some('\u{032D}')),
    ('\u{1E77}', '\u{0075}', Some('\u{032D}')),
    ('\u{1E78}', '\u{0168}', Some('\u{0301}')),
    ('\u{1E79}', '\u{0169}', Some('\u{0301}')),
    ('\u{1E7A}', '\u{016A}', Some('\u{0308}')),
    ('\u{1E7B}', '\u{016B}', Some('\u{0308}')),
    ('\u{1E7C}', '\u{0056}', Some('\u{0303}')),
    ('\u{1E7D}', '\u{0076}', Some('\u{0303}')),
    ('\u{1E7E}', '\u{0056}', Some('\u{0323}')),
    ('\u{1E7F}', '\u{0076}', Some('\u{0323}')),
    ('\u{1E80}', '\u{0057}', Some('\u{0300}')),
    ('\u{1E81}', '\u{0077}', Some('\u{0300}')),
    ('\u{1E82}', '\u{0057}', Some('\u{0301}')),
    ('\u{1E83}', '\u{0077}', Some('\u{0301}')),
    ('\u{1E84}', '\u{0057}', Some('\u{0308}')),
    ('\u{1E85}', '\u{0077}', Some('\u{0308}')),
    ('\u{1E86}', '\u{0057}', Some('\u{0307}')),
    ('\u{1E87}', '\u{0077}', Some('\u{0307}')),
    ('\u{1E88}', '\u{0057}', Some('\u{0323}')),
    ('\u{1E89}', '\u{0077}', Some('\u{0323}')),
    ('\u{1E8A}', '\u{0058}', Some('\u{0307}')),
    ('\u{1E8B}', '\u{0078}', Some('\u{0307}')),
    ('\u{1E8C}', '\u{0058}', Some('\u{0308}')),
    ('\u{1E8D}', '\u{0078}', Some('\u{0308}')),
    ('\u{1E8E}', '\u{0059}', Some('\u{0307}')),
    ('\u{1E8F}', '\u{0079}', Some('\u{0307}')),
    ('\u{1E90}', '\u{005A}', Some('\u{0302}')),
    ('\u{1E91}', '\u{007A}', Some('\u{0302}')),
    ('\u{1E92}', '\u{005A}', Some('\u{0323}')),
    ('\u{1E93}', '\u{007A}', Some('\u{0323}')),
    ('\u{1E94}', '\u{005A}', Some('\u{0331}')),
    ('\u{1E95}', '\u{007A}', Some('\u{0331}')),
    ('\u{1E96}', '\u{0068}', Some('\u{0331}')),
    ('\u{1E97}', '\u{0074}', Some('\u{0308}')),
    ('\u{1E98}', '\u{0077}', Some('\u{030A}')),
    ('\u{1E99}', '\u{0079}', Some('\u{030A}')),
    ('\u{1E9B}', '\u{017F}', Some('\u{0307}')),
    ('\u{1EA0}', '\u{0041}', Some('\u{0323}')),
    ('\u{1EA1}', '\u{0061}', Some('\u{0323}')),
    ('\u{1EA2}', '\u{0041}', Some('\u{0309}')),
    ('\u{1EA3}', '\u{0061}', Some('\u{0309}')),
    ('\u{1EA4}', '\u{00C2}', Some('\u{0301}')),
    ('\u{1EA5}', '\u{00E2}', Some('\u{0301}')),
    ('\u{1EA6}', '\u{00C2}', Some('\u{0300}')),
    ('\u{1EA7}', '\u{00E2}', Some('\u{0300}')),
    ('\u{1EA8}', '\u{00C2}', Some('\u{0309}')),
    ('\u{1EA9}', '\u{00E2}', Some('\u{0309}')),
    ('\u{1EAA}', '\u{00C2}', Some('\u{0303}')),
    ('\u{1EAB}', '\u{00E2}', Some('\u{0303}')),
    ('\u{1EAC}', '\u{1EA0}', Some('\u{0302}')),
    ('\u{1EAD}', '\u{1EA1}', Some('\u{0302}')),
    ('\u{1EAE}', '\u{0102}', Some('\u{0301}')),
    ('\u{1EAF}', '\u{0103}', Some('\u{0301}')),
    ('\u{1EB0}', '\u{0102}', Some('\u{0300}')),
    ('\u{1EB1}', '\u{0103}', Some('\u{0300}')),
    ('\u{1EB2}', '\u{0102}', Some('\u{0309}')),
    ('\u{1EB3}', '\u{0103}', Some('\u{0309}')),
    ('\u{1EB4}', '\u{0102}', Some('\u{0303}')),
    ('\u{1EB5}', '\u{0103}', Some('\u{0303}')),
    ('\u{1EB6}', '\u{1EA0}', Some('\u{0306}')),
    ('\u{1EB7}', '\u{1EA1}', Some('\u{0306}')),
    ('\u{1EB8}', '\u{0045}', Some('\u{0323}')),
    ('\u{1EB9}', '\u{0065}', Some('\u{0323}')),
    ('\u{1EBA}', '\u{0045}', Some('\u{0309}')),
    ('\u{1EBB}', '\u{0065}', Some('\u{0309}')),
    ('\u{1EBC}', '\u{0045}', Some('\u{0303}')),
    ('\u{1EBD}', '\u{0065}', Some('\u{0303}')),
    ('\u{1EBE}', '\u{00CA}', Some('\u{0301}')),
    ('\u{1EBF}', '\u{00EA}', Some('\u{0301}')),
    ('\u{1EC0}', '\u{00CA}', Some('\u{0300}')),
    ('\u{1EC1}', '\u{00EA}', Some('\u{0300}')),
    ('\u{1EC2}', '\u{00CA}', Some('\u{0309}')),
    ('\u{1EC3}', '\u{00EA}', Some('\u{0309}')),
    ('\u{1EC4}', '\u{00CA}', Some('\u{0303}')),
    ('\u{1EC5}', '\u{00EA}', Some('\u{0303}')),
    ('\u{1EC6}', '\u{1EB8}', Some('\u{0302}')),
    ('\u{1EC7}', '\u{1EB9}', Some('\u{0302}')),
    ('\u{1EC8}', '\u{0049}', Some('\u{0309}')),
    ('\u{1EC9}', '\u{0069}', Some('\u{0309}')),
    ('\u{1ECA}', '\u{0049}', Some('\u{0323}')),
    ('\u{1ECB}', '\u{0069}', Some('\u{0323}')),
    ('\u{1ECC}', '\u{004F}', Some('\u{0323}')),
    ('\u{1ECD}', '\u{006F}', Some('\u{0323}')),
    ('\u{1ECE}', '\u{004F}', Some('\u{0309}')),
    ('\u{1ECF}', '\u{006F}', Some('\u{0309}')),
    ('\u{1ED0}', '\u{00D4}', Some('\u{0301}')),
    ('\u{1ED1}', '\u{00F4}', Some('\u{0301}')),
    ('\u{1ED2}', '\u{00D4}', Some('\u{0300}')),
    ('\u{1ED3}', '\u{00F4}', Some('\u{0300}')),
    ('\u{1ED4}', '\u{00D4}', Some('\u{0309}')),
    ('\u{1ED5}', '\u{00F4}', Some('\u{0309}')),
    ('\u{1ED6}', '\u{00D4}', Some('\u{0303}')),
    ('\u{1ED7}', '\u{00F4}', Some('\u{0303}')),
    ('\u{1ED8}', '\u{1ECC}', Some('\u{0302}')),
    ('\u{1ED9}', '\u{1ECD}', Some('\u{0302}')),
    ('\u{1EDA}', '\u{01A0}', Some('\u{0301}')),
    ('\u{1EDB}', '\u{01A1}', Some('\u{0301}')),
    ('\u{1EDC}', '\u{01A0}', Some('\u{0300}')),
    ('\u{1EDD}', '\u{01A1}', Some('\u{0300}')),
    ('\u{1EDE}', '\u{01A0}', Some('\u{0309}')),
    ('\u{1EDF}', '\u{01A1}', Some('\u{0309}')),
    ('\u{1EE0}', '\u{01A0}', Some('\u{0303}')),
    ('\u{1EE1}', '\u{01A1}', Some('\u{0303}')),
    ('\u{1EE2}', '\u{01A0}', Some('\u{0323}')),
    ('\u{1EE3}', '\u{01A1}', Some('\u{0323}')),
    ('\u{1EE4}', '\u{0055}', Some('\u{0323}')),
    ('\u{1EE5}', '\u{0075}', Some('\u{0323}')),
    ('\u{1EE6}', '\u{0055}', Some('\u{0309}')),
    ('\u{1EE7}', '\u{0075}', Some('\u{0309}')),
    ('\u{1EE8}', '\u{01AF}', Some('\u{0301}')),
    ('\u{1EE9}', '\u{01B0}', Some('\u{0301}')),
    ('\u{1EEA}', '\u{01AF}', Some('\u{0300}')),
    ('\u{1EEB}', '\u{01B0}', Some('\u{0300}')),
    ('\u{1EEC}', '\u{01AF}', Some('\u{0309}')),
    ('\u{1EED}', '\u{01B0}', Some('\u{0309}')),
    ('\u{1EEE}', '\u{01AF}', Some('\u{0303}')),
    ('\u{1EEF}', '\u{01B0}', Some('\u{0303}')),
    ('\u{1EF0}', '\u{01AF}', Some('\u{0323}')),
    ('\u{1EF1}', '\u{01B0}', Some('\u{0323}')),
    ('\u{1EF2}', '\u{0059}', Some('\u{0300}')),
    ('\u{1EF3}', '\u{0079}', Some('\u{0300}')),
    ('\u{1EF4}', '\u{0059}', Some('\u{0323}')),
    ('\u{1EF5}', '\u{0079}', Some('\u{0323}')),
    ('\u{1EF6}', '\u{0059}', Some('\u{0309}')),
    ('\u{1EF7}', '\u{0079}', Some('\u{0309}')),
    ('\u{1EF8}', '\u{0059}', Some('\u{0303}')),
    ('\u{1EF9}', '\u{0079}', Some('\u{0303}')),
    ('\u{1F00}', '\u{03B1}', Some('\u{0313}')),
    ('\u{1F01}', '\u{03B1}', Some('\u{0314}')),
    ('\u{1F02}', '\u{1F00}', Some('\u{0300}')),
    ('\u{1F03}', '\u{1F01}', Some('\u{0300}')),
    ('\u{1F04}', '\u{1F00}', Some('\u{0301}')),
    ('\u{1F05}', '\u{1F01}', Some('\u{0301}')),
    ('\u{1F06}', '\u{1F00}', Some('\u{0342}')),
    ('\u{1F07}', '\u{1F01}', Some('\u{0342}')),
    ('\u{1F08}', '\u{0391}', Some('\u{0313}')),
    ('\u{1F09}', '\u{0391}', Some('\u{0314}')),
    ('\u{1F0A}', '\u{1F08}', Some('\u{0300}')),
    ('\u{1F0B}', '\u{1F09}', Some('\u{0300}')),
    ('\u{1F0C}', '\u{1F08}', Some('\u{0301}')),
    ('\u{1F0D}', '\u{1F09}', Some('\u{0301}')),
    ('\u{1F0E}', '\u{1F08}', Some('\u{0342}')),
    ('\u{1F0F}', '\u{1F09}', Some('\u{0342}')),
    ('\u{1F10}', '\u{03B5}', Some('\u{0313}')),
    ('\u{1F11}', '\u{03B5}', Some('\u{0314}')),
    ('\u{1F12}', '\u{1F10}', Some('\u{0300}')),
    ('\u{1F13}', '\u{1F11}', Some('\u{0300}')),
    ('\u{1F14}', '\u{1F10}', Some('\u{0301}')),
    ('\u{1F15}', '\u{1F11}', Some('\u{0301}')),
    ('\u{1F18}', '\u{0395}', Some('\u{0313}')),
    ('\u{1F19}', '\u{0395}', Some('\u{0314}')),
    ('\u{1F1A}', '\u{1F18}', Some('\u{0300}')),
    ('\u{1F1B}', '\u{1F19}', Some('\u{0300}')),
    ('\u{1F1C}', '\u{1F18}', Some('\u{0301}')),
    ('\u{1F1D}', '\u{1F19}', Some('\u{0301}')),
    ('\u{1F20}', '\u{03B7}', Some('\u{0313}')),
    ('\u{1F21}', '\u{03B7}', Some('\u{0314}')),
    ('\u{1F22}', '\u{1F20}', Some('\u{0300}')),
    ('\u{1F23}', '\u{1F21}', Some('\u{0300}')),
    ('\u{1F24}', '\u{1F20}', Some('\u{0301}')),
    ('\u{1F25}', '\u{1F21}', Some('\u{0301}')),
    ('\u{1F26}', '\u{1F20}', Some('\u{0342}')),
    ('\u{1F27}', '\u{1F21}', Some('\u{0342}')),
    ('\u{1F28}', '\u{0397}', Some('\u{0313}')),
    ('\u{1F29}', '\u{0397}', Some('\u{0314}')),
    ('\u{1F2A}', '\u{1F28}', Some('\u{0300}')),
    ('\u{1F2B}', '\u{1F29}', Some('\u{0300}')),
    ('\u{1F2C}', '\u{1F28}', Some('\u{0301}')),
    ('\u{1F2D}', '\u{1F29}', Some('\u{0301}')),
    ('\u{1F2E}', '\u{1F28}', Some('\u{0342}')),
    ('\u{1F2F}', '\u{1F29}', Some('\u{0342}')),
    ('\u{1F30}', '\u{03B9}', Some('\u{0313}')),
    ('\u{1F31}', '\u{03B9}', Some('\u{0314}')),
    ('\u{1F32}', '\u{1F30}', Some('\u{0300}')),
    ('\u{1F33}', '\u{1F31}', Some('\u{0300}')),
    ('\u{1F34}', '\u{1F30}', Some('\u{0301}')),
    ('\u{1F35}', '\u{1F31}', Some('\u{0301}')),
    ('\u{1F36}', '\u{1F30}', Some('\u{0342}')),
    ('\u{1F37}', '\u{1F31}', Some('\u{0342}')),
    ('\u{1F38}', '\u{0399}', Some('\u{0313}')),
    ('\u{1F39}', '\u{0399}', Some('\u{0314}')),
    ('\u{1F3A}', '\u{1F38}', Some('\u{0300}')),
    ('\u{1F3B}', '\u{1F39}', Some('\u{0300}')),
    ('\u{1F3C}', '\u{1F38}', Some('\u{0301}')),
    ('\u{1F3D}', '\u{1F39}', Some('\u{0301}')),
    ('\u{1F3E}', '\u{1F38}', Some('\u{0342}')),
    ('\u{1F3F}', '\u{1F39}', Some('\u{0342}')),
    ('\u{1F40}', '\u{03BF}', Some('\u{0313}')),
    ('\u{1F41}', '\u{03BF}', Some('\u{0314}')),
    ('\u{1F42}', '\u{1F40}', Some('\u{0300}')),
    ('\u{1F43}', '\u{1F41}', Some('\u{0300}')),
    ('\u{1F44}', '\u{1F40}', Some('\u{0301}')),
    ('\u{1F45}', '\u{1F41}', Some('\u{0301}')),
    ('\u{1F48}', '\u{039F}', Some('\u{0313}')),
    ('\u{1F49}', '\u{039F}', Some('\u{0314}')),
    ('\u{1F4A}', '\u{1F48}', Some('\u{0300}')),
    ('\u{1F4B}', '\u{1F49}', Some('\u{0300}')),
    ('\u{1F4C}', '\u{1F48}', Some('\u{0301}')),
    ('\u{1F4D}', '\u{1F49}', Some('\u{0301}')),
    ('\u{1F50}', '\u{03C5}', Some('\u{0313}')),
    ('\u{1F51}', '\u{03C5}', Some('\u{0314}')),
    ('\u{1F52}', '\u{1F50}', Some('\u{0300}')),
    ('\u{1F53}', '\u{1F51}', Some('\u{0300}')),
    ('\u{1F54}', '\u{1F50}', Some('\u{0301}')),
    ('\u{1F55}', '\u{1F51}', Some('\u{0301}')),
    ('\u{1F56}', '\u{1F50}', Some('\u{0342}')),
    ('\u{1F57}', '\u{1F51}', Some('\u{0342}')),
    ('\u{1F59}', '\u{03A5}', Some('\u{0314}')),
    ('\u{1F5B}', '\u{1F59}', Some('\u{0300}')),
    ('\u{1F5D}', '\u{1F59}', Some('\u{0301}')),
    ('\u{1F5F}', '\u{1F59}', Some('\u{0342}')),
    ('\u{1F60}', '\u{03C9}', Some('\u{0313}')),
    ('\u{1F61}', '\u{03C9}', Some('\u{0314}')),
    ('\u{1F62}', '\u{1F60}', Some('\u{0300}')),
    ('\u{1F63}', '\u{1F61}', Some('\u{0300}')),
    ('\u{1F64}', '\u{1F60}', Some('\u{0301}')),
    ('\u{1F65}', '\u{1F61}', Some('\u{0301}')),
    ('\u{1F66}', '\u{1F60}', Some('\u{0342}')),
    ('\u{1F67}', '\u{1F61}', Some('\u{0342}')),
    ('\u{1F68}', '\u{03A9}', Some('\u{0313}')),
    ('\u{1F69}', '\u{03A9}', Some('\u{0314}')),
    ('\u{1F6A}', '\u{1F68}', Some('\u{0300}')),
    ('\u{1F6B}', '\u{1F69}', Some('\u{0300}')),
    ('\u{1F6C}', '\u{1F68}', Some('\u{0301}')),
    ('\u{1F6D}', '\u{1F69}', Some('\u{0301}')),
    ('\u{1F6E}', '\u{1F68}', Some('\u{0342}')),
    ('\u{1F6F}', '\u{1F69}', Some('\u{0342}')),
    ('\u{1F70}', '\u{03B1}', Some('\u{0300}')),
    ('\u{1F71}', '\u{03AC}', None),
    ('\u{1F72}', '\u{03B5}', Some('\u{0300}')),
    ('\u{1F73}', '\u{03AD}', None),
    ('\u{1F74}', '\u{03B7}', Some('\u{0300}')),
    ('\u{1F75}', '\u{03AE}', None),
    ('\u{1F76}', '\u{03B9}', Some('\u{0300}')),
    ('\u{1F77}', '\u{03AF}', None),
    ('\u{1F78}', '\u{03BF}', Some('\u{0300}')),
    ('\u{1F79}', '\u{03CC}', None),
    ('\u{1F7A}', '\u{03C5}', Some('\u{0300}')),
    ('\u{1F7B}', '\u{03CD}', None),
    ('\u{1F7C}', '\u{03C9}', Some('\u{0300}')),
    ('\u{1F7D}', '\u{03CE}', None),
    ('\u{1F80}', '\u{1F00}', Some('\u{0345}')),
    ('\u{1F81}', '\u{1F01}', Some('\u{0345}')),
    ('\u{1F82}', '\u{1F02}', Some('\u{0345}')),
    ('\u{1F83}', '\u{1F03}', Some('\u{0345}')),
    ('\u{1F84}', '\u{1F04}', Some('\u{0345}')),
    ('\u{1F85}', '\u{1F05}', Some('\u{0345}')),
    ('\u{1F86}', '\u{1F06}', Some('\u{0345}')),
    ('\u{1F87}', '\u{1F07}', Some('\u{0345}')),
    ('\u{1F88}', '\u{1F08}', Some('\u{0345}')),
    ('\u{1F89}', '\u{1F09}', Some('\u{0345}')),
    ('\u{1F8A}', '\u{1F0A}', Some('\u{0345}')),
    ('\u{1F8B}', '\u{1F0B}', Some('\u{0345}')),
    ('\u{1F8C}', '\u{1F0C}', Some('\u{0345}')),
    ('\u{1F8D}', '\u{1F0D}', Some('\u{0345}')),
    ('\u{1F8E}', '\u{1F0E}', Some('\u{0345}')),
    ('\u{1F8F}', '\u{1F0F}', Some('\u{0345}')),
    ('\u{1F90}', '\u{1F20}', Some('\u{0345}')),
    ('\u{1F91}', '\u{1F21}', Some('\u{0345}')),
    ('\u{1F92}', '\u{1F22}', Some('\u{0345}')),
    ('\u{1F93}', '\u{1F23}', Some('\u{0345}')),
    ('\u{1F94}', '\u{1F24}', Some('\u{0345}')),
    ('\u{1F95}', '\u{1F25}', Some('\u{0345}')),
    ('\u{1F96}', '\u{1F26}', Some('\u{0345}')),
    ('\u{1F97}', '\u{1F27}', Some('\u{0345}')),
    ('\u{1F98}', '\u{1F28}', Some('\u{0345}')),
    ('\u{1F99}', '\u{1F29}', Some('\u{0345}')),
    ('\u{1F9A}', '\u{1F2A}', Some('\u{0345}')),
    ('\u{1F9B}', '\u{1F2B}', Some('\u{0345}')),
    ('\u{1F9C}', '\u{1F2C}', Some('\u{0345}')),
    ('\u{1F9D}', '\u{1F2D}', Some('\u{0345}')),
    ('\u{1F9E}', '\u{1F2E}', Some('\u{0345}')),
    ('\u{1F9F}', '\u{1F2F}', Some('\u{0345}')),
    ('\u{1FA0}', '\u{1F60}', Some('\u{0345}')),
    ('\u{1FA1}', '\u{1F61}', Some('\u{0345}')),
    ('\u{1FA2}', '\u{1F62}', Some('\u{0345}')),
    ('\u{1FA3}', '\u{1F63}', Some('\u{0345}')),
    ('\u{1FA4}', '\u{1F64}', Some('\u{0345}')),
    ('\u{1FA5}', '\u{1F65}', Some('\u{0345}')),
    ('\u{1FA6}', '\u{1F66}', Some('\u{0345}')),
    ('\u{1FA7}', '\u{1F67}', Some('\u{0345}')),
    ('\u{1FA8}', '\u{1F68}', Some('\u{0345}')),
    ('\u{1FA9}', '\u{1F69}', Some('\u{0345}')),
    ('\u{1FAA}', '\u{1F6A}', Some('\u{0345}')),
    ('\u{1FAB}', '\u{1F6B}', Some('\u{0345}')),
    ('\u{1FAC}', '\u{1F6C}', Some('\u{0345}')),
    ('\u{1FAD}', '\u{1F6D}', Some('\u{0345}')),
    ('\u{1FAE}', '\u{1F6E}', Some('\u{0345}')),
    ('\u{1FAF}', '\u{1F6F}', Some('\u{0345}')),
    ('\u{1FB0}', '\u{03B1}', Some('\u{0306}')),
    ('\u{1FB1}', '\u{03B1}', Some('\u{0304}')),
    ('\u{1FB2}', '\u{1F70}', Some('\u{0345}')),
    ('\u{1FB3}', '\u{03B1}', Some('\u{0345}')),
    ('\u{1FB4}', '\u{03AC}', Some('\u{0345}')),
    ('\u{1FB6}', '\u{03B1}', Some('\u{0342}')),
    ('\u{1FB7}', '\u{1FB6}', Some('\u{0345}')),
    ('\u{1FB8}', '\u{0391}', Some('\u{0306}')),
    ('\u{1FB9}', '\u{0391}', Some('\u{0304}')),
    ('\u{1FBA}', '\u{0391}', Some('\u{0300}')),
    ('\u{1FBB}', '\u{0386}', None),
    ('\u{1FBC}', '\u{0391}', Some('\u{0345}')),
    ('\u{1FBE}', '\u{03B9}', None),
    ('\u{1FC1}', '\u{00A8}', Some('\u{0342}')),
    ('\u{1FC2}', '\u{1F74}', Some('\u{0345}')),
    ('\u{1FC3}', '\u{03B7}', Some('\u{0345}')),
    ('\u{1FC4}', '\u{03AE}', Some('\u{0345}')),
    ('\u{1FC6}', '\u{03B7}', Some('\u{0342}')),
    ('\u{1FC7}', '\u{1FC6}', Some('\u{0345}')),
    ('\u{1FC8}', '\u{0395}', Some('\u{0300}')),
    ('\u{1FC9}', '\u{0388}', None),
    ('\u{1FCA}', '\u{0397}', Some('\u{0300}')),
    ('\u{1FCB}', '\u{0389}', None),
    ('\u{1FCC}', '\u{0397}', Some('\u{0345}')),
    ('\u{1FCD}', '\u{1FBF}', Some('\u{0300}')),
    ('\u{1FCE}', '\u{1FBF}', Some('\u{0301}')),
    ('\u{1FCF}', '\u{1FBF}', Some('\u{0342}')),
    ('\u{1FD0}', '\u{03B9}', Some('\u{0306}')),
    ('\u{1FD1}', '\u{03B9}', Some('\u{0304}')),
    ('\u{1FD2}', '\u{03CA}', Some('\u{0300}')),
    ('\u{1FD3}', '\u{0390}', None),
    ('\u{1FD6}', '\u{03B9}', Some('\u{0342}')),
    ('\u{1FD7}', '\u{03CA}', Some('\u{0342}')),
    ('\u{1FD8}', '\u{0399}', Some('\u{0306}')),
    ('\u{1FD9}', '\u{0399}', Some('\u{0304}')),
    ('\u{1FDA}', '\u{0399}', Some('\u{0300}')),
    ('\u{1FDB}', '\u{038A}', None),
    ('\u{1FDD}', '\u{1FFE}', Some('\u{0300}')),
    ('\u{1FDE}', '\u{1FFE}', Some('\u{0301}')),
    ('\u{1FDF}', '\u{1FFE}', Some('\u{0342}')),
    ('\u{1FE0}', '\u{03C5}', Some('\u{0306}')),
    ('\u{1FE1}', '\u{03C5}', Some('\u{0304}')),
    ('\u{1FE2}', '\u{03CB}', Some('\u{0300}')),
    ('\u{1FE3}', '\u{03B0}', None),
    ('\u{1FE4}', '\u{03C1}', Some('\u{0313}')),
    ('\u{1FE5}', '\u{03C1}', Some('\u{0314}')),
    ('\u{1FE6}', '\u{03C5}', Some('\u{0342}')),
    ('\u{1FE7}', '\u{03CB}', Some('\u{0342}')),
    ('\u{1FE8}', '\u{03A5}', Some('\u{0306}')),
    ('\u{1FE9}', '\u{03A5}', Some('\u{0304}')),
    ('\u{1FEA}', '\u{03A5}', Some('\u{0300}')),
    ('\u{1FEB}', '\u{038E}', None),
    ('\u{1FEC}', '\u{03A1}', Some('\u{0314}')),
    ('\u{1FED}', '\u{00A8}', Some('\u{0300}')),
    ('\u{1FEE}', '\u{0385}', None),
    ('\u{1FEF}', '\u{0060}', None),
    ('\u{1FF2}', '\u{1F7C}', Some('\u{0345}')),
    ('\u{1FF3}', '\u{03C9}', Some('\u{0345}')),
    ('\u{1FF4}', '\u{03CE}', Some('\u{0345}')),
    ('\u{1FF6}', '\u{03C9}', Some('\u{0342}')),
    ('\u{1FF7}', '\u{1FF6}', Some('\u{0345}')),
    ('\u{1FF8}', '\u{039F}', Some('\u{0300}')),
    ('\u{1FF9}', '\u{038C}', None),
    ('\u{1FFA}', '\u{03A9}', Some('\u{0300}')),
    ('\u{1FFB}', '\u{038F}', None),
    ('\u{1FFC}', '\u{03A9}', Some('\u{0345}')),
    ('\u{1FFD}', '\u{00B4}', None),
    ('\u{2000}', '\u{2002}', None),
    ('\u{2001}', '\u{2003}', None),
    ('\u{2126}', '\u{03A9}', None),
    ('\u{212A}', '\u{004B}', None),
    ('\u{212B}', '\u{00C5}', None),
    ('\u{219A}', '\u{2190}', Some('\u{0338}')),
    ('\u{219B}', '\u{2192}', Some('\u{0338}')),
    ('\u{21AE}', '\u{2194}', Some('\u{0338}')),
    ('\u{21CD}', '\u{21D0}', Some('\u{0338}')),
    ('\u{21CE}', '\u{21D4}', Some('\u{0338}')),
    ('\u{21CF}', '\u{21D2}', Some('\u{0338}')),
    ('\u{2204}', '\u{2203}', Some('\u{0338}')),
    ('\u{2209}', '\u{2208}', Some('\u{0338}')),
    ('\u{220C}', '\u{220B}', Some('\u{0338}')),
    ('\u{2224}', '\u{2223}', Some('\u{0338}')),
    ('\u{2226}', '\u{2225}', Some('\u{0338}')),
    ('\u{2241}', '\u{223C}', Some('\u{0338}')),
    ('\u{2244}', '\u{2243}', Some('\u{0338}')),
    ('\u{2247}', '\u{2245}', Some('\u{0338}')),
    ('\u{2249}', '\u{2248}', Some('\u{0338}')),
    ('\u{2260}', '\u{003D}', Some('\u{0338}')),
    ('\u{2262}', '\u{2261}', Some('\u{0338}')),
    ('\u{226D}', '\u{224D}', Some('\u{0338}')),
    ('\u{226E}', '\u{003C}', Some('\u{0338}')),
    ('\u{226F}', '\u{003E}', Some('\u{0338}')),
    ('\u{2270}', '\u{2264}', Some('\u{0338}')),
    ('\u{2271}', '\u{2265}', Some('\u{0338}')),
    ('\u{2274}', '\u{2272}', Some('\u{0338}')),
    ('\u{2275}', '\u{2273}', Some('\u{0338}')),
    ('\u{2278}', '\u{2276}', Some('\u{0338}')),
    ('\u{2279}', '\u{2277}', Some('\u{0338}')),
    ('\u{2280}', '\u{227A}', Some('\u{0338}')),
    ('\u{2281}', '\u{227B}', Some('\u{0338}')),
    ('\u{2284}', '\u{2282}', Some('\u{0338}')),
    ('\u{2285}', '\u{2283}', Some('\u{0338}')),
    ('\u{2288}', '\u{2286}', Some('\u{0338}')),
    ('\u{2289}', '\u{2287}', Some('\u{0338}')),
    ('\u{22AC}', '\u{22A2}', Some('\u{0338}')),
    ('\u{22AD}', '\u{22A8}', Some('\u{0338}')),
    ('\u{22AE}', '\u{22A9}', Some('\u{0338}')),
    ('\u{22AF}', '\u{22AB}', Some('\u{0338}')),
    ('\u{22E0}', '\u{227C}', Some('\u{0338}')),
    ('\u{22E1}', '\u{227D}', Some('\u{0338}')),
    ('\u{22E2}', '\u{2291}', Some('\u{0338}')),
    ('\u{22E3}', '\u{2292}', Some('\u{0338}')),
    ('\u{22EA}', '\u{22B2}', Some('\u{0338}')),
    ('\u{22EB}', '\u{22B3}', Some('\u{0338}')),
    ('\u{22EC}', '\u{22B4}', Some('\u{0338}')),
    ('\u{22ED}', '\u{22B5}', Some('\u{0338}')),
    ('\u{2329}', '\u{3008}', None),
    ('\u{232A}', '\u{3009}', None),
    ('\u{2ADC}', '\u{2ADD}', Some('\u{0338}')),
    ('\u{304C}', '\u{304B}', Some('\u{3099}')),
    ('\u{304E}', '\u{304D}', Some('\u{3099}')),
    ('\u{3050}', '\u{304F}', Some('\u{3099}')),
    ('\u{3052}', '\u{3051}', Some('\u{3099}')),
    ('\u{3054}', '\u{3053}', Some('\u{3099}')),
    ('\u{3056}', '\u{3055}', Some('\u{3099}')),
    ('\u{3058}', '\u{3057}', Some('\u{3099}')),
    ('\u{305A}', '\u{3059}', Some('\u{3099}')),
    ('\u{305C}', '\u{305B}', Some('\u{3099}')),
    ('\u{305E}', '\u{305D}', Some('\u{3099}')),
    ('\u{3060}', '\u{305F}', Some('\u{3099}')),
    ('\u{3062}', '\u{3061}', Some('\u{3099}')),
    ('\u{3065}', '\u{3064}', Some('\u{3099}')),
    ('\u{3067}', '\u{3066}', Some('\u{3099}')),
    ('\u{3069}', '\u{3068}', Some('\u{3099}')),
    ('\u{3070}', '\u{306F}', Some('\u{3099}')),
    ('\u{3071}', '\u{306F}', Some('\u{309A}')),
    ('\u{3073}', '\u{3072}', Some('\u{3099}')),
    ('\u{3074}', '\u{3072}', Some('\u{309A}')),
    ('\u{3076}', '\u{3075}', Some('\u{3099}')),
    ('\u{3077}', '\u{3075}', Some('\u{309A}')),
    ('\u{3079}', '\u{3078}', Some('\u{3099}')),
    ('\u{307A}', '\u{3078}', Some('\u{309A}')),
    ('\u{307C}', '\u{307B}', Some('\u{3099}')),
    ('\u{307D}', '\u{307B}', Some('\u{309A}')),
    ('\u{3094}', '\u{3046}', Some('\u{3099}')),
    ('\u{309E}', '\u{309D}', Some('\u{3099}')),
    ('\u{30AC}', '\u{30AB}', Some('\u{3099}')),
    ('\u{30AE}', '\u{30AD}', Some('\u{3099}')),
    ('\u{30B0}', '\u{30AF}', Some('\u{3099}')),
    ('\u{30B2}', '\u{30B1}', Some('\u{3099}')),
    ('\u{30B4}', '\u{30B3}', Some('\u{3099}')),
    ('\u{30B6}', '\u{30B5}', Some('\u{3099}')),
    ('\u{30B8}', '\u{30B7}', Some('\u{3099}')),
    ('\u{30BA}', '\u{30B9}', Some('\u{3099}')),
    ('\u{30BC}', '\u{30BB}', Some('\u{3099}')),
    ('\u{30BE}', '\u{30BD}', Some('\u{3099}')),
    ('\u{30C0}', '\u{30BF}', Some('\u{3099}')),
    ('\u{30C2}', '\u{30C1}', Some('\u{3099}')),
    ('\u{30C5}', '\u{30C4}', Some('\u{3099}')),
    ('\u{30C7}', '\u{30C6}', Some('\u{3099}')),
    ('\u{30C9}', '\u{30C8}', Some('\u{3099}')),
    ('\u{30D0}', '\u{30CF}', Some('\u{3099}')),
    ('\u{30D1}', '\u{30CF}', Some('\u{309A}')),
    ('\u{30D3}', '\u{30D2}', Some('\u{3099}')),
    ('\u{30D4}', '\u{30D2}', Some('\u{309A}')),
    ('\u{30D6}', '\u{30D5}', Some('\u{3099}')),
    ('\u{30D7}', '\u{30D5}', Some('\u{309A}')),
    ('\u{30D9}', '\u{30D8}', Some('\u{3099}')),
    ('\u{30DA}', '\u{30D8}', Some('\u{309A}')),
    ('\u{30DC}', '\u{30DB}', Some('\u{3099}')),
    ('\u{30DD}', '\u{30DB}', Some('\u{309A}')),
    ('\u{30F4}', '\u{30A6}', Some('\u{3099}')),
    ('\u{30F7}', '\u{30EF}', Some('\u{3099}')),
    ('\u{30F8}', '\u{30F0}', Some('\u{3099}')),
    ('\u{30F9}', '\u{30F1}', Some('\u{3099}')),
    ('\u{30FA}', '\u{30F2}', Some('\u{3099}')),
    ('\u{30FE}', '\u{30FD}', Some('\u{3099}')),
    ('\u{F900}', '\u{8C48}', None),
    ('\u{F901}', '\u{66F4}', None),
    ('\u{F902}', '\u{8ECA}', None),
    ('\u{F903}', '\u{8CC8}', None),
    ('\u{F904}', '\u{6ED1}', None),
    ('\u{F905}', '\u{4E32}', None),
    ('\u{F906}', '\u{53E5}', None),
    ('\u{F907}', '\u{9F9C}', None),
    ('\u{F908}', '\u{9F9C}', None),
    ('\u{F909}', '\u{5951}', None),
    ('\u{F90A}', '\u{91D1}', None),
    ('\u{F90B}', '\u{5587}', None),
    ('\u{F90C}', '\u{5948}', None),
    ('\u{F90D}', '\u{61F6}', None),
    ('\u{F90E}', '\u{7669}', None),
    ('\u{F90F}', '\u{7F85}', None),
    ('\u{F910}', '\u{863F}', None),
    ('\u{F911}', '\u{87BA}', None),
    ('\u{F912}', '\u{88F8}', None),
    ('\u{F913}', '\u{908F}', None),
    ('\u{F914}', '\u{6A02}', None),
    ('\u{F915}', '\u{6D1B}', None),
    ('\u{F916}', '\u{70D9}', None),
    ('\u{F917}', '\u{73DE}', None),
    ('\u{F918}', '\u{843D}', None),
    ('\u{F919}', '\u{916A}', None),
    ('\u{F91A}', '\u{99F1}', None),
    ('\u{F91B}', '\u{4E82}', None),
    ('\u{F91C}', '\u{5375}', None),
    ('\u{F91D}', '\u{6B04}', None),
    ('\u{F91E}', '\u{721B}', None),
    ('\u{F91F}', '\u{862D}', None),
    ('\u{F920}', '\u{9E1E}', None),
    ('\u{F921}', '\u{5D50}', None),
    ('\u{F922}', '\u{6FEB}', None),
    ('\u{F923}', '\u{85CD}', None),
    ('\u{F924}', '\u{8964}', None),
    ('\u{F925}', '\u{62C9}', None),
    ('\u{F926}', '\u{81D8}', None),
    ('\u{F927}', '\u{881F}', None),
    ('\u{F928}', '\u{5ECA}', None),
    ('\u{F929}', '\u{6717}', None),
    ('\u{F92A}', '\u{6D6A}', None),
    ('\u{F92B}', '\u{72FC}', None),
    ('\u{F92C}', '\u{90CE}', None),
    ('\u{F92D}', '\u{4F86}', None),
    ('\u{F92E}', '\u{51B7}', None),
    ('\u{F92F}', '\u{52DE}', None),
    ('\u{F930}', '\u{64C4}', None),
    ('\u{F931}', '\u{6AD3}', None),
    ('\u{F932}', '\u{7210}', None),
    ('\u{F933}', '\u{76E7}', None),
    ('\u{F934}', '\u{8001}', None),
    ('\u{F935}', '\u{8606}', None),
    ('\u{F936}', '\u{865C}', None),
    ('\u{F937}', '\u{8DEF}', None),
    ('\u{F938}', '\u{9732}', None),
    ('\u{F939}', '\u{9B6F}', None),
    ('\u{F93A}', '\u{9DFA}', None),
    ('\u{F93B}', '\u{788C}', None),
    ('\u{F93C}', '\u{797F}', None),
    ('\u{F93D}', '\u{7DA0}', None),
    ('\u{F93E}', '\u{83C9}', None),
    ('\u{F93F}', '\u{9304}', None),
    ('\u{F940}', '\u{9E7F}', None),
    ('\u{F941}', '\u{8AD6}', None),
    ('\u{F942}', '\u{58DF}', None),
    ('\u{F943}', '\u{5F04}', None),
    ('\u{F944}', '\u{7C60}', None),
    ('\u{F945}', '\u{807E}', None),
    ('\u{F946}', '\u{7262}', None),
    ('\u{F947}', '\u{78CA}', None),
    ('\u{F948}', '\u{8CC2}', None),
    ('\u{F949}', '\u{96F7}', None),
    ('\u{F94A}', '\u{58D8}', None),
    ('\u{F94B}', '\u{5C62}', None),
    ('\u{F94C}', '\u{6A13}', None),
    ('\u{F94D}', '\u{6DDA}', None),
    ('\u{F94E}', '\u{6F0F}', None),
    ('\u{F94F}', '\u{7D2F}', None),
    ('\u{F950}', '\u{7E37}', None),
    ('\u{F951}', '\u{964B}', None),
    ('\u{F952}', '\u{52D2}', None),
    ('\u{F953}', '\u{808B}', None),
    ('\u{F954}', '\u{51DC}', None),
    ('\u{F955}', '\u{51CC}', None),
    ('\u{F956}', '\u{7A1C}', None),
    ('\u{F957}', '\u{7DBE}', None),
    ('\u{F958}', '\u{83F1}', None),
    ('\u{F959}', '\u{9675}', None),
    ('\u{F95A}', '\u{8B80}', None),
    ('\u{F95B}', '\u{62CF}', None),
    ('\u{F95C}', '\u{6A02}', None),
    ('\u{F95D}', '\u{8AFE}', None),
    ('\u{F95E}', '\u{4E39}', None),
    ('\u{F95F}', '\u{5BE7}', None),
    ('\u{F960}', '\u{6012}', None),
    ('\u{F961}', '\u{7387}', None),
    ('\u{F962}', '\u{7570}', None),
    ('\u{F963}', '\u{5317}', None),
    ('\u{F964}', '\u{78FB}', None),
    ('\u{F965}', '\u{4FBF}', None),
    ('\u{F966}', '\u{5FA9}', None),
    ('\u{F967}', '\u{4E0D}', None),
    ('\u{F968}', '\u{6CCC}', None),
    ('\u{F969}', '\u{6578}', None),
    ('\u{F96A}', '\u{7D22}', None),
    ('\u{F96B}', '\u{53C3}', None),
    ('\u{F96C}', '\u{585E}', None),
    ('\u{F96D}', '\u{7701}', None),
    ('\u{F96E}', '\u{8449}', None),
    ('\u{F96F}', '\u{8AAA}', None),
    ('\u{F970}', '\u{6BBA}', None),
    ('\u{F971}', '\u{8FB0}', None),
    ('\u{F972}', '\u{6C88}', None),
    ('\u{F973}', '\u{62FE}', None),
    ('\u{F974}', '\u{82E5}', None),
    ('\u{F975}', '\u{63A0}', None),
    ('\u{F976}', '\u{7565}', None),
    ('\u{F977}', '\u{4EAE}', None),
    ('\u{F978}', '\u{5169}', None),
    ('\u{F979}', '\u{51C9}', None),
    ('\u{F97A}', '\u{6881}', None),
    ('\u{F97B}', '\u{7CE7}', None),
    ('\u{F97C}', '\u{826F}', None),
    ('\u{F97D}', '\u{8AD2}', None),
    ('\u{F97E}', '\u{91CF}', None),
    ('\u{F97F}', '\u{52F5}', None),
    ('\u{F980}', '\u{5442}', None),
    ('\u{F981}', '\u{5973}', None),
    ('\u{F982}', '\u{5EEC}', None),
    ('\u{F983}', '\u{65C5}', None),
    ('\u{F984}', '\u{6FFE}', None),
    ('\u{F985}', '\u{792A}', None),
    ('\u{F986}', '\u{95AD}', None),
    ('\u{F987}', '\u{9A6A}', None),
    ('\u{F988}', '\u{9E97}', None),
    ('\u{F989}', '\u{9ECE}', None),
    ('\u{F98A}', '\u{529B}', None),
    ('\u{F98B}', '\u{66C6}', None),
    ('\u{F98C}', '\u{6B77}', None),
    ('\u{F98D}', '\u{8F62}', None),
    ('\u{F98E}', '\u{5E74}', None),
    ('\u{F98F}', '\u{6190}', None),
    ('\u{F990}', '\u{6200}', None),
    ('\u{F991}', '\u{649A}', None),
    ('\u{F992}', '\u{6F23}', None),
    ('\u{F993}', '\u{7149}', None),
    ('\u{F994}', '\u{7489}', None),
    ('\u{F995}', '\u{79CA}', None),
    ('\u{F996}', '\u{7DF4}', None),
    ('\u{F997}', '\u{806F}', None),
    ('\u{F998}', '\u{8F26}', None),
    ('\u{F999}', '\u{84EE}', None),
    ('\u{F99A}', '\u{9023}', None),
    ('\u{F99B}', '\u{934A}', None),
    ('\u{F99C}', '\u{5217}', None),
    ('\u{F99D}', '\u{52A3}', None),
    ('\u{F99E}', '\u{54BD}', None),
    ('\u{F99F}', '\u{70C8}', None),
    ('\u{F9A0}', '\u{88C2}', None),
    ('\u{F9A1}', '\u{8AAA}', None),
    ('\u{F9A2}', '\u{5EC9}', None),
    ('\u{F9A3}', '\u{5FF5}', None),
    ('\u{F9A4}', '\u{637B}', None),
    ('\u{F9A5}', '\u{6BAE}', None),
    ('\u{F9A6}', '\u{7C3E}', None),
    ('\u{F9A7}', '\u{7375}', None),
    ('\u{F9A8}', '\u{4EE4}', None),
    ('\u{F9A9}', '\u{56F9}', None),
    ('\u{F9AA}', '\u{5BE7}', None),
    ('\u{F9AB}', '\u{5DBA}', None),
    ('\u{F9AC}', '\u{601C}', None),
    ('\u{F9AD}', '\u{73B2}', None),
    ('\u{F9AE}', '\u{7469}', None),
    ('\u{F9AF}', '\u{7F9A}', None),
    ('\u{F9B0}', '\u{8046}', None),
    ('\u{F9B1}', '\u{9234}', None),
    ('\u{F9B2}', '\u{96F6}', None),
    ('\u{F9B3}', '\u{9748}', None),
    ('\u{F9B4}', '\u{9818}', None),
    ('\u{F9B5}', '\u{4F8B}', None),
    ('\u{F9B6}', '\u{79AE}', None),
    ('\u{F9B7}', '\u{91B4}', None),
    ('\u{F9B8}', '\u{96B8}', None),
    ('\u{F9B9}', '\u{60E1}', None),
    ('\u{F9BA}', '\u{4E86}', None),
    ('\u{F9BB}', '\u{50DA}', None),
    ('\u{F9BC}', '\u{5BEE}', None),
    ('\u{F9BD}', '\u{5C3F}', None),
    ('\u{F9BE}', '\u{6599}', None),
    ('\u{F9BF}', '\u{6A02}', None),
    ('\u{F9C0}', '\u{71CE}', None),
    ('\u{F9C1}', '\u{7642}', None),
    ('\u{F9C2}', '\u{84FC}', None),
    ('\u{F9C3}', '\u{907C}', None),
    ('\u{F9C4}', '\u{9F8D}', None),
    ('\u{F9C5}', '\u{6688}', None),
    ('\u{F9C6}', '\u{962E}', None),
    ('\u{F9C7}', '\u{5289}', None),
    ('\u{F9C8}', '\u{677B}', None),
    ('\u{F9C9}', '\u{67F3}', None),
    ('\u{F9CA}', '\u{6D41}', None),
    ('\u{F9CB}', '\u{6E9C}', None),
    ('\u{F9CC}', '\u{7409}', None),
    ('\u{F9CD}', '\u{7559}', None),
    ('\u{F9CE}', '\u{786B}', None),
    ('\u{F9CF}', '\u{7D10}', None),
    ('\u{F9D0}', '\u{985E}', None),
    ('\u{F9D1}', '\u{516D}', None),
    ('\u{F9D2}', '\u{622E}', None),
    ('\u{F9D3}', '\u{9678}', None),
    ('\u{F9D4}', '\u{502B}', None),
    ('\u{F9D5}', '\u{5D19}', None),
    ('\u{F9D6}', '\u{6DEA}', None),
    ('\u{F9D7}', '\u{8F2A}', None),
    ('\u{F9D8}', '\u{5F8B}', None),
    ('\u{F9D9}', '\u{6144}', None),
    ('\u{F9DA}', '\u{6817}', None),
    ('\u{F9DB}', '\u{7387}', None),
    ('\u{F9DC}', '\u{9686}', None),
    ('\u{F9DD}', '\u{5229}', None),
    ('\u{F9DE}', '\u{540F}', None),
    ('\u{F9DF}', '\u{5C65}', None),
    ('\u{F9E0}', '\u{6613}', None),
    ('\u{F9E1}', '\u{674E}', None),
    ('\u{F9E2}', '\u{68A8}', None),
    ('\u{F9E3}', '\u{6CE5}', None),
    ('\u{F9E4}', '\u{7406}', None),
    ('\u{F9E5}', '\u{75E2}', None),
    ('\u{F9E6}', '\u{7F79}', None),
    ('\u{F9E7}', '\u{88CF}', None),
    ('\u{F9E8}', '\u{88E1}', None),
    ('\u{F9E9}', '\u{91CC}', None),
    ('\u{F9EA}', '\u{96E2}', None),
    ('\u{F9EB}', '\u{533F}', None),
    ('\u{F9EC}', '\u{6EBA}', None),
    ('\u{F9ED}', '\u{541D}', None),
    ('\u{F9EE}', '\u{71D0}', None),
    ('\u{F9EF}', '\u{7498}', None),
    ('\u{F9F0}', '\u{85FA}', None),
    ('\u{F9F1}', '\u{96A3}', None),
    ('\u{F9F2}', '\u{9C57}', None),
    ('\u{F9F3}', '\u{9E9F}', None),
    ('\u{F9F4}', '\u{6797}', None),
    ('\u{F9F5}', '\u{6DCB}', None),
    ('\u{F9F6}', '\u{81E8}', None),
    ('\u{F9F7}', '\u{7ACB}', None),
    ('\u{F9F8}', '\u{7B20}', None),
    ('\u{F9F9}', '\u{7C92}', None),
    ('\u{F9FA}', '\u{72C0}', None),
    ('\u{F9FB}', '\u{7099}', None),
    ('\u{F9FC}', '\u{8B58}', None),
    ('\u{F9FD}', '\u{4EC0}', None),
    ('\u{F9FE}', '\u{8336}', None),
    ('\u{F9FF}', '\u{523A}', None),
    ('\u{FA00}', '\u{5207}', None),
    ('\u{FA01}', '\u{5EA6}', None),
    ('\u{FA02}', '\u{62D3}', None),
    ('\u{FA03}', '\u{7CD6}', None),
    ('\u{FA04}', '\u{5B85}', None),
    ('\u{FA05}', '\u{6D1E}', None),
    ('\u{FA06}', '\u{66B4}', None),
    ('\u{FA07}', '\u{8F3B}', None),
    ('\u{FA08}', '\u{884C}', None),
    ('\u{FA09}', '\u{964D}', None),
    ('\u{FA0A}', '\u{898B}', None),
    ('\u{FA0B}', '\u{5ED3}', None),
    ('\u{FA0C}', '\u{5140}', None),
    ('\u{FA0D}', '\u{55C0}', None),
    ('\u{FA10}', '\u{585A}', None),
    ('\u{FA12}', '\u{6674}', None),
    ('\u{FA15}', '\u{51DE}', None),
    ('\u{FA16}', '\u{732A}', None),
    ('\u{FA17}', '\u{76CA}', None),
    ('\u{FA18}', '\u{793C}', None),
    ('\u{FA19}', '\u{795E}', None),
    ('\u{FA1A}', '\u{7965}', None),
    ('\u{FA1B}', '\u{798F}', None),
    ('\u{FA1C}', '\u{9756}', None),
    ('\u{FA1D}', '\u{7CBE}', None),
    ('\u{FA1E}', '\u{7FBD}', None),
    ('\u{FA20}', '\u{8612}', None),
    ('\u{FA22}', '\u{8AF8}', None),
    ('\u{FA25}', '\u{9038}', None),
    ('\u{FA26}', '\u{90FD}', None),
    ('\u{FA2A}', '\u{98EF}', None),
    ('\u{FA2B}', '\u{98FC}', None),
    ('\u{FA2C}', '\u{9928}', None),
    ('\u{FA2D}', '\u{9DB4}', None),
    ('\u{FA2E}', '\u{90DE}', None),
    ('\u{FA2F}', '\u{96B7}', None),
    ('\u{FA30}', '\u{4FAE}', None),
    ('\u{FA31}', '\u{50E7}', None),
    ('\u{FA32}', '\u{514D}', None),
    ('\u{FA33}', '\u{52C9}', None),
    ('\u{FA34}', '\u{52E4}', None),
    ('\u{FA35}', '\u{5351}', None),
    ('\u{FA36}', '\u{559D}', None),
    ('\u{FA37}', '\u{5606}', None),
    ('\u{FA38}', '\u{5668}', None),
    ('\u{FA39}', '\u{5840}', None),
    ('\u{FA3A}', '\u{58A8}', None),
    ('\u{FA3B}', '\u{5C64}', None),
    ('\u{FA3C}', '\u{5C6E}', None),
    ('\u{FA3D}', '\u{6094}', None),
    ('\u{FA3E}', '\u{6168}', None),
    ('\u{FA3F}', '\u{618E}', None),
    ('\u{FA40}', '\u{61F2}', None),
    ('\u{FA41}', '\u{654F}', None),
    ('\u{FA42}', '\u{65E2}', None),
    ('\u{FA43}', '\u{6691}', None),
    ('\u{FA44}', '\u{6885}', None),
    ('\u{FA45}', '\u{6D77}', None),
    ('\u{FA46}', '\u{6E1A}', None),
    ('\u{FA47}', '\u{6F22}', None),
    ('\u{FA48}', '\u{716E}', None),
    ('\u{FA49}', '\u{722B}', None),
    ('\u{FA4A}', '\u{7422}', None),
    ('\u{FA4B}', '\u{7891}', None),
    ('\u{FA4C}', '\u{793E}', None),
    ('\u{FA4D}', '\u{7949}', None),
    ('\u{FA4E}', '\u{7948}', None),
    ('\u{FA4F}', '\u{7950}', None),
    ('\u{FA50}', '\u{7956}', None),
    ('\u{FA51}', '\u{795D}', None),
    ('\u{FA52}', '\u{798D}', None),
    ('\u{FA53}', '\u{798E}', None),
    ('\u{FA54}', '\u{7A40}', None),
    ('\u{FA55}', '\u{7A81}', None),
    ('\u{FA56}', '\u{7BC0}', None),
    ('\u{FA57}', '\u{7DF4}', None),
    ('\u{FA58}', '\u{7E09}', None),
    ('\u{FA59}', '\u{7E41}', None),
    ('\u{FA5A}', '\u{7F72}', None),
    ('\u{FA5B}', '\u{8005}', None),
    ('\u{FA5C}', '\u{81ED}', None),
    ('\u{FA5D}', '\u{8279}', None),
    ('\u{FA5E}', '\u{8279}', None),
    ('\u{FA5F}', '\u{8457}', None),
    ('\u{FA60}', '\u{8910}', None),
    ('\u{FA61}', '\u{8996}', None),
    ('\u{FA62}', '\u{8B01}', None),
    ('\u{FA63}', '\u{8B39}', None),
    ('\u{FA64}', '\u{8CD3}', None),
    ('\u{FA65}', '\u{8D08}', None),
    ('\u{FA66}', '\u{8FB6}', None),
    ('\u{FA67}', '\u{9038}', None),
    ('\u{FA68}', '\u{96E3}', None),
    ('\u{FA69}', '\u{97FF}', None),
    ('\u{FA6A}', '\u{983B}', None),
    ('\u{FA6B}', '\u{6075}', None),
    ('\u{FA6C}', '\u{242EE}', None),
    ('\u{FA6D}', '\u{8218}', None),
    ('\u{FA70}', '\u{4E26}', None),
    ('\u{FA71}', '\u{51B5}', None),
    ('\u{FA72}', '\u{5168}', None),
    ('\u{FA73}', '\u{4F80}', None),
    ('\u{FA74}', '\u{5145}', None),
    ('\u{FA75}', '\u{5180}', None),
    ('\u{FA76}', '\u{52C7}', None),
    ('\u{FA77}', '\u{52FA}', None),
    ('\u{FA78}', '\u{559D}', None),
    ('\u{FA79}', '\u{5555}', None),
    ('\u{FA7A}', '\u{5599}', None),
    ('\u{FA7B}', '\u{55E2}', None),
    ('\u{FA7C}', '\u{585A}', None),
    ('\u{FA7D}', '\u{58B3}', None),
    ('\u{FA7E}', '\u{5944}', None),
    ('\u{FA7F}', '\u{5954}', None),
    ('\u{FA80}', '\u{5A62}', None),
    ('\u{FA81}', '\u{5B28}', None),
    ('\u{FA82}', '\u{5ED2}', None),
    ('\u{FA83}', '\u{5ED9}', None),
    ('\u{FA84}', '\u{5F69}', None),
    ('\u{FA85}', '\u{5FAD}', None),
    ('\u{FA86}', '\u{60D8}', None),
    ('\u{FA87}', '\u{614E}', None),
    ('\u{FA88}', '\u{6108}', None),
    ('\u{FA89}', '\u{618E}', None),
    ('\u{FA8A}', '\u{6160}', None),
    ('\u{FA8B}', '\u{61F2}', None),
    ('\u{FA8C}', '\u{6234}', None),
    ('\u{FA8D}', '\u{63C4}', None),
    ('\u{FA8E}', '\u{641C}', None),
    ('\u{FA8F}', '\u{6452}', None),
    ('\u{FA90}', '\u{6556}', None),
    ('\u{FA91}', '\u{6674}', None),
    ('\u{FA92}', '\u{6717}', None),
    ('\u{FA93}', '\u{671B}', None),
    ('\u{FA94}', '\u{6756}', None),
    ('\u{FA95}', '\u{6B79}', None),
    ('\u{FA96}', '\u{6BBA}', None),
    ('\u{FA97}', '\u{6D41}', None),
    ('\u{FA98}', '\u{6EDB}', None),
    ('\u{FA99}', '\u{6ECB}', None),
    ('\u{FA9A}', '\u{6F22}', None),
    ('\u{FA9B}', '\u{701E}', None),
    ('\u{FA9C}', '\u{716E}', None),
    ('\u{FA9D}', '\u{77A7}', None),
    ('\u{FA9E}', '\u{7235}', None),
    ('\u{FA9F}', '\u{72AF}', None),
    ('\u{FAA0}', '\u{732A}', None),
    ('\u{FAA1}', '\u{7471}', None),
    ('\u{FAA2}', '\u{7506}', None),
    ('\u{FAA3}', '\u{753B}', None),
    ('\u{FAA4}', '\u{761D}', None),
    ('\u{FAA5}', '\u{761F}', None),
    ('\u{FAA6}', '\u{76CA}', None),
    ('\u{FAA7}', '\u{76DB}', None),
    ('\u{FAA8}', '\u{76F4}', None),
    ('\u{FAA9}', '\u{774A}', None),
    ('\u{FAAA}', '\u{7740}', None),
    ('\u{FAAB}', '\u{78CC}', None),
    ('\u{FAAC}', '\u{7AB1}', None),
    ('\u{FAAD}', '\u{7BC0}', None),
    ('\u{FAAE}', '\u{7C7B}', None),
    ('\u{FAAF}', '\u{7D5B}', None),
    ('\u{FAB0}', '\u{7DF4}', None),
    ('\u{FAB1}', '\u{7F3E}', None),
    ('\u{FAB2}', '\u{8005}', None),
    ('\u{FAB3}', '\u{8352}', None),
    ('\u{FAB4}', '\u{83EF}', None),
    ('\u{FAB5}', '\u{8779}', None),
    ('\u{FAB6}', '\u{8941}', None),
    ('\u{FAB7}', '\u{8986}', None),
    ('\u{FAB8}', '\u{8996}', None),
    ('\u{FAB9}', '\u{8ABF}', None),
    ('\u{FABA}', '\u{8AF8}', None),
    ('\u{FABB}', '\u{8ACB}', None),
    ('\u{FABC}', '\u{8B01}', None),
    ('\u{FABD}', '\u{8AFE}', None),
    ('\u{FABE}', '\u{8AED}', None),
    ('\u{FABF}', '\u{8B39}', None),
    ('\u{FAC0}', '\u{8B8A}', None),
    ('\u{FAC1}', '\u{8D08}', None),
    ('\u{FAC2}', '\u{8F38}', None),
    ('\u{FAC3}', '\u{9072}', None),
    ('\u{FAC4}', '\u{9199}', None),
    ('\u{FAC5}', '\u{9276}', None),
    ('\u{FAC6}', '\u{967C}', None),
    ('\u{FAC7}', '\u{96E3}', None),
    ('\u{FAC8}', '\u{9756}', None),
    ('\u{FAC9}', '\u{97DB}', None),
    ('\u{FACA}', '\u{97FF}', None),
    ('\u{FACB}', '\u{980B}', None),
    ('\u{FACC}', '\u{983B}', None),
    ('\u{FACD}', '\u{9B12}', None),
    ('\u{FACE}', '\u{9F9C}', None),
    ('\u{FACF}', '\u{2284A}', None),
    ('\u{FAD0}', '\u{22844}', None),
    ('\u{FAD1}', '\u{233D5}', None),
    ('\u{FAD2}', '\u{3B9D}', None),
    ('\u{FAD3}', '\u{4018}', None),
    ('\u{FAD4}', '\u{4039}', None),
    ('\u{FAD5}', '\u{25249}', None),
    ('\u{FAD6}', '\u{25CD0}', None),
    ('\u{FAD7}', '\u{27ED3}', None),
    ('\u{FAD8}', '\u{9F43}', None),
    ('\u{FAD9}', '\u{9F8E}', None),
    ('\u{FB1D}', '\u{05D9}', Some('\u{05B4}')),
    ('\u{FB1F}', '\u{05F2}', Some('\u{05B7}')),
    ('\u{FB2A}', '\u{05E9}', Some('\u{05C1}')),
    ('\u{FB2B}', '\u{05E9}', Some('\u{05C2}')),
    ('\u{FB2C}', '\u{FB49}', Some('\u{05C1}')),
    ('\u{FB2D}', '\u{FB49}', Some('\u{05C2}')),
    ('\u{FB2E}', '\u{05D0}', Some('\u{05B7}')),
    ('\u{FB2F}', '\u{05D0}', Some('\u{05B8}')),
    ('\u{FB30}', '\u{05D0}', Some('\u{05BC}')),
    ('\u{FB31}', '\u{05D1}', Some('\u{05BC}')),
    ('\u{FB32}', '\u{05D2}', Some('\u{05BC}')),
    ('\u{FB33}', '\u{05D3}', Some('\u{05BC}')),
    ('\u{FB34}', '\u{05D4}', Some('\u{05BC}')),
    ('\u{FB35}', '\u{05D5}', Some('\u{05BC}')),
    ('\u{FB36}', '\u{05D6}', Some('\u{05BC}')),
    ('\u{FB38}', '\u{05D8}', Some('\u{05BC}')),
    ('\u{FB39}', '\u{05D9}', Some('\u{05BC}')),
    ('\u{FB3A}', '\u{05DA}', Some('\u{05BC}')),
    ('\u{FB3B}', '\u{05DB}', Some('\u{05BC}')),
    ('\u{FB3C}', '\u{05DC}', Some('\u{05BC}')),
    ('\u{FB3E}', '\u{05DE}', Some('\u{05BC}')),
    ('\u{FB40}', '\u{05E0}', Some('\u{05BC}')),
    ('\u{FB41}', '\u{05E1}', Some('\u{05BC}')),
    ('\u{FB43}', '\u{05E3}', Some('\u{05BC}')),
    ('\u{FB44}', '\u{05E4}', Some('\u{05BC}')),
    ('\u{FB46}', '\u{05E6}', Some('\u{05BC}')),
    ('\u{FB47}', '\u{05E7}', Some('\u{05BC}')),
    ('\u{FB48}', '\u{05E8}', Some('\u{05BC}')),
    ('\u{FB49}', '\u{05E9}', Some('\u{05BC}')),
    ('\u{FB4A}', '\u{05EA}', Some('\u{05BC}')),
    ('\u{FB4B}', '\u{05D5}', Some('\u{05B9}')),
    ('\u{FB4C}', '\u{05D1}', Some('\u{05BF}')),
    ('\u{FB4D}', '\u{05DB}', Some('\u{05BF}')),
    ('\u{FB4E}', '\u{05E4}', Some('\u{05BF}')),
    ('\u{105C9}', '\u{105D2}', Some('\u{0307}')),
    ('\u{105E4}', '\u{105DA}', Some('\u{0307}')),
    ('\u{1109A}', '\u{11099}', Some('\u{110BA}')),
    ('\u{1109C}', '\u{1109B}', Some('\u{110BA}')),
    ('\u{110AB}', '\u{110A5}', Some('\u{110BA}')),
    ('\u{1112E}', '\u{11131}', Some('\u{11127}')),
    ('\u{1112F}', '\u{11132}', Some('\u{11127}')),
    ('\u{1134B}', '\u{11347}', Some('\u{1133E}')),
    ('\u{1134C}', '\u{11347}', Some('\u{11357}')),
    ('\u{11383}', '\u{11382}', Some('\u{113C9}')),
    ('\u{11385}', '\u{11384}', Some('\u{113BB}')),
    ('\u{1138E}', '\u{1138B}', Some('\u{113C2}')),
    ('\u{11391}', '\u{11390}', Some('\u{113C9}')),
    ('\u{113C5}', '\u{113C2}', Some('\u{113C2}')),
    ('\u{113C7}', '\u{113C2}', Some('\u{113B8}')),
    ('\u{113C8}', '\u{113C2}', Some('\u{113C9}')),
    ('\u{114BB}', '\u{114B9}', Some('\u{114BA}')),
    ('\u{114BC}', '\u{114B9}', Some('\u{114B0}')),
    ('\u{114BE}', '\u{114B9}', Some('\u{114BD}')),
    ('\u{115BA}', '\u{115B8}', Some('\u{115AF}')),
    ('\u{115BB}', '\u{115B9}', Some('\u{115AF}')),
    ('\u{11938}', '\u{11935}', Some('\u{11930}')),
    ('\u{16121}', '\u{1611E}', Some('\u{1611E}')),
    ('\u{16122}', '\u{1611E}', Some('\u{16129}')),
    ('\u{16123}', '\u{1611E}', Some('\u{1611F}')),
    ('\u{16124}', '\u{16129}', Some('\u{1611F}')),
    ('\u{16125}', '\u{1611E}', Some('\u{16120}')),
    ('\u{16126}', '\u{16121}', Some('\u{1611F}')),
    ('\u{16127}', '\u{16122}', Some('\u{1611F}')),
    ('\u{16128}', '\u{16121}', Some('\u{16120}')),
    ('\u{16D68}', '\u{16D67}', Some('\u{16D67}')),
    ('\u{16D69}', '\u{16D63}', Some('\u{16D67}')),
    ('\u{16D6A}', '\u{16D69}', Some('\u{16D67}')),
    ('\u{1D15E}', '\u{1D157}', Some('\u{1D165}')),
    ('\u{1D15F}', '\u{1D158}', Some('\u{1D165}')),
    ('\u{1D160}', '\u{1D15F}', Some('\u{1D16E}')),
    ('\u{1D161}', '\u{1D15F}', Some('\u{1D16F}')),
    ('\u{1D162}', '\u{1D15F}', Some('\u{1D170}')),
    ('\u{1D163}', '\u{1D15F}', Some('\u{1D171}')),
    ('\u{1D164}', '\u{1D15F}', Some('\u{1D172}')),
    ('\u{1D1BB}', '\u{1D1B9}', Some('\u{1D165}')),
    ('\u{1D1BC}', '\u{1D1BA}', Some('\u{1D165}')),
    ('\u{1D1BD}', '\u{1D1BB}', Some('\u{1D16E}')),
    ('\u{1D1BE}', '\u{1D1BC}', Some('\u{1D16E}')),
    ('\u{1D1BF}', '\u{1D1BB}', Some('\u{1D16F}')),
    ('\u{1D1C0}', '\u{1D1BC}', Some('\u{1D16F}')),
    ('\u{2F800}', '\u{4E3D}', None),
    ('\u{2F801}', '\u{4E38}', None),
    ('\u{2F802}', '\u{4E41}', None),
    ('\u{2F803}', '\u{20122}', None),
    ('\u{2F804}', '\u{4F60}', None),
    ('\u{2F805}', '\u{4FAE}', None),
    ('\u{2F806}', '\u{4FBB}', None),
    ('\u{2F807}', '\u{5002}', None),
    ('\u{2F808}', '\u{507A}', None),
    ('\u{2F809}', '\u{5099}', None),
    ('\u{2F80A}', '\u{50E7}', None),
    ('\u{2F80B}', '\u{50CF}', None),
    ('\u{2F80C}', '\u{349E}', None),
    ('\u{2F80D}', '\u{2063A}', None),
    ('\u{2F80E}', '\u{514D}', None),
    ('\u{2F80F}', '\u{5154}', None),
    ('\u{2F810}', '\u{5164}', None),
    ('\u{2F811}', '\u{5177}', None),
    ('\u{2F812}', '\u{2051C}', None),
    ('\u{2F813}', '\u{34B9}', None),
    ('\u{2F814}', '\u{5167}', None),
    ('\u{2F815}', '\u{518D}', None),
    ('\u{2F816}', '\u{2054B}', None),
    ('\u{2F817}', '\u{5197}', None),
    ('\u{2F818}', '\u{51A4}', None),
    ('\u{2F819}', '\u{4ECC}', None),
    ('\u{2F81A}', '\u{51AC}', None),
    ('\u{2F81B}', '\u{51B5}', None),
    ('\u{2F81C}', '\u{291DF}', None),
    ('\u{2F81D}', '\u{51F5}', None),
    ('\u{2F81E}', '\u{5203}', None),
    ('\u{2F81F}', '\u{34DF}', None),
    ('\u{2F820}', '\u{523B}', None),
    ('\u{2F821}', '\u{5246}', None),
    ('\u{2F822}', '\u{5272}', None),
    ('\u{2F823}', '\u{5277}', None),
    ('\u{2F824}', '\u{3515}', None),
    ('\u{2F825}', '\u{52C7}', None),
    ('\u{2F826}', '\u{52C9}', None),
    ('\u{2F827}', '\u{52E4}', None),
    ('\u{2F828}', '\u{52FA}', None),
    ('\u{2F829}', '\u{5305}', None),
    ('\u{2F82A}', '\u{5306}', None),
    ('\u{2F82B}', '\u{5317}', None),
    ('\u{2F82C}', '\u{5349}', None),
    ('\u{2F82D}', '\u{5351}', None),
    ('\u{2F82E}', '\u{535A}', None),
    ('\u{2F82F}', '\u{5373}', None),
    ('\u{2F830}', '\u{537D}', None),
    ('\u{2F831}', '\u{537F}', None),
    ('\u{2F832}', '\u{537F}', None),
    ('\u{2F833}', '\u{537F}', None),
    ('\u{2F834}', '\u{20A2C}', None),
    ('\u{2F835}', '\u{7070}', None),
    ('\u{2F836}', '\u{53CA}', None),
    ('\u{2F837}', '\u{53DF}', None),
    ('\u{2F838}', '\u{20B63}', None),
    ('\u{2F839}', '\u{53EB}', None),
    ('\u{2F83A}', '\u{53F1}', None),
    ('\u{2F83B}', '\u{5406}', None),
    ('\u{2F83C}', '\u{549E}', None),
    ('\u{2F83D}', '\u{5438}', None),
    ('\u{2F83E}', '\u{5448}', None),
    ('\u{2F83F}', '\u{5468}', None),
    ('\u{2F840}', '\u{54A2}', None),
    ('\u{2F841}', '\u{54F6}', None),
    ('\u{2F842}', '\u{5510}', None),
    ('\u{2F843}', '\u{5553}', None),
    ('\u{2F844}', '\u{5563}', None),
    ('\u{2F845}', '\u{5584}', None),
    ('\u{2F846}', '\u{5584}', None),
    ('\u{2F847}', '\u{5599}', None),
    ('\u{2F848}', '\u{55AB}', None),
    ('\u{2F849}', '\u{55B3}', None),
    ('\u{2F84A}', '\u{55C2}', None),
    ('\u{2F84B}', '\u{5716}', None),
    ('\u{2F84C}', '\u{5606}', None),
    ('\u{2F84D}', '\u{5717}', None),
    ('\u{2F84E}', '\u{5651}', None),
    ('\u{2F84F}', '\u{5674}', None),
    ('\u{2F850}', '\u{5207}', None),
    ('\u{2F851}', '\u{58EE}', None),
    ('\u{2F852}', '\u{57CE}', None),
    ('\u{2F853}', '\u{57F4}', None),
    ('\u{2F854}', '\u{580D}', None),
    ('\u{2F855}', '\u{578B}', None),
    ('\u{2F856}', '\u{5832}', None),
    ('\u{2F857}', '\u{5831}', None),
    ('\u{2F858}', '\u{58AC}', None),
    ('\u{2F859}', '\u{214E4}', None),
    ('\u{2F85A}', '\u{58F2}', None),
    ('\u{2F85B}', '\u{58F7}', None),
    ('\u{2F85C}', '\u{5906}', None),
    ('\u{2F85D}', '\u{591A}', None),
    ('\u{2F85E}', '\u{5922}', None),
    ('\u{2F85F}', '\u{5962}', None),
    ('\u{2F860}', '\u{216A8}', None),
    ('\u{2F861}', '\u{216EA}', None),
    ('\u{2F862}', '\u{59EC}', None),
    ('\u{2F863}', '\u{5A1B}', None),
    ('\u{2F864}', '\u{5A27}', None),
    ('\u{2F865}', '\u{59D8}', None),
    ('\u{2F866}', '\u{5A66}', None),
    ('\u{2F867}', '\u{36EE}', None),
    ('\u{2F868}', '\u{36FC}', None),
    ('\u{2F869}', '\u{5B08}', None),
    ('\u{2F86A}', '\u{5B3E}', None),
    ('\u{2F86B}', '\u{5B3E}', None),
    ('\u{2F86C}', '\u{219C8}', None),
    ('\u{2F86D}', '\u{5BC3}', None),
    ('\u{2F86E}', '\u{5BD8}', None),
    ('\u{2F86F}', '\u{5BE7}', None),
    ('\u{2F870}', '\u{5BF3}', None),
    ('\u{2F871}', '\u{21B18}', None),
    ('\u{2F872}', '\u{5BFF}', None),
    ('\u{2F873}', '\u{5C06}', None),
    ('\u{2F874}', '\u{5F53}', None),
    ('\u{2F875}', '\u{5C22}', None),
    ('\u{2F876}', '\u{3781}', None),
    ('\u{2F877}', '\u{5C60}', None),
    ('\u{2F878}', '\u{5C6E}', None),
    ('\u{2F879}', '\u{5CC0}', None),
    ('\u{2F87A}', '\u{5C8D}', None),
    ('\u{2F87B}', '\u{21DE4}', None),
    ('\u{2F87C}', '\u{5D43}', None),
    ('\u{2F87D}', '\u{21DE6}', None),
    ('\u{2F87E}', '\u{5D6E}', None),
    ('\u{2F87F}', '\u{5D6B}', None),
    ('\u{2F880}', '\u{5D7C}', None),
    ('\u{2F881}', '\u{5DE1}', None),
    ('\u{2F882}', '\u{5DE2}', None),
    ('\u{2F883}', '\u{382F}', None),
    ('\u{2F884}', '\u{5DFD}', None),
    ('\u{2F885}', '\u{5E28}', None),
    ('\u{2F886}', '\u{5E3D}', None),
    ('\u{2F887}', '\u{5E69}', None),
    ('\u{2F888}', '\u{3862}', None),
    ('\u{2F889}', '\u{22183}', None),
    ('\u{2F88A}', '\u{387C}', None),
    ('\u{2F88B}', '\u{5EB0}', None),
    ('\u{2F88C}', '\u{5EB3}', None),
    ('\u{2F88D}', '\u{5EB6}', None),
    ('\u{2F88E}', '\u{5ECA}', None),
    ('\u{2F88F}', '\u{2A392}', None),
    ('\u{2F890}', '\u{5EFE}', None),
    ('\u{2F891}', '\u{22331}', None),
    ('\u{2F892}', '\u{22331}', None),
    ('\u{2F893}', '\u{8201}', None),
    ('\u{2F894}', '\u{5F22}', None),
    ('\u{2F895}', '\u{5F22}', None),
    ('\u{2F896}', '\u{38C7}', None),
    ('\u{2F897}', '\u{232B8}', None),
    ('\u{2F898}', '\u{261DA}', None),
    ('\u{2F899}', '\u{5F62}', None),
    ('\u{2F89A}', '\u{5F6B}', None),
    ('\u{2F89B}', '\u{38E3}', None),
    ('\u{2F89C}', '\u{5F9A}', None),
    ('\u{2F89D}', '\u{5FCD}', None),
    ('\u{2F89E}', '\u{5FD7}', None),
    ('\u{2F89F}', '\u{5FF9}', None),
    ('\u{2F8A0}', '\u{6081}', None),
    ('\u{2F8A1}', '\u{393A}', None),
    ('\u{2F8A2}', '\u{391C}', None),
    ('\u{2F8A3}', '\u{6094}', None),
    ('\u{2F8A4}', '\u{226D4}', None),
    ('\u{2F8A5}', '\u{60C7}', None),
    ('\u{2F8A6}', '\u{6148}', None),
    ('\u{2F8A7}', '\u{614C}', None),
    ('\u{2F8A8}', '\u{614E}', None),
    ('\u{2F8A9}', '\u{614C}', None),
    ('\u{2F8AA}', '\u{617A}', None),
    ('\u{2F8AB}', '\u{618E}', None),
    ('\u{2F8AC}', '\u{61B2}', None),
    ('\u{2F8AD}', '\u{61A4}', None),
    ('\u{2F8AE}', '\u{61AF}', None),
    ('\u{2F8AF}', '\u{61DE}', None),
    ('\u{2F8B0}', '\u{61F2}', None),
    ('\u{2F8B1}', '\u{61F6}', None),
    ('\u{2F8B2}', '\u{6210}', None),
    ('\u{2F8B3}', '\u{621B}', None),
    ('\u{2F8B4}', '\u{625D}', None),
    ('\u{2F8B5}', '\u{62B1}', None),
    ('\u{2F8B6}', '\u{62D4}', None),
    ('\u{2F8B7}', '\u{6350}', None),
    ('\u{2F8B8}', '\u{22B0C}', None),
    ('\u{2F8B9}', '\u{633D}', None),
    ('\u{2F8BA}', '\u{62FC}', None),
    ('\u{2F8BB}', '\u{6368}', None),
    ('\u{2F8BC}', '\u{6383}', None),
    ('\u{2F8BD}', '\u{63E4}', None),
    ('\u{2F8BE}', '\u{22BF1}', None),
    ('\u{2F8BF}', '\u{6422}', None),
    ('\u{2F8C0}', '\u{63C5}', None),
    ('\u{2F8C1}', '\u{63A9}', None),
    ('\u{2F8C2}', '\u{3A2E}', None),
    ('\u{2F8C3}', '\u{6469}', None),
    ('\u{2F8C4}', '\u{647E}', None),
    ('\u{2F8C5}', '\u{649D}', None),
    ('\u{2F8C6}', '\u{6477}', None),
    ('\u{2F8C7}', '\u{3A6C}', None),
    ('\u{2F8C8}', '\u{654F}', None),
    ('\u{2F8C9}', '\u{656C}', None),
    ('\u{2F8CA}', '\u{2300A}', None),
    ('\u{2F8CB}', '\u{65E3}', None),
    ('\u{2F8CC}', '\u{66F8}', None),
    ('\u{2F8CD}', '\u{6649}', None),
    ('\u{2F8CE}', '\u{3B19}', None),
    ('\u{2F8CF}', '\u{6691}', None),
    ('\u{2F8D0}', '\u{3B08}', None),
    ('\u{2F8D1}', '\u{3AE4}', None),
    ('\u{2F8D2}', '\u{5192}', None),
    ('\u{2F8D3}', '\u{5195}', None),
    ('\u{2F8D4}', '\u{6700}', None),
    ('\u{2F8D5}', '\u{669C}', None),
    ('\u{2F8D6}', '\u{80AD}', None),
    ('\u{2F8D7}', '\u{43D9}', None),
    ('\u{2F8D8}', '\u{6717}', None),
    ('\u{2F8D9}', '\u{671B}', None),
    ('\u{2F8DA}', '\u{6721}', None),
    ('\u{2F8DB}', '\u{675E}', None),
    ('\u{2F8DC}', '\u{6753}', None),
    ('\u{2F8DD}', '\u{233C3}', None),
    ('\u{2F8DE}', '\u{3B49}', None),
    ('\u{2F8DF}', '\u{67FA}', None),
    ('\u{2F8E0}', '\u{6785}', None),
    ('\u{2F8E1}', '\u{6852}', None),
    ('\u{2F8E2}', '\u{6885}', None),
    ('\u{2F8E3}', '\u{2346D}', None),
    ('\u{2F8E4}', '\u{688E}', None),
    ('\u{2F8E5}', '\u{681F}', None),
    ('\u{2F8E6}', '\u{6914}', None),
    ('\u{2F8E7}', '\u{3B9D}', None),
    ('\u{2F8E8}', '\u{6942}', None),
    ('\u{2F8E9}', '\u{69A3}', None),
    ('\u{2F8EA}', '\u{69EA}', None),
    ('\u{2F8EB}', '\u{6AA8}', None),
    ('\u{2F8EC}', '\u{236A3}', None),
    ('\u{2F8ED}', '\u{6ADB}', None),
    ('\u{2F8EE}', '\u{3C18}', None),
    ('\u{2F8EF}', '\u{6B21}', None),
    ('\u{2F8F0}', '\u{238A7}', None),
    ('\u{2F8F1}', '\u{6B54}', None),
    ('\u{2F8F2}', '\u{3C4E}', None),
    ('\u{2F8F3}', '\u{6B72}', None),
    ('\u{2F8F4}', '\u{6B9F}', None),
    ('\u{2F8F5}', '\u{6BBA}', None),
    ('\u{2F8F6}', '\u{6BBB}', None),
    ('\u{2F8F7}', '\u{23A8D}', None),
    ('\u{2F8F8}', '\u{21D0B}', None),
    ('\u{2F8F9}', '\u{23AFA}', None),
    ('\u{2F8FA}', '\u{6C4E}', None),
    ('\u{2F8FB}', '\u{23CBC}', None),
    ('\u{2F8FC}', '\u{6CBF}', None),
    ('\u{2F8FD}', '\u{6CCD}', None),
    ('\u{2F8FE}', '\u{6C67}', None),
    ('\u{2F8FF}', '\u{6D16}', None),
    ('\u{2F900}', '\u{6D3E}', None),
    ('\u{2F901}', '\u{6D77}', None),
    ('\u{2F902}', '\u{6D41}', None),
    ('\u{2F903}', '\u{6D69}', None),
    ('\u{2F904}', '\u{6D78}', None),
    ('\u{2F905}', '\u{6D85}', None),
    ('\u{2F906}', '\u{23D1E}', None),
    ('\u{2F907}', '\u{6D34}', None),
    ('\u{2F908}', '\u{6E2F}', None),
    ('\u{2F909}', '\u{6E6E}', None),
    ('\u{2F90A}', '\u{3D33}', None),
    ('\u{2F90B}', '\u{6ECB}', None),
    ('\u{2F90C}', '\u{6EC7}', None),
    ('\u{2F90D}', '\u{23ED1}', None),
    ('\u{2F90E}', '\u{6DF9}', None),
    ('\u{2F90F}', '\u{6F6E}', None),
    ('\u{2F910}', '\u{23F5E}', None),
    ('\u{2F911}', '\u{23F8E}', None),
    ('\u{2F912}', '\u{6FC6}', None),
    ('\u{2F913}', '\u{7039}', None),
    ('\u{2F914}', '\u{701E}', None),
    ('\u{2F915}', '\u{701B}', None),
    ('\u{2F916}', '\u{3D96}', None),
    ('\u{2F917}', '\u{704A}', None),
    ('\u{2F918}', '\u{707D}', None),
    ('\u{2F919}', '\u{7077}', None),
    ('\u{2F91A}', '\u{70AD}', None),
    ('\u{2F91B}', '\u{20525}', None),
    ('\u{2F91C}', '\u{7145}', None),
    ('\u{2F91D}', '\u{24263}', None),
    ('\u{2F91E}', '\u{719C}', None),
    ('\u{2F91F}', '\u{243AB}', None),
    ('\u{2F920}', '\u{7228}', None),
    ('\u{2F921}', '\u{7235}', None),
    ('\u{2F922}', '\u{7250}', None),
    ('\u{2F923}', '\u{24608}', None),
    ('\u{2F924}', '\u{7280}', None),
    ('\u{2F925}', '\u{7295}', None),
    ('\u{2F926}', '\u{24735}', None),
    ('\u{2F927}', '\u{24814}', None),
    ('\u{2F928}', '\u{737A}', None),
    ('\u{2F929}', '\u{738B}', None),
    ('\u{2F92A}', '\u{3EAC}', None),
    ('\u{2F92B}', '\u{73A5}', None),
    ('\u{2F92C}', '\u{3EB8}', None),
    ('\u{2F92D}', '\u{3EB8}', None),
    ('\u{2F92E}', '\u{7447}', None),
    ('\u{2F92F}', '\u{745C}', None),
    ('\u{2F930}', '\u{7471}', None),
    ('\u{2F931}', '\u{7485}', None),
    ('\u{2F932}', '\u{74CA}', None),
    ('\u{2F933}', '\u{3F1B}', None),
    ('\u{2F934}', '\u{7524}', None),
    ('\u{2F935}', '\u{24C36}', None),
    ('\u{2F936}', '\u{753E}', None),
    ('\u{2F937}', '\u{24C92}', None),
    ('\u{2F938}', '\u{7570}', None),
    ('\u{2F939}', '\u{2219F}', None),
    ('\u{2F93A}', '\u{7610}', None),
    ('\u{2F93B}', '\u{24FA1}', None),
    ('\u{2F93C}', '\u{24FB8}', None),
    ('\u{2F93D}', '\u{25044}', None),
    ('\u{2F93E}', '\u{3FFC}', None),
    ('\u{2F93F}', '\u{4008}', None),
    ('\u{2F940}', '\u{76F4}', None),
    ('\u{2F941}', '\u{250F3}', None),
    ('\u{2F942}', '\u{250F2}', None),
    ('\u{2F943}', '\u{25119}', None),
    ('\u{2F944}', '\u{25133}', None),
    ('\u{2F945}', '\u{771E}', None),
    ('\u{2F946}', '\u{771F}', None),
    ('\u{2F947}', '\u{771F}', None),
    ('\u{2F948}', '\u{774A}', None),
    ('\u{2F949}', '\u{4039}', None),
    ('\u{2F94A}', '\u{778B}', None),
    ('\u{2F94B}', '\u{4046}', None),
    ('\u{2F94C}', '\u{4096}', None),
    ('\u{2F94D}', '\u{2541D}', None),
    ('\u{2F94E}', '\u{784E}', None),
    ('\u{2F94F}', '\u{788C}', None),
    ('\u{2F950}', '\u{78CC}', None),
    ('\u{2F951}', '\u{40E3}', None),
    ('\u{2F952}', '\u{25626}', None),
    ('\u{2F953}', '\u{7956}', None),
    ('\u{2F954}', '\u{2569A}', None),
    ('\u{2F955}', '\u{256C5}', None),
    ('\u{2F956}', '\u{798F}', None),
    ('\u{2F957}', '\u{79EB}', None),
    ('\u{2F958}', '\u{412F}', None),
    ('\u{2F959}', '\u{7A40}', None),
    ('\u{2F95A}', '\u{7A4A}', None),
    ('\u{2F95B}', '\u{7A4F}', None),
    ('\u{2F95C}', '\u{2597C}', None),
    ('\u{2F95D}', '\u{25AA7}', None),
    ('\u{2F95E}', '\u{25AA7}', None),
    ('\u{2F95F}', '\u{7AEE}', None),
    ('\u{2F960}', '\u{4202}', None),
    ('\u{2F961}', '\u{25BAB}', None),
    ('\u{2F962}', '\u{7BC6}', None),
    ('\u{2F963}', '\u{7BC9}', None),
    ('\u{2F964}', '\u{4227}', None),
    ('\u{2F965}', '\u{25C80}', None),
    ('\u{2F966}', '\u{7CD2}', None),
    ('\u{2F967}', '\u{42A0}', None),
    ('\u{2F968}', '\u{7CE8}', None),
    ('\u{2F969}', '\u{7CE3}', None),
    ('\u{2F96A}', '\u{7D00}', None),
    ('\u{2F96B}', '\u{25F86}', None),
    ('\u{2F96C}', '\u{7D63}', None),
    ('\u{2F96D}', '\u{4301}', None),
    ('\u{2F96E}', '\u{7DC7}', None),
    ('\u{2F96F}', '\u{7E02}', None),
    ('\u{2F970}', '\u{7E45}', None),
    ('\u{2F971}', '\u{4334}', None),
    ('\u{2F972}', '\u{26228}', None),
    ('\u{2F973}', '\u{26247}', None),
    ('\u{2F974}', '\u{4359}', None),
    ('\u{2F975}', '\u{262D9}', None),
    ('\u{2F976}', '\u{7F7A}', None),
    ('\u{2F977}', '\u{2633E}', None),
    ('\u{2F978}', '\u{7F95}', None),
    ('\u{2F979}', '\u{7FFA}', None),
    ('\u{2F97A}', '\u{8005}', None),
    ('\u{2F97B}', '\u{264DA}', None),
    ('\u{2F97C}', '\u{26523}', None),
    ('\u{2F97D}', '\u{8060}', None),
    ('\u{2F97E}', '\u{265A8}', None),
    ('\u{2F97F}', '\u{8070}', None),
    ('\u{2F980}', '\u{2335F}', None),
    ('\u{2F981}', '\u{43D5}', None),
    ('\u{2F982}', '\u{80B2}', None),
    ('\u{2F983}', '\u{8103}', None),
    ('\u{2F984}', '\u{440B}', None),
    ('\u{2F985}', '\u{813E}', None),
    ('\u{2F986}', '\u{5AB5}', None),
    ('\u{2F987}', '\u{267A7}', None),
    ('\u{2F988}', '\u{267B5}', None),
    ('\u{2F989}', '\u{23393}', None),
    ('\u{2F98A}', '\u{2339C}', None),
    ('\u{2F98B}', '\u{8201}', None),
    ('\u{2F98C}', '\u{8204}', None),
    ('\u{2F98D}', '\u{8F9E}', None),
    ('\u{2F98E}', '\u{446B}', None),
    ('\u{2F98F}', '\u{8291}', None),
    ('\u{2F990}', '\u{828B}', None),
    ('\u{2F991}', '\u{829D}', None),
    ('\u{2F992}', '\u{52B3}', None),
    ('\u{2F993}', '\u{82B1}', None),
    ('\u{2F994}', '\u{82B3}', None),
    ('\u{2F995}', '\u{82BD}', None),
    ('\u{2F996}', '\u{82E6}', None),
    ('\u{2F997}', '\u{26B3C}', None),
    ('\u{2F998}', '\u{82E5}', None),
    ('\u{2F999}', '\u{831D}', None),
    ('\u{2F99A}', '\u{8363}', None),
    ('\u{2F99B}', '\u{83AD}', None),
    ('\u{2F99C}', '\u{8323}', None),
    ('\u{2F99D}', '\u{83BD}', None),
    ('\u{2F99E}', '\u{83E7}', None),
    ('\u{2F99F}', '\u{8457}', None),
    ('\u{2F9A0}', '\u{8353}', None),
    ('\u{2F9A1}', '\u{83CA}', None),
    ('\u{2F9A2}', '\u{83CC}', None),
    ('\u{2F9A3}', '\u{83DC}', None),
    ('\u{2F9A4}', '\u{26C36}', None),
    ('\u{2F9A5}', '\u{26D6B}', None),
    ('\u{2F9A6}', '\u{26CD5}', None),
    ('\u{2F9A7}', '\u{452B}', None),
    ('\u{2F9A8}', '\u{84F1}', None),
    ('\u{2F9A9}', '\u{84F3}', None),
    ('\u{2F9AA}', '\u{8516}', None),
    ('\u{2F9AB}', '\u{273CA}', None),
    ('\u{2F9AC}', '\u{8564}', None),
    ('\u{2F9AD}', '\u{26F2C}', None),
    ('\u{2F9AE}', '\u{455D}', None),
    ('\u{2F9AF}', '\u{4561}', None),
    ('\u{2F9B0}', '\u{26FB1}', None),
    ('\u{2F9B1}', '\u{270D2}', None),
    ('\u{2F9B2}', '\u{456B}', None),
    ('\u{2F9B3}', '\u{8650}', None),
    ('\u{2F9B4}', '\u{865C}', None),
    ('\u{2F9B5}', '\u{8667}', None),
    ('\u{2F9B6}', '\u{8669}', None),
    ('\u{2F9B7}', '\u{86A9}', None),
    ('\u{2F9B8}', '\u{8688}', None),
    ('\u{2F9B9}', '\u{870E}', None),
    ('\u{2F9BA}', '\u{86E2}', None),
    ('\u{2F9BB}', '\u{8779}', None),
    ('\u{2F9BC}', '\u{8728}', None),
    ('\u{2F9BD}', '\u{876B}', None),
    ('\u{2F9BE}', '\u{8786}', None),
    ('\u{2F9BF}', '\u{45D7}', None),
    ('\u{2F9C0}', '\u{87E1}', None),
    ('\u{2F9C1}', '\u{8801}', None),
    ('\u{2F9C2}', '\u{45F9}', None),
    ('\u{2F9C3}', '\u{8860}', None),
    ('\u{2F9C4}', '\u{8863}', None),
    ('\u{2F9C5}', '\u{27667}', None),
    ('\u{2F9C6}', '\u{88D7}', None),
    ('\u{2F9C7}', '\u{88DE}', None),
    ('\u{2F9C8}', '\u{4635}', None),
    ('\u{2F9C9}', '\u{88FA}', None),
    ('\u{2F9CA}', '\u{34BB}', None),
    ('\u{2F9CB}', '\u{278AE}', None),
    ('\u{2F9CC}', '\u{27966}', None),
    ('\u{2F9CD}', '\u{46BE}', None),
    ('\u{2F9CE}', '\u{46C7}', None),
    ('\u{2F9CF}', '\u{8AA0}', None),
    ('\u{2F9D0}', '\u{8AED}', None),
    ('\u{2F9D1}', '\u{8B8A}', None),
    ('\u{2F9D2}', '\u{8C55}', None),
    ('\u{2F9D3}', '\u{27CA8}', None),
    ('\u{2F9D4}', '\u{8CAB}', None),
    ('\u{2F9D5}', '\u{8CC1}', None),
    ('\u{2F9D6}', '\u{8D1B}', None),
    ('\u{2F9D7}', '\u{8D77}', None),
    ('\u{2F9D8}', '\u{27F2F}', None),
    ('\u{2F9D9}', '\u{20804}', None),
    ('\u{2F9DA}', '\u{8DCB}', None),
    ('\u{2F9DB}', '\u{8DBC}', None),
    ('\u{2F9DC}', '\u{8DF0}', None),
    ('\u{2F9DD}', '\u{208DE}', None),
    ('\u{2F9DE}', '\u{8ED4}', None),
    ('\u{2F9DF}', '\u{8F38}', None),
    ('\u{2F9E0}', '\u{285D2}', None),
    ('\u{2F9E1}', '\u{285ED}', None),
    ('\u{2F9E2}', '\u{9094}', None),
    ('\u{2F9E3}', '\u{90F1}', None),
    ('\u{2F9E4}', '\u{9111}', None),
    ('\u{2F9E5}', '\u{2872E}', None),
    ('\u{2F9E6}', '\u{911B}', None),
    ('\u{2F9E7}', '\u{9238}', None),
    ('\u{2F9E8}', '\u{92D7}', None),
    ('\u{2F9E9}', '\u{92D8}', None),
    ('\u{2F9EA}', '\u{927C}', None),
    ('\u{2F9EB}', '\u{93F9}', None),
    ('\u{2F9EC}', '\u{9415}', None),
    ('\u{2F9ED}', '\u{28BFA}', None),
    ('\u{2F9EE}', '\u{958B}', None),
    ('\u{2F9EF}', '\u{4995}', None),
    ('\u{2F9F0}', '\u{95B7}', None),
    ('\u{2F9F1}', '\u{28D77}', None),
    ('\u{2F9F2}', '\u{49E6}', None),
    ('\u{2F9F3}', '\u{96C3}', None),
    ('\u{2F9F4}', '\u{5DB2}', None),
    ('\u{2F9F5}', '\u{9723}', None),
    ('\u{2F9F6}', '\u{29145}', None),
    ('\u{2F9F7}', '\u{2921A}', None),
    ('\u{2F9F8}', '\u{4A6E}', None),
    ('\u{2F9F9}', '\u{4A76}', None),
    ('\u{2F9FA}', '\u{97E0}', None),
    ('\u{2F9FB}', '\u{2940A}', None),
    ('\u{2F9FC}', '\u{4AB2}', None),
    ('\u{2F9FD}', '\u{29496}', None),
    ('\u{2F9FE}', '\u{980B}', None),
    ('\u{2F9FF}', '\u{980B}', None),
    ('\u{2FA00}', '\u{9829}', None),
    ('\u{2FA01}', '\u{295B6}', None),
    ('\u{2FA02}', '\u{98E2}', None),
    ('\u{2FA03}', '\u{4B33}', None),
    ('\u{2FA04}', '\u{9929}', None),
    ('\u{2FA05}', '\u{99A7}', None),
    ('\u{2FA06}', '\u{99C2}', None),
    ('\u{2FA07}', '\u{99FE}', None),
    ('\u{2FA08}', '\u{4BCE}', None),
    ('\u{2FA09}', '\u{29B30}', None),
    ('\u{2FA0A}', '\u{9B12}', None),
    ('\u{2FA0B}', '\u{9C40}', None),
    ('\u{2FA0C}', '\u{9CFD}', None),
    ('\u{2FA0D}', '\u{4CCE}', None),
    ('\u{2FA0E}', '\u{4CED}', None),
    ('\u{2FA0F}', '\u{9D67}', None),
    ('\u{2FA10}', '\u{2A0CE}', None),
    ('\u{2FA11}', '\u{4CF8}', None),
    ('\u{2FA12}', '\u{2A105}', None),
    ('\u{2FA13}', '\u{2A20E}', None),
    ('\u{2FA14}', '\u{2A291}', None),
    ('\u{2FA15}', '\u{9EBB}', None),
    ('\u{2FA16}', '\u{4D56}', None),
    ('\u{2FA17}', '\u{9EF9}', None),
    ('\u{2FA18}', '\u{9EFE}', None),
    ('\u{2FA19}', '\u{9F05}', None),
    ('\u{2FA1A}', '\u{9F0F}', None),
    ('\u{2FA1B}', '\u{9F16}', None),
    ('\u{2FA1C}', '\u{9F3B}', None),
    ('\u{2FA1D}', '\u{2A600}', None),
];

// The first value is `a << 32 | b`.
// Sorted by the first value.
pub const COMPOSITION_TABLE: &[(u64, char)] = &[
    (257698038584, '\u{226E}'),
    (261993005880, '\u{2260}'),
    (266287973176, '\u{226F}'),
    (279172875008, '\u{00C0}'),
    (279172875009, '\u{00C1}'),
    (279172875010, '\u{00C2}'),
    (279172875011, '\u{00C3}'),
    (279172875012, '\u{0100}'),
    (279172875014, '\u{0102}'),
    (279172875015, '\u{0226}'),
    (279172875016, '\u{00C4}'),
    (279172875017, '\u{1EA2}'),
    (279172875018, '\u{00C5}'),
    (279172875020, '\u{01CD}'),
    (279172875023, '\u{0200}'),
    (279172875025, '\u{0202}'),
    (279172875043, '\u{1EA0}'),
    (279172875045, '\u{1E00}'),
    (279172875048, '\u{0104}'),
    (283467842311, '\u{1E02}'),
    (283467842339, '\u{1E04}'),
    (283467842353, '\u{1E06}'),
    (287762809601, '\u{0106}'),
    (287762809602, '\u{0108}'),
    (287762809607, '\u{010A}'),
    (287762809612, '\u{010C}'),
    (287762809639, '\u{00C7}'),
    (292057776903, '\u{1E0A}'),
    (292057776908, '\u{010E}'),
    (292057776931, '\u{1E0C}'),
    (292057776935, '\u{1E10}'),
    (292057776941, '\u{1E12}'),
    (292057776945, '\u{1E0E}'),
    (296352744192, '\u{00C8}'),
    (296352744193, '\u{00C9}'),
    (296352744194, '\u{00CA}'),
    (296352744195, '\u{1EBC}'),
    (296352744196, '\u{0112}'),
    (296352744198, '\u{0114}'),
    (296352744199, '\u{0116}'),
    (296352744200, '\u{00CB}'),
    (296352744201, '\u{1EBA}'),
    (296352744204, '\u{011A}'),
    (296352744207, '\u{0204}'),
    (296352744209, '\u{0206}'),
    (296352744227, '\u{1EB8}'),
    (296352744231, '\u{0228}'),
    (296352744232, '\u{0118}'),
    (296352744237, '\u{1E18}'),
    (296352744240, '\u{1E1A}'),
    (300647711495, '\u{1E1E}'),
    (304942678785, '\u{01F4}'),
    (304942678786, '\u{011C}'),
    (304942678788, '\u{1E20}'),
    (304942678790, '\u{011E}'),
    (304942678791, '\u{0120}'),
    (304942678796, '\u{01E6}'),
    (304942678823, '\u{0122}'),
    (309237646082, '\u{0124}'),
    (309237646087, '\u{1E22}'),
    (309237646088, '\u{1E26}'),
    (309237646092, '\u{021E}'),
    (309237646115, '\u{1E24}'),
    (309237646119, '\u{1E28}'),
    (309237646126, '\u{1E2A}'),
    (313532613376, '\u{00CC}'),
    (313532613377, '\u{00CD}'),
    (313532613378, '\u{00CE}'),
    (313532613379, '\u{0128}'),
    (313532613380, '\u{012A}'),
    (313532613382, '\u{012C}'),
    (313532613383, '\u{0130}'),
    (313532613384, '\u{00CF}'),
    (313532613385, '\u{1EC8}'),
    (313532613388, '\u{01CF}'),
    (313532613391, '\u{0208}'),
    (313532613393, '\u{020A}'),
    (313532613411, '\u{1ECA}'),
    (313532613416, '\u{012E}'),
    (313532613424, '\u{1E2C}'),
    (317827580674, '\u{0134}'),
    (322122547969, '\u{1E30}'),
    (322122547980, '\u{01E8}'),
    (322122548003, '\u{1E32}'),
    (322122548007, '\u{0136}'),
    (322122548017, '\u{1E34}'),
    (326417515265, '\u{0139}'),
    (326417515276, '\u{013D}'),
    (326417515299, '\u{1E36}'),
    (326417515303, '\u{013B}'),
    (326417515309, '\u{1E3C}'),
    (326417515313, '\u{1E3A}'),
    (330712482561, '\u{1E3E}'),
    (330712482567, '\u{1E40}'),
    (330712482595, '\u{1E42}'),
    (335007449856, '\u{01F8}'),
    (335007449857, '\u{0143}'),
    (335007449859, '\u{00D1}'),
    (335007449863, '\u{1E44}'),
    (335007449868, '\u{0147}'),
    (335007449891, '\u{1E46}'),
    (335007449895, '\u{0145}'),
    (335007449901, '\u{1E4A}'),
    (335007449905, '\u{1E48}'),
    (339302417152, '\u{00D2}'),
    (339302417153, '\u{00D3}'),
    (339302417154, '\u{00D4}'),
    (339302417155, '\u{00D5}'),
    (339302417156, '\u{014C}'),
    (339302417158, '\u{014E}'),
    (339302417159, '\u{022E}'),
    (339302417160, '\u{00D6}'),
    (339302417161, '\u{1ECE}'),
    (339302417163, '\u{0150}'),
    (339302417164, '\u{01D1}'),
    (339302417167, '\u{020C}'),
    (339302417169, '\u{020E}'),
    (339302417179, '\u{01A0}'),
    (339302417187, '\u{1ECC}'),
    (339302417192, '\u{01EA}'),
    (343597384449, '\u{1E54}'),
    (343597384455, '\u{1E56}'),
    (352187319041, '\u{0154}'),
    (352187319047, '\u{1E58}'),
    (352187319052, '\u{0158}'),
    (352187319055, '\u{0210}'),
    (352187319057, '\u{0212}'),
    (352187319075, '\u{1E5A}'),
    (352187319079, '\u{0156}'),
    (352187319089, '\u{1E5E}'),
    (356482286337, '\u{015A}'),
    (356482286338, '\u{015C}'),
    (356482286343, '\u{1E60}'),
    (356482286348, '\u{0160}'),
    (356482286371, '\u{1E62}'),
    (356482286374, '\u{0218}'),
    (356482286375, '\u{015E}'),
    (360777253639, '\u{1E6A}'),
    (360777253644, '\u{0164}'),
    (360777253667, '\u{1E6C}'),
    (360777253670, '\u{021A}'),
    (360777253671, '\u{0162}'),
    (360777253677, '\u{1E70}'),
    (360777253681, '\u{1E6E}'),
    (365072220928, '\u{00D9}'),
    (365072220929, '\u{00DA}'),
    (365072220930, '\u{00DB}'),
    (365072220931, '\u{0168}'),
    (365072220932, '\u{016A}'),
    (365072220934, '\u{016C}'),
    (365072220936, '\u{00DC}'),
    (365072220937, '\u{1EE6}'),
    (365072220938, '\u{016E}'),
    (365072220939, '\u{0170}'),
    (365072220940, '\u{01D3}'),
    (365072220943, '\u{0214}'),
    (365072220945, '\u{0216}'),
    (365072220955, '\u{01AF}'),
    (365072220963, '\u{1EE4}'),
    (365072220964, '\u{1E72}'),
    (365072220968, '\u{0172}'),
    (365072220973, '\u{1E76}'),
    (365072220976, '\u{1E74}'),
    (369367188227, '\u{1E7C}'),
    (369367188259, '\u{1E7E}'),
    (373662155520, '\u{1E80}'),
    (373662155521, '\u{1E82}'),
    (373662155522, '\u{0174}'),
    (373662155527, '\u{1E86}'),
    (373662155528, '\u{1E84}'),
    (373662155555, '\u{1E88}'),
    (377957122823, '\u{1E8A}'),
    (377957122824, '\u{1E8C}'),
    (382252090112, '\u{1EF2}'),
    (382252090113, '\u{00DD}'),
    (382252090114, '\u{0176}'),
    (382252090115, '\u{1EF8}'),
    (382252090116, '\u{0232}'),
    (382252090119, '\u{1E8E}'),
    (382252090120, '\u{0178}'),
    (382252090121, '\u{1EF6}'),
    (382252090147, '\u{1EF4}'),
    (386547057409, '\u{0179}'),
    (386547057410, '\u{1E90}'),
    (386547057415, '\u{017B}'),
    (386547057420, '\u{017D}'),
    (386547057443, '\u{1E92}'),
    (386547057457, '\u{1E94}'),
    (416611828480, '\u{00E0}'),
    (416611828481, '\u{00E1}'),
    (416611828482, '\u{00E2}'),
    (416611828483, '\u{00E3}'),
    (416611828484, '\u{0101}'),
    (416611828486, '\u{0103}'),
    (416611828487, '\u{0227}'),
    (416611828488, '\u{00E4}'),
    (416611828489, '\u{1EA3}'),
    (416611828490, '\u{00E5}'),
    (416611828492, '\u{01CE}'),
    (416611828495, '\u{0201}'),
    (416611828497, '\u{0203}'),
    (416611828515, '\u{1EA1}'),
    (416611828517, '\u{1E01}'),
    (416611828520, '\u{0105}'),
    (420906795783, '\u{1E03}'),
    (420906795811, '\u{1E05}'),
    (420906795825, '\u{1E07}'),
    (425201763073, '\u{0107}'),
    (425201763074, '\u{0109}'),
    (425201763079, '\u{010B}'),
    (425201763084, '\u{010D}'),
    (425201763111, '\u{00E7}'),
    (429496730375, '\u{1E0B}'),
    (429496730380, '\u{010F}'),
    (429496730403, '\u{1E0D}'),
    (429496730407, '\u{1E11}'),
    (429496730413, '\u{1E13}'),
    (429496730417, '\u{1E0F}'),
    (433791697664, '\u{00E8}'),
    (433791697665, '\u{00E9}'),
    (433791697666, '\u{00EA}'),
    (433791697667, '\u{1EBD}'),
    (433791697668, '\u{0113}'),
    (433791697670, '\u{0115}'),
    (433791697671, '\u{0117}'),
    (433791697672, '\u{00EB}'),
    (433791697673, '\u{1EBB}'),
    (433791697676, '\u{011B}'),
    (433791697679, '\u{0205}'),
    (433791697681, '\u{0207}'),
    (433791697699, '\u{1EB9}'),
    (433791697703, '\u{0229}'),
    (433791697704, '\u{0119}'),
    (433791697709, '\u{1E19}'),
    (433791697712, '\u{1E1B}'),
    (438086664967, '\u{1E1F}'),
    (442381632257, '\u{01F5}'),
    (442381632258, '\u{011D}'),
    (442381632260, '\u{1E21}'),
    (442381632262, '\u{011F}'),
    (442381632263, '\u{0121}'),
    (442381632268, '\u{01E7}'),
    (442381632295, '\u{0123}'),
    (446676599554, '\u{0125}'),
    (446676599559, '\u{1E23}'),
    (446676599560, '\u{1E27}'),
    (446676599564, '\u{021F}'),
    (446676599587, '\u{1E25}'),
    (446676599591, '\u{1E29}'),
    (446676599598, '\u{1E2B}'),
    (446676599601, '\u{1E96}'),
    (450971566848, '\u{00EC}'),
    (450971566849, '\u{00ED}'),
    (450971566850, '\u{00EE}'),
    (450971566851, '\u{0129}'),
    (450971566852, '\u{012B}'),
    (450971566854, '\u{012D}'),
    (450971566856, '\u{00EF}'),
    (450971566857, '\u{1EC9}'),
    (450971566860, '\u{01D0}'),
    (450971566863, '\u{0209}'),
    (450971566865, '\u{020B}'),
    (450971566883, '\u{1ECB}'),
    (450971566888, '\u{012F}'),
    (450971566896, '\u{1E2D}'),
    (455266534146, '\u{0135}'),
    (455266534156, '\u{01F0}'),
    (459561501441, '\u{1E31}'),
    (459561501452, '\u{01E9}'),
    (459561501475, '\u{1E33}'),
    (459561501479, '\u{0137}'),
    (459561501489, '\u{1E35}'),
    (463856468737, '\u{013A}'),
    (463856468748, '\u{013E}'),
    (463856468771, '\u{1E37}'),
    (463856468775, '\u{013C}'),
    (463856468781, '\u{1E3D}'),
    (463856468785, '\u{1E3B}'),
    (468151436033, '\u{1E3F}'),
    (468151436039, '\u{1E41}'),
    (468151436067, '\u{1E43}'),
    (472446403328, '\u{01F9}'),
    (472446403329, '\u{0144}'),
    (472446403331, '\u{00F1}'),
    (472446403335, '\u{1E45}'),
    (472446403340, '\u{0148}'),
    (472446403363, '\u{1E47}'),
    (472446403367, '\u{0146}'),
    (472446403373, '\u{1E4B}'),
    (472446403377, '\u{1E49}'),
    (476741370624, '\u{00F2}'),
    (476741370625, '\u{00F3}'),
    (476741370626, '\u{00F4}'),
    (476741370627, '\u{00F5}'),
    (476741370628, '\u{014D}'),
    (476741370630, '\u{014F}'),
    (476741370631, '\u{022F}'),
    (476741370632, '\u{00F6}'),
    (476741370633, '\u{1ECF}'),
    (476741370635, '\u{0151}'),
    (476741370636, '\u{01D2}'),
    (476741370639, '\u{020D}'),
    (476741370641, '\u{020F}'),
    (476741370651, '\u{01A1}'),
    (476741370659, '\u{1ECD}'),
    (476741370664, '\u{01EB}'),
    (481036337921, '\u{1E55}'),
    (481036337927, '\u{1E57}'),
    (489626272513, '\u{0155}'),
    (489626272519, '\u{1E59}'),
    (489626272524, '\u{0159}'),
    (489626272527, '\u{0211}'),
    (489626272529, '\u{0213}'),
    (489626272547, '\u{1E5B}'),
    (489626272551, '\u{0157}'),
    (489626272561, '\u{1E5F}'),
    (493921239809, '\u{015B}'),
    (493921239810, '\u{015D}'),
    (493921239815, '\u{1E61}'),
    (493921239820, '\u{0161}'),
    (493921239843, '\u{1E63}'),
    (493921239846, '\u{0219}'),
    (493921239847, '\u{015F}'),
    (498216207111, '\u{1E6B}'),
    (498216207112, '\u{1E97}'),
    (498216207116, '\u{0165}'),
    (498216207139, '\u{1E6D}'),
    (498216207142, '\u{021B}'),
    (498216207143, '\u{0163}'),
    (498216207149, '\u{1E71}'),
    (498216207153, '\u{1E6F}'),
    (502511174400, '\u{00F9}'),
    (502511174401, '\u{00FA}'),
    (502511174402, '\u{00FB}'),
    (502511174403, '\u{0169}'),
    (502511174404, '\u{016B}'),
    (502511174406, '\u{016D}'),
    (502511174408, '\u{00FC}'),
    (502511174409, '\u{1EE7}'),
    (502511174410, '\u{016F}'),
    (502511174411, '\u{0171}'),
    (502511174412, '\u{01D4}'),
    (502511174415, '\u{0215}'),
    (502511174417, '\u{0217}'),
    (502511174427, '\u{01B0}'),
    (502511174435, '\u{1EE5}'),
    (502511174436, '\u{1E73}'),
    (502511174440, '\u{0173}'),
    (502511174445, '\u{1E77}'),
    (502511174448, '\u{1E75}'),
    (506806141699, '\u{1E7D}'),
    (506806141731, '\u{1E7F}'),
    (511101108992, '\u{1E81}'),
    (511101108993, '\u{1E83}'),
    (511101108994, '\u{0175}'),
    (511101108999, '\u{1E87}'),
    (511101109000, '\u{1E85}'),
    (511101109002, '\u{1E98}'),
    (511101109027, '\u{1E89}'),
    (515396076295, '\u{1E8B}'),
    (515396076296, '\u{1E8D}'),
    (519691043584, '\u{1EF3}'),
    (519691043585, '\u{00FD}'),
    (519691043586, '\u{0177}'),
    (519691043587, '\u{1EF9}'),
    (519691043588, '\u{0233}'),
    (519691043591, '\u{1E8F}'),
    (519691043592, '\u{00FF}'),
    (519691043593, '\u{1EF7}'),
    (519691043594, '\u{1E99}'),
    (519691043619, '\u{1EF5}'),
    (523986010881, '\u{017A}'),
    (523986010882, '\u{1E91}'),
    (523986010887, '\u{017C}'),
    (523986010892, '\u{017E}'),
    (523986010915, '\u{1E93}'),
    (523986010929, '\u{1E95}'),
    (721554506496, '\u{1FED}'),
    (721554506497, '\u{0385}'),
    (721554506562, '\u{1FC1}'),
    (833223656192, '\u{1EA6}'),
    (833223656193, '\u{1EA4}'),
    (833223656195, '\u{1EAA}'),
    (833223656201, '\u{1EA8}'),
    (841813590788, '\u{01DE}'),
    (846108558081, '\u{01FA}'),
    (850403525377, '\u{01FC}'),
    (850403525380, '\u{01E2}'),
    (854698492673, '\u{1E08}'),
    (867583394560, '\u{1EC0}'),
    (867583394561, '\u{1EBE}'),
    (867583394563, '\u{1EC4}'),
    (867583394569, '\u{1EC2}'),
    (889058231041, '\u{1E2E}'),
    (910533067520, '\u{1ED2}'),
    (910533067521, '\u{1ED0}'),
    (910533067523, '\u{1ED6}'),
    (910533067529, '\u{1ED4}'),
    (914828034817, '\u{1E4C}'),
    (914828034820, '\u{022C}'),
    (914828034824, '\u{1E4E}'),
    (919123002116, '\u{022A}'),
    (927712936705, '\u{01FE}'),
    (944892805888, '\u{01DB}'),
    (944892805889, '\u{01D7}'),
    (944892805892, '\u{01D5}'),
    (944892805900, '\u{01D9}'),
    (970662609664, '\u{1EA7}'),
    (970662609665, '\u{1EA5}'),
    (970662609667, '\u{1EAB}'),
    (970662609673, '\u{1EA9}'),
    (979252544260, '\u{01DF}'),
    (983547511553, '\u{01FB}'),
    (987842478849, '\u{01FD}'),
    (987842478852, '\u{01E3}'),
    (992137446145, '\u{1E09}'),
    (1005022348032, '\u{1EC1}'),
    (1005022348033, '\u{1EBF}'),
    (1005022348035, '\u{1EC5}'),
    (1005022348041, '\u{1EC3}'),
    (1026497184513, '\u{1E2F}'),
    (1047972020992, '\u{1ED3}'),
    (1047972020993, '\u{1ED1}'),
    (1047972020995, '\u{1ED7}'),
    (1047972021001, '\u{1ED5}'),
    (1052266988289, '\u{1E4D}'),
    (1052266988292, '\u{022D}'),
    (1052266988296, '\u{1E4F}'),
    (1056561955588, '\u{022B}'),
    (1065151890177, '\u{01FF}'),
    (1082331759360, '\u{01DC}'),
    (1082331759361, '\u{01D8}'),
    (1082331759364, '\u{01D6}'),
    (1082331759372, '\u{01DA}'),
    (1108101563136, '\u{1EB0}'),
    (1108101563137, '\u{1EAE}'),
    (1108101563139, '\u{1EB4}'),
    (1108101563145, '\u{1EB2}'),
    (1112396530432, '\u{1EB1}'),
    (1112396530433, '\u{1EAF}'),
    (1112396530435, '\u{1EB5}'),
    (1112396530441, '\u{1EB3}'),
    (1176821039872, '\u{1E14}'),
    (1176821039873, '\u{1E16}'),
    (1181116007168, '\u{1E15}'),
    (1181116007169, '\u{1E17}'),
    (1425929143040, '\u{1E50}'),
    (1425929143041, '\u{1E52}'),
    (1430224110336, '\u{1E51}'),
    (1430224110337, '\u{1E53}'),
    (1486058685191, '\u{1E64}'),
    (1490353652487, '\u{1E65}'),
    (1511828488967, '\u{1E66}'),
    (1516123456263, '\u{1E67}'),
    (1546188227329, '\u{1E78}'),
    (1550483194625, '\u{1E79}'),
    (1554778161928, '\u{1E7A}'),
    (1559073129224, '\u{1E7B}'),
    (1644972475143, '\u{1E9B}'),
    (1786706395904, '\u{1EDC}'),
    (1786706395905, '\u{1EDA}'),
    (1786706395907, '\u{1EE0}'),
    (1786706395913, '\u{1EDE}'),
    (1786706395939, '\u{1EE2}'),
    (1791001363200, '\u{1EDD}'),
    (1791001363201, '\u{1EDB}'),
    (1791001363203, '\u{1EE1}'),
    (1791001363209, '\u{1EDF}'),
    (1791001363235, '\u{1EE3}'),
    (1851130905344, '\u{1EEA}'),
    (1851130905345, '\u{1EE8}'),
    (1851130905347, '\u{1EEE}'),
    (1851130905353, '\u{1EEC}'),
    (1851130905379, '\u{1EF0}'),
    (1855425872640, '\u{1EEB}'),
    (1855425872641, '\u{1EE9}'),
    (1855425872643, '\u{1EEF}'),
    (1855425872649, '\u{1EED}'),
    (1855425872675, '\u{1EF1}'),
    (1885490643724, '\u{01EE}'),
    (2104533975812, '\u{01EC}'),
    (2108828943108, '\u{01ED}'),
    (2362232013572, '\u{01E0}'),
    (2366526980868, '\u{01E1}'),
    (2370821948166, '\u{1E1C}'),
    (2375116915462, '\u{1E1D}'),
    (2396591751940, '\u{0230}'),
    (2400886719236, '\u{0231}'),
    (2826088481548, '\u{01EF}'),
    (3332894622465, '\u{0344}'),
    (3921305142016, '\u{1FBA}'),
    (3921305142017, '\u{0386}'),
    (3921305142020, '\u{1FB9}'),
    (3921305142022, '\u{1FB8}'),
    (3921305142035, '\u{1F08}'),
    (3921305142036, '\u{1F09}'),
    (3921305142085, '\u{1FBC}'),
    (3938485011200, '\u{1FC8}'),
    (3938485011201, '\u{0388}'),
    (3938485011219, '\u{1F18}'),
    (3938485011220, '\u{1F19}'),
    (3947074945792, '\u{1FCA}'),
    (3947074945793, '\u{0389}'),
    (3947074945811, '\u{1F28}'),
    (3947074945812, '\u{1F29}'),
    (3947074945861, '\u{1FCC}'),
    (3955664880384, '\u{1FDA}'),
    (3955664880385, '\u{038A}'),
    (3955664880388, '\u{1FD9}'),
    (3955664880390, '\u{1FD8}'),
    (3955664880392, '\u{03AA}'),
    (3955664880403, '\u{1F38}'),
    (3955664880404, '\u{1F39}'),
    (3981434684160, '\u{1FF8}'),
    (3981434684161, '\u{038C}'),
    (3981434684179, '\u{1F48}'),
    (3981434684180, '\u{1F49}'),
    (3990024618772, '\u{1FEC}'),
    (4007204487936, '\u{1FEA}'),
    (4007204487937, '\u{038E}'),
    (4007204487940, '\u{1FE9}'),
    (4007204487942, '\u{1FE8}'),
    (4007204487944, '\u{03AB}'),
    (4007204487956, '\u{1F59}'),
    (4024384357120, '\u{1FFA}'),
    (4024384357121, '\u{038F}'),
    (4024384357139, '\u{1F68}'),
    (4024384357140, '\u{1F69}'),
    (4024384357189, '\u{1FFC}'),
    (4037269259077, '\u{1FB4}'),
    (4045859193669, '\u{1FC4}'),
    (4058744095488, '\u{1F70}'),
    (4058744095489, '\u{03AC}'),
    (4058744095492, '\u{1FB1}'),
    (4058744095494, '\u{1FB0}'),
    (4058744095507, '\u{1F00}'),
    (4058744095508, '\u{1F01}'),
    (4058744095554, '\u{1FB6}'),
    (4058744095557, '\u{1FB3}'),
    (4075923964672, '\u{1F72}'),
    (4075923964673, '\u{03AD}'),
    (4075923964691, '\u{1F10}'),
    (4075923964692, '\u{1F11}'),
    (4084513899264, '\u{1F74}'),
    (4084513899265, '\u{03AE}'),
    (4084513899283, '\u{1F20}'),
    (4084513899284, '\u{1F21}'),
    (4084513899330, '\u{1FC6}'),
    (4084513899333, '\u{1FC3}'),
    (4093103833856, '\u{1F76}'),
    (4093103833857, '\u{03AF}'),
    (4093103833860, '\u{1FD1}'),
    (4093103833862, '\u{1FD0}'),
    (4093103833864, '\u{03CA}'),
    (4093103833875, '\u{1F30}'),
    (4093103833876, '\u{1F31}'),
    (4093103833922, '\u{1FD6}'),
    (4118873637632, '\u{1F78}'),
    (4118873637633, '\u{03CC}'),
    (4118873637651, '\u{1F40}'),
    (4118873637652, '\u{1F41}'),
    (4127463572243, '\u{1FE4}'),
    (4127463572244, '\u{1FE5}'),
    (4144643441408, '\u{1F7A}'),
    (4144643441409, '\u{03CD}'),
    (4144643441412, '\u{1FE1}'),
    (4144643441414, '\u{1FE0}'),
    (4144643441416, '\u{03CB}'),
    (4144643441427, '\u{1F50}'),
    (4144643441428, '\u{1F51}'),
    (4144643441474, '\u{1FE6}'),
    (4161823310592, '\u{1F7C}'),
    (4161823310593, '\u{03CE}'),
    (4161823310611, '\u{1F60}'),
    (4161823310612, '\u{1F61}'),
    (4161823310658, '\u{1FF6}'),
    (4161823310661, '\u{1FF3}'),
    (4166118277888, '\u{1FD2}'),
    (4166118277889, '\u{0390}'),
    (4166118277954, '\u{1FD7}'),
    (4170413245184, '\u{1FE2}'),
    (4170413245185, '\u{03B0}'),
    (4170413245250, '\u{1FE7}'),
    (4183298147141, '\u{1FF4}'),
    (4200478016257, '\u{03D3}'),
    (4200478016264, '\u{03D4}'),
    (4423816315656, '\u{0407}'),
    (4466765988614, '\u{04D0}'),
    (4466765988616, '\u{04D2}'),
    (4479650890497, '\u{0403}'),
    (4488240825088, '\u{0400}'),
    (4488240825094, '\u{04D6}'),
    (4488240825096, '\u{0401}'),
    (4492535792390, '\u{04C1}'),
    (4492535792392, '\u{04DC}'),
    (4496830759688, '\u{04DE}'),
    (4501125726976, '\u{040D}'),
    (4501125726980, '\u{04E2}'),
    (4501125726982, '\u{0419}'),
    (4501125726984, '\u{04E4}'),
    (4509715661569, '\u{040C}'),
    (4526895530760, '\u{04E6}'),
    (4548370367236, '\u{04EE}'),
    (4548370367238, '\u{040E}'),
    (4548370367240, '\u{04F0}'),
    (4548370367243, '\u{04F2}'),
    (4565550236424, '\u{04F4}'),
    (4582730105608, '\u{04F8}'),
    (4591320040200, '\u{04EC}'),
    (4604204942086, '\u{04D1}'),
    (4604204942088, '\u{04D3}'),
    (4617089843969, '\u{0453}'),
    (4625679778560, '\u{0450}'),
    (4625679778566, '\u{04D7}'),
    (4625679778568, '\u{0451}'),
    (4629974745862, '\u{04C2}'),
    (4629974745864, '\u{04DD}'),
    (4634269713160, '\u{04DF}'),
    (4638564680448, '\u{045D}'),
    (4638564680452, '\u{04E3}'),
    (4638564680454, '\u{0439}'),
    (4638564680456, '\u{04E5}'),
    (4647154615041, '\u{045C}'),
    (4664334484232, '\u{04E7}'),
    (4685809320708, '\u{04EF}'),
    (4685809320710, '\u{045E}'),
    (4685809320712, '\u{04F1}'),
    (4685809320715, '\u{04F3}'),
    (4702989189896, '\u{04F5}'),
    (4720169059080, '\u{04F9}'),
    (4728758993672, '\u{04ED}'),
    (4767413699336, '\u{0457}'),
    (4896262718223, '\u{0476}'),
    (4900557685519, '\u{0477}'),
    (5325759447816, '\u{04DA}'),
    (5330054415112, '\u{04DB}'),
    (5394478924552, '\u{04EA}'),
    (5398773891848, '\u{04EB}'),
    (6764573492819, '\u{0622}'),
    (6764573492820, '\u{0623}'),
    (6764573492821, '\u{0625}'),
    (6906307413588, '\u{0624}'),
    (6914897348180, '\u{0626}'),
    (7425998456404, '\u{06C2}'),
    (7499012900436, '\u{06D3}'),
    (7511897802324, '\u{06C0}'),
    (10067403344188, '\u{0929}'),
    (10101763082556, '\u{0931}'),
    (10114647984444, '\u{0934}'),
    (10750303144382, '\u{09CB}'),
    (10750303144407, '\u{09CC}'),
    (12399570586430, '\u{0B4B}'),
    (12399570586454, '\u{0B48}'),
    (12399570586455, '\u{0B4C}'),
    (12721693133783, '\u{0B94}'),
    (12945031433150, '\u{0BCA}'),
    (12945031433175, '\u{0BCC}'),
    (12949326400446, '\u{0BCB}'),
    (13494787247190, '\u{0C48}'),
    (14014478290133, '\u{0CC0}'),
    (14044543061186, '\u{0CCA}'),
    (14044543061205, '\u{0CC7}'),
    (14044543061206, '\u{0CC8}'),
    (14061722930389, '\u{0CCB}'),
    (14594298875198, '\u{0D4A}'),
    (14594298875223, '\u{0D4C}'),
    (14598593842494, '\u{0D4B}'),
    (15225659067850, '\u{0DDA}'),
    (15225659067855, '\u{0DDC}'),
    (15225659067871, '\u{0DDE}'),
    (15238543969738, '\u{0DDD}'),
    (16978005725042, '\u{0F73}'),
    (16978005725044, '\u{0F75}'),
    (16978005725056, '\u{0F81}'),
    (17751099838510, '\u{1026}'),
    (29708288793397, '\u{1B06}'),
    (29716878727989, '\u{1B08}'),
    (29725468662581, '\u{1B0A}'),
    (29734058597173, '\u{1B0C}'),
    (29742648531765, '\u{1B0E}'),
    (29759828400949, '\u{1B12}'),
    (29935922060085, '\u{1B3B}'),
    (29944511994677, '\u{1B3D}'),
    (29953101929269, '\u{1B40}'),
    (29957396896565, '\u{1B41}'),
    (29970281798453, '\u{1B43}'),
    (33217277068036, '\u{1E38}'),
    (33221572035332, '\u{1E39}'),
    (33371895890692, '\u{1E5C}'),
    (33376190857988, '\u{1E5D}'),
    (33406255629063, '\u{1E68}'),
    (33410550596359, '\u{1E69}'),
    (33672543601410, '\u{1EAC}'),
    (33672543601414, '\u{1EB6}'),
    (33676838568706, '\u{1EAD}'),
    (33676838568710, '\u{1EB7}'),
    (33775622816514, '\u{1EC6}'),
    (33779917783810, '\u{1EC7}'),
    (33861522162434, '\u{1ED8}'),
    (33865817129730, '\u{1ED9}'),
    (34084860461824, '\u{1F02}'),
    (34084860461825, '\u{1F04}'),
    (34084860461890, '\u{1F06}'),
    (34084860461893, '\u{1F80}'),
    (34089155429120, '\u{1F03}'),
    (34089155429121, '\u{1F05}'),
    (34089155429186, '\u{1F07}'),
    (34089155429189, '\u{1F81}'),
    (34093450396485, '\u{1F82}'),
    (34097745363781, '\u{1F83}'),
    (34102040331077, '\u{1F84}'),
    (34106335298373, '\u{1F85}'),
    (34110630265669, '\u{1F86}'),
    (34114925232965, '\u{1F87}'),
    (34119220200192, '\u{1F0A}'),
    (34119220200193, '\u{1F0C}'),
    (34119220200258, '\u{1F0E}'),
    (34119220200261, '\u{1F88}'),
    (34123515167488, '\u{1F0B}'),
    (34123515167489, '\u{1F0D}'),
    (34123515167554, '\u{1F0F}'),
    (34123515167557, '\u{1F89}'),
    (34127810134853, '\u{1F8A}'),
    (34132105102149, '\u{1F8B}'),
    (34136400069445, '\u{1F8C}'),
    (34140695036741, '\u{1F8D}'),
    (34144990004037, '\u{1F8E}'),
    (34149284971333, '\u{1F8F}'),
    (34153579938560, '\u{1F12}'),
    (34153579938561, '\u{1F14}'),
    (34157874905856, '\u{1F13}'),
    (34157874905857, '\u{1F15}'),
    (34187939676928, '\u{1F1A}'),
    (34187939676929, '\u{1F1C}'),
    (34192234644224, '\u{1F1B}'),
    (34192234644225, '\u{1F1D}'),
    (34222299415296, '\u{1F22}'),
    (34222299415297, '\u{1F24}'),
    (34222299415362, '\u{1F26}'),
    (34222299415365, '\u{1F90}'),
    (34226594382592, '\u{1F23}'),
    (34226594382593, '\u{1F25}'),
    (34226594382658, '\u{1F27}'),
    (34226594382661, '\u{1F91}'),
    (34230889349957, '\u{1F92}'),
    (34235184317253, '\u{1F93}'),
    (34239479284549, '\u{1F94}'),
    (34243774251845, '\u{1F95}'),
    (34248069219141, '\u{1F96}'),
    (34252364186437, '\u{1F97}'),
    (34256659153664, '\u{1F2A}'),
    (34256659153665, '\u{1F2C}'),
    (34256659153730, '\u{1F2E}'),
    (34256659153733, '\u{1F98}'),
    (34260954120960, '\u{1F2B}'),
    (34260954120961, '\u{1F2D}'),
    (34260954121026, '\u{1F2F}'),
    (34260954121029, '\u{1F99}'),
    (34265249088325, '\u{1F9A}'),
    (34269544055621, '\u{1F9B}'),
    (34273839022917, '\u{1F9C}'),
    (34278133990213, '\u{1F9D}'),
    (34282428957509, '\u{1F9E}'),
    (34286723924805, '\u{1F9F}'),
    (34291018892032, '\u{1F32}'),
    (34291018892033, '\u{1F34}'),
    (34291018892098, '\u{1F36}'),
    (34295313859328, '\u{1F33}'),
    (34295313859329, '\u{1F35}'),
    (34295313859394, '\u{1F37}'),
    (34325378630400, '\u{1F3A}'),
    (34325378630401, '\u{1F3C}'),
    (34325378630466, '\u{1F3E}'),
    (34329673597696, '\u{1F3B}'),
    (34329673597697, '\u{1F3D}'),
    (34329673597762, '\u{1F3F}'),
    (34359738368768, '\u{1F42}'),
    (34359738368769, '\u{1F44}'),
    (34364033336064, '\u{1F43}'),
    (34364033336065, '\u{1F45}'),
    (34394098107136, '\u{1F4A}'),
    (34394098107137, '\u{1F4C}'),
    (34398393074432, '\u{1F4B}'),
    (34398393074433, '\u{1F4D}'),
    (34428457845504, '\u{1F52}'),
    (34428457845505, '\u{1F54}'),
    (34428457845570, '\u{1F56}'),
    (34432752812800, '\u{1F53}'),
    (34432752812801, '\u{1F55}'),
    (34432752812866, '\u{1F57}'),
    (34467112551168, '\u{1F5B}'),
    (34467112551169, '\u{1F5D}'),
    (34467112551234, '\u{1F5F}'),
    (34497177322240, '\u{1F62}'),
    (34497177322241, '\u{1F64}'),
    (34497177322306, '\u{1F66}'),
    (34497177322309, '\u{1FA0}'),
    (34501472289536, '\u{1F63}'),
    (34501472289537, '\u{1F65}'),
    (34501472289602, '\u{1F67}'),
    (34501472289605, '\u{1FA1}'),
    (34505767256901, '\u{1FA2}'),
    (34510062224197, '\u{1FA3}'),
    (34514357191493, '\u{1FA4}'),
    (34518652158789, '\u{1FA5}'),
    (34522947126085, '\u{1FA6}'),
    (34527242093381, '\u{1FA7}'),
    (34531537060608, '\u{1F6A}'),
    (34531537060609, '\u{1F6C}'),
    (34531537060674, '\u{1F6E}'),
    (34531537060677, '\u{1FA8}'),
    (34535832027904, '\u{1F6B}'),
    (34535832027905, '\u{1F6D}'),
    (34535832027970, '\u{1F6F}'),
    (34535832027973, '\u{1FA9}'),
    (34540126995269, '\u{1FAA}'),
    (34544421962565, '\u{1FAB}'),
    (34548716929861, '\u{1FAC}'),
    (34553011897157, '\u{1FAD}'),
    (34557306864453, '\u{1FAE}'),
    (34561601831749, '\u{1FAF}'),
    (34565896799045, '\u{1FB2}'),
    (34583076668229, '\u{1FC2}'),
    (34617436406597, '\u{1FF2}'),
    (34866544509765, '\u{1FB7}'),
    (34905199215360, '\u{1FCD}'),
    (34905199215361, '\u{1FCE}'),
    (34905199215426, '\u{1FCF}'),
    (34935263986501, '\u{1FC7}'),
    (35141422416709, '\u{1FF7}'),
    (35175782155008, '\u{1FDD}'),
    (35175782155009, '\u{1FDE}'),
    (35175782155074, '\u{1FDF}'),
    (36902359008056, '\u{219A}'),
    (36910948942648, '\u{219B}'),
    (36919538877240, '\u{21AE}'),
    (37177236915000, '\u{21CD}'),
    (37185826849592, '\u{21CF}'),
    (37194416784184, '\u{21CE}'),
    (37396280247096, '\u{2204}'),
    (37417755083576, '\u{2209}'),
    (37430639985464, '\u{220C}'),
    (37533719200568, '\u{2224}'),
    (37542309135160, '\u{2226}'),
    (37641093382968, '\u{2241}'),
    (37671158154040, '\u{2244}'),
    (37679748088632, '\u{2247}'),
    (37692632990520, '\u{2249}'),
    (37714107827000, '\u{226D}'),
    (37800007172920, '\u{2262}'),
    (37812892074808, '\u{2270}'),
    (37817187042104, '\u{2271}'),
    (37873021616952, '\u{2274}'),
    (37877316584248, '\u{2275}'),
    (37890201486136, '\u{2278}'),
    (37894496453432, '\u{2279}'),
    (37907381355320, '\u{2280}'),
    (37911676322616, '\u{2281}'),
    (37915971289912, '\u{22E0}'),
    (37920266257208, '\u{22E1}'),
    (37941741093688, '\u{2284}'),
    (37946036060984, '\u{2285}'),
    (37958920962872, '\u{2288}'),
    (37963215930168, '\u{2289}'),
    (38006165603128, '\u{22E2}'),
    (38010460570424, '\u{22E3}'),
    (38079180047160, '\u{22AC}'),
    (38104949850936, '\u{22AD}'),
    (38109244818232, '\u{22AE}'),
    (38117834752824, '\u{22AF}'),
    (38147899523896, '\u{22EA}'),
    (38152194491192, '\u{22EB}'),
    (38156489458488, '\u{22EC}'),
    (38160784425784, '\u{22ED}'),
    (53077205856409, '\u{3094}'),
    (53098680692889, '\u{304C}'),
    (53107270627481, '\u{304E}'),
    (53115860562073, '\u{3050}'),
    (53124450496665, '\u{3052}'),
    (53133040431257, '\u{3054}'),
    (53141630365849, '\u{3056}'),
    (53150220300441, '\u{3058}'),
    (53158810235033, '\u{305A}'),
    (53167400169625, '\u{305C}'),
    (53175990104217, '\u{305E}'),
    (53184580038809, '\u{3060}'),
    (53193169973401, '\u{3062}'),
    (53206054875289, '\u{3065}'),
    (53214644809881, '\u{3067}'),
    (53223234744473, '\u{3069}'),
    (53253299515545, '\u{3070}'),
    (53253299515546, '\u{3071}'),
    (53266184417433, '\u{3073}'),
    (53266184417434, '\u{3074}'),
    (53279069319321, '\u{3076}'),
    (53279069319322, '\u{3077}'),
    (53291954221209, '\u{3079}'),
    (53291954221210, '\u{307A}'),
    (53304839123097, '\u{307C}'),
    (53304839123098, '\u{307D}'),
    (53450868011161, '\u{309E}'),
    (53489522716825, '\u{30F4}'),
    (53510997553305, '\u{30AC}'),
    (53519587487897, '\u{30AE}'),
    (53528177422489, '\u{30B0}'),
    (53536767357081, '\u{30B2}'),
    (53545357291673, '\u{30B4}'),
    (53553947226265, '\u{30B6}'),
    (53562537160857, '\u{30B8}'),
    (53571127095449, '\u{30BA}'),
    (53579717030041, '\u{30BC}'),
    (53588306964633, '\u{30BE}'),
    (53596896899225, '\u{30C0}'),
    (53605486833817, '\u{30C2}'),
    (53618371735705, '\u{30C5}'),
    (53626961670297, '\u{30C7}'),
    (53635551604889, '\u{30C9}'),
    (53665616375961, '\u{30D0}'),
    (53665616375962, '\u{30D1}'),
    (53678501277849, '\u{30D3}'),
    (53678501277850, '\u{30D4}'),
    (53691386179737, '\u{30D6}'),
    (53691386179738, '\u{30D7}'),
    (53704271081625, '\u{30D9}'),
    (53704271081626, '\u{30DA}'),
    (53717155983513, '\u{30DC}'),
    (53717155983514, '\u{30DD}'),
    (53803055329433, '\u{30F7}'),
    (53807350296729, '\u{30F8}'),
    (53811645264025, '\u{30F9}'),
    (53815940231321, '\u{30FA}'),
    (53863184871577, '\u{30FE}'),
    (287874477982471, '\u{105C9}'),
    (287908837720839, '\u{105E4}'),
    (299724292821178, '\u{1109A}'),
    (299732882755770, '\u{1109C}'),
    (299775832428730, '\u{110AB}'),
    (300377127850279, '\u{1112E}'),
    (300381422817575, '\u{1112F}'),
    (302670640386878, '\u{1134B}'),
    (302670640386903, '\u{1134C}'),
    (302924043457481, '\u{11383}'),
    (302932633392059, '\u{11385}'),
    (302962698163138, '\u{1138E}'),
    (302984172999625, '\u{11391}'),
    (303198921364408, '\u{113C7}'),
    (303198921364418, '\u{113C5}'),
    (303198921364425, '\u{113C8}'),
    (304259778286768, '\u{114BC}'),
    (304259778286778, '\u{114BB}'),
    (304259778286781, '\u{114BE}'),
    (305354994947503, '\u{115BA}'),
    (305359289914799, '\u{115BB}'),
    (309190400743728, '\u{11938}'),
    (388256453714206, '\u{16121}'),
    (388256453714207, '\u{16123}'),
    (388256453714208, '\u{16125}'),
    (388256453714217, '\u{16122}'),
    (388269338616095, '\u{16126}'),
    (388269338616096, '\u{16128}'),
    (388273633583391, '\u{16127}'),
    (388303698354463, '\u{16124}'),
    (401746945994087, '\u{16D69}'),
    (401764125863271, '\u{16D68}'),
    (401772715797863, '\u{16D6A}'),
];
