/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lrc extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "أرمأنی";
        final String metaValue_bn = "بأنگالی";
        final String metaValue_ka = "گورجی";
        final String metaValue_el = "یوٙنانی";
        final String metaValue_gu = "گوجأراتی";
        final String metaValue_he = "عئبری";
        final String metaValue_ja = "جاپوٙنی";
        final String metaValue_km = "خئمئر";
        final String metaValue_ko = "کورئ یی";
        final String metaValue_la = "لاتین";
        final String metaValue_ml = "مالایام";
        final String metaValue_mn = "موغولی";
        final String metaValue_or = "ئوریا";
        final String metaValue_ta = "تامیل";
        final String metaValue_te = "تئلئگو";
        final String metaValue_th = "تایلأندی";
        final String metaValue_bo = "تأبأتی";
        final Object[][] data = new Object[][] {
            { "001", "دونیا" },
            { "002", "ئفریقا" },
            { "003", "ئمریکا شومالی" },
            { "005", "ئمریکا ھارگە" },
            { "009", "ھوم پئڤأند جأھوٙن آڤ" },
            { "013", "مینجا ئمریکا" },
            { "019", "ئمریکا" },
            { "021", "ئمریکا ڤارو" },
            { "029", "کارائیب" },
            { "142", "آسیا" },
            { "150", "ئوروٙپا" },
            { "419", "ئمریکا لاتین" },
            { "BR", "بئرئزیل" },
            { "CN", "چین" },
            { "DE", "آلمان" },
            { "FR", "فأرانسە" },
            { "GB", "بیریتانیا گأپ" },
            { "IN", "ھئن" },
            { "IT", "ئیتالیا" },
            { "JP", "جاپوٙن" },
            { "RU", "روٙسیە" },
            { "US", "ڤولاتیا یأکاگئرتە" },
            { "ZZ", "راساگە نادیار" },
            { "ab", "آذأربایئجانی" },
            { "af", "آفریکانس" },
            { "ak", "آکان" },
            { "am", "أمھأری" },
            { "ar", "أرأڤی" },
            { "as", "آسامی" },
            { "az", "آذأربایئجانی ھارگە" },
            { "ba", "باشکیری" },
            { "be", "بئلاروٙسی" },
            { "bg", "بولغاری" },
            { "bm", "بامبارا" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "بئرئتون" },
            { "bs", "بوسنیایی" },
            { "ca", "کاتالان" },
            { "ce", "چئچئنی" },
            { "co", "کوریسکان" },
            { "cv", "چواشی" },
            { "cy", "ڤئلزی" },
            { "da", "دانمارکی" },
            { "de", "آلمانی" },
            { "dz", "زوٙنگخا" },
            { "ee", "ئڤئ" },
            { "el", metaValue_el },
            { "en", "ئینگیلیسی" },
            { "eo", "ئسپئرانتو" },
            { "es", "ئسپانیایی" },
            { "et", "ئستونیایی" },
            { "eu", "باسکی" },
            { "fa", "فارسی" },
            { "fi", "فأنلاندی" },
            { "fj", "فیجی" },
            { "fo", "فاروٙسی" },
            { "fr", "فآرانسئ ئی" },
            { "fy", "فئریسی أفتونئشین" },
            { "ga", "ئیرلأندی" },
            { "gl", "گالیسی" },
            { "gn", "گوٙآرانی" },
            { "gu", metaValue_gu },
            { "gv", "مانکس" },
            { "ha", "ھائوسا" },
            { "he", metaValue_he },
            { "hi", "ھئنی" },
            { "hr", "کوروڤاتی" },
            { "ht", "ھاییتی" },
            { "hu", "مأجاری" },
            { "hy", metaValue_hy },
            { "id", "أندونئزیایی" },
            { "ig", "ئیگبو" },
            { "ii", "سی چوان یی" },
            { "is", "ئیسلأندی" },
            { "it", "ئیتالیایی" },
            { "iu", "ئینوکتیتوٙت" },
            { "ja", metaValue_ja },
            { "jv", "جاڤئ یی" },
            { "ka", metaValue_ka },
            { "ki", "کیکیوٙ" },
            { "kk", "قأزاق" },
            { "kl", "کالالیسوٙت" },
            { "km", metaValue_km },
            { "kn", "کاناد" },
            { "ko", metaValue_ko },
            { "ks", "کأشمیری" },
            { "ku", "کوردی کورمانجی" },
            { "kw", "کورنیش" },
            { "ky", "قئرقیزی" },
            { "la", metaValue_la },
            { "lb", "لوٙکزامبوٙرگی" },
            { "lg", "گاندا" },
            { "ln", "لینگالا" },
            { "lo", "لاو" },
            { "lt", "لیتوڤانیایی" },
            { "lu", "لوٙبا کاتانگا" },
            { "lv", "لاتوڤیایی" },
            { "mg", "مالاگاشی" },
            { "mi", "مائوری" },
            { "mk", "مأقدوٙنی" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "مأراتی" },
            { "ms", "مالایی" },
            { "mt", "مالتی" },
            { "my", "بئرمئ یی" },
            { "nb", "نورڤئجی بوٙکمال" },
            { "nd", "نئدئبئلئ شومالی" },
            { "ne", "نئپالی" },
            { "nl", "ھولأندی" },
            { "nn", "نورڤئجی نینورسک" },
            { "om", "ئوروموٙ" },
            { "or", metaValue_or },
            { "pa", "پأنجابی" },
            { "pl", "لأھئستانی" },
            { "ps", "پأشتوٙ" },
            { "pt", "پورتئغالی" },
            { "qu", "کوچوٙا" },
            { "rm", "رومانش" },
            { "rn", "راندی" },
            { "ro", "رومانیایی" },
            { "ru", "روٙسی" },
            { "rw", "کینیاروآندا" },
            { "sa", "سانسکئریت" },
            { "sd", "سئندی" },
            { "se", "سامی شومالی" },
            { "sg", "سانگو" },
            { "si", "سینھالا" },
            { "sk", "ئسلوڤاکی" },
            { "sl", "ئسلوڤئنیایی" },
            { "sn", "شونا" },
            { "so", "سوٙمالی" },
            { "sq", "آلبانی" },
            { "sr", "سئربی" },
            { "su", "سوٙدانی" },
            { "sv", "سوٙئدی" },
            { "sw", "سأڤاحیلی" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجیکی" },
            { "th", metaValue_th },
            { "ti", "تیگرینیا" },
            { "tk", "تورکأمأنی" },
            { "to", "توٙنگان" },
            { "tr", "تورکی" },
            { "tt", "تاتار" },
            { "ug", "ئویغوٙر" },
            { "uk", "ئوکراینی" },
            { "ur", "ئوردوٙ" },
            { "uz", "ئوزبأکی" },
            { "vi", "ڤییئتنامی" },
            { "wo", "ڤولوف" },
            { "xh", "خوٙسا" },
            { "yo", "یوروبا" },
            { "zh", "چینی" },
            { "zu", "زولو" },
            { "agq", "آقئم" },
            { "arn", "ماپوٙچئ" },
            { "asa", "آسوٙ" },
            { "bem", "بیما" },
            { "bez", "بئنا" },
            { "bgn", "بألوٙچی أقتوٙنئشین" },
            { "brx", "بودو" },
            { "cgg", "چیگا" },
            { "chr", "چوروٙکی" },
            { "ckb", "کوردی سوٙرانی" },
            { "dav", "تایتا" },
            { "dje", "زارما" },
            { "dsb", "سوربی ھاری" },
            { "dua", "دوٙالا" },
            { "dyo", "جولا فوٙنیی" },
            { "ebu", "ئمبو" },
            { "fil", "فیلیپینی" },
            { "gag", "گاگائوز" },
            { "gsw", "آلمانی سوٙئیسی" },
            { "guz", "گوٙسی" },
            { "haw", "ھاڤایی" },
            { "hsb", "سوربی ڤارو" },
            { "jgo", "نئگوٙمبا" },
            { "jmc", "ماچامئ" },
            { "kab", "کابیلئ" },
            { "kam", "کامبا" },
            { "kde", "ماکوٙندئ" },
            { "kea", "کاباردینو" },
            { "khq", "کی یورا چینی" },
            { "kln", "کالئجین" },
            { "koi", "کومی پئرمیاک" },
            { "kok", "کوٙنکانی" },
            { "ksb", "شامبالا" },
            { "ksf", "بافیا" },
            { "lag", "لانگی" },
            { "lkt", "لاکوٙتا" },
            { "lrc", "لۊری شومالی" },
            { "luo", "لوٙ" },
            { "luy", "لوٙئیا" },
            { "mas", "ماسایی" },
            { "mer", "مئرو" },
            { "mfe", "موٙریسی" },
            { "mgh", "ماخوڤا میتو" },
            { "mgo", "مئتاٛ" },
            { "moh", "موٙھاڤک" },
            { "mua", "موٙندانگ" },
            { "mzn", "مازأندأرانی" },
            { "naq", "ناما" },
            { "nds", "آلمانی ھاری" },
            { "nmg", "کئڤاسیوٙ" },
            { "nqo", "نئکوٙ" },
            { "nus", "نیوٙئر" },
            { "nyn", "نیان کوٙلئ" },
            { "quc", "کیچی" },
            { "rof", "رومبو" },
            { "rwk", "رئڤا" },
            { "saq", "سامبوٙروٙ" },
            { "sbp", "سانگوٙ" },
            { "sdh", "کوردی ھارگە" },
            { "seh", "سئنا" },
            { "ses", "کیارابورو سئنی" },
            { "shi", "تاچئلھیت" },
            { "sma", "سامی ھارگە" },
            { "smj", "لۉلئ سامی" },
            { "smn", "ئیناری سامی" },
            { "sms", "ئسکولت سامی" },
            { "teo", "تئسو" },
            { "twq", "تاساڤاق" },
            { "tzm", "تامازیغ مینجایی" },
            { "und", "زوٙن نادیار" },
            { "vai", "ڤای" },
            { "vun", "ڤوٙنجوٙ" },
            { "wbp", "ڤارلپیری" },
            { "xog", "سوٙگا" },
            { "zgh", "تامازیغ مأراکئشی" },
            { "zxx", "بی نئشوٙ" },
            { "Arab", "عأرأڤی" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "بوٙپوٙ" },
            { "Brai", "بئرئیل" },
            { "Cyrl", "سیریلیک" },
            { "Deva", "دیڤانگأری" },
            { "Ethi", "ئتوٙیوٙپیایی" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "گوٙروٙمخی" },
            { "Hang", "ھانگوٙل" },
            { "Hani", "ھانی" },
            { "Hans", "سادە بیە" },
            { "Hant", "سونأتی" },
            { "Hebr", metaValue_he },
            { "Hira", "ھیراگانا" },
            { "Jpan", metaValue_ja },
            { "Kana", "کاتانگا" },
            { "Khmr", metaValue_km },
            { "Knda", "کانادا" },
            { "Kore", metaValue_ko },
            { "Laoo", "لائو" },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mymr", "میانمار" },
            { "Orya", metaValue_or },
            { "Sinh", "سیناھالا" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "تانا" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zsym", "نئشوٙنە یا" },
            { "Zxxx", "نیسئسە نأبیە" },
            { "Zyyy", "جائوفتاأ" },
            { "Zzzz", "نیسئسە نادیار" },
            { "de_AT", "آلمانی ئوتریشی" },
            { "de_CH", "آلمانی سوٙییسی" },
            { "en_AU", "ئینگیلیسی ئوستارالیایی" },
            { "en_CA", "ئینگیلیسی کانادایی" },
            { "en_GB", "ئینگیلیسی بئریتانیایی" },
            { "en_US", "ئینگیلیسی ئمریکایی" },
            { "es_ES", "ئسپانیایی ئوروٙپا" },
            { "es_MX", "ئسپانیایی مئکزیک" },
            { "fr_CA", "فآرانسئ ئی کانادا" },
            { "fr_CH", "فآرانسئ ئی سوٙییس" },
            { "nl_BE", "فئلاماندی" },
            { "pt_BR", "پورتئغالی بئرئزیل" },
            { "pt_PT", "پورتئغالی ئوروٙپایی" },
            { "ro_MD", "رومانیایی مولداڤی" },
            { "sw_CD", "سأڤاحیلی کونگو" },
            { "ar_001", "عروی مدرن" },
            { "es_419", "ئسپانیایی ئمریکا لاتین" },
            { "nds_NL", "آلمانی ھارگە جا" },
            { "az_Arab", "آذأری ھارگە" },
            { "zh_Hans", "چینی سادە بیە" },
            { "zh_Hant", "چینی سونأتی" },
            { "type.nu.arab", "أدأدیا عأرأڤی" },
            { "type.nu.latn", "عأدأدیا لاتین" },
            { "type.co.standard", "کوٙلاتی ئستاندارد" },
            { "type.ca.gregorian", "تأقڤیم گأرئگوٙری" },
        };
        return data;
    }
}
