//===-- Floating point math functions ---------------------------*- C++ -*-===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIBC_SHARED_MATH_H
#define LLVM_LIBC_SHARED_MATH_H

#include "libc_common.h"

#include "math/acos.h"
#include "math/acosf.h"
#include "math/acosf16.h"
#include "math/acoshf.h"
#include "math/acoshf16.h"
#include "math/acospif16.h"
#include "math/asin.h"
#include "math/asinf.h"
#include "math/asinf16.h"
#include "math/asinhf.h"
#include "math/asinhf16.h"
#include "math/atan.h"
#include "math/atan2.h"
#include "math/atan2f.h"
#include "math/atan2f128.h"
#include "math/atanf.h"
#include "math/atanf16.h"
#include "math/atanhf.h"
#include "math/atanhf16.h"
#include "math/cbrt.h"
#include "math/cbrtf.h"
#include "math/cos.h"
#include "math/cosf.h"
#include "math/cosf16.h"
#include "math/coshf.h"
#include "math/coshf16.h"
#include "math/cospif.h"
#include "math/cospif16.h"
#include "math/dsqrtl.h"
#include "math/erff.h"
#include "math/exp.h"
#include "math/exp10.h"
#include "math/exp10f.h"
#include "math/exp10f16.h"
#include "math/exp10m1f.h"
#include "math/exp10m1f16.h"
#include "math/exp2.h"
#include "math/exp2f.h"
#include "math/exp2f16.h"
#include "math/exp2m1f.h"
#include "math/exp2m1f16.h"
#include "math/expf.h"
#include "math/expf16.h"
#include "math/expm1.h"
#include "math/expm1f.h"
#include "math/expm1f16.h"
#include "math/frexpf.h"
#include "math/frexpf128.h"
#include "math/frexpf16.h"
#include "math/ilogbf16.h"
#include "math/ldexpf.h"
#include "math/ldexpf128.h"
#include "math/ldexpf16.h"
#include "math/log.h"
#include "math/rsqrtf.h"
#include "math/rsqrtf16.h"
#include "math/sin.h"

#endif // LLVM_LIBC_SHARED_MATH_H
