// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The specification for the tool. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tool-use.html">Call a tool with the Converse API</a> in the Amazon Bedrock User Guide.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ToolSpecification {
    /// <p>The name for the tool.</p>
    pub name: ::std::string::String,
    /// <p>The description for the tool.</p>
    pub description: ::std::option::Option<::std::string::String>,
    /// <p>The input schema for the tool in JSON format.</p>
    pub input_schema: ::std::option::Option<crate::types::ToolInputSchema>,
}
impl ToolSpecification {
    /// <p>The name for the tool.</p>
    pub fn name(&self) -> &str {
        use std::ops::Deref;
        self.name.deref()
    }
    /// <p>The description for the tool.</p>
    pub fn description(&self) -> ::std::option::Option<&str> {
        self.description.as_deref()
    }
    /// <p>The input schema for the tool in JSON format.</p>
    pub fn input_schema(&self) -> ::std::option::Option<&crate::types::ToolInputSchema> {
        self.input_schema.as_ref()
    }
}
impl ToolSpecification {
    /// Creates a new builder-style object to manufacture [`ToolSpecification`](crate::types::ToolSpecification).
    pub fn builder() -> crate::types::builders::ToolSpecificationBuilder {
        crate::types::builders::ToolSpecificationBuilder::default()
    }
}

/// A builder for [`ToolSpecification`](crate::types::ToolSpecification).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ToolSpecificationBuilder {
    pub(crate) name: ::std::option::Option<::std::string::String>,
    pub(crate) description: ::std::option::Option<::std::string::String>,
    pub(crate) input_schema: ::std::option::Option<crate::types::ToolInputSchema>,
}
impl ToolSpecificationBuilder {
    /// <p>The name for the tool.</p>
    /// This field is required.
    pub fn name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The name for the tool.</p>
    pub fn set_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.name = input;
        self
    }
    /// <p>The name for the tool.</p>
    pub fn get_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.name
    }
    /// <p>The description for the tool.</p>
    pub fn description(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.description = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The description for the tool.</p>
    pub fn set_description(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.description = input;
        self
    }
    /// <p>The description for the tool.</p>
    pub fn get_description(&self) -> &::std::option::Option<::std::string::String> {
        &self.description
    }
    /// <p>The input schema for the tool in JSON format.</p>
    /// This field is required.
    pub fn input_schema(mut self, input: crate::types::ToolInputSchema) -> Self {
        self.input_schema = ::std::option::Option::Some(input);
        self
    }
    /// <p>The input schema for the tool in JSON format.</p>
    pub fn set_input_schema(mut self, input: ::std::option::Option<crate::types::ToolInputSchema>) -> Self {
        self.input_schema = input;
        self
    }
    /// <p>The input schema for the tool in JSON format.</p>
    pub fn get_input_schema(&self) -> &::std::option::Option<crate::types::ToolInputSchema> {
        &self.input_schema
    }
    /// Consumes the builder and constructs a [`ToolSpecification`](crate::types::ToolSpecification).
    /// This method will fail if any of the following fields are not set:
    /// - [`name`](crate::types::builders::ToolSpecificationBuilder::name)
    pub fn build(self) -> ::std::result::Result<crate::types::ToolSpecification, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ToolSpecification {
            name: self.name.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "name",
                    "name was not specified but it is required when building ToolSpecification",
                )
            })?,
            description: self.description,
            input_schema: self.input_schema,
        })
    }
}
