/*
 * DO NOT EDIT THIS FILE. Generated by checkmk.
 * Edit the original source file "../../libdrgn/tests/bitmap.c.in" instead.
 */

#include <check.h>

#line 1 "../../libdrgn/tests/bitmap.c.in"
// Copyright (c) Meta Platforms, Inc. and affiliates.
// SPDX-License-Identifier: LGPL-2.1-or-later

#include "test_util.h"
#include "../bitmap.h"
#include "../cleanup.h"


START_TEST(bitmap_set_bit)
{
#line 11
{
	_cleanup_free_ unsigned long *bitmap = drgn_bitmap_create(9);
	ck_assert_ptr_nonnull(bitmap);

	drgn_bitmap_set_bit(bitmap, 0);
	drgn_bitmap_set_bit(bitmap, 1);
	drgn_bitmap_set_bit(bitmap, 2);
	drgn_bitmap_set_bit(bitmap, 3);
	drgn_bitmap_set_bit(bitmap, 5);
	drgn_bitmap_set_bit(bitmap, 8);

	ck_assert(drgn_bitmap_test_bit(bitmap, 0));
	ck_assert(drgn_bitmap_test_bit(bitmap, 1));
	ck_assert(drgn_bitmap_test_bit(bitmap, 2));
	ck_assert(drgn_bitmap_test_bit(bitmap, 3));
	ck_assert(!drgn_bitmap_test_bit(bitmap, 4));
	ck_assert(drgn_bitmap_test_bit(bitmap, 5));
	ck_assert(!drgn_bitmap_test_bit(bitmap, 6));
	ck_assert(!drgn_bitmap_test_bit(bitmap, 7));
	ck_assert(drgn_bitmap_test_bit(bitmap, 8));
}

}
END_TEST

START_TEST(bitmap_clear_bit)
{
#line 34
{
	_cleanup_free_ unsigned long *bitmap = drgn_bitmap_create(9);
	ck_assert_ptr_nonnull(bitmap);

	bitmap[0] = ~0UL;
	drgn_bitmap_clear_bit(bitmap, 4);
	drgn_bitmap_clear_bit(bitmap, 6);
	drgn_bitmap_clear_bit(bitmap, 7);

	ck_assert(drgn_bitmap_test_bit(bitmap, 0));
	ck_assert(drgn_bitmap_test_bit(bitmap, 1));
	ck_assert(drgn_bitmap_test_bit(bitmap, 2));
	ck_assert(drgn_bitmap_test_bit(bitmap, 3));
	ck_assert(!drgn_bitmap_test_bit(bitmap, 4));
	ck_assert(drgn_bitmap_test_bit(bitmap, 5));
	ck_assert(!drgn_bitmap_test_bit(bitmap, 6));
	ck_assert(!drgn_bitmap_test_bit(bitmap, 7));
	ck_assert(drgn_bitmap_test_bit(bitmap, 8));
}
}
END_TEST

int main(void)
{
    Suite *s1 = suite_create("bitmap");
    TCase *tc1_1 = tcase_create("bitmap");
    SRunner *sr = srunner_create(s1);
    int nf;

    suite_add_tcase(s1, tc1_1);
    tcase_add_test(tc1_1, bitmap_set_bit);
    tcase_add_test(tc1_1, bitmap_clear_bit);

    srunner_run_all(sr, CK_ENV);
    nf = srunner_ntests_failed(sr);
    srunner_free(sr);

    return nf == 0 ? 0 : 1;
}
