# coding=utf-8
from color_darker import Darker
from .test_inkex_extensions import ColorBaseCase


class ColorDarkerTest(ColorBaseCase):
    effect_class = Darker
    color_tests = [
        ("none", "none"),
        ((0, 0, 0), "#000000"),
        ((255, 255, 255), "#e6e6e6"),
        ((192, 192, 192), "#adadad"),
        ((128, 128, 128), "#737373"),
        ((128, 0, 0), "#730000"),
        ((255, 0, 0), "#e60000"),
        ((128, 128, 0), "#737300"),
        ((255, 255, 0), "#e6e600"),
        ((0, 128, 0), "#007300"),
        ((0, 255, 0), "#00e600"),
        ((0, 128, 128), "#007373"),
        ((0, 255, 255), "#00e6e6"),
        ((0, 0, 128), "#000073"),
        ((0, 0, 255), "#0000e6"),
        ((128, 0, 128), "#730073"),
        ((255, 0, 255), "#e600e6"),
        ("hsl(25, 14, 128)", "hsl(25, 14, 115)"),
        ("red", "#e60000"),
    ]
