/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.java;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.ClassFileViewProvider;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.util.SlowOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BackendJavaClassCodeFoldingPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar,
DumbAware {
    BackendJavaClassCodeFoldingPassFactory() {
    }

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            BackendJavaClassCodeFoldingPassFactory.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BackendJavaClassCodeFoldingPassFactory.$$$reportNull$$$0(1);
        }
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, new int[]{4}, null, false, -1);
    }

    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        ClsFileImpl originalFile;
        PsiFile psiFile;
        if (file == null) {
            BackendJavaClassCodeFoldingPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            BackendJavaClassCodeFoldingPassFactory.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PsiJavaFile && Registry.is((String)"ide.java.backend.compiler.folding") && (psiFile = file.getOriginalFile()) instanceof ClsFileImpl && (originalFile = (ClsFileImpl)psiFile).getViewProvider() instanceof ClassFileViewProvider && AppMode.isRemoteDevHost())) {
            return new MyEmptyPass(file, editor);
        }
        return new MyCodeFoldingPass(editor, file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cwm/plugin/java/BackendJavaClassCodeFoldingPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingPassFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyEmptyPass
    extends TextEditorHighlightingPass {
        private MyEmptyPass(@NotNull PsiFile file, @NotNull Editor editor) {
            if (file == null) {
                MyEmptyPass.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyEmptyPass.$$$reportNull$$$0(1);
            }
            super(file.getProject(), editor.getDocument());
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            if (progress == null) {
                MyEmptyPass.$$$reportNull$$$0(2);
            }
        }

        public void doApplyInformationToEditor() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cwm/plugin/java/BackendJavaClassCodeFoldingPassFactory$MyEmptyPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class MyCodeFoldingPass
    extends EditorBoundHighlightingPass
    implements PossiblyDumbAware {
        private static final Key<Boolean> THE_FIRST_TIME = Key.create((String)"ClsSplitModeFirstFoldingPass");
        @Nullable
        private volatile Runnable myRunnable;

        MyCodeFoldingPass(@NotNull Editor editor, @NotNull PsiFile file) {
            if (editor == null) {
                MyCodeFoldingPass.$$$reportNull$$$0(0);
            }
            if (file == null) {
                MyCodeFoldingPass.$$$reportNull$$$0(1);
            }
            super(editor, file, false);
        }

        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            boolean firstTime;
            if (progress == null) {
                MyCodeFoldingPass.$$$reportNull$$$0(2);
            }
            if ((firstTime = MyCodeFoldingPass.isFirstTime(this.myFile, this.myEditor)) && this.myEditor.getFoldingModel().getAllFoldRegions().length == 0) {
                try (AccessToken ignored = MyCodeFoldingPass.runPass();){
                    this.myRunnable = CodeFoldingManager.getInstance((Project)this.myProject).updateFoldRegionsAsync(this.myEditor, true);
                }
            }
        }

        private static boolean isFirstTime(PsiFile file, Editor editor) {
            return file.getUserData(THE_FIRST_TIME) == null || editor.getUserData(THE_FIRST_TIME) == null;
        }

        private static void clearFirstTimeFlag(PsiFile file, Editor editor) {
            file.putUserData(THE_FIRST_TIME, (Object)Boolean.FALSE);
            editor.putUserData(THE_FIRST_TIME, (Object)Boolean.FALSE);
        }

        public void doApplyInformationToEditor() {
            Runnable runnable = this.myRunnable;
            if (runnable != null && MyCodeFoldingPass.isFirstTime(this.myFile, this.myEditor)) {
                try (AccessToken ignore = SlowOperations.knownIssue((String)"IDEA-333911");){
                    runnable.run();
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
                MyCodeFoldingPass.clearFirstTimeFlag(this.myFile, this.myEditor);
                this.myRunnable = null;
            }
        }

        public boolean isDumbAware() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progress";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/cwm/plugin/java/BackendJavaClassCodeFoldingPassFactory$MyCodeFoldingPass";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCollectInformation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

