/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.util.Ref;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.performancePlugin.utils.DaemonCodeAnalyzerResult;
import io.opentelemetry.api.trace.Span;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/performancePlugin/utils/DaemonCodeAnalyzerListener;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "listen", "Lcom/jetbrains/performancePlugin/utils/DaemonCodeAnalyzerResult;", "connection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "spanRef", "Lcom/intellij/openapi/util/Ref;", "Lio/opentelemetry/api/trace/Span;", "timeoutInSeconds", "", "expectedOpenedFile", "", "printFinishedAnalyzers", "", "fileEditors", "", "Lcom/intellij/openapi/fileEditor/FileEditor;", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nDaemonCodeAnalyzerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonCodeAnalyzerListener.kt\ncom/jetbrains/performancePlugin/utils/DaemonCodeAnalyzerListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,123:1\n1863#2,2:124\n14#3:126\n*S KotlinDebug\n*F\n+ 1 DaemonCodeAnalyzerListener.kt\ncom/jetbrains/performancePlugin/utils/DaemonCodeAnalyzerListener\n*L\n49#1:124,2\n16#1:126\n*E\n"})
public final class DaemonCodeAnalyzerListener {
    @NotNull
    public static final DaemonCodeAnalyzerListener INSTANCE = new DaemonCodeAnalyzerListener();
    @NotNull
    private static final Logger LOG;

    private DaemonCodeAnalyzerListener() {
    }

    @NotNull
    public final Logger getLOG() {
        return LOG;
    }

    @NotNull
    public final DaemonCodeAnalyzerResult listen(@NotNull SimpleMessageBusConnection connection, @NotNull Ref<Span> spanRef, long timeoutInSeconds, @Nullable String expectedOpenedFile) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(spanRef, (String)"spanRef");
        LOG.info("Start listening " + DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC.getDisplayName());
        DaemonCodeAnalyzerResult result = new DaemonCodeAnalyzerResult(connection, spanRef, timeoutInSeconds);
        Topic topic = DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DAEMON_EVENT_TOPIC");
        connection.subscribe(topic, (Object)new DaemonCodeAnalyzer.DaemonListener(expectedOpenedFile, result){
            final /* synthetic */ String $expectedOpenedFile;
            final /* synthetic */ DaemonCodeAnalyzerResult $result;
            {
                this.$expectedOpenedFile = $expectedOpenedFile;
                this.$result = $result;
            }

            /*
             * WARNING - void declaration
             */
            public void daemonFinished(Collection<? extends FileEditor> fileEditors) {
                Intrinsics.checkNotNullParameter(fileEditors, (String)"fileEditors");
                DaemonCodeAnalyzerListener.access$printFinishedAnalyzers(DaemonCodeAnalyzerListener.INSTANCE, fileEditors);
                if (this.$expectedOpenedFile == null) {
                    this.$result.release();
                }
                if (this.$expectedOpenedFile != null) {
                    boolean bl;
                    block6: {
                        void $this$any$iv;
                        Iterable iterable = fileEditors;
                        String string = this.$expectedOpenedFile;
                        boolean $i$f$any = false;
                        if (((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                FileEditor fileEditor = (FileEditor)element$iv;
                                boolean bl2 = false;
                                if (!Intrinsics.areEqual((Object)fileEditor.getFile().getName(), (Object)string)) continue;
                                bl = true;
                                break block6;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        this.$result.release();
                    }
                }
            }
        });
        return result;
    }

    public static /* synthetic */ DaemonCodeAnalyzerResult listen$default(DaemonCodeAnalyzerListener daemonCodeAnalyzerListener, SimpleMessageBusConnection simpleMessageBusConnection, Ref ref, long l2, String string, int n, Object object) {
        if ((n & 4) != 0) {
            l2 = 0L;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        return daemonCodeAnalyzerListener.listen(simpleMessageBusConnection, (Ref<Span>)ref, l2, string);
    }

    private final void printFinishedAnalyzers(Collection<? extends FileEditor> fileEditors) {
        try {
            Iterable $this$forEach$iv = fileEditors;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FileEditor it = (FileEditor)element$iv;
                boolean bl = false;
                LOG.info("daemonFinished for " + it.getFile().getName());
            }
        }
        catch (Throwable throwable) {
            LOG.error("printFinishedAnalyzers failed " + throwable.getMessage());
        }
    }

    public static final /* synthetic */ void access$printFinishedAnalyzers(DaemonCodeAnalyzerListener $this, Collection fileEditors) {
        $this.printFinishedAnalyzers(fileEditors);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DaemonCodeAnalyzerListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

