/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.Verifier;
import org.jdom.input.sax.BuilderErrorHandler;
import org.jdom.input.sax.DefaultSAXHandlerFactory;
import org.jdom.input.sax.SAXBuilderEngine;
import org.jdom.input.sax.SAXEngine;
import org.jdom.input.sax.SAXHandler;
import org.jdom.input.sax.SAXHandlerFactory;
import org.jdom.input.sax.XMLReaderJDOMFactory;
import org.jdom.input.sax.XMLReaders;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

@Deprecated
public final class SAXBuilder
implements SAXEngine {
    private static final SAXHandlerFactory DEFAULTSAXHANDLERFAC = new DefaultSAXHandlerFactory();
    private static final JDOMFactory DEFAULT_JDOM_FACTORY = new DefaultJDOMFactory();
    private XMLReaderJDOMFactory readerFactory;
    private SAXHandlerFactory handlerfac;
    private JDOMFactory jdomFactory = DEFAULT_JDOM_FACTORY;
    private final HashMap<String, Boolean> features = new HashMap(5);
    private final HashMap<String, Object> properties = new HashMap(5);
    private EntityResolver saxEntityResolver = null;
    private boolean expand = true;
    private boolean ignoringWhite = false;
    private boolean ignoringBoundaryWhite = false;
    private SAXEngine engine = null;

    public SAXBuilder() {
        this(XMLReaders.NONVALIDATING, null);
    }

    @Deprecated
    public SAXBuilder(boolean validate) {
        this(validate ? XMLReaders.DTDVALIDATING : XMLReaders.NONVALIDATING);
    }

    public SAXBuilder(XMLReaderJDOMFactory factory) {
        this(factory == null ? XMLReaders.NONVALIDATING : factory, null);
    }

    private SAXBuilder(XMLReaderJDOMFactory factory, SAXHandlerFactory handlerFactory) {
        this.readerFactory = factory;
        this.handlerfac = handlerFactory == null ? DEFAULTSAXHANDLERFAC : handlerFactory;
    }

    @Deprecated
    public void setFactory(JDOMFactory factory) {
        this.setJDOMFactory(factory);
    }

    public void setJDOMFactory(JDOMFactory factory) {
        this.jdomFactory = factory;
        this.engine = null;
    }

    public void setXMLReaderFactory(XMLReaderJDOMFactory rfac) {
        this.readerFactory = rfac == null ? XMLReaders.NONVALIDATING : rfac;
        this.engine = null;
    }

    public void setSAXHandlerFactory(SAXHandlerFactory factory) {
        this.handlerfac = factory == null ? DEFAULTSAXHANDLERFAC : factory;
        this.engine = null;
    }

    @Deprecated
    public boolean getValidation() {
        return this.isValidating();
    }

    @Override
    public boolean isValidating() {
        return this.readerFactory.isValidating();
    }

    @Deprecated
    public void setValidation(boolean validate) {
        this.setXMLReaderFactory(validate ? XMLReaders.DTDVALIDATING : XMLReaders.NONVALIDATING);
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.saxEntityResolver = entityResolver;
        this.engine = null;
    }

    @Override
    public boolean getIgnoringElementContentWhitespace() {
        return this.ignoringWhite;
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.ignoringWhite = ignoringWhite;
        this.engine = null;
    }

    @Override
    public boolean getIgnoringBoundaryWhitespace() {
        return this.ignoringBoundaryWhite;
    }

    public void setIgnoringBoundaryWhitespace(boolean ignoringBoundaryWhite) {
        this.ignoringBoundaryWhite = ignoringBoundaryWhite;
        this.engine = null;
    }

    @Override
    public boolean getExpandEntities() {
        return this.expand;
    }

    public void setExpandEntities(boolean expand) {
        this.expand = expand;
        this.engine = null;
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, value ? Boolean.TRUE : Boolean.FALSE);
        this.engine = null;
    }

    public void setProperty(String name, Object value) {
        this.properties.put(name, value);
        this.engine = null;
    }

    private SAXEngine buildEngine() throws JDOMException {
        SAXHandler contentHandler = this.handlerfac.createSAXHandler(this.jdomFactory);
        contentHandler.setExpandEntities(this.expand);
        contentHandler.setIgnoringElementContentWhitespace(this.ignoringWhite);
        contentHandler.setIgnoringBoundaryWhitespace(this.ignoringBoundaryWhite);
        XMLReader parser = this.readerFactory.createXMLReader();
        this.configureParser(parser, contentHandler);
        return new SAXBuilderEngine(parser, contentHandler, this.readerFactory.isValidating());
    }

    private SAXEngine getEngine() throws JDOMException {
        if (this.engine != null) {
            return this.engine;
        }
        this.engine = this.buildEngine();
        return this.engine;
    }

    private void configureParser(XMLReader parser, SAXHandler contentHandler) throws JDOMException {
        parser.setContentHandler(contentHandler);
        if (this.saxEntityResolver != null) {
            parser.setEntityResolver(this.saxEntityResolver);
        }
        parser.setDTDHandler(contentHandler);
        parser.setErrorHandler(new BuilderErrorHandler());
        boolean success = false;
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
            success = true;
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
            // empty catch block
        }
        if (!success) {
            try {
                parser.setProperty("http://xml.org/sax/handlers/LexicalHandler", contentHandler);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            SAXBuilder.internalSetProperty(parser, entry.getKey(), entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, Object> entry : this.features.entrySet()) {
            SAXBuilder.internalSetFeature(parser, entry.getKey(), (Boolean)entry.getValue(), entry.getKey());
        }
        if (!this.getExpandEntities()) {
            try {
                parser.setProperty("http://xml.org/sax/properties/declaration-handler", contentHandler);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
        }
        try {
            parser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void internalSetFeature(XMLReader parser, String feature, boolean value, String displayName) throws JDOMException {
        try {
            parser.setFeature(feature, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " feature not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " feature not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    private static void internalSetProperty(XMLReader parser, String property, Object value, String displayName) throws JDOMException {
        try {
            parser.setProperty(property, value);
        }
        catch (SAXNotSupportedException e) {
            throw new JDOMException(displayName + " property not supported for SAX driver " + parser.getClass().getName());
        }
        catch (SAXNotRecognizedException e) {
            throw new JDOMException(displayName + " property not recognized for SAX driver " + parser.getClass().getName());
        }
    }

    @Override
    public Document build(InputSource in) throws JDOMException, IOException {
        return this.getEngine().build(in);
    }

    @Override
    public Document build(InputStream in) throws JDOMException, IOException {
        return this.getEngine().build(in);
    }

    @Override
    public Document build(File file) throws JDOMException, IOException {
        return this.getEngine().build(file);
    }

    @Override
    public Document build(URL url) throws JDOMException, IOException {
        return this.getEngine().build(url);
    }

    @Override
    public Document build(InputStream in, String systemId) throws JDOMException, IOException {
        return this.getEngine().build(in, systemId);
    }

    @Override
    public Document build(Reader characterStream) throws JDOMException, IOException {
        return this.getEngine().build(characterStream);
    }

    @Override
    public Document build(Reader characterStream, String systemId) throws JDOMException, IOException {
        return this.getEngine().build(characterStream, systemId);
    }

    @Override
    public Document build(String systemId) throws JDOMException, IOException {
        if (systemId == null) {
            throw new NullPointerException("Unable to build a URI from a null systemID.");
        }
        try {
            return this.getEngine().build(systemId);
        }
        catch (IOException ioe) {
            int i;
            int len = systemId.length();
            for (i = 0; i < len && Verifier.isXMLWhitespace(systemId.charAt(i)); ++i) {
            }
            if (i < len && '<' == systemId.charAt(i)) {
                MalformedURLException mx = new MalformedURLException("SAXBuilder.build(String) expects the String to be a systemID, but in this instance it appears to be actual XML data.");
                mx.initCause(ioe);
                throw mx;
            }
            throw ioe;
        }
    }
}

