/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.ide.util.RunOnceUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.actions.GitUnshallowRepositoryAction;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitShallowRepositoryCheckKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lgit4idea/repo/GitShallowRepositoryCheck;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "suggestToUnshallow", "repository", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
public final class GitShallowRepositoryCheck
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        List<GitRepository> list = GitRepositoryManager.getInstance(project).getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        GitRepository gitRepository = (GitRepository)CollectionsKt.singleOrNull(list);
        if (gitRepository == null) {
            return Unit.INSTANCE;
        }
        GitRepository repository = gitRepository;
        RunOnceUtil.runOnceForProject((Project)project, (String)"git.unshallow", () -> GitShallowRepositoryCheck.execute$lambda$0(this, repository, project));
        return Unit.INSTANCE;
    }

    private final void suggestToUnshallow(GitRepository repository, Project project) {
        if (repository.getInfo().isShallow()) {
            GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(project);
            Intrinsics.checkNotNullExpressionValue((Object)gitFetchSupport, (String)"fetchSupport(...)");
            GitFetchSupport fetcher = gitFetchSupport;
            GitRemote remote = fetcher.getDefaultRemoteToFetch(repository);
            if (remote == null) {
                GitShallowRepositoryCheckKt.access$getLOG$p().debug("Couldn't detect remote for shallow repository");
                return;
            }
            VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)project);
            NotificationGroup notificationGroup = VcsNotifier.importantNotification();
            String string = GitBundle.message("unshallow.repository.notification.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = GitBundle.message("unshallow.repository.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            vcsNotifier.notify(notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addAction((AnAction)NotificationAction.createExpiring((String)GitBundle.message("action.Git.Unshallow.text", new Object[0]), (arg_0, arg_1) -> GitShallowRepositoryCheck.suggestToUnshallow$lambda$2(GitShallowRepositoryCheck::suggestToUnshallow$lambda$1, arg_0, arg_1))));
        }
    }

    private static final void execute$lambda$0(GitShallowRepositoryCheck this$0, GitRepository $repository, Project $project) {
        this$0.suggestToUnshallow($repository, $project);
    }

    private static final Unit suggestToUnshallow$lambda$1(AnActionEvent e, Notification notification) {
        GitUnshallowRepositoryAction gitUnshallowRepositoryAction = new GitUnshallowRepositoryAction();
        Intrinsics.checkNotNull((Object)e);
        gitUnshallowRepositoryAction.actionPerformed(e);
        return Unit.INSTANCE;
    }

    private static final void suggestToUnshallow$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

