/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.impl;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectView.impl.AbstractProjectViewPane;
import com.intellij.model.Pointer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationRequests;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItemKt;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/platform/navbar/backend/impl/ModuleNavBarItem;", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "Lcom/intellij/openapi/module/Module;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "data", "<init>", "(Lcom/intellij/openapi/module/Module;)V", "createPointer", "dereference", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "getIcon", "Ljavax/swing/Icon;", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "weight", "", "intellij.platform.navbar.backend"})
public final class ModuleNavBarItem
extends DefaultNavBarItem<Module>
implements Pointer<NavBarItem> {
    public ModuleNavBarItem(@NotNull Module data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data);
    }

    @Override
    @NotNull
    public Pointer<? extends NavBarItem> createPointer() {
        return this;
    }

    @Nullable
    public NavBarItem dereference() {
        return ((Module)this.getData()).isDisposed() ? null : (NavBarItem)this;
    }

    @Override
    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationRequests.Companion.getInstance().rawNavigationRequest(new Navigatable(this){
            final /* synthetic */ ModuleNavBarItem this$0;
            {
                this.this$0 = $receiver;
            }

            public void navigate(boolean requestFocus) {
                block0: {
                    AbstractProjectViewPane projectViewPane;
                    ProjectView projectView = ProjectView.getInstance((Project)((Module)this.this$0.getData()).getProject());
                    AbstractProjectViewPane abstractProjectViewPane = projectViewPane = projectView.getProjectViewPaneById(projectView.getCurrentViewId());
                    if (abstractProjectViewPane == null) break block0;
                    abstractProjectViewPane.selectModule((Module)this.this$0.getData(), true);
                }
            }

            public boolean canNavigate() {
                return true;
            }

            public boolean canNavigateToSource() {
                return true;
            }
        });
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = ModuleType.get((Module)((Module)this.getData())).getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
        return icon;
    }

    @Override
    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes;
        WolfTheProblemSolver problemSolver = WolfTheProblemSolver.getInstance((Project)((Module)this.getData()).getProject());
        boolean hasProblems = problemSolver.hasProblemFilesBeneath((Module)this.getData());
        if (hasProblems) {
            simpleTextAttributes = DefaultNavBarItemKt.getNavBarErrorAttributes();
        } else {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            simpleTextAttributes = simpleTextAttributes2;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
        }
        return simpleTextAttributes;
    }

    @Override
    public int weight() {
        return 5;
    }
}

