# nextest-metadata

[![nextest-metadata on crates.io](https://img.shields.io/crates/v/nextest-metadata)](https://crates.io/crates/nextest-metadata)
[![Documentation (latest release)](https://img.shields.io/badge/docs-latest-brightgreen.svg)](https://docs.rs/nextest-metadata/)
[![Documentation (main)](https://img.shields.io/badge/docs-main-purple)](https://nexte.st/rustdoc/nextest_metadata/)
[![Changelog](https://img.shields.io/badge/changelog-latest-blue)](CHANGELOG.md)
[![License](https://img.shields.io/badge/license-Apache-green.svg)](LICENSE-APACHE)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE-MIT)

This crate contains deserializers for machine-readable output generated by
[cargo-nextest](https://nexte.st).

Implemented so far:
* ✅ Listing tests with `TestListSummary`
* ✅ Semantic exit codes with `NextestExitCode`

## Examples

Get the list of tests in the repository:

```rust
// This example requires `cargo nextest` to be installed.

use nextest_metadata::ListCommand;

let command = ListCommand::new();
let test_list = command.exec().unwrap();

// The result is a TestListSummary.
println!("{:?}", test_list);
```

## Minimum supported Rust version (MSRV)

The minimum supported Rust version is **Rust 1.78.**

While this crate is a pre-release (0.x.x) it may have its MSRV bumped in a patch release. Once a
crate has reached 1.x, any MSRV bump will be accompanied with a new minor version.

## Minimum supported cargo-nextest version

The "minimum supported cargo-nextest version" is **cargo-nextest 0.9.15**.

For more about nextest-metadata's stability policy, see the [Stability
page](https://nexte.st/docs/stability/#nextest-metadata) on the nextest site.

## Contributing

See the [CONTRIBUTING](../CONTRIBUTING.md) file for how to help out.

## License

This project is available under the terms of either the [Apache 2.0 license](../LICENSE-APACHE) or
the [MIT license](../LICENSE-MIT).

<!--
README.md is generated from README.tpl by cargo readme. To regenerate, run from the repository root:

./scripts/regenerate-readmes.sh
-->
