// NOTE: File has been autogenerated by utils/aarch64_builtins_test_generator.py
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sve -target-feature +sve-sha3 -verify=guard
// RUN: %clang_cc1 %s -fsyntax-only -triple aarch64-none-linux-gnu -target-feature +sme -target-feature +sme2p1 -target-feature +sve -target-feature +sve-sha3 -verify
// expected-no-diagnostics

// REQUIRES: aarch64-registered-target

#include <arm_sve.h>

// Properties: guard="sve,sve-sha3" streaming_guard="sme,sme2p1,sve-sha3" flags="feature-dependent"

void test(void) {
  svint64_t svint64_t_val;
  svuint64_t svuint64_t_val;

  svrax1(svint64_t_val, svint64_t_val);
  svrax1(svuint64_t_val, svuint64_t_val);
  svrax1_s64(svint64_t_val, svint64_t_val);
  svrax1_u64(svuint64_t_val, svuint64_t_val);
}

void test_streaming(void) __arm_streaming{
  svint64_t svint64_t_val;
  svuint64_t svuint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1(svint64_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1_s64(svint64_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1_u64(svuint64_t_val, svuint64_t_val);
}

void test_streaming_compatible(void) __arm_streaming_compatible{
  svint64_t svint64_t_val;
  svuint64_t svuint64_t_val;

  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1(svint64_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1(svuint64_t_val, svuint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1_s64(svint64_t_val, svint64_t_val);
  // guard-error@+1 {{builtin can only be called from a non-streaming function}}
  svrax1_u64(svuint64_t_val, svuint64_t_val);
}
