// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// SummaryDataPointValueAtQuantile is a quantile value within a Summary data point.
type SummaryDataPointValueAtQuantile struct {
	Quantile float64
	Value    float64
}

var (
	protoPoolSummaryDataPointValueAtQuantile = sync.Pool{
		New: func() any {
			return &SummaryDataPointValueAtQuantile{}
		},
	}
)

func NewSummaryDataPointValueAtQuantile() *SummaryDataPointValueAtQuantile {
	if !UseProtoPooling.IsEnabled() {
		return &SummaryDataPointValueAtQuantile{}
	}
	return protoPoolSummaryDataPointValueAtQuantile.Get().(*SummaryDataPointValueAtQuantile)
}

func DeleteSummaryDataPointValueAtQuantile(orig *SummaryDataPointValueAtQuantile, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolSummaryDataPointValueAtQuantile.Put(orig)
	}
}

func CopySummaryDataPointValueAtQuantile(dest, src *SummaryDataPointValueAtQuantile) *SummaryDataPointValueAtQuantile {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSummaryDataPointValueAtQuantile()
	}
	dest.Quantile = src.Quantile
	dest.Value = src.Value

	return dest
}

func CopySummaryDataPointValueAtQuantileSlice(dest, src []SummaryDataPointValueAtQuantile) []SummaryDataPointValueAtQuantile {
	var newDest []SummaryDataPointValueAtQuantile
	if cap(dest) < len(src) {
		newDest = make([]SummaryDataPointValueAtQuantile, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSummaryDataPointValueAtQuantile(&dest[i], false)
		}
	}
	for i := range src {
		CopySummaryDataPointValueAtQuantile(&newDest[i], &src[i])
	}
	return newDest
}

func CopySummaryDataPointValueAtQuantilePtrSlice(dest, src []*SummaryDataPointValueAtQuantile) []*SummaryDataPointValueAtQuantile {
	var newDest []*SummaryDataPointValueAtQuantile
	if cap(dest) < len(src) {
		newDest = make([]*SummaryDataPointValueAtQuantile, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSummaryDataPointValueAtQuantile()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSummaryDataPointValueAtQuantile(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSummaryDataPointValueAtQuantile()
		}
	}
	for i := range src {
		CopySummaryDataPointValueAtQuantile(newDest[i], src[i])
	}
	return newDest
}

func (orig *SummaryDataPointValueAtQuantile) Reset() {
	*orig = SummaryDataPointValueAtQuantile{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *SummaryDataPointValueAtQuantile) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.Quantile != float64(0) {
		dest.WriteObjectField("quantile")
		dest.WriteFloat64(orig.Quantile)
	}
	if orig.Value != float64(0) {
		dest.WriteObjectField("value")
		dest.WriteFloat64(orig.Value)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *SummaryDataPointValueAtQuantile) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "quantile":
			orig.Quantile = iter.ReadFloat64()
		case "value":
			orig.Value = iter.ReadFloat64()
		default:
			iter.Skip()
		}
	}
}

func (orig *SummaryDataPointValueAtQuantile) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.Quantile != float64(0) {
		n += 9
	}
	if orig.Value != float64(0) {
		n += 9
	}
	return n
}

func (orig *SummaryDataPointValueAtQuantile) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.Quantile != float64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Quantile))
		pos--
		buf[pos] = 0x9
	}
	if orig.Value != float64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.Value))
		pos--
		buf[pos] = 0x11
	}
	return len(buf) - pos
}

func (orig *SummaryDataPointValueAtQuantile) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quantile", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.Quantile = math.Float64frombits(num)

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			orig.Value = math.Float64frombits(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSummaryDataPointValueAtQuantile() *SummaryDataPointValueAtQuantile {
	orig := NewSummaryDataPointValueAtQuantile()
	orig.Quantile = float64(3.1415926)
	orig.Value = float64(3.1415926)
	return orig
}

func GenTestSummaryDataPointValueAtQuantilePtrSlice() []*SummaryDataPointValueAtQuantile {
	orig := make([]*SummaryDataPointValueAtQuantile, 5)
	orig[0] = NewSummaryDataPointValueAtQuantile()
	orig[1] = GenTestSummaryDataPointValueAtQuantile()
	orig[2] = NewSummaryDataPointValueAtQuantile()
	orig[3] = GenTestSummaryDataPointValueAtQuantile()
	orig[4] = NewSummaryDataPointValueAtQuantile()
	return orig
}

func GenTestSummaryDataPointValueAtQuantileSlice() []SummaryDataPointValueAtQuantile {
	orig := make([]SummaryDataPointValueAtQuantile, 5)
	orig[1] = *GenTestSummaryDataPointValueAtQuantile()
	orig[3] = *GenTestSummaryDataPointValueAtQuantile()
	return orig
}
