---
title: include-auto-generated
---

:octicons-tag-24: v3.5.0

The `#!yaml include-auto-generated:` parameter specifies whether or not mockery should include source files that appear to be auto-generated. By default, mockery will search for the presence of a string in the source code that appears before the `#!go package foo` declaration that matches the regular expression `^\/\/ Code generated by .*; DO NOT EDIT(\.?)( )*$`. Sometimes, users may wish to override this behavior and unconditionally include these source files. For example:

```yaml title=".mockery.yml"
packages:
  github.com/vektra/mockery/v3/internal/fixtures/include_auto_generated:
    config:
      include-auto-generated: true
```

You may also set this at the top-level as such:

```yaml title=".mockery.yml"
include-auto-generated: true
packages:
  github.com/vektra/mockery/v3/internal/fixtures/include_auto_generated:      
```

It is not possible to set this parameter at the interface level config because mockery performs this regular expression check before parsing the syntax in the source file. Allowing users to specify this on the interface-level config would require mockery to unconditionally parse all files, which defeats the performance benefits of excluding such auto-generated files in the first place.
