// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

type MetricsRequest struct {
	RequestContext *RequestContext
	MetricsData    MetricsData
	FormatVersion  uint32
}

var (
	protoPoolMetricsRequest = sync.Pool{
		New: func() any {
			return &MetricsRequest{}
		},
	}
)

func NewMetricsRequest() *MetricsRequest {
	if !UseProtoPooling.IsEnabled() {
		return &MetricsRequest{}
	}
	return protoPoolMetricsRequest.Get().(*MetricsRequest)
}

func DeleteMetricsRequest(orig *MetricsRequest, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteRequestContext(orig.RequestContext, true)
	DeleteMetricsData(&orig.MetricsData, false)

	orig.Reset()
	if nullable {
		protoPoolMetricsRequest.Put(orig)
	}
}

func CopyMetricsRequest(dest, src *MetricsRequest) *MetricsRequest {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewMetricsRequest()
	}
	dest.RequestContext = CopyRequestContext(dest.RequestContext, src.RequestContext)

	CopyMetricsData(&dest.MetricsData, &src.MetricsData)

	dest.FormatVersion = src.FormatVersion

	return dest
}

func CopyMetricsRequestSlice(dest, src []MetricsRequest) []MetricsRequest {
	var newDest []MetricsRequest
	if cap(dest) < len(src) {
		newDest = make([]MetricsRequest, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMetricsRequest(&dest[i], false)
		}
	}
	for i := range src {
		CopyMetricsRequest(&newDest[i], &src[i])
	}
	return newDest
}

func CopyMetricsRequestPtrSlice(dest, src []*MetricsRequest) []*MetricsRequest {
	var newDest []*MetricsRequest
	if cap(dest) < len(src) {
		newDest = make([]*MetricsRequest, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMetricsRequest()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteMetricsRequest(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewMetricsRequest()
		}
	}
	for i := range src {
		CopyMetricsRequest(newDest[i], src[i])
	}
	return newDest
}

func (orig *MetricsRequest) Reset() {
	*orig = MetricsRequest{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *MetricsRequest) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.RequestContext != nil {
		dest.WriteObjectField("requestContext")
		orig.RequestContext.MarshalJSON(dest)
	}
	dest.WriteObjectField("metricsData")
	orig.MetricsData.MarshalJSON(dest)
	if orig.FormatVersion != uint32(0) {
		dest.WriteObjectField("formatVersion")
		dest.WriteUint32(orig.FormatVersion)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *MetricsRequest) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "requestContext", "request_context":
			orig.RequestContext = NewRequestContext()
			orig.RequestContext.UnmarshalJSON(iter)
		case "metricsData", "metrics_data":

			orig.MetricsData.UnmarshalJSON(iter)
		case "formatVersion", "format_version":
			orig.FormatVersion = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *MetricsRequest) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.RequestContext != nil {
		l = orig.RequestContext.SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.MetricsData.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.FormatVersion != uint32(0) {
		n += 5
	}
	return n
}

func (orig *MetricsRequest) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.RequestContext != nil {
		l = orig.RequestContext.MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = orig.MetricsData.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x1a

	if orig.FormatVersion != uint32(0) {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.FormatVersion))
		pos--
		buf[pos] = 0xd
	}
	return len(buf) - pos
}

func (orig *MetricsRequest) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestContext", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			orig.RequestContext = NewRequestContext()
			err = orig.RequestContext.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricsData", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.MetricsData.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 1:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatVersion", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.FormatVersion = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestMetricsRequest() *MetricsRequest {
	orig := NewMetricsRequest()
	orig.RequestContext = GenTestRequestContext()
	orig.MetricsData = *GenTestMetricsData()
	orig.FormatVersion = uint32(13)
	return orig
}

func GenTestMetricsRequestPtrSlice() []*MetricsRequest {
	orig := make([]*MetricsRequest, 5)
	orig[0] = NewMetricsRequest()
	orig[1] = GenTestMetricsRequest()
	orig[2] = NewMetricsRequest()
	orig[3] = GenTestMetricsRequest()
	orig[4] = NewMetricsRequest()
	return orig
}

func GenTestMetricsRequestSlice() []MetricsRequest {
	orig := make([]MetricsRequest, 5)
	orig[1] = *GenTestMetricsRequest()
	orig[3] = *GenTestMetricsRequest()
	return orig
}
