// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// Line details a specific line in a source code, linked to a function.
type Line struct {
	FunctionIndex int32
	Line          int64
	Column        int64
}

var (
	protoPoolLine = sync.Pool{
		New: func() any {
			return &Line{}
		},
	}
)

func NewLine() *Line {
	if !UseProtoPooling.IsEnabled() {
		return &Line{}
	}
	return protoPoolLine.Get().(*Line)
}

func DeleteLine(orig *Line, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolLine.Put(orig)
	}
}

func CopyLine(dest, src *Line) *Line {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewLine()
	}
	dest.FunctionIndex = src.FunctionIndex
	dest.Line = src.Line
	dest.Column = src.Column

	return dest
}

func CopyLineSlice(dest, src []Line) []Line {
	var newDest []Line
	if cap(dest) < len(src) {
		newDest = make([]Line, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLine(&dest[i], false)
		}
	}
	for i := range src {
		CopyLine(&newDest[i], &src[i])
	}
	return newDest
}

func CopyLinePtrSlice(dest, src []*Line) []*Line {
	var newDest []*Line
	if cap(dest) < len(src) {
		newDest = make([]*Line, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLine()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteLine(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewLine()
		}
	}
	for i := range src {
		CopyLine(newDest[i], src[i])
	}
	return newDest
}

func (orig *Line) Reset() {
	*orig = Line{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Line) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.FunctionIndex != int32(0) {
		dest.WriteObjectField("functionIndex")
		dest.WriteInt32(orig.FunctionIndex)
	}
	if orig.Line != int64(0) {
		dest.WriteObjectField("line")
		dest.WriteInt64(orig.Line)
	}
	if orig.Column != int64(0) {
		dest.WriteObjectField("column")
		dest.WriteInt64(orig.Column)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Line) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "functionIndex", "function_index":
			orig.FunctionIndex = iter.ReadInt32()
		case "line":
			orig.Line = iter.ReadInt64()
		case "column":
			orig.Column = iter.ReadInt64()
		default:
			iter.Skip()
		}
	}
}

func (orig *Line) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.FunctionIndex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.FunctionIndex))
	}
	if orig.Line != int64(0) {
		n += 1 + proto.Sov(uint64(orig.Line))
	}
	if orig.Column != int64(0) {
		n += 1 + proto.Sov(uint64(orig.Column))
	}
	return n
}

func (orig *Line) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.FunctionIndex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FunctionIndex))
		pos--
		buf[pos] = 0x8
	}
	if orig.Line != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Line))
		pos--
		buf[pos] = 0x10
	}
	if orig.Column != int64(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.Column))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func (orig *Line) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FunctionIndex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.FunctionIndex = int32(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Line", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Line = int64(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.Column = int64(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestLine() *Line {
	orig := NewLine()
	orig.FunctionIndex = int32(13)
	orig.Line = int64(13)
	orig.Column = int64(13)
	return orig
}

func GenTestLinePtrSlice() []*Line {
	orig := make([]*Line, 5)
	orig[0] = NewLine()
	orig[1] = GenTestLine()
	orig[2] = NewLine()
	orig[3] = GenTestLine()
	orig[4] = NewLine()
	return orig
}

func GenTestLineSlice() []Line {
	orig := make([]Line, 5)
	orig[1] = *GenTestLine()
	orig[3] = *GenTestLine()
	return orig
}
