// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// KeyValueAndUnit represents a custom 'dictionary native'
// style of encoding attributes which is more convenient
// for profiles than opentelemetry.proto.common.v1.KeyValue.
type KeyValueAndUnit struct {
	Value        AnyValue
	KeyStrindex  int32
	UnitStrindex int32
}

var (
	protoPoolKeyValueAndUnit = sync.Pool{
		New: func() any {
			return &KeyValueAndUnit{}
		},
	}
)

func NewKeyValueAndUnit() *KeyValueAndUnit {
	if !UseProtoPooling.IsEnabled() {
		return &KeyValueAndUnit{}
	}
	return protoPoolKeyValueAndUnit.Get().(*KeyValueAndUnit)
}

func DeleteKeyValueAndUnit(orig *KeyValueAndUnit, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteAnyValue(&orig.Value, false)

	orig.Reset()
	if nullable {
		protoPoolKeyValueAndUnit.Put(orig)
	}
}

func CopyKeyValueAndUnit(dest, src *KeyValueAndUnit) *KeyValueAndUnit {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewKeyValueAndUnit()
	}
	dest.KeyStrindex = src.KeyStrindex
	CopyAnyValue(&dest.Value, &src.Value)

	dest.UnitStrindex = src.UnitStrindex

	return dest
}

func CopyKeyValueAndUnitSlice(dest, src []KeyValueAndUnit) []KeyValueAndUnit {
	var newDest []KeyValueAndUnit
	if cap(dest) < len(src) {
		newDest = make([]KeyValueAndUnit, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteKeyValueAndUnit(&dest[i], false)
		}
	}
	for i := range src {
		CopyKeyValueAndUnit(&newDest[i], &src[i])
	}
	return newDest
}

func CopyKeyValueAndUnitPtrSlice(dest, src []*KeyValueAndUnit) []*KeyValueAndUnit {
	var newDest []*KeyValueAndUnit
	if cap(dest) < len(src) {
		newDest = make([]*KeyValueAndUnit, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewKeyValueAndUnit()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteKeyValueAndUnit(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewKeyValueAndUnit()
		}
	}
	for i := range src {
		CopyKeyValueAndUnit(newDest[i], src[i])
	}
	return newDest
}

func (orig *KeyValueAndUnit) Reset() {
	*orig = KeyValueAndUnit{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *KeyValueAndUnit) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.KeyStrindex != int32(0) {
		dest.WriteObjectField("keyStrindex")
		dest.WriteInt32(orig.KeyStrindex)
	}
	dest.WriteObjectField("value")
	orig.Value.MarshalJSON(dest)
	if orig.UnitStrindex != int32(0) {
		dest.WriteObjectField("unitStrindex")
		dest.WriteInt32(orig.UnitStrindex)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *KeyValueAndUnit) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "keyStrindex", "key_strindex":
			orig.KeyStrindex = iter.ReadInt32()
		case "value":

			orig.Value.UnmarshalJSON(iter)
		case "unitStrindex", "unit_strindex":
			orig.UnitStrindex = iter.ReadInt32()
		default:
			iter.Skip()
		}
	}
}

func (orig *KeyValueAndUnit) SizeProto() int {
	var n int
	var l int
	_ = l
	if orig.KeyStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.KeyStrindex))
	}
	l = orig.Value.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	if orig.UnitStrindex != int32(0) {
		n += 1 + proto.Sov(uint64(orig.UnitStrindex))
	}
	return n
}

func (orig *KeyValueAndUnit) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.KeyStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.KeyStrindex))
		pos--
		buf[pos] = 0x8
	}
	l = orig.Value.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	if orig.UnitStrindex != int32(0) {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.UnitStrindex))
		pos--
		buf[pos] = 0x18
	}
	return len(buf) - pos
}

func (orig *KeyValueAndUnit) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.KeyStrindex = int32(num)

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Value.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field UnitStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}
			orig.UnitStrindex = int32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestKeyValueAndUnit() *KeyValueAndUnit {
	orig := NewKeyValueAndUnit()
	orig.KeyStrindex = int32(13)
	orig.Value = *GenTestAnyValue()
	orig.UnitStrindex = int32(13)
	return orig
}

func GenTestKeyValueAndUnitPtrSlice() []*KeyValueAndUnit {
	orig := make([]*KeyValueAndUnit, 5)
	orig[0] = NewKeyValueAndUnit()
	orig[1] = GenTestKeyValueAndUnit()
	orig[2] = NewKeyValueAndUnit()
	orig[3] = GenTestKeyValueAndUnit()
	orig[4] = NewKeyValueAndUnit()
	return orig
}

func GenTestKeyValueAndUnitSlice() []KeyValueAndUnit {
	orig := make([]KeyValueAndUnit, 5)
	orig[1] = *GenTestKeyValueAndUnit()
	orig[3] = *GenTestKeyValueAndUnit()
	return orig
}
