// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportResponse represents the response for gRPC/HTTP client/server.
type ExportProfilesServiceResponse struct {
	PartialSuccess ExportProfilesPartialSuccess
}

var (
	protoPoolExportProfilesServiceResponse = sync.Pool{
		New: func() any {
			return &ExportProfilesServiceResponse{}
		},
	}
)

func NewExportProfilesServiceResponse() *ExportProfilesServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &ExportProfilesServiceResponse{}
	}
	return protoPoolExportProfilesServiceResponse.Get().(*ExportProfilesServiceResponse)
}

func DeleteExportProfilesServiceResponse(orig *ExportProfilesServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteExportProfilesPartialSuccess(&orig.PartialSuccess, false)
	orig.Reset()
	if nullable {
		protoPoolExportProfilesServiceResponse.Put(orig)
	}
}

func CopyExportProfilesServiceResponse(dest, src *ExportProfilesServiceResponse) *ExportProfilesServiceResponse {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportProfilesServiceResponse()
	}
	CopyExportProfilesPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)

	return dest
}

func CopyExportProfilesServiceResponseSlice(dest, src []ExportProfilesServiceResponse) []ExportProfilesServiceResponse {
	var newDest []ExportProfilesServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]ExportProfilesServiceResponse, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportProfilesServiceResponse(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportProfilesServiceResponse(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportProfilesServiceResponsePtrSlice(dest, src []*ExportProfilesServiceResponse) []*ExportProfilesServiceResponse {
	var newDest []*ExportProfilesServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]*ExportProfilesServiceResponse, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportProfilesServiceResponse()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportProfilesServiceResponse(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportProfilesServiceResponse()
		}
	}
	for i := range src {
		CopyExportProfilesServiceResponse(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportProfilesServiceResponse) Reset() {
	*orig = ExportProfilesServiceResponse{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportProfilesServiceResponse) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	orig.PartialSuccess.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportProfilesServiceResponse) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":

			orig.PartialSuccess.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportProfilesServiceResponse) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.PartialSuccess.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *ExportProfilesServiceResponse) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.PartialSuccess.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func (orig *ExportProfilesServiceResponse) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.PartialSuccess.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportProfilesServiceResponse() *ExportProfilesServiceResponse {
	orig := NewExportProfilesServiceResponse()
	orig.PartialSuccess = *GenTestExportProfilesPartialSuccess()
	return orig
}

func GenTestExportProfilesServiceResponsePtrSlice() []*ExportProfilesServiceResponse {
	orig := make([]*ExportProfilesServiceResponse, 5)
	orig[0] = NewExportProfilesServiceResponse()
	orig[1] = GenTestExportProfilesServiceResponse()
	orig[2] = NewExportProfilesServiceResponse()
	orig[3] = GenTestExportProfilesServiceResponse()
	orig[4] = NewExportProfilesServiceResponse()
	return orig
}

func GenTestExportProfilesServiceResponseSlice() []ExportProfilesServiceResponse {
	orig := make([]ExportProfilesServiceResponse, 5)
	orig[1] = *GenTestExportProfilesServiceResponse()
	orig[3] = *GenTestExportProfilesServiceResponse()
	return orig
}
