// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ExportResponse represents the response for gRPC/HTTP client/server.
type ExportMetricsServiceResponse struct {
	PartialSuccess ExportMetricsPartialSuccess
}

var (
	protoPoolExportMetricsServiceResponse = sync.Pool{
		New: func() any {
			return &ExportMetricsServiceResponse{}
		},
	}
)

func NewExportMetricsServiceResponse() *ExportMetricsServiceResponse {
	if !UseProtoPooling.IsEnabled() {
		return &ExportMetricsServiceResponse{}
	}
	return protoPoolExportMetricsServiceResponse.Get().(*ExportMetricsServiceResponse)
}

func DeleteExportMetricsServiceResponse(orig *ExportMetricsServiceResponse, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	DeleteExportMetricsPartialSuccess(&orig.PartialSuccess, false)
	orig.Reset()
	if nullable {
		protoPoolExportMetricsServiceResponse.Put(orig)
	}
}

func CopyExportMetricsServiceResponse(dest, src *ExportMetricsServiceResponse) *ExportMetricsServiceResponse {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExportMetricsServiceResponse()
	}
	CopyExportMetricsPartialSuccess(&dest.PartialSuccess, &src.PartialSuccess)

	return dest
}

func CopyExportMetricsServiceResponseSlice(dest, src []ExportMetricsServiceResponse) []ExportMetricsServiceResponse {
	var newDest []ExportMetricsServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]ExportMetricsServiceResponse, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportMetricsServiceResponse(&dest[i], false)
		}
	}
	for i := range src {
		CopyExportMetricsServiceResponse(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExportMetricsServiceResponsePtrSlice(dest, src []*ExportMetricsServiceResponse) []*ExportMetricsServiceResponse {
	var newDest []*ExportMetricsServiceResponse
	if cap(dest) < len(src) {
		newDest = make([]*ExportMetricsServiceResponse, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportMetricsServiceResponse()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExportMetricsServiceResponse(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExportMetricsServiceResponse()
		}
	}
	for i := range src {
		CopyExportMetricsServiceResponse(newDest[i], src[i])
	}
	return newDest
}

func (orig *ExportMetricsServiceResponse) Reset() {
	*orig = ExportMetricsServiceResponse{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ExportMetricsServiceResponse) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("partialSuccess")
	orig.PartialSuccess.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ExportMetricsServiceResponse) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "partialSuccess", "partial_success":

			orig.PartialSuccess.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *ExportMetricsServiceResponse) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.PartialSuccess.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *ExportMetricsServiceResponse) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.PartialSuccess.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	return len(buf) - pos
}

func (orig *ExportMetricsServiceResponse) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field PartialSuccess", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.PartialSuccess.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExportMetricsServiceResponse() *ExportMetricsServiceResponse {
	orig := NewExportMetricsServiceResponse()
	orig.PartialSuccess = *GenTestExportMetricsPartialSuccess()
	return orig
}

func GenTestExportMetricsServiceResponsePtrSlice() []*ExportMetricsServiceResponse {
	orig := make([]*ExportMetricsServiceResponse, 5)
	orig[0] = NewExportMetricsServiceResponse()
	orig[1] = GenTestExportMetricsServiceResponse()
	orig[2] = NewExportMetricsServiceResponse()
	orig[3] = GenTestExportMetricsServiceResponse()
	orig[4] = NewExportMetricsServiceResponse()
	return orig
}

func GenTestExportMetricsServiceResponseSlice() []ExportMetricsServiceResponse {
	orig := make([]ExportMetricsServiceResponse, 5)
	orig[1] = *GenTestExportMetricsServiceResponse()
	orig[3] = *GenTestExportMetricsServiceResponse()
	return orig
}
