// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"math"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

func (m *Exemplar) GetValue() any {
	if m != nil {
		return m.Value
	}
	return nil
}

type Exemplar_AsDouble struct {
	AsDouble float64
}

func (m *Exemplar) GetAsDouble() float64 {
	if v, ok := m.GetValue().(*Exemplar_AsDouble); ok {
		return v.AsDouble
	}
	return float64(0)
}

type Exemplar_AsInt struct {
	AsInt int64
}

func (m *Exemplar) GetAsInt() int64 {
	if v, ok := m.GetValue().(*Exemplar_AsInt); ok {
		return v.AsInt
	}
	return int64(0)
}

// Exemplar is a sample input double measurement.
//
// Exemplars also hold information about the environment when the measurement was recorded,
// for example the span and trace ID of the active span when the exemplar was recorded.
type Exemplar struct {
	Value              any
	FilteredAttributes []KeyValue
	TimeUnixNano       uint64
	TraceId            TraceID
	SpanId             SpanID
}

var (
	protoPoolExemplar = sync.Pool{
		New: func() any {
			return &Exemplar{}
		},
	}

	ProtoPoolExemplar_AsDouble = sync.Pool{
		New: func() any {
			return &Exemplar_AsDouble{}
		},
	}

	ProtoPoolExemplar_AsInt = sync.Pool{
		New: func() any {
			return &Exemplar_AsInt{}
		},
	}
)

func NewExemplar() *Exemplar {
	if !UseProtoPooling.IsEnabled() {
		return &Exemplar{}
	}
	return protoPoolExemplar.Get().(*Exemplar)
}

func DeleteExemplar(orig *Exemplar, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}
	for i := range orig.FilteredAttributes {
		DeleteKeyValue(&orig.FilteredAttributes[i], false)
	}

	switch ov := orig.Value.(type) {
	case *Exemplar_AsDouble:
		if UseProtoPooling.IsEnabled() {
			ov.AsDouble = float64(0)
			ProtoPoolExemplar_AsDouble.Put(ov)
		}
	case *Exemplar_AsInt:
		if UseProtoPooling.IsEnabled() {
			ov.AsInt = int64(0)
			ProtoPoolExemplar_AsInt.Put(ov)
		}
	}
	DeleteTraceID(&orig.TraceId, false)
	DeleteSpanID(&orig.SpanId, false)
	orig.Reset()
	if nullable {
		protoPoolExemplar.Put(orig)
	}
}

func CopyExemplar(dest, src *Exemplar) *Exemplar {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewExemplar()
	}
	dest.FilteredAttributes = CopyKeyValueSlice(dest.FilteredAttributes, src.FilteredAttributes)

	dest.TimeUnixNano = src.TimeUnixNano
	switch t := src.Value.(type) {
	case *Exemplar_AsDouble:
		var ov *Exemplar_AsDouble
		if !UseProtoPooling.IsEnabled() {
			ov = &Exemplar_AsDouble{}
		} else {
			ov = ProtoPoolExemplar_AsDouble.Get().(*Exemplar_AsDouble)
		}
		ov.AsDouble = t.AsDouble
		dest.Value = ov

	case *Exemplar_AsInt:
		var ov *Exemplar_AsInt
		if !UseProtoPooling.IsEnabled() {
			ov = &Exemplar_AsInt{}
		} else {
			ov = ProtoPoolExemplar_AsInt.Get().(*Exemplar_AsInt)
		}
		ov.AsInt = t.AsInt
		dest.Value = ov

	default:
		dest.Value = nil
	}
	CopyTraceID(&dest.TraceId, &src.TraceId)

	CopySpanID(&dest.SpanId, &src.SpanId)

	return dest
}

func CopyExemplarSlice(dest, src []Exemplar) []Exemplar {
	var newDest []Exemplar
	if cap(dest) < len(src) {
		newDest = make([]Exemplar, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExemplar(&dest[i], false)
		}
	}
	for i := range src {
		CopyExemplar(&newDest[i], &src[i])
	}
	return newDest
}

func CopyExemplarPtrSlice(dest, src []*Exemplar) []*Exemplar {
	var newDest []*Exemplar
	if cap(dest) < len(src) {
		newDest = make([]*Exemplar, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExemplar()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteExemplar(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewExemplar()
		}
	}
	for i := range src {
		CopyExemplar(newDest[i], src[i])
	}
	return newDest
}

func (orig *Exemplar) Reset() {
	*orig = Exemplar{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *Exemplar) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.FilteredAttributes) > 0 {
		dest.WriteObjectField("filteredAttributes")
		dest.WriteArrayStart()
		orig.FilteredAttributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.FilteredAttributes); i++ {
			dest.WriteMore()
			orig.FilteredAttributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.TimeUnixNano != uint64(0) {
		dest.WriteObjectField("timeUnixNano")
		dest.WriteUint64(orig.TimeUnixNano)
	}
	switch orig := orig.Value.(type) {
	case *Exemplar_AsDouble:
		dest.WriteObjectField("asDouble")
		dest.WriteFloat64(orig.AsDouble)
	case *Exemplar_AsInt:
		dest.WriteObjectField("asInt")
		dest.WriteInt64(orig.AsInt)
	}
	if !orig.TraceId.IsEmpty() {
		dest.WriteObjectField("traceId")
		orig.TraceId.MarshalJSON(dest)
	}
	if !orig.SpanId.IsEmpty() {
		dest.WriteObjectField("spanId")
		orig.SpanId.MarshalJSON(dest)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *Exemplar) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "filteredAttributes", "filtered_attributes":
			for iter.ReadArray() {
				orig.FilteredAttributes = append(orig.FilteredAttributes, KeyValue{})
				orig.FilteredAttributes[len(orig.FilteredAttributes)-1].UnmarshalJSON(iter)
			}

		case "timeUnixNano", "time_unix_nano":
			orig.TimeUnixNano = iter.ReadUint64()

		case "asDouble", "as_double":
			{
				var ov *Exemplar_AsDouble
				if !UseProtoPooling.IsEnabled() {
					ov = &Exemplar_AsDouble{}
				} else {
					ov = ProtoPoolExemplar_AsDouble.Get().(*Exemplar_AsDouble)
				}
				ov.AsDouble = iter.ReadFloat64()
				orig.Value = ov
			}
		case "asInt", "as_int":
			{
				var ov *Exemplar_AsInt
				if !UseProtoPooling.IsEnabled() {
					ov = &Exemplar_AsInt{}
				} else {
					ov = ProtoPoolExemplar_AsInt.Get().(*Exemplar_AsInt)
				}
				ov.AsInt = iter.ReadInt64()
				orig.Value = ov
			}

		case "traceId", "trace_id":

			orig.TraceId.UnmarshalJSON(iter)
		case "spanId", "span_id":

			orig.SpanId.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *Exemplar) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.FilteredAttributes {
		l = orig.FilteredAttributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.TimeUnixNano != uint64(0) {
		n += 9
	}
	switch orig := orig.Value.(type) {
	case nil:
		_ = orig
		break
	case *Exemplar_AsDouble:

		n += 9
	case *Exemplar_AsInt:

		n += 9
	}
	l = orig.TraceId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.SpanId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *Exemplar) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.FilteredAttributes) - 1; i >= 0; i-- {
		l = orig.FilteredAttributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3a
	}
	if orig.TimeUnixNano != uint64(0) {
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.TimeUnixNano))
		pos--
		buf[pos] = 0x11
	}
	switch orig := orig.Value.(type) {
	case *Exemplar_AsDouble:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], math.Float64bits(orig.AsDouble))
		pos--
		buf[pos] = 0x19

	case *Exemplar_AsInt:
		pos -= 8
		binary.LittleEndian.PutUint64(buf[pos:], uint64(orig.AsInt))
		pos--
		buf[pos] = 0x31

	}
	l = orig.TraceId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x2a

	l = orig.SpanId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x22

	return len(buf) - pos
}

func (orig *Exemplar) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 7:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field FilteredAttributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.FilteredAttributes = append(orig.FilteredAttributes, KeyValue{})
			err = orig.FilteredAttributes[len(orig.FilteredAttributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field TimeUnixNano", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}

			orig.TimeUnixNano = uint64(num)

		case 3:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsDouble", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *Exemplar_AsDouble
			if !UseProtoPooling.IsEnabled() {
				ov = &Exemplar_AsDouble{}
			} else {
				ov = ProtoPoolExemplar_AsDouble.Get().(*Exemplar_AsDouble)
			}
			ov.AsDouble = math.Float64frombits(num)
			orig.Value = ov

		case 6:
			if wireType != proto.WireTypeI64 {
				return fmt.Errorf("proto: wrong wireType = %d for field AsInt", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeI64(buf, pos)
			if err != nil {
				return err
			}
			var ov *Exemplar_AsInt
			if !UseProtoPooling.IsEnabled() {
				ov = &Exemplar_AsInt{}
			} else {
				ov = ProtoPoolExemplar_AsInt.Get().(*Exemplar_AsInt)
			}
			ov.AsInt = int64(num)
			orig.Value = ov

		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TraceId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SpanId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestExemplar() *Exemplar {
	orig := NewExemplar()
	orig.FilteredAttributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.TimeUnixNano = uint64(13)
	orig.Value = &Exemplar_AsDouble{AsDouble: float64(3.1415926)}
	orig.TraceId = *GenTestTraceID()
	orig.SpanId = *GenTestSpanID()
	return orig
}

func GenTestExemplarPtrSlice() []*Exemplar {
	orig := make([]*Exemplar, 5)
	orig[0] = NewExemplar()
	orig[1] = GenTestExemplar()
	orig[2] = NewExemplar()
	orig[3] = GenTestExemplar()
	orig[4] = NewExemplar()
	return orig
}

func GenTestExemplarSlice() []Exemplar {
	orig := make([]Exemplar, 5)
	orig[1] = *GenTestExemplar()
	orig[3] = *GenTestExemplar()
	return orig
}
