//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

extern_class!(
    /// Provides a mechanism for displaying and animating a temporary text cursor to indicate a drop location.
    ///
    /// For custom text view implementations that implement drag and drop functionality, use this animator providing either your own UITextCursorView
    /// implementation or a concrete implementation to indicate at which point in your document the dropped item will be inserted. Using this animator provides
    /// you with all of the default system animations for how the text cursor would behave.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uitextcursordroppositionanimator?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UITextCursorDropPositionAnimator;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for UITextCursorDropPositionAnimator {}
);

impl UITextCursorDropPositionAnimator {
    extern_methods!(
        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextCursorView",
            feature = "UIView"
        ))]
        /// The cursor view to be animated.
        #[unsafe(method(cursorView))]
        #[unsafe(method_family = none)]
        pub fn cursorView(&self) -> Option<Retained<UIView>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextInput",
            feature = "UITextInputTraits",
            feature = "UIView"
        ))]
        /// The object that implements the UITextInput protocol, used to query for geometry information regarding cursor placement.
        #[unsafe(method(textInput))]
        #[unsafe(method_family = none)]
        pub fn textInput(&self) -> Option<Retained<UIView>>;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UITextCursorView",
            feature = "UITextInput",
            feature = "UITextInputTraits",
            feature = "UIView"
        ))]
        /// Creates an animator for the given text cursor view implementation, and the document object that implements the UITextInput protocol.
        ///
        /// # Safety
        ///
        /// - `cursor_view` must implement UITextCursorView.
        /// - `cursor_view` might not allow `None`.
        /// - `text_input` must implement UITextInput.
        /// - `text_input` might not allow `None`.
        #[unsafe(method(initWithTextCursorView:textInput:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithTextCursorView_textInput(
            this: Allocated<Self>,
            cursor_view: Option<&UIView>,
            text_input: Option<&UIView>,
        ) -> Option<Retained<Self>>;

        /// Controls the visibility of the cursor.
        #[unsafe(method(setCursorVisible:animated:))]
        #[unsafe(method_family = none)]
        pub fn setCursorVisible_animated(&self, visible: bool, animated: bool);

        #[cfg(feature = "UITextInput")]
        /// Controls the placement of the cursor, using
        /// `textInput`and
        /// `position`to compute the final frame for the cursor view.
        ///
        /// # Safety
        ///
        /// `position` might not allow `None`.
        #[unsafe(method(placeCursorAtPosition:animated:))]
        #[unsafe(method_family = none)]
        pub unsafe fn placeCursorAtPosition_animated(
            &self,
            position: Option<&UITextPosition>,
            animated: bool,
        );

        #[cfg(feature = "block2")]
        /// Optionally, provide an animation block or completion block to run alongside cursor appearance or position update animations.
        #[unsafe(method(animateAlongsideChanges:completion:))]
        #[unsafe(method_family = none)]
        pub fn animateAlongsideChanges_completion(
            &self,
            animation: Option<&block2::DynBlock<dyn Fn()>>,
            completion: Option<&block2::DynBlock<dyn Fn()>>,
        );

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
impl UITextCursorDropPositionAnimator {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
