//! DO NOT EDIT! This file is generated by `xtask`.
//! Contains tests for the `event!` macro.
#![deny(warnings)]
#![no_implicit_prelude]

extern crate tracing;

// We call all macros in this module with `no_implicit_prelude` to ensure they do not depend on the standard prelude.
#[cfg(target_arch = "wasm32")]
extern crate wasm_bindgen_test;

struct Disp {
    val: u64,
}

impl ::std::fmt::Display for Disp {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        ::std::write!(f, "Disp.val={val}", val = self.val)
    }
}

struct Deb {
    val: u64,
}

/// Manual implementation because otherwise `val` is unused.
impl ::std::fmt::Debug for Deb {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        f.debug_struct("Deb").field("val", &self.val).finish()
    }
}

struct Sub {
    field: u64,
}
#[cfg_attr(target_arch = "wasm32", wasm_bindgen_test::wasm_bindgen_test)]
#[test]
fn event() {
    const CONST_VAR: &str = "const-field";

    let var = true;
    let sub = Sub { field: 4, };
    let disp = Disp { val: 61, };
    let deb = Deb { val: 102, };

    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3); // DEBUG:event,np,-,-,-,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3); // DEBUG:event,np,-,p,-,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3); // DEBUG:event,np,-,f,-,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3); // DEBUG:event,np,-,pf,-,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg without args"); // DEBUG:event,np,-,-,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg without args"); // DEBUG:event,np,-,p,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false); // DEBUG:event,np,-,-,-,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false); // DEBUG:event,np,-,p,-,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3); // DEBUG:event,np,-,f,-,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3); // DEBUG:event,np,-,pf,-,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg without args"); // DEBUG:event,np,-,-,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg without args"); // DEBUG:event,np,-,p,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3); // DEBUG:event,np,-,-,-,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3); // DEBUG:event,np,-,p,-,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3); // DEBUG:event,np,-,f,-,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3); // DEBUG:event,np,-,pf,-,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg without args"); // DEBUG:event,np,-,-,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg without args"); // DEBUG:event,np,-,p,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3); // DEBUG:event,np,-,-,-,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3); // DEBUG:event,np,-,p,-,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3); // DEBUG:event,np,-,f,-,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3); // DEBUG:event,np,-,pf,-,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg without args"); // DEBUG:event,np,-,-,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg without args"); // DEBUG:event,np,-,p,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb); // DEBUG:event,np,-,-,-,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb); // DEBUG:event,np,-,p,-,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3); // DEBUG:event,np,-,f,-,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3); // DEBUG:event,np,-,pf,-,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg without args"); // DEBUG:event,np,-,-,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg without args"); // DEBUG:event,np,-,p,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp); // DEBUG:event,np,-,-,-,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp); // DEBUG:event,np,-,p,-,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3); // DEBUG:event,np,-,f,-,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3); // DEBUG:event,np,-,pf,-,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg without args"); // DEBUG:event,np,-,-,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg without args"); // DEBUG:event,np,-,p,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field); // DEBUG:event,np,-,-,-,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field); // DEBUG:event,np,-,p,-,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3); // DEBUG:event,np,-,f,-,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field); // DEBUG:event,np,-,-,-,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field); // DEBUG:event,np,-,p,-,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3); // DEBUG:event,np,-,f,-,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb)); // DEBUG:event,np,-,-,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb)); // DEBUG:event,np,-,p,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3); // DEBUG:event,np,-,f,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3); // DEBUG:event,np,-,pf,-,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg without args"); // DEBUG:event,np,-,-,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg without args"); // DEBUG:event,np,-,p,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp)); // DEBUG:event,np,-,-,-,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp)); // DEBUG:event,np,-,p,-,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3); // DEBUG:event,np,-,f,-,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3); // DEBUG:event,np,-,pf,-,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg without args"); // DEBUG:event,np,-,-,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg without args"); // DEBUG:event,np,-,p,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty); // DEBUG:event,np,-,-,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty); // DEBUG:event,np,-,p,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,f,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,pf,-,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,-,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,p,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},-,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},p,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3); // DEBUG:event,np,-,-,-,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3); // DEBUG:event,np,-,p,-,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false); // DEBUG:event,np,-,-,-,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false); // DEBUG:event,np,-,p,-,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3); // DEBUG:event,np,-,-,-,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3); // DEBUG:event,np,-,p,-,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3); // DEBUG:event,np,-,-,-,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3); // DEBUG:event,np,-,p,-,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb); // DEBUG:event,np,-,-,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb); // DEBUG:event,np,-,p,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp); // DEBUG:event,np,-,-,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp); // DEBUG:event,np,-,p,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field); // DEBUG:event,np,-,-,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field); // DEBUG:event,np,-,p,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field); // DEBUG:event,np,-,-,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field); // DEBUG:event,np,-,p,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb)); // DEBUG:event,np,-,-,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb)); // DEBUG:event,np,-,p,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp)); // DEBUG:event,np,-,-,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp)); // DEBUG:event,np,-,p,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty); // DEBUG:event,np,-,-,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty); // DEBUG:event,np,-,p,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,f,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,pf,-,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},-,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},p,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, dotted.ident = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, dotted.ident = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"dotted.ident","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3); // DEBUG:event,np,-,-,-,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3); // DEBUG:event,np,-,p,-,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false); // DEBUG:event,np,-,-,-,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false); // DEBUG:event,np,-,p,-,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3); // DEBUG:event,np,-,-,-,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3); // DEBUG:event,np,-,p,-,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3); // DEBUG:event,np,-,-,-,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3); // DEBUG:event,np,-,p,-,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb); // DEBUG:event,np,-,-,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb); // DEBUG:event,np,-,p,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp); // DEBUG:event,np,-,-,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp); // DEBUG:event,np,-,p,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field); // DEBUG:event,np,-,-,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field); // DEBUG:event,np,-,p,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field); // DEBUG:event,np,-,-,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field); // DEBUG:event,np,-,p,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb)); // DEBUG:event,np,-,-,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb)); // DEBUG:event,np,-,p,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp)); // DEBUG:event,np,-,-,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp)); // DEBUG:event,np,-,p,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty); // DEBUG:event,np,-,-,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty); // DEBUG:event,np,-,p,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,f,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,pf,-,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},-,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},p,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, "literal" = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, "literal" = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"\"literal\"","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb)); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb)); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp)); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp)); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,np,-,-,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty); // DEBUG:event,np,-,p,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,f,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,pf,-,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},-,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},p,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, { CONST_VAR } = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"{ CONST_VAR }","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3); // DEBUG:event,np,-,-,-,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3); // DEBUG:event,np,-,p,-,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3); // DEBUG:event,np,-,f,-,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = 3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = 3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false); // DEBUG:event,np,-,-,-,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false); // DEBUG:event,np,-,p,-,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3); // DEBUG:event,np,-,f,-,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = false, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = false, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","false"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3); // DEBUG:event,np,-,-,-,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3); // DEBUG:event,np,-,p,-,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3); // DEBUG:event,np,-,f,-,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","?3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3); // DEBUG:event,np,-,-,-,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3); // DEBUG:event,np,-,p,-,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3); // DEBUG:event,np,-,f,-,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %3, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %3, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","%3"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb); // DEBUG:event,np,-,-,-,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb); // DEBUG:event,np,-,p,-,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3); // DEBUG:event,np,-,f,-,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp); // DEBUG:event,np,-,-,-,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp); // DEBUG:event,np,-,p,-,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3); // DEBUG:event,np,-,f,-,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field); // DEBUG:event,np,-,-,-,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field); // DEBUG:event,np,-,p,-,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3); // DEBUG:event,np,-,f,-,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field); // DEBUG:event,np,-,-,-,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field); // DEBUG:event,np,-,p,-,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3); // DEBUG:event,np,-,f,-,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb)); // DEBUG:event,np,-,-,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb)); // DEBUG:event,np,-,p,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3); // DEBUG:event,np,-,f,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3); // DEBUG:event,np,-,pf,-,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg without args"); // DEBUG:event,np,-,-,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg without args"); // DEBUG:event,np,-,p,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = debug(&deb), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = debug(&deb), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","debug(&deb)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp)); // DEBUG:event,np,-,-,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp)); // DEBUG:event,np,-,p,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3); // DEBUG:event,np,-,f,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3); // DEBUG:event,np,-,pf,-,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg without args"); // DEBUG:event,np,-,-,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg without args"); // DEBUG:event,np,-,p,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = display(&disp), qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp) }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = display(&disp), qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","display(&disp)"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty); // DEBUG:event,np,-,-,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty); // DEBUG:event,np,-,p,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,f,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3); // DEBUG:event,np,-,pf,-,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,-,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg without args"); // DEBUG:event,np,-,p,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},-,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg without args"); // DEBUG:event,np,{},p,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, r#type = tracing::field::Empty, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, r#type = tracing::field::Empty, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,"r#type","tracing::field::Empty"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, var); // DEBUG:event,np,-,-,-,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var); // DEBUG:event,np,-,p,-,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3); // DEBUG:event,np,-,f,-,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3); // DEBUG:event,np,-,pf,-,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg without args"); // DEBUG:event,np,-,-,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg without args"); // DEBUG:event,np,-,p,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg without args"); // DEBUG:event,np,{},-,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg without args"); // DEBUG:event,np,{},p,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, var, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, var, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { var }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, var, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,-,"var"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field); // DEBUG:event,np,-,-,-,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field); // DEBUG:event,np,-,p,-,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3); // DEBUG:event,np,-,f,-,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3); // DEBUG:event,np,-,pf,-,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg without args"); // DEBUG:event,np,-,-,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg without args"); // DEBUG:event,np,-,p,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,-,"sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %disp); // DEBUG:event,np,-,-,-,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp); // DEBUG:event,np,-,p,-,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3); // DEBUG:event,np,-,f,-,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3); // DEBUG:event,np,-,pf,-,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg without args"); // DEBUG:event,np,-,-,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg without args"); // DEBUG:event,np,-,p,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg without args"); // DEBUG:event,np,{},-,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg without args"); // DEBUG:event,np,{},p,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %disp, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %disp, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,-,"%disp"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb); // DEBUG:event,np,-,-,-,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb); // DEBUG:event,np,-,p,-,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3); // DEBUG:event,np,-,f,-,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3); // DEBUG:event,np,-,pf,-,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg without args"); // DEBUG:event,np,-,-,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg without args"); // DEBUG:event,np,-,p,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg without args"); // DEBUG:event,np,{},-,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg without args"); // DEBUG:event,np,{},p,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?deb, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?deb, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,-,"?deb"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field); // DEBUG:event,np,-,-,-,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field); // DEBUG:event,np,-,p,-,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3); // DEBUG:event,np,-,f,-,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3); // DEBUG:event,np,-,pf,-,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg without args"); // DEBUG:event,np,-,-,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg without args"); // DEBUG:event,np,-,p,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, %sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, %sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,-,"%sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field); // DEBUG:event,np,-,-,-,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field); // DEBUG:event,np,-,p,-,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3); // DEBUG:event,np,-,f,-,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3); // DEBUG:event,np,-,pf,-,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg without args"); // DEBUG:event,np,-,-,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg without args"); // DEBUG:event,np,-,p,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,f,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg without args"); // DEBUG:event,np,-,pf,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg without args"); // DEBUG:event,np,{},-,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg without args"); // DEBUG:event,np,{},p,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},f,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg without args"); // DEBUG:event,np,{},pf,m,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,-,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, "msg with arg: {:?}", 56); // DEBUG:event,np,-,p,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,f,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, foo = true, ?sub.field, qux = 3, "msg with arg: {:?}", 56); // DEBUG:event,np,-,pf,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},-,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},p,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},f,ma,-,"?sub.field"
    tracing::event!(name: "mog", parent: ::core::option::Option::None, tracing::Level::INFO, { foo = true, ?sub.field, qux = 3 }, "msg with arg: {:?}", 56); // DEBUG:event,np,{},pf,ma,-,"?sub.field"
}
