/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_lb extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Mëttler Greenwich-Zäit",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre-Normalzäit",
               "",
               "Acre-Summerzäit",
               "",
               "Acre-Zäit",
               "",
            };
        final String[] Cook = new String[] {
               "Cookinselen-Normalzäit",
               "",
               "Cookinselen-Summerzäit",
               "",
               "Cookinselen-Zäit",
               "",
            };
        final String[] Cuba = new String[] {
               "Kubanesch Normalzäit",
               "CST",
               "Kubanesch Summerzäit",
               "CDT",
               "Kubanesch Zäit",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Fidschi-Normalzäit",
               "",
               "Fidschi-Summerzäit",
               "",
               "Fidschi-Zäit",
               "",
            };
        final String[] Gulf = new String[] {
               "Golf-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hovd-Normalzäit",
               "",
               "Hovd-Summerzäit",
               "",
               "Hovd-Zäit",
               "",
            };
        final String[] Iran = new String[] {
               "Iranesch Normalzäit",
               "",
               "Iranesch Summerzäit",
               "",
               "Iranesch Zäit",
               "",
            };
        final String[] Niue = new String[] {
               "Niue-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk-Normalzäit",
               "",
               "Omsk-Summerzäit",
               "",
               "Omsk-Zäit",
               "",
            };
        final String[] Peru = new String[] {
               "Peruanesch Normalzäit",
               "",
               "Peruanesch Summerzäit",
               "",
               "Peruanesch Zäit",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Wake-Insel-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Chilenesch Normalzäit",
               "",
               "Chilenesch Summerzäit",
               "",
               "Chilenesch Zäit",
               "",
            };
        final String[] China = new String[] {
               "Chinesesch Normalzäit",
               "CST",
               "Chinesesch Summerzäit",
               "CDT",
               "Chinesesch Zäit",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Kokosinselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Davis-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Indesch Zäit",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Japanesch Normalzäit",
               "JST",
               "Japanesch Summerzäit",
               "JDT",
               "Japanesch Zäit",
               "JT",
            };
        final String[] Korea = new String[] {
               "Koreanesch Normalzäit",
               "KST",
               "Koreanesch Summerzäit",
               "KST",
               "Koreanesch Zäit",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Nauru-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepalesesch Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa-Normalzäit",
               "SST",
               "Samoa-Summerzäit",
               "SST",
               "Samoa-Zäit",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Syowa-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonganesch Normalzäit",
               "",
               "Tonganesch Summerzäit",
               "",
               "Tonganesch Zäit",
               "",
            };
        final String[] Alaska = new String[] {
               "Alaska-Normalzäit",
               "AKST",
               "Alaska-Summerzäit",
               "AKDT",
               "Alaska-Zäit",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Amazonas-Normalzäit",
               "",
               "Amazonas-Summerzäit",
               "",
               "Amazonas-Zäit",
               "",
            };
        final String[] Azores = new String[] {
               "Azoren-Normalzäit",
               "",
               "Azoren-Summerzäit",
               "",
               "Azoren-Zäit",
               "",
            };
        final String[] Bhutan = new String[] {
               "Bhutan-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Brunei-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Ouschterinsel-Normalzäit",
               "",
               "Ouschterinsel-Summerzäit",
               "",
               "Ouschterinsel-Zäit",
               "",
            };
        final String[] Guyana = new String[] {
               "Guyana-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Hawaii-Aleuten-Normalzäit",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Israelesch Normalzäit",
               "IST",
               "Israelesch Summerzäit",
               "IDT",
               "Israelesch Zäit",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Kosrae-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Mawson-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Moskauer Normalzäit",
               "MSK",
               "Moskauer Summerzäit",
               "MSK",
               "Moskauer Zäit",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Samara-Normalzäit",
               "",
               "Samara-Summerzäit",
               "",
               "Samara-Zäit",
               "",
            };
        final String[] Tahiti = new String[] {
               "Tahiti-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Taipei-Normalzäit",
               "CST",
               "Taipei-Summerzäit",
               "CDT",
               "Taipei-Zäit",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Wostok-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Wallis-a-Futuna-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Arabesch Normalzäit",
               "",
               "Arabesch Summerzäit",
               "",
               "Arabesch Zäit",
               "",
            };
        final String[] Armenia = new String[] {
               "Armenesch Normalzäit",
               "",
               "Armenesch Summerzäit",
               "",
               "Armenesch Zäit",
               "",
            };
        final String[] Bolivia = new String[] {
               "Bolivianesch Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatham-Normalzäit",
               "",
               "Chatham-Summerzäit",
               "",
               "Chatham-Zäit",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ecuadorianesch Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambier-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Georgesch Normalzäit",
               "",
               "Georgesch Summerzäit",
               "",
               "Georgesch Zäit",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk-Normalzäit",
               "",
               "Irkutsk-Summerzäit",
               "",
               "Irkutsk-Zäit",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan-Normalzäit",
               "",
               "Magadan-Summerzäit",
               "",
               "Magadan-Zäit",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanmar-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolkinselen-Normalzäit",
               "",
               "Norfolkinselen-Summerzäit",
               "",
               "Norfolkinselen-Zäit",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernando-de-Noronha-Normalzäit",
               "",
               "Fernando-de-Noronha-Summerzäit",
               "",
               "Fernando-de-Noronha-Zäit",
               "",
            };
        final String[] Reunion = new String[] {
               "Réunion-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rothera-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Salomoninselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Uruguyanesch Normalzäit",
               "",
               "Uruguayanesch Summerzäit",
               "",
               "Uruguayanesch Zäit",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu-Normalzäit",
               "",
               "Vanuatu-Summerzäit",
               "",
               "Vanuatu-Zäit",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk-Normalzäit",
               "",
               "Jakutsk-Summerzäit",
               "",
               "Jakutsk-Zäit",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantik-Normalzäit",
               "AST",
               "Atlantik-Summerzäit",
               "AST",
               "Atlantik-Zäit",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Brasília-Normalzäit",
               "",
               "Brasília-Summerzäit",
               "",
               "Brasília-Zäit",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro-Zäit",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Kolumbianesch Normalzäit",
               "",
               "Kolumbianesch Summerzäit",
               "",
               "Kolumbianesch Zäit",
               "",
            };
        final String[] Falkland = new String[] {
               "Falklandinselen-Normalzäit",
               "",
               "Falklandinselen-Summerzäit",
               "",
               "Falklandinselen-Zäit",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malaysesch Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldiven-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulaanbaatar-Normalzäit",
               "",
               "Ulaanbaatar-Summerzäit",
               "",
               "Ulaanbaatar-Zäit",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pakistanesch Normalzäit",
               "PKT",
               "Pakistanesch Summerzäit",
               "PKST",
               "Pakistanesch Zäit",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Paraguayanesch Normalzäit",
               "",
               "Paraguayanesch Summerzäit",
               "",
               "Paraguayanesch Zäit",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitcairninselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Suriname-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentinesch Normalzäit",
               "",
               "Argentinesch Summerzäit",
               "",
               "Argentinesch Zäit",
               "",
            };
        final String[] Christmas = new String[] {
               "Chrëschtdagsinsel-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hong-Kong-Normalzäit",
               "HKT",
               "Hong-Kong-Summerzäit",
               "HKST",
               "Hong-Kong-Zäit",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Indochina-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Kamtschatka-Normalzäit",
               "",
               "Kamtschatka-Summerzäit",
               "",
               "Kamtschatka-Zäit",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Kirgisistan-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Howe-Normalzäit",
               "",
               "Lord-Howe-Summerzäit",
               "",
               "Lord-Howe-Zäit",
               "",
            };
        final String[] Marquesas = new String[] {
               "Marquesas-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mauritius-Normalzäit",
               "",
               "Mauritius-Summerzäit",
               "",
               "Mauritius-Zäit",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur-Standardzäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venezuela-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Aserbeidschanesch Normalzäit",
               "",
               "Aserbaidschanesch Summerzäit",
               "",
               "Aserbaidschanesch Zäit",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesch-Normalzäit",
               "",
               "Bangladesch-Summerzäit",
               "",
               "Bangladesch-Zäit",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kap-Verde-Normalzäit",
               "",
               "Kap-Verde-Summerzäit",
               "",
               "Kap-Verde-Zäit",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "Osttimor-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seychellen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tadschikistan-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Usbekistan-Normalzäit",
               "",
               "Usbekistan-Summerzäit",
               "",
               "Usbekistan-Zäit",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afghanistan-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk-Normalzäit",
               "",
               "Krasnojarsk-Summerzäit",
               "",
               "Krasnojarsk-Zäit",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Neiséiland-Normalzäit",
               "NZST",
               "Neiséiland-Summerzäit",
               "NZDT",
               "Neiséiland-Zäit",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Philippinnesch Normalzäit",
               "PST",
               "Philippinnesch Summerzäit",
               "PDT",
               "Philippinnesch Zäit",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Wladiwostok-Normalzäit",
               "",
               "Wladiwostok-Summerzäit",
               "",
               "Wladiwostok-Zäit",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Indeschen Ozean-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Linneninselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Neifundland-Normalzäit",
               "NST",
               "Neifundland-Summerzäit",
               "NDT",
               "Neifundland-Zäit",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmenistan-Normalzäit",
               "",
               "Turkmenistan-Summerzäit",
               "",
               "Turkmenistan-Zäit",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Franséisch-Guayane-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Neikaledonesch Normalzäit",
               "",
               "Neikaledonesch Summerzäit",
               "",
               "Neikaledonesch Zäit",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Südgeorgesch Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekaterinbuerg-Normalzäit",
               "",
               "Jekaterinbuerg-Summerzäit",
               "",
               "Jekaterinbuerg-Zäit",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Zentralafrikanesch Zäit",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Ostafrikanesch Zäit",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Westafrikanesch Zäit",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Dumont-d’Urville-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Mëtteleuropäesch Normalzäit",
               "CET",
               "Mëtteleuropäesch Summerzäit",
               "CEST",
               "Mëtteleuropäesch Zäit",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Osteuropäesch Normalzäit",
               "EET",
               "Osteuropäesch Summerzäit",
               "EEST",
               "Osteuropäesch Zäit",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Westeuropäesch Normalzäit",
               "WET",
               "Westeuropäesch Summerzäit",
               "WEST",
               "Westeuropäesch Zäit",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Mexikanesch Pazifik-Normalzäit",
               "MST",
               "Mexikanesch Pazifik-Summerzäit",
               "MDT",
               "Mexikanesch Pazifikzäit",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Südafrikanesch Zäit",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Nordamerikanesch Inland-Normalzäit",
               "CST",
               "Nordamerikanesch Inland-Summerzäit",
               "CDT",
               "Nordamerikanesch Inlandzäit",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Nordamerikanesch Ostküsten-Normalzäit",
               "EST",
               "Nordamerikanesch Ostküsten-Summerzäit",
               "EST",
               "Nordamerikanesch Ostküstenzäit",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Nordamerikanesch Westküsten-Normalzäit",
               "PST",
               "Nordamerikanesch Westküsten-Summerzäit",
               "PDT",
               "Nordamerikanesch Westküstenzäit",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Franséisch Süd- an Antarktisgebidder-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert-Inselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hawaii-Aleuten-Normalzäit",
               "HST",
               "Hawaii-Aleuten-Summerzäit",
               "HDT",
               "Hawaii-Aleuten-Zäit",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Phoenixinselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Saint-Pierre-a-Miquelon-Normalzäit",
               "",
               "Saint-Pierre-a-Miquelon-Summerzäit",
               "",
               "Saint-Pierre-a-Miquelon-Zäit",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Rocky-Mountain-Normalzäit",
               "MST",
               "Rocky-Mountain-Summerzäit",
               "MST",
               "Rocky-Mountain-Zäit",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshallinselen-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Neiguinea-Zäit",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Zentralaustralesch Normalzäit",
               "ACST",
               "Zentralaustralesch Summerzäit",
               "ACDT",
               "Zentralaustralesch Zäit",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Ostaustralesch Normalzäit",
               "AEST",
               "Ostaustralesch Summerzäit",
               "AEDT",
               "Ostaustralesch Zäit",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Westaustralesch Normalzäit",
               "AWST",
               "Westaustralesch Summerzäit",
               "AWDT",
               "Westaustralesch Zäit",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Zentralindonesesch Zäit",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Ostindonesesch Zäit",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Westindonesesch Zäit",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Zentral-/Westaustralesch Normalzäit",
               "",
               "Zentral-/Westaustralesch Summerzäit",
               "",
               "Zentral-/Westaustralesch Zäit",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Iresch Summerzäit",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Anadyr", Kamchatka },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Iresch Summerzäit",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Saratov", Samara },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Astrakhan", Samara },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Ulyanovsk", Samara },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Mëttler Greenwich-Zäit",
                    "GMT",
                    "Britesch Summerzäit",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aqtöbe" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Riyadh", "Riad" },
            { "timezone.excity.Asia/Saigon", "Ho-Chi-Minh-Stad" },
            { "timezone.excity.Asia/Taipei", "Taipeh" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Onbekannt" },
            { "timezone.excity.Europe/Kiev", "Kiew" },
            { "timezone.excity.Europe/Rome", "Roum" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bishkek", "Bischkek" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Tbilisi", "Tiflis" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Erivan" },
            { "timezone.excity.Pacific/Fiji", "Fidschi" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Dushanbe", "Duschanbe" },
            { "timezone.excity.Asia/Jayapura", "Port Numbay" },
            { "timezone.excity.Asia/Sakhalin", "Sachalin" },
            { "timezone.excity.Asia/Tashkent", "Taschkent" },
            { "timezone.excity.Europe/Athens", "Athen" },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Europe/Moscow", "Moskau" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Vienna", "Wien" },
            { "timezone.excity.Europe/Warsaw", "Warschau" },
            { "timezone.excity.Europe/Zurich", "Zürech" },
            { "timezone.excity.Indian/Comoro", "Komoren" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Alger" },
            { "timezone.excity.America/Cayman", "Kaimaninselen" },
            { "timezone.excity.America/Havana", "Havanna" },
            { "timezone.excity.Asia/Kamchatka", "Kamtschatka" },
            { "timezone.excity.Asia/Pyongyang", "Pjöngjang" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Vilnius", "Wilna" },
            { "timezone.excity.Pacific/Easter", "Ouschterinsel" },
            { "timezone.excity.Africa/Djibouti", "Dschibuti" },
            { "timezone.excity.Africa/Khartoum", "Khartum" },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Atlantic/Azores", "Azoren" },
            { "timezone.excity.Atlantic/Canary", "Kanaresch Inselen" },
            { "timezone.excity.Atlantic/Faeroe", "Färöer" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.Europe/Brussels", "Bréissel" },
            { "timezone.excity.Europe/Chisinau", "Kischinau" },
            { "timezone.excity.Indian/Maldives", "Maldiven" },
            { "timezone.excity.Africa/Mogadishu", "Mogadischu" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Novosibirsk", "Nowosibirsk" },
            { "timezone.excity.Asia/Vladivostok", "Wladiwostok" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.Europe/Volgograd", "Wolgograd" },
            { "timezone.excity.Indian/Christmas", "Chrëschtdagsinsel" },
            { "timezone.excity.Antarctica/Vostok", "Wostok" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Lëtzebuerg" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.Africa/Ouagadougou", "Wagadugu" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinbuerg" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Mexiko-Stad" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kap Verde" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Spain" },
            { "timezone.excity.America/St_Barthelemy", "Saint-Barthélemy" },
            { "timezone.excity.Atlantic/South_Georgia", "Südgeorgien" },
        };
        return data;
    }
}
