/* Generated by fuzzing - test hash_head == 0 handling. */

#include "zbuild.h"
#ifdef ZLIB_COMPAT
#  include "zlib.h"
#else
#  include "zlib-ng.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "test_shared.h"

#include <gtest/gtest.h>

TEST(deflate, hash_head_0) {
    PREFIX3(stream) strm;
    int err;

    memset(&strm, 0, sizeof(strm));
    err = PREFIX(deflateInit2)(&strm, 1, Z_DEFLATED, -15, 4, Z_HUFFMAN_ONLY);
    EXPECT_EQ(err, Z_OK);

    unsigned char next_in[9698];
    memset(next_in, 0x30, sizeof(next_in));
    next_in[8193] = 0x00;
    next_in[8194] = 0x00;
    next_in[8195] = 0x00;
    next_in[8199] = 0x8a;
    strm.next_in = next_in;
    unsigned char next_out[21572];
    strm.next_out = next_out;

    strm.avail_in = 0;
    strm.avail_out = 1348;
    err = PREFIX(deflateParams(&strm, 3, Z_FILTERED));
    EXPECT_EQ(err, Z_OK);

    strm.avail_in = 6728;
    strm.avail_out = 2696;
    err = PREFIX(deflate(&strm, Z_SYNC_FLUSH));
    EXPECT_EQ(err, Z_OK);

    strm.avail_in = 15;
    strm.avail_out = 1348;
    err = PREFIX(deflateParams(&strm, 9, Z_FILTERED));
    EXPECT_EQ(err, Z_OK);

    strm.avail_in = 1453;
    strm.avail_out = 1348;
    err = PREFIX(deflate(&strm, Z_FULL_FLUSH));
    EXPECT_EQ(err, Z_OK);

    strm.avail_in = (uint32_t)(next_in + sizeof(next_in) - strm.next_in);
    strm.avail_out = (uint32_t)(next_out + sizeof(next_out) - strm.next_out);
    err = PREFIX(deflate)(&strm, Z_FINISH);
    EXPECT_EQ(err, Z_STREAM_END);

    uint32_t compressed_size = (uint32_t)(strm.next_out - next_out);

    err = PREFIX(deflateEnd)(&strm);
    EXPECT_EQ(err, Z_OK);

    memset(&strm, 0, sizeof(strm));
    err = PREFIX(inflateInit2)(&strm, -15);
    EXPECT_EQ(err, Z_OK);

    strm.next_in = next_out;
    strm.avail_in = compressed_size;
    unsigned char uncompressed[sizeof(next_in)];
    strm.next_out = uncompressed;
    strm.avail_out = sizeof(uncompressed);

    err = PREFIX(inflate)(&strm, Z_NO_FLUSH);
    EXPECT_EQ(err, Z_STREAM_END);

    err = PREFIX(inflateEnd)(&strm);
    EXPECT_EQ(err, Z_OK);

    EXPECT_TRUE(memcmp(uncompressed, next_in, sizeof(uncompressed)) == 0);
}
