//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-audio-types")]
use objc2_core_audio_types::*;

use crate::*;

/// This flag is set in a call to AudioFileStream_PropertyListenerProc when the value of the property
/// can be obtained at any later time. If this flag is not set, then you should either get the value of
/// the property from within this callback or set the flag kAudioFileStreamPropertyFlag_CacheProperty in order to signal
/// to the parser to begin caching the property data. Otherwise the value may not be available in the future.
///
///
/// This flag can be set by a property listener in order to signal to the parser that the client is
/// interested in the value of the property and that it should be cached until the full value of the property is available.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestreampropertyflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioFileStreamPropertyFlags(pub u32);
bitflags::bitflags! {
    impl AudioFileStreamPropertyFlags: u32 {
        #[doc(alias = "kAudioFileStreamPropertyFlag_PropertyIsCached")]
        const PropertyIsCached = 1;
        #[doc(alias = "kAudioFileStreamPropertyFlag_CacheProperty")]
        const CacheProperty = 2;
    }
}

unsafe impl Encode for AudioFileStreamPropertyFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioFileStreamPropertyFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This flag is passed in to AudioFileStreamParseBytes to signal a discontinuity. Any partial packet straddling a buffer
/// boundary will be discarded. This is necessary to avoid being called with a corrupt packet. After a discontinuity occurs
/// seeking may be approximate in some data formats.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestreamparseflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioFileStreamParseFlags(pub u32);
bitflags::bitflags! {
    impl AudioFileStreamParseFlags: u32 {
        #[doc(alias = "kAudioFileStreamParseFlag_Discontinuity")]
        const Discontinuity = 1;
    }
}

unsafe impl Encode for AudioFileStreamParseFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioFileStreamParseFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// This flag may be returned from AudioFileStreamSeek if the byte offset is only an estimate, not exact.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestreamseekflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct AudioFileStreamSeekFlags(pub u32);
bitflags::bitflags! {
    impl AudioFileStreamSeekFlags: u32 {
        #[doc(alias = "kAudioFileStreamSeekFlag_OffsetIsEstimated")]
        const OffsetIsEstimated = 1;
    }
}

unsafe impl Encode for AudioFileStreamSeekFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for AudioFileStreamSeekFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestreampropertyid?language=objc)
pub type AudioFileStreamPropertyID = u32;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/opaqueaudiofilestreamid?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct OpaqueAudioFileStreamID {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

unsafe impl RefEncode for OpaqueAudioFileStreamID {
    const ENCODING_REF: Encoding =
        Encoding::Pointer(&Encoding::Struct("OpaqueAudioFileStreamID", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestreamid?language=objc)
pub type AudioFileStreamID = *mut OpaqueAudioFileStreamID;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestream_propertylistenerproc?language=objc)
pub type AudioFileStream_PropertyListenerProc = Option<
    unsafe extern "C-unwind" fn(
        NonNull<c_void>,
        AudioFileStreamID,
        AudioFileStreamPropertyID,
        NonNull<AudioFileStreamPropertyFlags>,
    ),
>;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/audiofilestream_packetsproc?language=objc)
#[cfg(feature = "objc2-core-audio-types")]
pub type AudioFileStream_PacketsProc = Option<
    unsafe extern "C-unwind" fn(
        NonNull<c_void>,
        u32,
        u32,
        NonNull<c_void>,
        *mut AudioStreamPacketDescription,
    ),
>;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_unsupportedfiletype?language=objc)
pub const kAudioFileStreamError_UnsupportedFileType: OSStatus = 0x7479703f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_unsupporteddataformat?language=objc)
pub const kAudioFileStreamError_UnsupportedDataFormat: OSStatus = 0x666d743f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_unsupportedproperty?language=objc)
pub const kAudioFileStreamError_UnsupportedProperty: OSStatus = 0x7074793f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_badpropertysize?language=objc)
pub const kAudioFileStreamError_BadPropertySize: OSStatus = 0x2173697a;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_notoptimized?language=objc)
pub const kAudioFileStreamError_NotOptimized: OSStatus = 0x6f70746d;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_invalidpacketoffset?language=objc)
pub const kAudioFileStreamError_InvalidPacketOffset: OSStatus = 0x70636b3f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_invalidfile?language=objc)
pub const kAudioFileStreamError_InvalidFile: OSStatus = 0x6474613f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_valueunknown?language=objc)
pub const kAudioFileStreamError_ValueUnknown: OSStatus = 0x756e6b3f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_dataunavailable?language=objc)
pub const kAudioFileStreamError_DataUnavailable: OSStatus = 0x6d6f7265;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_illegaloperation?language=objc)
pub const kAudioFileStreamError_IllegalOperation: OSStatus = 0x6e6f7065;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_unspecifiederror?language=objc)
pub const kAudioFileStreamError_UnspecifiedError: OSStatus = 0x7768743f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamerror_discontinuitycantrecover?language=objc)
pub const kAudioFileStreamError_DiscontinuityCantRecover: OSStatus = 0x64736321;

/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_readytoproducepackets?language=objc)
pub const kAudioFileStreamProperty_ReadyToProducePackets: AudioFileStreamPropertyID = 0x72656479;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_fileformat?language=objc)
pub const kAudioFileStreamProperty_FileFormat: AudioFileStreamPropertyID = 0x66666d74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_dataformat?language=objc)
pub const kAudioFileStreamProperty_DataFormat: AudioFileStreamPropertyID = 0x64666d74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_formatlist?language=objc)
pub const kAudioFileStreamProperty_FormatList: AudioFileStreamPropertyID = 0x666c7374;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_magiccookiedata?language=objc)
pub const kAudioFileStreamProperty_MagicCookieData: AudioFileStreamPropertyID = 0x6d676963;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_audiodatabytecount?language=objc)
pub const kAudioFileStreamProperty_AudioDataByteCount: AudioFileStreamPropertyID = 0x62636e74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_audiodatapacketcount?language=objc)
pub const kAudioFileStreamProperty_AudioDataPacketCount: AudioFileStreamPropertyID = 0x70636e74;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_maximumpacketsize?language=objc)
pub const kAudioFileStreamProperty_MaximumPacketSize: AudioFileStreamPropertyID = 0x70737a65;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_dataoffset?language=objc)
pub const kAudioFileStreamProperty_DataOffset: AudioFileStreamPropertyID = 0x646f6666;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_channellayout?language=objc)
pub const kAudioFileStreamProperty_ChannelLayout: AudioFileStreamPropertyID = 0x636d6170;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_packettoframe?language=objc)
pub const kAudioFileStreamProperty_PacketToFrame: AudioFileStreamPropertyID = 0x706b6672;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_frametopacket?language=objc)
pub const kAudioFileStreamProperty_FrameToPacket: AudioFileStreamPropertyID = 0x6672706b;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_restrictsrandomaccess?language=objc)
pub const kAudioFileStreamProperty_RestrictsRandomAccess: AudioFileStreamPropertyID = 0x72726170;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_packettorolldistance?language=objc)
pub const kAudioFileStreamProperty_PacketToRollDistance: AudioFileStreamPropertyID = 0x706b726c;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_previousindependentpacket?language=objc)
pub const kAudioFileStreamProperty_PreviousIndependentPacket: AudioFileStreamPropertyID =
    0x70696e64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_nextindependentpacket?language=objc)
pub const kAudioFileStreamProperty_NextIndependentPacket: AudioFileStreamPropertyID = 0x6e696e64;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_packettodependencyinfo?language=objc)
pub const kAudioFileStreamProperty_PacketToDependencyInfo: AudioFileStreamPropertyID = 0x706b6470;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_packettobyte?language=objc)
pub const kAudioFileStreamProperty_PacketToByte: AudioFileStreamPropertyID = 0x706b6279;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_bytetopacket?language=objc)
pub const kAudioFileStreamProperty_ByteToPacket: AudioFileStreamPropertyID = 0x6279706b;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_packettableinfo?language=objc)
pub const kAudioFileStreamProperty_PacketTableInfo: AudioFileStreamPropertyID = 0x706e666f;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_packetsizeupperbound?language=objc)
pub const kAudioFileStreamProperty_PacketSizeUpperBound: AudioFileStreamPropertyID = 0x706b7562;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_averagebytesperpacket?language=objc)
pub const kAudioFileStreamProperty_AverageBytesPerPacket: AudioFileStreamPropertyID = 0x61627070;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_bitrate?language=objc)
pub const kAudioFileStreamProperty_BitRate: AudioFileStreamPropertyID = 0x62726174;
/// [Apple's documentation](https://developer.apple.com/documentation/audiotoolbox/kaudiofilestreamproperty_infodictionary?language=objc)
pub const kAudioFileStreamProperty_InfoDictionary: AudioFileStreamPropertyID = 0x696e666f;

extern "C-unwind" {
    /// Create a new audio file stream parser.
    /// The client provides the parser with data and the parser calls
    /// callbacks when interesting things are found in the data, such as properties and
    /// audio packets.
    ///
    ///
    /// Parameter `inClientData`: a constant that will be passed to your callbacks.
    ///
    /// Parameter `inPropertyListenerProc`: Whenever the value of a property is parsed in the data, this function will be called.
    /// You can then get the value of the property from in the callback. In some cases, due to
    /// boundaries in the input data, the property may return kAudioFileStreamError_DataUnavailable.
    /// When unavailable data is requested from within the property listener, the parser will begin
    /// caching the property value and will call the property listener again when the property is
    /// available. For property values for which kAudioFileStreamPropertyFlag_PropertyIsCached is unset, this
    /// will be the only opportunity to get the value of the property, since the data will be
    /// disposed upon return of the property listener callback.
    ///
    /// Parameter `inPacketsProc`: Whenever packets are parsed in the data, a pointer to the packets is passed to the client
    /// using this callback. At times only a single packet may be passed due to boundaries in the
    /// input data.
    ///
    /// Parameter `inFileTypeHint`: For files whose type cannot be easily or uniquely determined from the data (ADTS,AC3),
    /// this hint can be used to indicate the file type.
    /// Otherwise if you do not know the file type, you can pass zero.
    ///
    /// Parameter `outAudioFileStream`: A new file stream ID for use in other AudioFileStream API calls.
    ///
    /// # Safety
    ///
    /// - `in_client_data` must be a valid pointer or null.
    /// - `in_property_listener_proc` must be implemented correctly.
    /// - `in_packets_proc` must be implemented correctly.
    /// - `out_audio_file_stream` must be a valid pointer.
    #[cfg(all(feature = "AudioFile", feature = "objc2-core-audio-types"))]
    pub fn AudioFileStreamOpen(
        in_client_data: *mut c_void,
        in_property_listener_proc: AudioFileStream_PropertyListenerProc,
        in_packets_proc: AudioFileStream_PacketsProc,
        in_file_type_hint: AudioFileTypeID,
        out_audio_file_stream: NonNull<AudioFileStreamID>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// This call is the means for streams to supply data to the parser.
    /// Data is expected to be passed in sequentially from the beginning of the file, without gaps.
    /// In the course of parsing, the client's property and/or packets callbacks may be called.
    /// At the end of the stream, this function must be called once with null data pointer and zero
    /// data byte size to flush any remaining packets out of the parser.
    ///
    ///
    /// Parameter `inAudioFileStream`: The file stream ID
    ///
    /// Parameter `inDataByteSize`: The number of bytes passed in for parsing. Must be zero when flushing the parser.
    ///
    /// Parameter `inData`: The data passed in to be parsed. Must be null when flushing the parser.
    ///
    /// Parameter `inFlags`: If there is a data discontinuity, then kAudioFileStreamParseFlag_Discontinuity should be set true.
    ///
    /// # Safety
    ///
    /// - `in_audio_file_stream` must be a valid pointer.
    /// - `in_data` must be a valid pointer or null.
    pub fn AudioFileStreamParseBytes(
        in_audio_file_stream: AudioFileStreamID,
        in_data_byte_size: u32,
        in_data: *const c_void,
        in_flags: AudioFileStreamParseFlags,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// This call is used to seek in the data stream. The client passes in a packet
    /// offset to seek to and the parser passes back a byte offset from which to
    /// get the data to satisfy that request. The data passed to the next call to
    /// AudioFileParseBytes will be assumed to be from that byte offset.
    /// For file formats which do not contain packet tables the byte offset may
    /// be an estimate. If so, the flag kAudioFileStreamSeekFlag_OffsetIsEstimated will be true.
    ///
    ///
    /// Parameter `inAudioFileStream`: The file stream ID
    ///
    /// Parameter `inPacketOffset`: The offset from the beginning of the file of the packet to which to seek.
    ///
    /// Parameter `outDataByteOffset`: The byte offset of the data from the file's data offset returned.
    /// You need to add the value of kAudioFileStreamProperty_DataOffset to get an absolute byte offset in the file.
    ///
    /// Parameter `ioFlags`: If outDataByteOffset is an estimate, then kAudioFileStreamSeekFlag_OffsetIsEstimated will be set on output.
    /// There are currently no flags defined for passing into this call.
    ///
    /// # Safety
    ///
    /// - `in_audio_file_stream` must be a valid pointer.
    /// - `out_data_byte_offset` must be a valid pointer.
    /// - `io_flags` must be a valid pointer.
    pub fn AudioFileStreamSeek(
        in_audio_file_stream: AudioFileStreamID,
        in_packet_offset: i64,
        out_data_byte_offset: NonNull<i64>,
        io_flags: NonNull<AudioFileStreamSeekFlags>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve the info about the given property. The outSize argument
    /// will return the size in bytes of the current value of the property.
    ///
    ///
    /// Parameter `inAudioFileStream`: The file stream ID
    ///
    /// Parameter `inPropertyID`: Property ID whose value should be read
    ///
    /// Parameter `outPropertyDataSize`: Size in bytes of the property
    ///
    /// Parameter `outWritable`: whether the property is writable
    ///
    ///
    /// Returns: an OSStatus return code
    ///
    /// # Safety
    ///
    /// - `in_audio_file_stream` must be a valid pointer.
    /// - `out_property_data_size` must be a valid pointer or null.
    /// - `out_writable` must be a valid pointer or null.
    pub fn AudioFileStreamGetPropertyInfo(
        in_audio_file_stream: AudioFileStreamID,
        in_property_id: AudioFileStreamPropertyID,
        out_property_data_size: *mut u32,
        out_writable: *mut Boolean,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Retrieve the indicated property data.
    ///
    ///
    /// Parameter `inAudioFileStream`: The file stream ID
    ///
    /// Parameter `inPropertyID`: Property ID whose value should be read
    ///
    /// Parameter `ioPropertyDataSize`: On input, the size of the buffer pointed to by outPropertyData. On output,
    /// the number of bytes written.
    ///
    /// Parameter `outPropertyData`: Pointer to the property data buffer
    ///
    ///
    /// Returns: an OSStatus return code
    ///
    /// # Safety
    ///
    /// - `in_audio_file_stream` must be a valid pointer.
    /// - `io_property_data_size` must be a valid pointer.
    /// - `out_property_data` must be a valid pointer.
    pub fn AudioFileStreamGetProperty(
        in_audio_file_stream: AudioFileStreamID,
        in_property_id: AudioFileStreamPropertyID,
        io_property_data_size: NonNull<u32>,
        out_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Set the value of the property. There are currently no settable properties.
    ///
    ///
    /// Parameter `inAudioFileStream`: The file stream ID
    ///
    /// Parameter `inPropertyID`: Property ID whose value should be set
    ///
    /// Parameter `inPropertyDataSize`: Size in bytes of the property data
    ///
    /// Parameter `inPropertyData`: Pointer to the property data buffer
    ///
    ///
    /// Returns: an OSStatus return code
    ///
    /// # Safety
    ///
    /// - `in_audio_file_stream` must be a valid pointer.
    /// - `in_property_data` must be a valid pointer.
    pub fn AudioFileStreamSetProperty(
        in_audio_file_stream: AudioFileStreamID,
        in_property_id: AudioFileStreamPropertyID,
        in_property_data_size: u32,
        in_property_data: NonNull<c_void>,
    ) -> OSStatus;
}

extern "C-unwind" {
    /// Close and deallocate the file stream object.
    ///
    ///
    /// Parameter `inAudioFileStream`: The file stream ID
    ///
    /// # Safety
    ///
    /// `in_audio_file_stream` must be a valid pointer.
    pub fn AudioFileStreamClose(in_audio_file_stream: AudioFileStreamID) -> OSStatus;
}
