/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.util.HashSet;
import java.util.Set;
import org.jkiss.code.Nullable;

public enum RMProjectPermission {
    DATA_SOURCES_VIEW("project-datasource-view"),
    DATA_SOURCES_EDIT("project-datasource-edit", Set.of(DATA_SOURCES_VIEW)),
    RESOURCE_VIEW("project-resource-view"),
    RESOURCE_EDIT("project-resource-edit", Set.of(RESOURCE_VIEW)),
    TASK_MANAGER("task-manager"),
    PROJECT_ADMIN("project-admin", Set.of(RESOURCE_EDIT, DATA_SOURCES_EDIT, TASK_MANAGER));

    private final String permission;
    private final Set<RMProjectPermission> childPermissions;

    private RMProjectPermission(String permission) {
        this(permission, Set.of());
    }

    private RMProjectPermission(String permission, Set<RMProjectPermission> childPermissions) {
        this.permission = permission;
        this.childPermissions = childPermissions;
    }

    @Nullable
    public static RMProjectPermission fromPermission(String permission) {
        RMProjectPermission[] rMProjectPermissionArray = RMProjectPermission.values();
        int n = rMProjectPermissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            RMProjectPermission projectPermission = rMProjectPermissionArray[n2];
            if (projectPermission.permission.equals(permission)) {
                return projectPermission;
            }
            ++n2;
        }
        return null;
    }

    public String getPermissionId() {
        return this.permission;
    }

    public Set<String> getAllPermissions() {
        HashSet<String> allPermissions = new HashSet<String>();
        allPermissions.add(this.permission);
        for (RMProjectPermission childPermission : this.childPermissions) {
            allPermissions.addAll(childPermission.getAllPermissions());
        }
        return allPermissions;
    }
}

