/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceMap;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class TaskPreferenceStore
extends AbstractPreferenceStore
implements DBPPreferenceMap {
    private final DBPPreferenceStore parentStore = DBWorkbench.getPlatform().getPreferenceStore();
    private final DBTTask task;
    private final Map<String, Object> properties;
    private boolean dirty = false;

    public TaskPreferenceStore(@NotNull DBTTask task) {
        this.task = task;
        this.properties = new LinkedHashMap<String, Object>(task.getProperties());
    }

    public TaskPreferenceStore(@NotNull Map<String, Object> properties) {
        this.task = null;
        this.properties = properties;
    }

    @Nullable
    public DBPPreferenceStore getParentStore() {
        return this.parentStore;
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void save() throws IOException {
        if (this.task != null) {
            this.task.setProperties(this.properties);
        }
    }

    public boolean contains(@NotNull String name) {
        return this.properties.containsKey(name);
    }

    public boolean getBoolean(@NotNull String name) {
        return CommonUtils.toBoolean((Object)this.getValue(name));
    }

    public boolean getDefaultBoolean(@NotNull String name) {
        return CommonUtils.toBoolean((Object)this.getValue(name));
    }

    public double getDouble(@NotNull String name) {
        return CommonUtils.toDouble((Object)this.getValue(name));
    }

    public double getDefaultDouble(@NotNull String name) {
        return CommonUtils.toDouble((Object)this.getValue(name));
    }

    public float getFloat(@NotNull String name) {
        return (float)CommonUtils.toDouble((Object)this.getValue(name));
    }

    public float getDefaultFloat(@NotNull String name) {
        return this.getFloat(name);
    }

    public int getInt(@NotNull String name) {
        return CommonUtils.toInt((Object)this.getValue(name));
    }

    public int getDefaultInt(@NotNull String name) {
        return this.getInt(name);
    }

    public long getLong(@NotNull String name) {
        return CommonUtils.toLong((Object)this.getValue(name));
    }

    public long getDefaultLong(@NotNull String name) {
        return this.getLong(name);
    }

    public String getString(@NotNull String name) {
        return CommonUtils.toString((Object)this.getValue(name));
    }

    @Nullable
    public Object getValue(String name) {
        Object value = this.properties.get(name);
        if (value == null) {
            value = this.parentStore.getString(name);
        }
        return value;
    }

    public String getDefaultString(@NotNull String name) {
        return this.getString(name);
    }

    public boolean isDefault(@NotNull String name) {
        return false;
    }

    public boolean isSet(String name) {
        return this.properties.containsKey(name);
    }

    public boolean needsSaving() {
        return this.dirty;
    }

    public void setDefault(@NotNull String name, double value) {
    }

    public void setDefault(@NotNull String name, float value) {
    }

    public void setDefault(@NotNull String name, int value) {
    }

    public void setDefault(@NotNull String name, long value) {
    }

    public void setDefault(@NotNull String name, @Nullable String value) {
    }

    public void setDefault(@NotNull String name, boolean value) {
    }

    public void setToDefault(@NotNull String name) {
        Object oldValue = this.properties.get(name);
        this.properties.remove(name);
        this.dirty = true;
        this.firePropertyChangeEvent(name, oldValue, null);
    }

    public void setValue(@NotNull String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(@NotNull String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, Float.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, Float.valueOf(oldValue), Float.valueOf(value));
        }
    }

    public void setValue(@NotNull String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(@NotNull String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(@NotNull String name, @Nullable String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value) || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    public void setValue(@NotNull String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TaskPreferenceStore)) {
            return false;
        }
        TaskPreferenceStore copy = (TaskPreferenceStore)((Object)obj);
        return CommonUtils.equalObjects((Object)this.parentStore, (Object)copy.parentStore) && CommonUtils.equalObjects(this.properties, copy.properties);
    }

    @Nullable
    public <T> T getObject(String name) {
        return (T)this.properties.get(name);
    }

    public Map<String, Object> getPropertyMap() {
        return this.properties;
    }
}

