/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;

public class ZoomComboContributionItem
extends ContributionItem
implements ZoomListener {
    private boolean forceSetText;
    private Combo combo;
    private final String[] initStrings;
    private ToolItem toolitem;
    private ZoomManager zoomManager;
    private final IPartService service;
    private IPartListener partListener;

    public ZoomComboContributionItem(IPartService partService) {
        this(partService, "8888%");
    }

    public ZoomComboContributionItem(IPartService partService, String initString) {
        this(partService, new String[]{initString});
    }

    public ZoomComboContributionItem(IPartService partService, String[] initStrings) {
        super("org.eclipse.gef.zoom_widget");
        this.initStrings = initStrings;
        this.service = partService;
        Assert.isNotNull((Object)partService);
        this.partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                ZoomComboContributionItem.this.setZoomManager((ZoomManager)((Object)part.getAdapter(ZoomManager.class)));
            }

            public void partBroughtToTop(IWorkbenchPart p) {
            }

            public void partClosed(IWorkbenchPart p) {
            }

            public void partDeactivated(IWorkbenchPart p) {
            }

            public void partOpened(IWorkbenchPart p) {
            }
        };
        partService.addPartListener(this.partListener);
    }

    private void refresh(boolean repopulateCombo) {
        block8: {
            if (this.combo == null || this.combo.isDisposed()) {
                return;
            }
            try {
                if (this.zoomManager == null) {
                    this.combo.setEnabled(false);
                    this.combo.setText("");
                } else {
                    String zoom;
                    int index;
                    if (repopulateCombo) {
                        this.combo.setItems(this.getZoomManager().getZoomLevelsAsText());
                    }
                    if ((index = this.combo.indexOf(zoom = this.getZoomManager().getZoomAsText())) == -1 || this.forceSetText) {
                        this.combo.setText(zoom);
                    } else {
                        this.combo.select(index);
                    }
                    this.combo.setEnabled(true);
                }
            }
            catch (SWTException exception) {
                if (SWT.getPlatform().equals("gtk")) break block8;
                throw exception;
            }
        }
    }

    protected int computeWidth(Control control) {
        return control.computeSize((int)-1, (int)-1, (boolean)true).x;
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ZoomComboContributionItem.this.handleWidgetSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ZoomComboContributionItem.this.handleWidgetDefaultSelected(e);
            }
        });
        this.combo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ZoomComboContributionItem.this.refresh(false);
            }
        });
        this.combo.setItems(this.initStrings);
        this.toolitem.setWidth(this.computeWidth((Control)this.combo));
        this.refresh(true);
        return this.combo;
    }

    public void dispose() {
        if (this.partListener == null) {
            return;
        }
        this.service.removePartListener(this.partListener);
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener(this);
            this.zoomManager = null;
        }
        this.combo = null;
        this.partListener = null;
    }

    public final void fill(Composite parent) {
        this.createControl(parent);
    }

    public final void fill(Menu parent, int index) {
        Assert.isTrue((boolean)false, (String)"Can't add a control to a menu");
    }

    public void fill(ToolBar parent, int index) {
        this.toolitem = new ToolItem(parent, 2, index);
        Control control = this.createControl((Composite)parent);
        this.toolitem.setControl(control);
    }

    public ZoomManager getZoomManager() {
        return this.zoomManager;
    }

    public void setZoomManager(ZoomManager zm) {
        if (this.zoomManager == zm) {
            return;
        }
        if (this.zoomManager != null) {
            this.zoomManager.removeZoomListener(this);
        }
        this.zoomManager = zm;
        this.refresh(true);
        if (this.zoomManager != null) {
            this.zoomManager.addZoomListener(this);
        }
    }

    private void handleWidgetDefaultSelected(SelectionEvent event) {
        if (this.zoomManager != null) {
            if (this.combo.getSelectionIndex() >= 0) {
                this.zoomManager.setZoomAsText(this.combo.getItem(this.combo.getSelectionIndex()));
            } else {
                this.zoomManager.setZoomAsText(this.combo.getText());
            }
        }
        this.refresh(false);
    }

    private void handleWidgetSelected(SelectionEvent event) {
        this.forceSetText = true;
        this.handleWidgetDefaultSelected(event);
        this.forceSetText = false;
    }

    public void zoomChanged(double zoom) {
        this.refresh(false);
    }
}

