/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.utils.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.Base64;
import org.jkiss.utils.xml.XMLConstants;
import org.jkiss.utils.xml.XMLUtils;

public class XMLBuilder {
    private static final int STATE_NOTHING = 0;
    private static final int STATE_ELEM_OPENED = 1;
    private static final int STATE_TEXT_ADDED = 2;
    private static final int IO_BUFFER_SIZE = 8192;
    private Writer writer;
    private int state = 0;
    private Element element = null;
    private boolean beautify = false;
    private final List<Element> trashElements = new ArrayList<Element>();

    public XMLBuilder(@NotNull OutputStream stream, @Nullable String documentEncoding) throws IOException {
        this(stream, documentEncoding, true);
    }

    public XMLBuilder(@NotNull OutputStream stream, @Nullable String documentEncoding, boolean printHeader) throws IOException {
        if (documentEncoding == null) {
            this.init(new OutputStreamWriter(stream), null, printHeader);
        } else {
            this.init(new OutputStreamWriter(stream, documentEncoding), documentEncoding, printHeader);
        }
    }

    public XMLBuilder(@NotNull Writer writer, @Nullable String documentEncoding) throws IOException {
        this(writer, documentEncoding, true);
    }

    public XMLBuilder(@NotNull Writer writer, @Nullable String documentEncoding, boolean printHeader) throws IOException {
        this.init(writer, documentEncoding, printHeader);
    }

    @NotNull
    private Element createElement(@NotNull Element parent, @NotNull String name) {
        if (this.trashElements.isEmpty()) {
            return new Element(parent, name);
        }
        Element element = this.trashElements.remove(this.trashElements.size() - 1);
        element.init(parent, name);
        return element;
    }

    private void deleteElement(@NotNull Element element) {
        this.trashElements.add(element);
    }

    private void init(@NotNull Writer writer, @Nullable String documentEncoding, boolean printHeader) throws IOException {
        this.writer = new BufferedWriter(writer, 8192);
        if (printHeader) {
            if (documentEncoding != null) {
                this.writer.write(XMLConstants.XML_HEADER(documentEncoding));
            } else {
                this.writer.write(XMLConstants.XML_HEADER());
            }
        }
    }

    public boolean isBeautify() {
        return this.beautify;
    }

    public void setBeautify(boolean beautify) {
        this.beautify = beautify;
    }

    @NotNull
    public Element startElement(@NotNull String elementName) throws IOException {
        return this.startElement(null, null, elementName);
    }

    @NotNull
    public Element startElement(@Nullable String nsURI, @NotNull String elementName) throws IOException {
        return this.startElement(nsURI, null, elementName);
    }

    @NotNull
    public Element startElement(@Nullable String nsURI, @Nullable String nsPrefix, @NotNull String elementName) throws IOException {
        boolean addNamespace;
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: {
                if (!this.beautify) break;
                this.writer.write(10);
                break;
            }
        }
        if (this.beautify && this.element != null) {
            int i = 0;
            while (i <= this.element.getLevel()) {
                this.writer.write(9);
                ++i;
            }
        }
        this.writer.write(60);
        boolean bl = addNamespace = nsURI != null;
        if (nsURI != null && nsPrefix == null && this.element != null && (nsPrefix = this.element.getNamespacePrefix(nsURI)) != null) {
            addNamespace = false;
        }
        if (nsPrefix != null) {
            elementName = nsPrefix + ":" + (String)elementName;
        }
        this.writer.write((String)elementName);
        this.state = 1;
        this.element = this.createElement(this.element, (String)elementName);
        if (addNamespace) {
            this.addNamespace(nsURI, nsPrefix);
            this.element.addNamespace(nsURI, nsPrefix);
        }
        return this.element;
    }

    @NotNull
    public XMLBuilder endElement() throws IOException, IllegalStateException {
        if (this.element == null) {
            throw new IllegalStateException("Close tag without open");
        }
        switch (this.state) {
            case 1: {
                this.writer.write("/>");
                break;
            }
            case 0: {
                if (this.beautify) {
                    this.writer.write(10);
                    int i = 0;
                    while (i < this.element.getLevel()) {
                        this.writer.write(9);
                        ++i;
                    }
                }
            }
            case 2: {
                this.writer.write("</");
                this.writer.write(this.element.getName());
                this.writer.write(62);
            }
        }
        this.deleteElement(this.element);
        this.element = this.element.parent;
        this.state = 0;
        return this;
    }

    @NotNull
    public XMLBuilder addNamespace(@NotNull String nsURI) throws IOException {
        return this.addNamespace(nsURI, null);
    }

    @NotNull
    public XMLBuilder addNamespace(@NotNull String nsURI, @Nullable String nsPrefix) throws IOException, IllegalStateException {
        if (this.element == null) {
            throw new IllegalStateException("Namespace outside of element");
        }
        Object attrName = "xmlns";
        if (nsPrefix != null) {
            attrName = (String)attrName + ":" + nsPrefix;
            this.element.addNamespace(nsURI, nsPrefix);
        }
        this.addAttribute(null, (String)attrName, nsURI, true);
        return this;
    }

    @NotNull
    public XMLBuilder addAttribute(@NotNull String attributeName, @Nullable String attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, attributeValue, true);
    }

    @NotNull
    public XMLBuilder addAttribute(@NotNull String attributeName, int attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    @NotNull
    public XMLBuilder addAttribute(String attributeName, long attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    public XMLBuilder addAttribute(String attributeName, boolean attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    @NotNull
    public XMLBuilder addAttribute(@NotNull String attributeName, float attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    @NotNull
    public XMLBuilder addAttribute(@NotNull String attributeName, double attributeValue) throws IOException {
        return this.addAttribute(null, attributeName, String.valueOf(attributeValue), false);
    }

    @NotNull
    public XMLBuilder addAttribute(@Nullable String nsURI, @NotNull String attributeName, @Nullable String attributeValue) throws IOException {
        return this.addAttribute(nsURI, attributeName, attributeValue, true);
    }

    @NotNull
    private XMLBuilder addAttribute(@Nullable String nsURI, @NotNull String attributeName, @Nullable String attributeValue, boolean escape) throws IOException, IllegalStateException {
        switch (this.state) {
            case 1: {
                if (nsURI != null) {
                    String nsPrefix = this.element.getNamespacePrefix(nsURI);
                    if (nsPrefix == null) {
                        throw new IllegalStateException("Unknown attribute '" + (String)attributeName + "' namespace URI '" + nsURI + "' in element '" + this.element.getName() + "'");
                    }
                    attributeName = nsPrefix + ":" + (String)attributeName;
                }
                this.writer.write(32);
                this.writer.write((String)attributeName);
                this.writer.write("=\"");
                if (attributeValue != null) {
                    this.writer.write(escape ? XMLUtils.escapeXml(attributeValue) : attributeValue);
                }
                this.writer.write(34);
                break;
            }
            case 0: 
            case 2: {
                throw new IllegalStateException("Attribute outside of element");
            }
        }
        return this;
    }

    @NotNull
    public XMLBuilder addText(@NotNull CharSequence textValue) throws IOException {
        return this.addText(textValue, true);
    }

    @NotNull
    public XMLBuilder addText(@NotNull CharSequence textValue, boolean escape) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        this.writeText(textValue, escape);
        this.state = 2;
        return this;
    }

    @NotNull
    public XMLBuilder addText(@NotNull Reader reader) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        this.writer.write("<![CDATA[");
        char[] writeBuffer = new char[8192];
        int br = reader.read(writeBuffer);
        while (br != -1) {
            this.writer.write(new String(writeBuffer, 0, br));
            br = reader.read(writeBuffer);
        }
        this.writer.write("]]>");
        this.state = 2;
        return this;
    }

    @NotNull
    public XMLBuilder addTextData(@NotNull String text) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        this.writer.write("<![CDATA[");
        this.writer.write(text);
        this.writer.write("]]>");
        this.state = 2;
        return this;
    }

    @NotNull
    public XMLBuilder addBinary(@NotNull InputStream stream, int length) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        Base64.encode(stream, (long)length, this.writer);
        this.state = 2;
        return this;
    }

    @NotNull
    public XMLBuilder addBinary(@NotNull byte[] buffer) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: 
            case 2: {
                break;
            }
        }
        Base64.encode(buffer, 0, buffer.length, this.writer);
        this.state = 2;
        return this;
    }

    @NotNull
    public XMLBuilder addContent(@NotNull CharSequence textValue) throws IOException {
        this.writer.write(textValue.toString());
        return this;
    }

    @NotNull
    public XMLBuilder addComment(@NotNull String commentValue) throws IOException {
        switch (this.state) {
            case 1: {
                this.writer.write(62);
            }
            case 0: {
                if (!this.beautify) break;
                this.writer.write(10);
                break;
            }
        }
        this.writer.write("<!--");
        this.writer.write(commentValue);
        this.writer.write("-->");
        if (this.beautify) {
            this.writer.write(10);
        }
        this.state = 2;
        return this;
    }

    @NotNull
    public XMLBuilder addElement(@NotNull String elementName, @NotNull String elementValue) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Element ignored = this.startElement(elementName);){
            this.addText(elementValue);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this;
    }

    @NotNull
    public XMLBuilder addElementText(String elementName, String elementValue) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Element ignored = this.startElement(elementName);){
            this.addTextData(elementValue);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this;
    }

    @NotNull
    public XMLBuilder flush() throws IOException {
        this.writer.flush();
        return this;
    }

    @NotNull
    private XMLBuilder writeText(@Nullable CharSequence textValue, boolean escape) throws IOException {
        if (textValue != null) {
            this.writer.write(escape ? XMLUtils.escapeXml(textValue) : textValue.toString());
        }
        return this;
    }

    public final class Element
    implements AutoCloseable {
        private Element parent;
        private String name;
        private Map<String, String> nsStack = null;
        private int level;

        Element(Element parent, String name) {
            this.init(parent, name);
        }

        void init(Element parent, String name) {
            this.parent = parent;
            this.name = name;
            this.nsStack = null;
            this.level = parent == null ? 0 : parent.level + 1;
        }

        public String getName() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public void addNamespace(String nsURI, String nsPrefix) {
            if (this.nsStack == null) {
                this.nsStack = new HashMap<String, String>();
            }
            this.nsStack.put(nsURI, nsPrefix);
        }

        public String getNamespacePrefix(String nsURI) {
            String prefix;
            if (nsURI.equals("http://www.w3.org/TR/REC-xml")) {
                return "xml";
            }
            String string = prefix = this.nsStack == null ? null : this.nsStack.get(nsURI);
            return prefix != null ? prefix : (this.parent != null ? this.parent.getNamespacePrefix(nsURI) : null);
        }

        @Override
        public void close() throws IOException {
            XMLBuilder.this.endElement();
        }
    }
}

