// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Represents a logical validation result from automated reasoning policy evaluation. The finding indicates whether claims in the input are logically valid, invalid, satisfiable, impossible, or have other logical issues.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum GuardrailAutomatedReasoningFinding {
    /// <p>Contains the result when the automated reasoning evaluation determines that no valid logical conclusions can be drawn due to contradictions in the premises or policy rules themselves.</p>
    Impossible(crate::types::GuardrailAutomatedReasoningImpossibleFinding),
    /// <p>Contains the result when the automated reasoning evaluation determines that the claims in the input are logically invalid and contradict the established premises or policy rules.</p>
    Invalid(crate::types::GuardrailAutomatedReasoningInvalidFinding),
    /// <p>Contains the result when the automated reasoning evaluation cannot extract any relevant logical information from the input that can be validated against the policy rules.</p>
    NoTranslations(crate::types::GuardrailAutomatedReasoningNoTranslationsFinding),
    /// <p>Contains the result when the automated reasoning evaluation determines that the claims in the input could be either true or false depending on additional assumptions not provided in the input context.</p>
    Satisfiable(crate::types::GuardrailAutomatedReasoningSatisfiableFinding),
    /// <p>Contains the result when the automated reasoning evaluation cannot process the input due to its complexity or volume exceeding the system's processing capacity for logical analysis.</p>
    TooComplex(crate::types::GuardrailAutomatedReasoningTooComplexFinding),
    /// <p>Contains the result when the automated reasoning evaluation detects that the input has multiple valid logical interpretations, requiring additional context or clarification to proceed with validation.</p>
    TranslationAmbiguous(crate::types::GuardrailAutomatedReasoningTranslationAmbiguousFinding),
    /// <p>Contains the result when the automated reasoning evaluation determines that the claims in the input are logically valid and definitively true based on the provided premises and policy rules.</p>
    Valid(crate::types::GuardrailAutomatedReasoningValidFinding),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl GuardrailAutomatedReasoningFinding {
    /// Tries to convert the enum instance into [`Impossible`](crate::types::GuardrailAutomatedReasoningFinding::Impossible), extracting the inner [`GuardrailAutomatedReasoningImpossibleFinding`](crate::types::GuardrailAutomatedReasoningImpossibleFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_impossible(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningImpossibleFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::Impossible(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Impossible`](crate::types::GuardrailAutomatedReasoningFinding::Impossible).
    pub fn is_impossible(&self) -> bool {
        self.as_impossible().is_ok()
    }
    /// Tries to convert the enum instance into [`Invalid`](crate::types::GuardrailAutomatedReasoningFinding::Invalid), extracting the inner [`GuardrailAutomatedReasoningInvalidFinding`](crate::types::GuardrailAutomatedReasoningInvalidFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_invalid(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningInvalidFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::Invalid(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Invalid`](crate::types::GuardrailAutomatedReasoningFinding::Invalid).
    pub fn is_invalid(&self) -> bool {
        self.as_invalid().is_ok()
    }
    /// Tries to convert the enum instance into [`NoTranslations`](crate::types::GuardrailAutomatedReasoningFinding::NoTranslations), extracting the inner [`GuardrailAutomatedReasoningNoTranslationsFinding`](crate::types::GuardrailAutomatedReasoningNoTranslationsFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_no_translations(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningNoTranslationsFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::NoTranslations(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`NoTranslations`](crate::types::GuardrailAutomatedReasoningFinding::NoTranslations).
    pub fn is_no_translations(&self) -> bool {
        self.as_no_translations().is_ok()
    }
    /// Tries to convert the enum instance into [`Satisfiable`](crate::types::GuardrailAutomatedReasoningFinding::Satisfiable), extracting the inner [`GuardrailAutomatedReasoningSatisfiableFinding`](crate::types::GuardrailAutomatedReasoningSatisfiableFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_satisfiable(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningSatisfiableFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::Satisfiable(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Satisfiable`](crate::types::GuardrailAutomatedReasoningFinding::Satisfiable).
    pub fn is_satisfiable(&self) -> bool {
        self.as_satisfiable().is_ok()
    }
    /// Tries to convert the enum instance into [`TooComplex`](crate::types::GuardrailAutomatedReasoningFinding::TooComplex), extracting the inner [`GuardrailAutomatedReasoningTooComplexFinding`](crate::types::GuardrailAutomatedReasoningTooComplexFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_too_complex(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningTooComplexFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::TooComplex(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`TooComplex`](crate::types::GuardrailAutomatedReasoningFinding::TooComplex).
    pub fn is_too_complex(&self) -> bool {
        self.as_too_complex().is_ok()
    }
    /// Tries to convert the enum instance into [`TranslationAmbiguous`](crate::types::GuardrailAutomatedReasoningFinding::TranslationAmbiguous), extracting the inner [`GuardrailAutomatedReasoningTranslationAmbiguousFinding`](crate::types::GuardrailAutomatedReasoningTranslationAmbiguousFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_translation_ambiguous(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningTranslationAmbiguousFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::TranslationAmbiguous(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`TranslationAmbiguous`](crate::types::GuardrailAutomatedReasoningFinding::TranslationAmbiguous).
    pub fn is_translation_ambiguous(&self) -> bool {
        self.as_translation_ambiguous().is_ok()
    }
    /// Tries to convert the enum instance into [`Valid`](crate::types::GuardrailAutomatedReasoningFinding::Valid), extracting the inner [`GuardrailAutomatedReasoningValidFinding`](crate::types::GuardrailAutomatedReasoningValidFinding).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_valid(&self) -> ::std::result::Result<&crate::types::GuardrailAutomatedReasoningValidFinding, &Self> {
        if let GuardrailAutomatedReasoningFinding::Valid(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`Valid`](crate::types::GuardrailAutomatedReasoningFinding::Valid).
    pub fn is_valid(&self) -> bool {
        self.as_valid().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
