package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VulnerabilityAssessmentScanResultClient is the the Azure SQL Database management API provides a RESTful set of web
// services that interact with Azure SQL Database services to manage your databases. The API enables you to create,
// retrieve, update, and delete databases.
type VulnerabilityAssessmentScanResultClient struct {
	BaseClient
}

// NewVulnerabilityAssessmentScanResultClient creates an instance of the VulnerabilityAssessmentScanResultClient
// client.
func NewVulnerabilityAssessmentScanResultClient(subscriptionID string) VulnerabilityAssessmentScanResultClient {
	return NewVulnerabilityAssessmentScanResultClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVulnerabilityAssessmentScanResultClientWithBaseURI creates an instance of the
// VulnerabilityAssessmentScanResultClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVulnerabilityAssessmentScanResultClientWithBaseURI(baseURI string, subscriptionID string) VulnerabilityAssessmentScanResultClient {
	return VulnerabilityAssessmentScanResultClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets a vulnerability assessment scan record of a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// scanID - the scan id of the SQL Vulnerability Assessment scan to retrieve result from.
// scanResultID - the scan result id of the specific result to retrieve.
func (client VulnerabilityAssessmentScanResultClient) Get(ctx context.Context, resourceGroupName string, serverName string, scanID string, scanResultID string) (result VulnerabilityAssessmentScanResults, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanResultClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, serverName, scanID, scanResultID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VulnerabilityAssessmentScanResultClient) GetPreparer(ctx context.Context, resourceGroupName string, serverName string, scanID string, scanResultID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"scanResultId":                autorest.Encode("path", scanResultID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentScanResultClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentScanResultClient) GetResponder(resp *http.Response) (result VulnerabilityAssessmentScanResults, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByScan gets a vulnerability assessment scan record of a database.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// serverName - the name of the server.
// scanID - the scan id of the SQL Vulnerability Assessment scan to retrieve result from.
func (client VulnerabilityAssessmentScanResultClient) ListByScan(ctx context.Context, resourceGroupName string, serverName string, scanID string) (result VulnerabilityAssessmentScanListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanResultClient.ListByScan")
		defer func() {
			sc := -1
			if result.vaslr.Response.Response != nil {
				sc = result.vaslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByScanNextResults
	req, err := client.ListByScanPreparer(ctx, resourceGroupName, serverName, scanID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "ListByScan", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByScanSender(req)
	if err != nil {
		result.vaslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "ListByScan", resp, "Failure sending request")
		return
	}

	result.vaslr, err = client.ListByScanResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "ListByScan", resp, "Failure responding to request")
		return
	}
	if result.vaslr.hasNextLink() && result.vaslr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByScanPreparer prepares the ListByScan request.
func (client VulnerabilityAssessmentScanResultClient) ListByScanPreparer(ctx context.Context, resourceGroupName string, serverName string, scanID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"scanId":                      autorest.Encode("path", scanID),
		"serverName":                  autorest.Encode("path", serverName),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2022-02-01-preview"
	queryParameters := map[string]interface{}{
		"api-version":        APIVersion,
		"systemDatabaseName": autorest.Encode("query", "master"),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByScanSender sends the ListByScan request. The method will close the
// http.Response Body if it receives an error.
func (client VulnerabilityAssessmentScanResultClient) ListByScanSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByScanResponder handles the response to the ListByScan request. The method always
// closes the http.Response Body.
func (client VulnerabilityAssessmentScanResultClient) ListByScanResponder(resp *http.Response) (result VulnerabilityAssessmentScanListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByScanNextResults retrieves the next set of results, if any.
func (client VulnerabilityAssessmentScanResultClient) listByScanNextResults(ctx context.Context, lastResults VulnerabilityAssessmentScanListResult) (result VulnerabilityAssessmentScanListResult, err error) {
	req, err := lastResults.vulnerabilityAssessmentScanListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "listByScanNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByScanSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "listByScanNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByScanResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.VulnerabilityAssessmentScanResultClient", "listByScanNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByScanComplete enumerates all values, automatically crossing page boundaries as required.
func (client VulnerabilityAssessmentScanResultClient) ListByScanComplete(ctx context.Context, resourceGroupName string, serverName string, scanID string) (result VulnerabilityAssessmentScanListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VulnerabilityAssessmentScanResultClient.ListByScan")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByScan(ctx, resourceGroupName, serverName, scanID)
	return
}
