; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use.i1(i1)
declare void @use.i8(i8)
define i8 @replace_with_y_noundef(i8 %x, i8 noundef %y, i8 %z) {
; CHECK-LABEL: @replace_with_y_noundef(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[Y]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %cmp = icmp eq i8 %x, %y
  %and = and i8 %x, %y
  %sel = select i1 %cmp, i8 %and, i8 %z
  ret i8 %sel
}

define i8 @replace_with_x_noundef(i8 noundef %x, i8 %y, i8 %z) {
; CHECK-LABEL: @replace_with_x_noundef(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @use.i1(i1 [[CMP]])
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[Z:%.*]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %cmp = icmp ne i8 %x, %y
  call void @use.i1(i1 %cmp)
  %and = or i8 %x, %y
  %sel = select i1 %cmp, i8 %z, i8 %and
  ret i8 %sel
}

define i8 @replace_with_x_maybe_undef_fail(i8 %x, i8 %y, i8 %z) {
; CHECK-LABEL: @replace_with_x_maybe_undef_fail(
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    call void @use.i1(i1 [[CMP]])
; CHECK-NEXT:    [[AND:%.*]] = or i8 [[X]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[Z:%.*]], i8 [[AND]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %cmp = icmp ne i8 %x, %y
  call void @use.i1(i1 %cmp)
  %and = or i8 %x, %y
  %sel = select i1 %cmp, i8 %z, i8 %and
  ret i8 %sel
}

define i8 @replace_with_y_for_new_oneuse(i8 noundef %xx, i8 noundef %y, i8 %z) {
; CHECK-LABEL: @replace_with_y_for_new_oneuse(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], 13
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[X]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[ADD]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %x = mul i8 %xx, 13
  %cmp = icmp eq i8 %x, %y
  %add = add nuw i8 %x, %y
  %sel = select i1 %cmp, i8 %add, i8 %z
  ret i8 %sel
}

define i8 @replace_with_y_for_new_oneuse2(i8 %xx, i8 noundef %y, i8 %z, i8 %q) {
; CHECK-LABEL: @replace_with_y_for_new_oneuse2(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], 13
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[X]], [[Q:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[ADD]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %x = mul i8 %xx, 13
  %cmp = icmp eq i8 %x, %y
  %add = add nuw i8 %x, %q
  %sel = select i1 %cmp, i8 %add, i8 %z
  ret i8 %sel
}

define i8 @replace_with_x_for_new_oneuse(i8 noundef %xx, i8 noundef %yy, i8 %z, i8 %w) {
; CHECK-LABEL: @replace_with_x_for_new_oneuse(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], 13
; CHECK-NEXT:    [[Y:%.*]] = add i8 [[YY:%.*]], [[W:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], [[Y]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[X]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %x = mul i8 %xx, 13
  %y = add i8 %yy, %w
  %cmp = icmp eq i8 %x, %y
  %mul = mul i8 %x, %y
  %sel = select i1 %cmp, i8 %mul, i8 %z
  ret i8 %sel
}

define i8 @replace_with_x_for_new_oneuse2(i8 noundef %xx, i8 %yy, i8 %z, i8 %w, i8 %q) {
; CHECK-LABEL: @replace_with_x_for_new_oneuse2(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], 13
; CHECK-NEXT:    [[Y:%.*]] = add i8 [[YY:%.*]], [[W:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], [[Y]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[Q:%.*]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %x = mul i8 %xx, 13
  %y = add i8 %yy, %w
  %cmp = icmp eq i8 %x, %y
  %mul = mul i8 %q, %y
  %sel = select i1 %cmp, i8 %mul, i8 %z
  ret i8 %sel
}

define i8 @replace_with_x_for_simple_binop(i8 noundef %xx, i8 %yy, i8 %z, i8 %w) {
; CHECK-LABEL: @replace_with_x_for_simple_binop(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], 13
; CHECK-NEXT:    [[Y:%.*]] = add i8 [[YY:%.*]], [[W:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], [[Y]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[X]], [[Y]]
; CHECK-NEXT:    call void @use.i8(i8 [[Y]])
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %x = mul i8 %xx, 13
  %y = add i8 %yy, %w
  %cmp = icmp eq i8 %x, %y
  %mul = mul i8 %x, %y
  call void @use.i8(i8 %y)
  %sel = select i1 %cmp, i8 %mul, i8 %z
  ret i8 %sel
}

define i8 @replace_with_none_for_new_oneuse_fail_maybe_undef(i8 %xx, i8 %y, i8 %z) {
; CHECK-LABEL: @replace_with_none_for_new_oneuse_fail_maybe_undef(
; CHECK-NEXT:    [[X:%.*]] = mul i8 [[XX:%.*]], 13
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X]], [[Y:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = mul i8 [[X]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %x = mul i8 %xx, 13
  %cmp = icmp eq i8 %x, %y
  %mul = mul i8 %x, %y
  %sel = select i1 %cmp, i8 %mul, i8 %z
  ret i8 %sel
}

define i8 @replace_with_y_for_simple_binop(i8 %x, i8 noundef %y, i8 %z) {
; CHECK-LABEL: @replace_with_y_for_simple_binop(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i8 [[X]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %cmp = icmp eq i8 %x, %y
  %mul = mul nsw i8 %x, %y
  %sel = select i1 %cmp, i8 %mul, i8 %z
  ret i8 %sel
}

define i8 @replace_with_y_for_simple_binop_fail_multiuse(i8 %x, i8 noundef %y, i8 %z) {
; CHECK-LABEL: @replace_with_y_for_simple_binop_fail_multiuse(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i8 [[X]], [[Y]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    call void @use.i8(i8 [[MUL]])
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %cmp = icmp eq i8 %x, %y
  %mul = mul nsw i8 %x, %y
  %sel = select i1 %cmp, i8 %mul, i8 %z
  call void @use.i8(i8 %mul)
  ret i8 %sel
}

define i8 @replace_with_y_for_simple_binop_fail(i8 %x, i8 noundef %y, i8 %z, i8 %q) {
; CHECK-LABEL: @replace_with_y_for_simple_binop_fail(
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[MUL:%.*]] = mul nsw i8 [[X]], [[Q:%.*]]
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[CMP]], i8 [[MUL]], i8 [[Z:%.*]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %cmp = icmp eq i8 %x, %y
  %mul = mul nsw i8 %x, %q
  %sel = select i1 %cmp, i8 %mul, i8 %z
  ret i8 %sel
}

; Make sure we don't run into an infinite loop.
define i32 @pr142405(i32 noundef %x) {
; CHECK-LABEL: @pr142405(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SMAX:%.*]] = call i32 @llvm.smax.i32(i32 [[X:%.*]], i32 0)
; CHECK-NEXT:    [[MASKED:%.*]] = and i32 [[SMAX]], 65535
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X]], [[MASKED]]
; CHECK-NEXT:    [[TMP0:%.*]] = and i32 [[SMAX]], 1
; CHECK-NEXT:    [[AND:%.*]] = select i1 [[CMP]], i32 [[TMP0]], i32 0
; CHECK-NEXT:    ret i32 [[AND]]
;
entry:
  %smax = call i32 @llvm.smax.i32(i32 %x, i32 0)
  %masked = and i32 %smax, 65535
  %cmp = icmp eq i32 %x, %masked
  %sel = select i1 %cmp, i32 %smax, i32 0
  %and = and i32 %sel, 1
  ret i32 %and
}
