; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test usage of VACC/VSCBI.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

define i128 @i128_subc_1(i128 %a, i128 %b) unnamed_addr {
; CHECK-LABEL: i128_subc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vscbiq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp uge i128 %a, %b
  %ext = zext i1 %cmp to i128
  ret i128 %ext
}

define i128 @i128_subc_2(i128 %a, i128 %b) unnamed_addr {
; CHECK-LABEL: i128_subc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vscbiq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %cmp = icmp ule i128 %a, %b
  %ext = zext i1 %cmp to i128
  ret i128 %ext
}

define i128 @i128_addc_1(i128 %a, i128 %b) {
; CHECK-LABEL: i128_addc_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaccq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %sum = add i128 %a, %b
  %cmp = icmp ult i128 %sum, %a
  %ext = zext i1 %cmp to i128
  ret i128 %ext
}

define i128 @i128_addc_2(i128 %a, i128 %b) {
; CHECK-LABEL: i128_addc_2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaccq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %sum = add i128 %a, %b
  %cmp = icmp ult i128 %sum, %b
  %ext = zext i1 %cmp to i128
  ret i128 %ext
}

define i128 @i128_addc_3(i128 %a, i128 %b) {
; CHECK-LABEL: i128_addc_3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaccq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %sum = add i128 %a, %b
  %cmp = icmp ugt i128 %a, %sum
  %ext = zext i1 %cmp to i128
  ret i128 %ext
}

define i128 @i128_addc_4(i128 %a, i128 %b) {
; CHECK-LABEL: i128_addc_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaccq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %sum = add i128 %a, %b
  %cmp = icmp ugt i128 %b, %sum
  %ext = zext i1 %cmp to i128
  ret i128 %ext
}

