; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @olt_pinf(half %x) {
; CHECK-LABEL: define i1 @olt_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one half [[X]], 0xH7C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp olt half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @ole_pinf(half %x) {
; CHECK-LABEL: define i1 @ole_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ole half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @ogt_pinf(half %x) {
; CHECK-LABEL: define i1 @ogt_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp ogt half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @oge_pinf(half %x) {
; CHECK-LABEL: define i1 @oge_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq half [[X]], 0xH7C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oge half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @ult_pinf(half %x) {
; CHECK-LABEL: define i1 @ult_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une half [[X]], 0xH7C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ult half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @ule_pinf(half %x) {
; CHECK-LABEL: define i1 @ule_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp ule half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @ugt_pinf(half %x) {
; CHECK-LABEL: define i1 @ugt_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ugt half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @uge_pinf(half %x) {
; CHECK-LABEL: define i1 @uge_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq half [[X]], 0xH7C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uge half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @olt_ninf(half %x) {
; CHECK-LABEL: define i1 @olt_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp olt half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @ole_ninf(half %x) {
; CHECK-LABEL: define i1 @ole_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp oeq half [[X]], 0xHFC00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ole half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @ogt_ninf(half %x) {
; CHECK-LABEL: define i1 @ogt_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one half [[X]], 0xHFC00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ogt half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @oge_ninf(half %x) {
; CHECK-LABEL: define i1 @oge_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp oge half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @ult_ninf(half %x) {
; CHECK-LABEL: define i1 @ult_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ult half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @ule_ninf(half %x) {
; CHECK-LABEL: define i1 @ule_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ueq half [[X]], 0xHFC00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ule half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @ugt_ninf(half %x) {
; CHECK-LABEL: define i1 @ugt_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une half [[X]], 0xHFC00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ugt half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @uge_ninf(half %x) {
; CHECK-LABEL: define i1 @uge_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp uge half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @olt_pinf_fmf(half %x) {
; CHECK-LABEL: define i1 @olt_pinf_fmf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp nsz one half [[X]], 0xH7C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp nsz olt half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @oge_pinf_fmf(half %x) {
; CHECK-LABEL: define i1 @oge_pinf_fmf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp nnan oeq half [[X]], 0xH7C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp nnan oge half %x, 0xH7c00
  ret i1 %cmp
}

define <2 x i1> @olt_pinf_vec(<2 x half> %x) {
; CHECK-LABEL: define <2 x i1> @olt_pinf_vec(
; CHECK-SAME: <2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one <2 x half> [[X]], splat (half 0xH7C00)
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %cmp = fcmp olt <2 x half> %x, <half 0xH7c00, half 0xH7c00>
  ret <2 x i1> %cmp
}

define <2 x i1> @oge_ninf_vec(<2 x half> %x) {
; CHECK-LABEL: define <2 x i1> @oge_ninf_vec(
; CHECK-SAME: <2 x half> [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord <2 x half> [[X]], zeroinitializer
; CHECK-NEXT:    ret <2 x i1> [[CMP]]
;
  %cmp = fcmp oge <2 x half> %x, <half 0xHfc00, half 0xHfc00>
  ret <2 x i1> %cmp
}

; Negative tests

define i1 @ord_pinf(half %x) {
; CHECK-LABEL: define i1 @ord_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ord half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @uno_pinf(half %x) {
; CHECK-LABEL: define i1 @uno_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uno half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @true_pinf(half %x) {
; CHECK-LABEL: define i1 @true_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @false_pinf(half %x) {
; CHECK-LABEL: define i1 @false_pinf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp false half %x, 0xH7c00
  ret i1 %cmp
}

define i1 @ord_ninf(half %x) {
; CHECK-LABEL: define i1 @ord_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp ord half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp ord half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @uno_ninf(half %x) {
; CHECK-LABEL: define i1 @uno_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp uno half [[X]], 0xH0000
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp uno half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @true_ninf(half %x) {
; CHECK-LABEL: define i1 @true_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %cmp = fcmp true half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @false_ninf(half %x) {
; CHECK-LABEL: define i1 @false_ninf(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    ret i1 false
;
  %cmp = fcmp false half %x, 0xHfc00
  ret i1 %cmp
}

define i1 @olt_one(half %x) {
; CHECK-LABEL: define i1 @olt_one(
; CHECK-SAME: half [[X:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = fcmp olt half [[X]], 0xH3C00
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %cmp = fcmp olt half %x, 1.0
  ret i1 %cmp
}
