; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=i386-pc-win32 < %s | FileCheck -check-prefix=WIN32 %s
; RUN: llc -mtriple=x86_64-unknown-unknown < %s | FileCheck -check-prefixes=X64 %s

; On 32-bit windows this should be promoted to a call to modf (not modff).
define { float, float } @test_modf_f32(float %a) {
; WIN32-LABEL: test_modf_f32:
; WIN32:       # %bb.0:
; WIN32-NEXT:    pushl %ebp
; WIN32-NEXT:    movl %esp, %ebp
; WIN32-NEXT:    andl $-8, %esp
; WIN32-NEXT:    subl $32, %esp
; WIN32-NEXT:    leal {{[0-9]+}}(%esp), %eax
; WIN32-NEXT:    movl %eax, {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds 8(%ebp)
; WIN32-NEXT:    fstpl (%esp)
; WIN32-NEXT:    calll _modf
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    fldl {{[0-9]+}}(%esp)
; WIN32-NEXT:    fstps {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    flds {{[0-9]+}}(%esp)
; WIN32-NEXT:    fxch %st(1)
; WIN32-NEXT:    movl %ebp, %esp
; WIN32-NEXT:    popl %ebp
; WIN32-NEXT:    retl
;
; X64-LABEL: test_modf_f32:
; X64:       # %bb.0:
; X64-NEXT:    pushq %rax
; X64-NEXT:    .cfi_def_cfa_offset 16
; X64-NEXT:    leaq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    callq modff@PLT
; X64-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X64-NEXT:    popq %rax
; X64-NEXT:    .cfi_def_cfa_offset 8
; X64-NEXT:    retq
  %result = call { float, float } @llvm.modf.f32(float %a)
  ret { float, float } %result
}
