; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-usenative -amdgpu-use-native=all < %s | FileCheck %s

; Verify nobuiltin is respected on a defined function. native_cos is
; marked nobuiltin, but native_sin is not.

define float @_Z10native_sinf(float %x) {
; CHECK-LABEL: define float @_Z10native_sinf
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float asm "
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float asm "; $0 = native_sin($1)", "=v,v"(float %x)
  ret float %result
}

define float @_Z10native_cosf(float %x) nobuiltin {
; CHECK-LABEL: define float @_Z10native_cosf
; CHECK-SAME: (float [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[RESULT:%.*]] = call float asm "
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float asm "; $0 = native_cos($1)", "=v,v"(float %x)
  ret float %result
}

define float @_Z3sinf(float %x) {
; CHECK-LABEL: define float @_Z3sinf
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float asm "
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float asm "; $0 = sin($1)", "=v,v"(float %x)
  ret float %result
}

define float @_Z3cosf(float %x) {
; CHECK-LABEL: define float @_Z3cosf
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float asm "
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float asm "; $0 = cos($1)", "=v,v"(float %x)
  ret float %result
}

define float @call_cos(float %x) {
; CHECK-LABEL: define float @call_cos
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float @_Z3cosf(float [[X]])
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float @_Z3cosf(float %x)
  ret float %result
}

define float @call_sin(float %x) {
; CHECK-LABEL: define float @call_sin
; CHECK-SAME: (float [[X:%.*]]) {
; CHECK-NEXT:    [[RESULT:%.*]] = call float @_Z10native_sinf(float [[X]])
; CHECK-NEXT:    ret float [[RESULT]]
;
  %result = call float @_Z3sinf(float %x)
  ret float %result
}
