; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefixes=COMPATIBLE,IR %s
; RUN: FileCheck -allow-empty --check-prefix=WARN-COMPATIBLE %s < %t
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -verify-machineinstrs < %s

; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -stop-after=amdgpu-remove-incompatible-functions\
; RUN:   -pass-remarks=amdgpu-remove-incompatible-functions %s -o - 2>%t | FileCheck -check-prefixes=INCOMPATIBLE,IR %s
; RUN: FileCheck --check-prefixes=WARN-INCOMPATIBLE %s < %t
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -verify-machineinstrs < %s

; Note: This test checks the IR, but also has a run line to codegen the file just to check we
; do not crash when trying to select those functions.

; WARN-COMPATIBLE-NOT: removing function 'needs_gws':
; WARN-INCOMPATIBLE:   removing function 'needs_gws': +gws is not supported on the current target


; COMPATIBLE:       @GVRefs {{.*}} [ptr @needs_gws]
; INCOMPATIBLE:     @GVRefs {{.*}} zeroinitializer
@GVRefs = internal global [1 x ptr] [
  ptr @needs_gws
]


; COMPATIBLE:         @ConstantExpr = internal global i64 ptrtoint (ptr @needs_gws to i64)
; INCOMPATIBLE:       @ConstantExpr = internal global i64 0
@ConstantExpr = internal global i64 ptrtoint (ptr @needs_gws to i64)


; COMPATIBLE:         define void @needs_gws
; INCOMPATIBLE-NOT:   define void @needs_gws
define void @needs_gws(i32 %val0, i32 %val1) #0 {
  call void @llvm.amdgcn.ds.gws.init(i32 %val0, i32 %val1)
  call void @llvm.amdgcn.ds.gws.barrier(i32 %val0, i32 %val1)
  ret void
}

; IR: define void @gws_caller(
define void @gws_caller(i32 %val0, i32 %val1) {
  call void @needs_gws(i32 %val0, i32 %val1)
  ret void
}

declare void @llvm.amdgcn.ds.gws.barrier(i32, i32) #1
declare void @llvm.amdgcn.ds.gws.init(i32, i32) #2


attributes #0 = { "target-features"="+gws"}
attributes #1 = { convergent inaccessiblememonly nounwind }
attributes #2 = { convergent inaccessiblememonly nounwind writeonly }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; COMPATIBLE: {{.*}}
; INCOMPATIBLE: {{.*}}
; IR: {{.*}}
