# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr3-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV64,SCR3_64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr3-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV32,SCR3_32
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr4-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV64,SCR4_5_64,SCR4_64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr4-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV32,SCR4_5_32,SCR4_32
# RUN: llvm-mca -mtriple=riscv64-unknown-unknown -mcpu=syntacore-scr5-rv64 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV64,SCR4_5_64,SCR5_64
# RUN: llvm-mca -mtriple=riscv32-unknown-unknown -mcpu=syntacore-scr5-rv32 --iterations=1 < %s | FileCheck %s --check-prefixes=CHECK,RV32,SCR4_5_32,SCR5_32

div a0, a0, a0
mul t0, a0, t0
add t1, a0, t0
add t2, t2, t2
div a1, a1, a1
mul s0, a1, s0
add s1, s0, s1
add s2, s2, s2

# CHECK:          Iterations:        1
# CHECK-NEXT:     Instructions:      8

# RV32-NEXT:      Total Cycles:      25
# RV64-NEXT:      Total Cycles:      31

# CHECK-NEXT:     Total uOps:        8

# CHECK:          Dispatch Width:    1

# RV32-NEXT:      uOps Per Cycle:    0.32
# RV32-NEXT:      IPC:               0.32
# RV32-NEXT:      Block RThroughput: 16.0

# RV64-NEXT:      uOps Per Cycle:    0.26
# RV64-NEXT:      IPC:               0.26
# RV64-NEXT:      Block RThroughput: 22.0

# CHECK:          Instruction Info:
# CHECK-NEXT:     [1]: #uOps
# CHECK-NEXT:     [2]: Latency
# CHECK-NEXT:     [3]: RThroughput
# CHECK-NEXT:     [4]: MayLoad
# CHECK-NEXT:     [5]: MayStore
# CHECK-NEXT:     [6]: HasSideEffects (U)

# CHECK:          [1]    [2]    [3]    [4]    [5]    [6]    Instructions:

# RV32-NEXT:       1      8     8.00                        div	a0, a0, a0
# RV64-NEXT:       1      11    11.00                       div	a0, a0, a0

# CHECK-NEXT:      1      2     1.00                        mul	t0, a0, t0
# CHECK-NEXT:      1      1     1.00                        add	t1, a0, t0
# CHECK-NEXT:      1      1     1.00                        add	t2, t2, t2

# RV32-NEXT:       1      8     8.00                        div	a1, a1, a1
# RV64-NEXT:       1      11    11.00                       div	a1, a1, a1

# CHECK-NEXT:      1      2     1.00                        mul	s0, a1, s0
# CHECK-NEXT:      1      1     1.00                        add	s1, s1, s0
# CHECK-NEXT:      1      1     1.00                        add	s2, s2, s2

# SCR3_32:        Resources:
# SCR3_32-NEXT:   [0]   - SCR3RV32_ALU
# SCR3_32-NEXT:   [1]   - SCR3RV32_CFU
# SCR3_32-NEXT:   [2]   - SCR3RV32_DIV
# SCR3_32-NEXT:   [3]   - SCR3RV32_LSU
# SCR3_32-NEXT:   [4]   - SCR3RV32_MUL

# SCR3_64:        Resources:
# SCR3_64-NEXT:   [0]   - SCR3RV64_ALU
# SCR3_64-NEXT:   [1]   - SCR3RV64_CFU
# SCR3_64-NEXT:   [2]   - SCR3RV64_DIV
# SCR3_64-NEXT:   [3]   - SCR3RV64_LSU
# SCR3_64-NEXT:   [4]   - SCR3RV64_MUL

# SCR4_32:        Resources:
# SCR4_32-NEXT:   [0]   - SCR4RV32_ALU
# SCR4_32-NEXT:   [1]   - SCR4RV32_CFU
# SCR4_32-NEXT:   [2]   - SCR4RV32_DIV
# SCR4_32-NEXT:   [3]   - SCR4RV32_FDU
# SCR4_32-NEXT:   [4]   - SCR4RV32_FPU
# SCR4_32-NEXT:   [5]   - SCR4RV32_LSU
# SCR4_32-NEXT:   [6]   - SCR4RV32_MUL

# SCR4_64:        Resources:
# SCR4_64-NEXT:   [0]   - SCR4RV64_ALU
# SCR4_64-NEXT:   [1]   - SCR4RV64_CFU
# SCR4_64-NEXT:   [2]   - SCR4RV64_DIV
# SCR4_64-NEXT:   [3]   - SCR4RV64_FDU
# SCR4_64-NEXT:   [4]   - SCR4RV64_FPU
# SCR4_64-NEXT:   [5]   - SCR4RV64_LSU
# SCR4_64-NEXT:   [6]   - SCR4RV64_MUL

# SCR5_32:        Resources:
# SCR5_32-NEXT:   [0]   - SCR5RV32_ALU
# SCR5_32-NEXT:   [1]   - SCR5RV32_CFU
# SCR5_32-NEXT:   [2]   - SCR5RV32_DIV
# SCR5_32-NEXT:   [3]   - SCR5RV32_FDU
# SCR5_32-NEXT:   [4]   - SCR5RV32_FPU
# SCR5_32-NEXT:   [5]   - SCR5RV32_LSU
# SCR5_32-NEXT:   [6]   - SCR5RV32_MUL

# SCR5_64:        Resources:
# SCR5_64-NEXT:   [0]   - SCR5RV64_ALU
# SCR5_64-NEXT:   [1]   - SCR5RV64_CFU
# SCR5_64-NEXT:   [2]   - SCR5RV64_DIV
# SCR5_64-NEXT:   [3]   - SCR5RV64_FDU
# SCR5_64-NEXT:   [4]   - SCR5RV64_FPU
# SCR5_64-NEXT:   [5]   - SCR5RV64_LSU
# SCR5_64-NEXT:   [6]   - SCR5RV64_MUL

# CHECK:          Resource pressure per iteration:

# SCR3_32-NEXT:   [0]    [1]    [2]    [3]    [4]
# SCR3_32-NEXT:   4.00    -     16.00   -     2.00

# SCR3_64-NEXT:   [0]    [1]    [2]    [3]    [4]
# SCR3_64-NEXT:   4.00    -     22.00   -     2.00

# SCR4_5_32-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]
# SCR4_5_32-NEXT: 4.00    -     16.00   -      -      -     2.00

# SCR4_5_64-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]
# SCR4_5_64-NEXT: 4.00    -     22.00   -      -      -     2.00

# CHECK:          Resource pressure by instruction:

# SCR3_32-NEXT:   [0]    [1]    [2]    [3]    [4]    Instructions:
# SCR3_32-NEXT:    -      -     8.00    -      -     div	a0, a0, a0
# SCR3_32-NEXT:    -      -      -      -     1.00   mul	t0, a0, t0
# SCR3_32-NEXT:   1.00    -      -      -      -     add	t1, a0, t0
# SCR3_32-NEXT:   1.00    -      -      -      -     add	t2, t2, t2
# SCR3_32-NEXT:    -      -     8.00    -      -     div	a1, a1, a1
# SCR3_32-NEXT:    -      -      -      -     1.00   mul	s0, a1, s0
# SCR3_32-NEXT:   1.00    -      -      -      -     add	s1, s1, s0
# SCR3_32-NEXT:   1.00    -      -      -      -     add	s2, s2, s2

# SCR3_64-NEXT:   [0]    [1]    [2]    [3]    [4]    Instructions:
# SCR3_64-NEXT:    -      -     11.00   -      -     div	a0, a0, a0
# SCR3_64-NEXT:    -      -      -      -     1.00   mul	t0, a0, t0
# SCR3_64-NEXT:   1.00    -      -      -      -     add	t1, a0, t0
# SCR3_64-NEXT:   1.00    -      -      -      -     add	t2, t2, t2
# SCR3_64-NEXT:    -      -     11.00   -      -     div	a1, a1, a1
# SCR3_64-NEXT:    -      -      -      -     1.00   mul	s0, a1, s0
# SCR3_64-NEXT:   1.00    -      -      -      -     add	s1, s1, s0
# SCR3_64-NEXT:   1.00    -      -      -      -     add	s2, s2, s2

# SCR4_5_32-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# SCR4_5_32-NEXT:  -      -     8.00    -      -      -      -     div	a0, a0, a0
# SCR4_5_32-NEXT:  -      -      -      -      -      -     1.00   mul	t0, a0, t0
# SCR4_5_32-NEXT: 1.00    -      -      -      -      -      -     add	t1, a0, t0
# SCR4_5_32-NEXT: 1.00    -      -      -      -      -      -     add	t2, t2, t2
# SCR4_5_32-NEXT:  -      -     8.00    -      -      -      -     div	a1, a1, a1
# SCR4_5_32-NEXT:  -      -      -      -      -      -     1.00   mul	s0, a1, s0
# SCR4_5_32-NEXT: 1.00    -      -      -      -      -      -     add	s1, s1, s0
# SCR4_5_32-NEXT: 1.00    -      -      -      -      -      -     add	s2, s2, s2

# SCR4_5_64-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# SCR4_5_64-NEXT:  -      -     11.00   -      -      -      -     div	a0, a0, a0
# SCR4_5_64-NEXT:  -      -      -      -      -      -     1.00   mul	t0, a0, t0
# SCR4_5_64-NEXT: 1.00    -      -      -      -      -      -     add	t1, a0, t0
# SCR4_5_64-NEXT: 1.00    -      -      -      -      -      -     add	t2, t2, t2
# SCR4_5_64-NEXT:  -      -     11.00   -      -      -      -     div	a1, a1, a1
# SCR4_5_64-NEXT:  -      -      -      -      -      -     1.00   mul	s0, a1, s0
# SCR4_5_64-NEXT: 1.00    -      -      -      -      -      -     add	s1, s1, s0
# SCR4_5_64-NEXT: 1.00    -      -      -      -      -      -     add	s2, s2, s2
