; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=powerpc64le-unknown-unknown -mcpu=pwr8 -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,PWR8
; RUN: llc < %s -mtriple=powerpc64le-unknown-unknown -mcpu=pwr7 -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,PWR7

define <16 x i8> @getsmaxi8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: getsmaxi8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmaxsb 2, 2, 3
; CHECK-NEXT:    blr
entry:
  %0 = icmp sgt <16 x i8> %a, %b
  %1 = select <16 x i1> %0, <16 x i8> %a, <16 x i8> %b
  ret <16 x i8> %1
}

define <8 x i16> @getsmaxi16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: getsmaxi16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmaxsh 2, 2, 3
; CHECK-NEXT:    blr
entry:
  %0 = icmp sgt <8 x i16> %a, %b
  %1 = select <8 x i1> %0, <8 x i16> %a, <8 x i16> %b
  ret <8 x i16> %1
}

define <4 x i32> @getsmaxi32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: getsmaxi32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vmaxsw 2, 2, 3
; CHECK-NEXT:    blr
entry:
  %0 = icmp sgt <4 x i32> %a, %b
  %1 = select <4 x i1> %0, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %1
}

define <2 x i64> @getsmaxi64(<2 x i64> %a, <2 x i64> %b) {
; PWR8-LABEL: getsmaxi64:
; PWR8:       # %bb.0: # %entry
; PWR8-NEXT:    vmaxsd 2, 2, 3
; PWR8-NEXT:    blr
;
; PWR7-LABEL: getsmaxi64:
; PWR7:       # %bb.0: # %entry
; PWR7-NEXT:    xxswapd 0, 35
; PWR7-NEXT:    addi 3, 1, -32
; PWR7-NEXT:    xxswapd 1, 34
; PWR7-NEXT:    stxvd2x 0, 0, 3
; PWR7-NEXT:    addi 3, 1, -48
; PWR7-NEXT:    stxvd2x 1, 0, 3
; PWR7-NEXT:    ld 3, -24(1)
; PWR7-NEXT:    ld 4, -40(1)
; PWR7-NEXT:    ld 6, -48(1)
; PWR7-NEXT:    cmpd 4, 3
; PWR7-NEXT:    li 3, 0
; PWR7-NEXT:    li 4, -1
; PWR7-NEXT:    iselgt 5, 4, 3
; PWR7-NEXT:    std 5, -8(1)
; PWR7-NEXT:    ld 5, -32(1)
; PWR7-NEXT:    cmpd 6, 5
; PWR7-NEXT:    iselgt 3, 4, 3
; PWR7-NEXT:    std 3, -16(1)
; PWR7-NEXT:    addi 3, 1, -16
; PWR7-NEXT:    lxvd2x 0, 0, 3
; PWR7-NEXT:    xxswapd 36, 0
; PWR7-NEXT:    xxsel 34, 35, 34, 36
; PWR7-NEXT:    blr
entry:
  %0 = icmp sgt <2 x i64> %a, %b
  %1 = select <2 x i1> %0, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %1
}

define <4 x float> @getsmaxf32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: getsmaxf32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvmaxsp 34, 34, 35
; CHECK-NEXT:    blr
entry:
  %0 = fcmp nnan nsz oge <4 x float> %a, %b
  %1 = select <4 x i1> %0, <4 x float> %a, <4 x float> %b
  ret <4 x float> %1
}

define <2 x double> @getsmaxf64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: getsmaxf64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvmaxdp 34, 34, 35
; CHECK-NEXT:    blr
entry:
  %0 = fcmp nnan nsz oge <2 x double> %a, %b
  %1 = select <2 x i1> %0, <2 x double> %a, <2 x double> %b
  ret <2 x double> %1
}

define <16 x i8> @getsmini8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: getsmini8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vminsb 2, 2, 3
; CHECK-NEXT:    blr
entry:
  %0 = icmp slt <16 x i8> %a, %b
  %1 = select <16 x i1> %0, <16 x i8> %a, <16 x i8> %b
  ret <16 x i8> %1
}

define <8 x i16> @getsmini16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: getsmini16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vminsh 2, 2, 3
; CHECK-NEXT:    blr
entry:
  %0 = icmp slt <8 x i16> %a, %b
  %1 = select <8 x i1> %0, <8 x i16> %a, <8 x i16> %b
  ret <8 x i16> %1
}

define <4 x i32> @getsmini32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: getsmini32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vminsw 2, 2, 3
; CHECK-NEXT:    blr
entry:
  %0 = icmp slt <4 x i32> %a, %b
  %1 = select <4 x i1> %0, <4 x i32> %a, <4 x i32> %b
  ret <4 x i32> %1
}

define <2 x i64> @getsmini64(<2 x i64> %a, <2 x i64> %b) {
; PWR8-LABEL: getsmini64:
; PWR8:       # %bb.0: # %entry
; PWR8-NEXT:    vminsd 2, 2, 3
; PWR8-NEXT:    blr
;
; PWR7-LABEL: getsmini64:
; PWR7:       # %bb.0: # %entry
; PWR7-NEXT:    xxswapd 0, 35
; PWR7-NEXT:    addi 3, 1, -32
; PWR7-NEXT:    xxswapd 1, 34
; PWR7-NEXT:    stxvd2x 0, 0, 3
; PWR7-NEXT:    addi 3, 1, -48
; PWR7-NEXT:    stxvd2x 1, 0, 3
; PWR7-NEXT:    ld 3, -24(1)
; PWR7-NEXT:    ld 4, -40(1)
; PWR7-NEXT:    ld 6, -48(1)
; PWR7-NEXT:    cmpd 4, 3
; PWR7-NEXT:    li 3, 0
; PWR7-NEXT:    li 4, -1
; PWR7-NEXT:    isellt 5, 4, 3
; PWR7-NEXT:    std 5, -8(1)
; PWR7-NEXT:    ld 5, -32(1)
; PWR7-NEXT:    cmpd 6, 5
; PWR7-NEXT:    isellt 3, 4, 3
; PWR7-NEXT:    std 3, -16(1)
; PWR7-NEXT:    addi 3, 1, -16
; PWR7-NEXT:    lxvd2x 0, 0, 3
; PWR7-NEXT:    xxswapd 36, 0
; PWR7-NEXT:    xxsel 34, 35, 34, 36
; PWR7-NEXT:    blr
entry:
  %0 = icmp slt <2 x i64> %a, %b
  %1 = select <2 x i1> %0, <2 x i64> %a, <2 x i64> %b
  ret <2 x i64> %1
}

define <4 x float> @getsminf32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: getsminf32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvminsp 34, 34, 35
; CHECK-NEXT:    blr
entry:
  %0 = fcmp nnan nsz ole <4 x float> %a, %b
  %1 = select <4 x i1> %0, <4 x float> %a, <4 x float> %b
  ret <4 x float> %1
}

define <2 x double> @getsminf64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: getsminf64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    xvmindp 34, 34, 35
; CHECK-NEXT:    blr
entry:
  %0 = fcmp nnan nsz ole <2 x double> %a, %b
  %1 = select <2 x i1> %0, <2 x double> %a, <2 x double> %b
  ret <2 x double> %1
}

define i128 @invalidv1i128(<2 x i128> %v1, <2 x i128> %v2) {
; PWR8-LABEL: invalidv1i128:
; PWR8:       # %bb.0:
; PWR8-NEXT:    mfvsrd 3, 36
; PWR8-NEXT:    mfvsrd 4, 34
; PWR8-NEXT:    cmpld 4, 3
; PWR8-NEXT:    xxswapd 0, 36
; PWR8-NEXT:    xxswapd 1, 34
; PWR8-NEXT:    cmpd 1, 4, 3
; PWR8-NEXT:    mffprd 3, 0
; PWR8-NEXT:    mffprd 4, 1
; PWR8-NEXT:    crandc 20, 4, 2
; PWR8-NEXT:    cmpld 1, 4, 3
; PWR8-NEXT:    bc 12, 20, .LBB12_3
; PWR8-NEXT:  # %bb.1:
; PWR8-NEXT:    crand 20, 2, 4
; PWR8-NEXT:    bc 12, 20, .LBB12_3
; PWR8-NEXT:  # %bb.2:
; PWR8-NEXT:    vmr 2, 4
; PWR8-NEXT:  .LBB12_3:
; PWR8-NEXT:    xxswapd 0, 34
; PWR8-NEXT:    mfvsrd 4, 34
; PWR8-NEXT:    mffprd 3, 0
; PWR8-NEXT:    blr
;
; PWR7-LABEL: invalidv1i128:
; PWR7:       # %bb.0:
; PWR7-NEXT:    cmpld 4, 8
; PWR7-NEXT:    cmpd 1, 4, 8
; PWR7-NEXT:    crandc 20, 4, 2
; PWR7-NEXT:    cmpld 1, 3, 7
; PWR7-NEXT:    crand 21, 2, 4
; PWR7-NEXT:    cror 20, 21, 20
; PWR7-NEXT:    isel 3, 3, 7, 20
; PWR7-NEXT:    isel 4, 4, 8, 20
; PWR7-NEXT:    std 3, -32(1)
; PWR7-NEXT:    addi 3, 1, -32
; PWR7-NEXT:    std 4, -24(1)
; PWR7-NEXT:    lxvd2x 0, 0, 3
; PWR7-NEXT:    addi 3, 1, -16
; PWR7-NEXT:    stxvd2x 0, 0, 3
; PWR7-NEXT:    ld 3, -16(1)
; PWR7-NEXT:    ld 4, -8(1)
; PWR7-NEXT:    blr
%1 = icmp slt <2 x i128> %v1, %v2
%2 = select <2 x i1> %1, <2 x i128> %v1, <2 x i128> %v2
%3 = extractelement <2 x i128> %2, i32 0
ret i128 %3
}
