/* valascope.c generated by valac, the Vala compiler
 * generated from valascope.vala, do not modify */

/* valascope.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>

#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaParamSpecScope ValaParamSpecScope;

struct _ValaScopePrivate {
	ValaSymbol* _owner;
	ValaScope* _parent_scope;
	ValaMap* symbol_table;
	ValaList* anonymous_members;
};

struct _ValaParamSpecScope {
	GParamSpec parent_instance;
};


static gint ValaScope_private_offset;
static gpointer vala_scope_parent_class = NULL;

static void vala_scope_finalize (ValaScope * obj);


static inline gpointer
vala_scope_get_instance_private (ValaScope* self)
{
	return G_STRUCT_MEMBER_P (self, ValaScope_private_offset);
}


/**
 * Creates a new scope.
 *
 * @return newly created scope
 */
ValaScope*
vala_scope_construct (GType object_type,
                      ValaSymbol* owner)
{
	ValaScope* self = NULL;
	self = (ValaScope*) g_type_create_instance (object_type);
	vala_scope_set_owner (self, owner);
	return self;
}


ValaScope*
vala_scope_new (ValaSymbol* owner)
{
	return vala_scope_construct (VALA_TYPE_SCOPE, owner);
}


/**
 * Adds the specified symbol with the specified name to the symbol table
 * of this scope.
 *
 * @param name name for the specified symbol
 * @param sym  a symbol
 */
void
vala_scope_add (ValaScope* self,
                const gchar* name,
                ValaSymbol* sym)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (name != NULL) {
		ValaMap* _tmp0_;
		ValaMap* _tmp33_;
		_tmp0_ = self->priv->symbol_table;
		if (_tmp0_ == NULL) {
			GHashFunc _tmp1_;
			GEqualFunc _tmp2_;
			GEqualFunc _tmp3_;
			ValaHashMap* _tmp4_;
			_tmp1_ = g_str_hash;
			_tmp2_ = g_str_equal;
			_tmp3_ = g_direct_equal;
			_tmp4_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_, _tmp2_, _tmp3_);
			_vala_map_unref0 (self->priv->symbol_table);
			self->priv->symbol_table = (ValaMap*) _tmp4_;
		} else {
			ValaSymbol* _tmp5_;
			ValaSymbol* _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = vala_scope_lookup (self, name);
			_tmp6_ = _tmp5_;
			_tmp7_ = _tmp6_ != NULL;
			_vala_code_node_unref0 (_tmp6_);
			if (_tmp7_) {
				ValaSymbol* _tmp8_;
				gboolean _tmp9_ = FALSE;
				ValaSymbol* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaSourceReference* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp8_ = self->priv->_owner;
				vala_code_node_set_error ((ValaCodeNode*) _tmp8_, TRUE);
				_tmp10_ = self->priv->_owner;
				_tmp11_ = vala_symbol_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_ == NULL) {
					ValaSymbol* _tmp13_;
					ValaSymbol* _tmp14_;
					ValaSymbol* _tmp15_;
					_tmp13_ = self->priv->_owner;
					_tmp14_ = vala_symbol_get_parent_symbol (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp9_ = _tmp15_ == NULL;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					ValaSourceReference* _tmp16_;
					ValaSourceReference* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
					_tmp17_ = _tmp16_;
					_tmp18_ = g_strdup_printf ("The root namespace already contains a definition for `%s'", name);
					_tmp19_ = _tmp18_;
					vala_report_error (_tmp17_, _tmp19_);
					_g_free0 (_tmp19_);
				} else {
					ValaSourceReference* _tmp20_;
					ValaSourceReference* _tmp21_;
					ValaSymbol* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
					_tmp21_ = _tmp20_;
					_tmp22_ = self->priv->_owner;
					_tmp23_ = vala_symbol_get_full_name (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strdup_printf ("`%s' already contains a definition for `%s'", _tmp24_, name);
					_tmp26_ = _tmp25_;
					vala_report_error (_tmp21_, _tmp26_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
				}
				_tmp27_ = vala_scope_lookup (self, name);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("previous definition of `%s' was here", name);
				_tmp32_ = _tmp31_;
				vala_report_notice (_tmp30_, _tmp32_);
				_g_free0 (_tmp32_);
				_vala_code_node_unref0 (_tmp28_);
				return;
			}
		}
		_tmp33_ = self->priv->symbol_table;
		vala_map_set (_tmp33_, (const gchar*) name, sym);
	} else {
		ValaList* _tmp34_;
		ValaList* _tmp37_;
		_tmp34_ = self->priv->anonymous_members;
		if (_tmp34_ == NULL) {
			GEqualFunc _tmp35_;
			ValaArrayList* _tmp36_;
			_tmp35_ = g_direct_equal;
			_tmp36_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp35_);
			_vala_iterable_unref0 (self->priv->anonymous_members);
			self->priv->anonymous_members = (ValaList*) _tmp36_;
		}
		_tmp37_ = self->priv->anonymous_members;
		vala_collection_add ((ValaCollection*) _tmp37_, sym);
	}
	vala_symbol_set_owner (sym, self);
}


void
vala_scope_remove (ValaScope* self,
                   const gchar* name)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->symbol_table;
	vala_map_remove (_tmp0_, name);
}


/**
 * Returns the symbol stored in the symbol table with the specified
 * name.
 *
 * @param name name of the symbol to be returned
 * @return     found symbol or null
 */
ValaSymbol*
vala_scope_lookup (ValaScope* self,
                   const gchar* name)
{
	ValaSymbol* result = NULL;
	ValaMap* _tmp0_;
	ValaSymbol* sym = NULL;
	ValaMap* _tmp1_;
	gpointer _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaSymbol* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->symbol_table;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->symbol_table;
	_tmp2_ = vala_map_get (_tmp1_, name);
	sym = (ValaSymbol*) _tmp2_;
	_tmp4_ = sym;
	if (_tmp4_ != NULL) {
		ValaSymbol* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = sym;
		_tmp6_ = vala_symbol_get_active (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = !_tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_vala_code_node_unref0 (sym);
		sym = NULL;
	}
	result = sym;
	return result;
}


/**
 * Returns whether the specified scope is an ancestor of this scope.
 *
 * @param scope a scope or null for the root scope
 * @return      true if this scope is a subscope of the specified
 *              scope, false otherwise
 */
gboolean
vala_scope_is_subscope_of (ValaScope* self,
                           ValaScope* scope)
{
	gboolean result = FALSE;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (scope == self) {
		result = TRUE;
		return result;
	}
	if (scope == NULL) {
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_parent_scope;
	if (_tmp0_ != NULL) {
		ValaScope* _tmp1_;
		_tmp1_ = self->priv->_parent_scope;
		result = vala_scope_is_subscope_of (_tmp1_, scope);
		return result;
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


ValaMap*
vala_scope_get_symbol_table (ValaScope* self)
{
	ValaMap* result = NULL;
	ValaMap* _tmp0_;
	ValaMap* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->symbol_table;
	_tmp1_ = _vala_map_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaSymbol*
vala_scope_get_owner (ValaScope* self)
{
	ValaSymbol* result;
	ValaSymbol* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_owner;
	result = _tmp0_;
	return result;
}


void
vala_scope_set_owner (ValaScope* self,
                      ValaSymbol* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_owner = value;
}


ValaScope*
vala_scope_get_parent_scope (ValaScope* self)
{
	ValaScope* result;
	ValaScope* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_parent_scope;
	result = _tmp0_;
	return result;
}


void
vala_scope_set_parent_scope (ValaScope* self,
                             ValaScope* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_parent_scope = value;
}


static void
vala_value_scope_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_scope_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_scope_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_scope_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_scope_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_scope_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_scope_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaScope * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_scope_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_scope_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	ValaScope ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_scope_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_scope (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ValaParamSpecScope* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SCOPE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_scope (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_scope (GValue* value,
                      gpointer v_object)
{
	ValaScope * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCOPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_scope_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scope_unref (old);
	}
}


void
vala_value_take_scope (GValue* value,
                       gpointer v_object)
{
	ValaScope * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SCOPE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SCOPE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_scope_unref (old);
	}
}


static void
vala_scope_class_init (ValaScopeClass * klass)
{
	vala_scope_parent_class = g_type_class_peek_parent (klass);
	((ValaScopeClass *) klass)->finalize = vala_scope_finalize;
	g_type_class_adjust_private_offset (klass, &ValaScope_private_offset);
}


static void
vala_scope_instance_init (ValaScope * self)
{
	self->priv = vala_scope_get_instance_private (self);
	self->ref_count = 1;
}


static void
vala_scope_finalize (ValaScope * obj)
{
	ValaScope * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SCOPE, ValaScope);
	g_signal_handlers_destroy (self);
	_vala_map_unref0 (self->priv->symbol_table);
	_vala_iterable_unref0 (self->priv->anonymous_members);
}


/**
 * Represents a part of the symbol tree.
 */
GType
vala_scope_get_type (void)
{
	static volatile gsize vala_scope_type_id__volatile = 0;
	if (g_once_init_enter (&vala_scope_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_scope_init, vala_value_scope_free_value, vala_value_scope_copy_value, vala_value_scope_peek_pointer, "p", vala_value_scope_collect_value, "p", vala_value_scope_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaScopeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_scope_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaScope), 0, (GInstanceInitFunc) vala_scope_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_scope_type_id;
		vala_scope_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaScope", &g_define_type_info, &g_define_type_fundamental_info, 0);
		ValaScope_private_offset = g_type_add_instance_private (vala_scope_type_id, sizeof (ValaScopePrivate));
		g_once_init_leave (&vala_scope_type_id__volatile, vala_scope_type_id);
	}
	return vala_scope_type_id__volatile;
}


gpointer
vala_scope_ref (gpointer instance)
{
	ValaScope * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_scope_unref (gpointer instance)
{
	ValaScope * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SCOPE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



