// Generated by gmmproc 2.55.2 -- DO NOT MODIFY!
#ifndef _GTKMM_ENUMS_H
#define _GTKMM_ENUMS_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * Copyright (C) 2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/value.h>
#include <gtk/gtk.h>


namespace Gtk
{


/** @addtogroup gtkmmEnums gtkmm Enums and Flags */

/** 
 *  @var AccelFlags VISIBLE
 * Accelerator is visible.
 * 
 *  @var AccelFlags LOCKED
 * Accelerator not removable.
 * 
 *  @var AccelFlags MASK
 * Mask.
 * 
 *  @enum AccelFlags
 * 
 * Accelerator flags used with Gtk::AccelGroup::connect().
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>AccelFlags operator|(AccelFlags, AccelFlags)</tt><br>
 * <tt>AccelFlags operator&(AccelFlags, AccelFlags)</tt><br>
 * <tt>AccelFlags operator^(AccelFlags, AccelFlags)</tt><br>
 * <tt>AccelFlags operator~(AccelFlags)</tt><br>
 * <tt>AccelFlags& operator|=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>AccelFlags& operator&=(AccelFlags&, AccelFlags)</tt><br>
 * <tt>AccelFlags& operator^=(AccelFlags&, AccelFlags)</tt><br>
 */
enum class AccelFlags
{
  VISIBLE = 1 << 0,
  LOCKED = 1 << 1,
  MASK = 0x07
};

/** @ingroup gtkmmEnums */
inline AccelFlags operator|(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator&(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator^(AccelFlags lhs, AccelFlags rhs)
  { return static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline AccelFlags operator~(AccelFlags flags)
  { return static_cast<AccelFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator|=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator&=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline AccelFlags& operator^=(AccelFlags& lhs, AccelFlags rhs)
  { return (lhs = static_cast<AccelFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::AccelFlags> : public Glib::Value_Flags<Gtk::AccelFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var Align FILL
 * Stretch to fill all space if possible, center if
 * no meaningful way to stretch.
 * 
 *  @var Align START
 * Snap to left or top side, leaving space on right
 * or bottom.
 * 
 *  @var Align END
 * Snap to right or bottom side, leaving space on left
 * or top.
 * 
 *  @var Align CENTER
 * Center natural width of widget inside the
 * allocation.
 * 
 *  @var Align BASELINE
 * Align the widget according to the baseline. @newin{3,10}
 * 
 *  @enum Align
 * 
 * Controls how a widget deals with extra space in a single (x or y)
 * dimension.
 * 
 * Alignment only matters if the widget receives a “too large” allocation,
 * for example if you packed the widget with the Gtk::Widget::property_expand()
 * flag inside a Gtk::Box, then the widget might get extra space.  If
 * you have for example a 16x16 icon inside a 32x32 space, the icon
 * could be scaled and stretched, it could be centered, or it could be
 * positioned to one side of the space.
 * 
 * Note that in horizontal context @a GTK_ALIGN_START and @a GTK_ALIGN_END
 * are interpreted relative to text direction.
 * 
 * GTK_ALIGN_BASELINE support for it is optional for containers and widgets, and
 * it is only supported for vertical alignment.  When its not supported by
 * a child or a container it is treated as @a GTK_ALIGN_FILL.
 *
 * @ingroup gtkmmEnums
 */
enum class Align
{
  FILL,
  START,
  END,
  CENTER,
  BASELINE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Align> : public Glib::Value_Enum<Gtk::Align>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ArrowType UP
 * Represents an upward pointing arrow.
 * 
 *  @var ArrowType DOWN
 * Represents a downward pointing arrow.
 * 
 *  @var ArrowType LEFT
 * Represents a left pointing arrow.
 * 
 *  @var ArrowType RIGHT
 * Represents a right pointing arrow.
 * 
 *  @var ArrowType NONE
 * No arrow. @newin{2,10}
 * 
 *  @enum ArrowType
 * 
 * Used to indicate the direction in which an arrow should point.
 *
 * @ingroup gtkmmEnums
 */
enum class ArrowType
{
  UP,
  DOWN,
  LEFT,
  RIGHT,
  NONE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ArrowType> : public Glib::Value_Enum<Gtk::ArrowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ButtonBoxStyle SPREAD
 * Buttons are evenly spread across the box.
 * 
 *  @var ButtonBoxStyle EDGE
 * Buttons are placed at the edges of the box.
 * 
 *  @var ButtonBoxStyle START
 * Buttons are grouped towards the start of the box,
 * (on the left for a HBox, or the top for a VBox).
 * 
 *  @var ButtonBoxStyle END
 * Buttons are grouped towards the end of the box,
 * (on the right for a HBox, or the bottom for a VBox).
 * 
 *  @var ButtonBoxStyle CENTER
 * Buttons are centered in the box. @newin{2,12}
 * 
 *  @var ButtonBoxStyle EXPAND
 * Buttons expand to fill the box. This entails giving
 * buttons a "linked" appearance, making button sizes homogeneous, and
 * setting spacing to 0 (same as calling Gtk::Box::set_homogeneous() and
 * Gtk::Box::set_spacing() manually). @newin{3,12}
 * 
 *  @enum ButtonBoxStyle
 * 
 * Used to dictate the style that a Gtk::ButtonBox uses to layout the buttons it
 * contains.
 *
 * @ingroup gtkmmEnums
 */
enum class ButtonBoxStyle
{
  SPREAD = 1,
  EDGE,
  START,
  END,
  CENTER,
  EXPAND
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ButtonBoxStyle> : public Glib::Value_Enum<Gtk::ButtonBoxStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var DeleteType CHARS
 * Delete characters.
 * 
 *  @var DeleteType WORD_ENDS
 * Delete only the portion of the word to the
 * left/right of cursor if we’re in the middle of a word.
 * 
 *  @var DeleteType WORDS
 * Delete words.
 * 
 *  @var DeleteType DISPLAY_LINES
 * Delete display-lines. Display-lines
 * refers to the visible lines, with respect to to the current line
 * breaks. As opposed to paragraphs, which are defined by line
 * breaks in the input.
 * 
 *  @var DeleteType DISPLAY_LINE_ENDS
 * Delete only the portion of the
 * display-line to the left/right of cursor.
 * 
 *  @var DeleteType PARAGRAPH_ENDS
 * Delete to the end of the
 * paragraph. Like C-k in Emacs (or its reverse).
 * 
 *  @var DeleteType PARAGRAPHS
 * Delete entire line. Like C-k in pico.
 * 
 *  @var DeleteType WHITESPACE
 * Delete only whitespace. Like M-\\ in Emacs.
 * 
 *  @enum DeleteType
 * 
 * See also: Gtk::Entry::signal_delete_from_cursor().
 *
 * @ingroup gtkmmEnums
 */
enum class DeleteType
{
  CHARS,
  WORD_ENDS,
  WORDS,
  DISPLAY_LINES,
  DISPLAY_LINE_ENDS,
  PARAGRAPH_ENDS,
  PARAGRAPHS,
  WHITESPACE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DeleteType> : public Glib::Value_Enum<Gtk::DeleteType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var DirectionType TAB_FORWARD
 * Move forward.
 * 
 *  @var DirectionType TAB_BACKWARD
 * Move backward.
 * 
 *  @var DirectionType UP
 * Move up.
 * 
 *  @var DirectionType DOWN
 * Move down.
 * 
 *  @var DirectionType LEFT
 * Move left.
 * 
 *  @var DirectionType RIGHT
 * Move right.
 * 
 *  @enum DirectionType
 * 
 * Focus movement types.
 *
 * @ingroup gtkmmEnums
 */
enum class DirectionType
{
  TAB_FORWARD,
  TAB_BACKWARD,
  UP,
  DOWN,
  LEFT,
  RIGHT
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::DirectionType> : public Glib::Value_Enum<Gtk::DirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var IconSize INHERIT
 * Keep the size of the parent element.
 * 
 *  @var IconSize NORMAL
 * Size similar to text size.
 * 
 *  @var IconSize LARGE
 * Large size, for example in an icon view.
 * 
 *  @enum IconSize
 * 
 * Built-in icon sizes.
 * 
 * Icon sizes default to being inherited. Where they cannot be
 * inherited, text size is the default.
 * 
 * All widgets which use GtkIconSize set the normal-icons or large-icons
 * style classes correspondingly, and let themes determine the actual size
 * to be used with the -gtk-icon-size CSS property.
 *
 * @ingroup gtkmmEnums
 */
enum class IconSize
{
  INHERIT,
  NORMAL,
  LARGE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::IconSize> : public Glib::Value_Enum<Gtk::IconSize>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var TextDirection NONE
 * No direction.
 * 
 *  @var TextDirection LTR
 * Left to right text direction.
 * 
 *  @var TextDirection RTL
 * Right to left text direction.
 * 
 *  @enum TextDirection
 * 
 * Reading directions for text.
 *
 * @ingroup gtkmmEnums
 */
enum class TextDirection
{
  NONE,
  LTR,
  RTL
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::TextDirection> : public Glib::Value_Enum<Gtk::TextDirection>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var Justification LEFT
 * The text is placed at the left edge of the label.
 * 
 *  @var Justification RIGHT
 * The text is placed at the right edge of the label.
 * 
 *  @var Justification CENTER
 * The text is placed in the center of the label.
 * 
 *  @var Justification FILL
 * The text is placed is distributed across the label.
 * 
 *  @enum Justification
 * 
 * Used for justifying the text inside a Gtk::Label widget. (See also
 * Gtk::Alignment).
 *
 * @ingroup gtkmmEnums
 */
enum class Justification
{
  LEFT,
  RIGHT,
  CENTER,
  FILL
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Justification> : public Glib::Value_Enum<Gtk::Justification>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var MenuDirectionType PARENT
 * To the parent menu shell.
 * 
 *  @var MenuDirectionType CHILD
 * To the submenu, if any, associated with the item.
 * 
 *  @var MenuDirectionType NEXT
 * To the next menu item.
 * 
 *  @var MenuDirectionType PREV
 * To the previous menu item.
 * 
 *  @enum MenuDirectionType
 * 
 * An enumeration representing directional movements within a menu.
 *
 * @ingroup gtkmmEnums
 */
enum class MenuDirectionType
{
  PARENT,
  CHILD,
  NEXT,
  PREV
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MenuDirectionType> : public Glib::Value_Enum<Gtk::MenuDirectionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var MessageType INFO
 * Informational message.
 * 
 *  @var MessageType WARNING
 * Non-fatal warning message.
 * 
 *  @var MessageType QUESTION
 * Question requiring a choice.
 * 
 *  @var MessageType ERROR
 * Fatal error message.
 * 
 *  @var MessageType OTHER
 * None of the above.
 * 
 *  @enum MessageType
 * 
 * The type of message being displayed in the dialog.
 *
 * @ingroup gtkmmEnums
 */
enum class MessageType
{
  INFO,
  WARNING,
  QUESTION,
  ERROR,
  OTHER
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MessageType> : public Glib::Value_Enum<Gtk::MessageType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var MovementStep LOGICAL_POSITIONS
 * Move forward or back by graphemes.
 * 
 *  @var MovementStep VISUAL_POSITIONS
 * Move left or right by graphemes.
 * 
 *  @var MovementStep WORDS
 * Move forward or back by words.
 * 
 *  @var MovementStep DISPLAY_LINES
 * Move up or down lines (wrapped lines).
 * 
 *  @var MovementStep DISPLAY_LINE_ENDS
 * Move to either end of a line.
 * 
 *  @var MovementStep PARAGRAPHS
 * Move up or down paragraphs (newline-ended lines).
 * 
 *  @var MovementStep PARAGRAPH_ENDS
 * Move to either end of a paragraph.
 * 
 *  @var MovementStep PAGES
 * Move by pages.
 * 
 *  @var MovementStep BUFFER_ENDS
 * Move to ends of the buffer.
 * 
 *  @var MovementStep HORIZONTAL_PAGES
 * Move horizontally by pages.
 * 
 *  @enum MovementStep
 *
 * @ingroup gtkmmEnums
 */
enum class MovementStep
{
  LOGICAL_POSITIONS,
  VISUAL_POSITIONS,
  WORDS,
  DISPLAY_LINES,
  DISPLAY_LINE_ENDS,
  PARAGRAPHS,
  PARAGRAPH_ENDS,
  PAGES,
  BUFFER_ENDS,
  HORIZONTAL_PAGES
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::MovementStep> : public Glib::Value_Enum<Gtk::MovementStep>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var Orientation HORIZONTAL
 * The element is in horizontal orientation.
 * 
 *  @var Orientation VERTICAL
 * The element is in vertical orientation.
 * 
 *  @enum Orientation
 * 
 * Represents the orientation of widgets and other objects which can be switched
 * between horizontal and vertical orientation on the fly, like Gtk::Toolbar or
 * Gtk::GesturePan.
 *
 * @ingroup gtkmmEnums
 */
enum class Orientation
{
  HORIZONTAL,
  VERTICAL
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::Orientation> : public Glib::Value_Enum<Gtk::Orientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var CornerType TOP_LEFT
 * Place the scrollbars on the right and bottom of the
 * widget (default behaviour).
 * 
 *  @var CornerType BOTTOM_LEFT
 * Place the scrollbars on the top and right of the
 * widget.
 * 
 *  @var CornerType TOP_RIGHT
 * Place the scrollbars on the left and bottom of the
 * widget.
 * 
 *  @var CornerType BOTTOM_RIGHT
 * Place the scrollbars on the top and left of the
 * widget.
 * 
 *  @enum CornerType
 * 
 * Specifies which corner a child widget should be placed in when packed into
 * a Gtk::ScrolledWindow. This is effectively the opposite of where the scroll
 * bars are placed.
 *
 * @ingroup gtkmmEnums
 */
enum class CornerType
{
  TOP_LEFT,
  BOTTOM_LEFT,
  TOP_RIGHT,
  BOTTOM_RIGHT
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::CornerType> : public Glib::Value_Enum<Gtk::CornerType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PackType START
 * The child is packed into the start of the box.
 * 
 *  @var PackType END
 * The child is packed into the end of the box.
 * 
 *  @enum PackType
 * 
 * Represents the packing location Gtk::Box children. (See: Gtk::VBox,
 * Gtk::HBox, and Gtk::ButtonBox).
 *
 * @ingroup gtkmmEnums
 */
enum class PackType
{
  START,
  END
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PackType> : public Glib::Value_Enum<Gtk::PackType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>PlacesOpenFlags operator|(PlacesOpenFlags, PlacesOpenFlags)</tt><br>
 * <tt>PlacesOpenFlags operator&(PlacesOpenFlags, PlacesOpenFlags)</tt><br>
 * <tt>PlacesOpenFlags operator^(PlacesOpenFlags, PlacesOpenFlags)</tt><br>
 * <tt>PlacesOpenFlags operator~(PlacesOpenFlags)</tt><br>
 * <tt>PlacesOpenFlags& operator|=(PlacesOpenFlags&, PlacesOpenFlags)</tt><br>
 * <tt>PlacesOpenFlags& operator&=(PlacesOpenFlags&, PlacesOpenFlags)</tt><br>
 * <tt>PlacesOpenFlags& operator^=(PlacesOpenFlags&, PlacesOpenFlags)</tt><br>
 */
enum class PlacesOpenFlags
{
  NORMAL = 1 << 0,
  NEW_TAB = 1 << 1,
  NEW_WINDOW = 1 << 2
};

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator|(PlacesOpenFlags lhs, PlacesOpenFlags rhs)
  { return static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator&(PlacesOpenFlags lhs, PlacesOpenFlags rhs)
  { return static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator^(PlacesOpenFlags lhs, PlacesOpenFlags rhs)
  { return static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags operator~(PlacesOpenFlags flags)
  { return static_cast<PlacesOpenFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags& operator|=(PlacesOpenFlags& lhs, PlacesOpenFlags rhs)
  { return (lhs = static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags& operator&=(PlacesOpenFlags& lhs, PlacesOpenFlags rhs)
  { return (lhs = static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline PlacesOpenFlags& operator^=(PlacesOpenFlags& lhs, PlacesOpenFlags rhs)
  { return (lhs = static_cast<PlacesOpenFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PlacesOpenFlags> : public Glib::Value_Flags<Gtk::PlacesOpenFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PolicyType ALWAYS
 * The scrollbar is always visible. The view size is
 * independent of the content.
 * 
 *  @var PolicyType AUTOMATIC
 * The scrollbar will appear and disappear as necessary.
 * For example, when all of a Gtk::TreeView can not be seen.
 * 
 *  @var PolicyType NEVER
 * The scrollbar should never appear. In this mode the
 * content determines the size.
 * 
 *  @var PolicyType EXTERNAL
 * Don't show a scrollbar, but don't force the
 * size to follow the content. This can be used e.g. to make multiple
 * scrolled windows share a scrollbar.
 * 
 *  @enum PolicyType
 * 
 * Determines how the size should be computed to achieve the one of the
 * visibility mode for the scrollbars.
 *
 * @ingroup gtkmmEnums
 */
enum class PolicyType
{
  ALWAYS,
  AUTOMATIC,
  NEVER,
  EXTERNAL
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PolicyType> : public Glib::Value_Enum<Gtk::PolicyType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PositionType LEFT
 * The feature is at the left edge.
 * 
 *  @var PositionType RIGHT
 * The feature is at the right edge.
 * 
 *  @var PositionType TOP
 * The feature is at the top edge.
 * 
 *  @var PositionType BOTTOM
 * The feature is at the bottom edge.
 * 
 *  @enum PositionType
 * 
 * Describes which edge of a widget a certain feature is positioned at, e.g. the
 * tabs of a Gtk::Notebook, the handle of a Gtk::HandleBox or the label of a
 * Gtk::Scale.
 *
 * @ingroup gtkmmEnums
 */
enum class PositionType
{
  LEFT,
  RIGHT,
  TOP,
  BOTTOM
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PositionType> : public Glib::Value_Enum<Gtk::PositionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ReliefStyle NORMAL
 * Draw a normal relief.
 * 
 *  @var ReliefStyle NONE
 * No relief.
 * 
 *  @enum ReliefStyle
 * 
 * Indicated the relief to be drawn around a Gtk::Button.
 *
 * @ingroup gtkmmEnums
 */
enum class ReliefStyle
{
  NORMAL,
  NONE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ReliefStyle> : public Glib::Value_Enum<Gtk::ReliefStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var RevealerTransitionType NONE
 * No transition.
 * 
 *  @var RevealerTransitionType CROSSFADE
 * Fade in.
 * 
 *  @var RevealerTransitionType SLIDE_RIGHT
 * Slide in from the left.
 * 
 *  @var RevealerTransitionType SLIDE_LEFT
 * Slide in from the right.
 * 
 *  @var RevealerTransitionType SLIDE_UP
 * Slide in from the bottom.
 * 
 *  @var RevealerTransitionType SLIDE_DOWN
 * Slide in from the top.
 * 
 *  @enum RevealerTransitionType
 * 
 * These enumeration values describe the possible transitions
 * when the child of a Gtk::Revealer widget is shown or hidden.
 *
 * @ingroup gtkmmEnums
 */
enum class RevealerTransitionType
{
  NONE,
  CROSSFADE,
  SLIDE_RIGHT,
  SLIDE_LEFT,
  SLIDE_UP,
  SLIDE_DOWN
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::RevealerTransitionType> : public Glib::Value_Enum<Gtk::RevealerTransitionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ScrollType NONE
 * No scrolling.
 * 
 *  @var ScrollType JUMP
 * Jump to new location.
 * 
 *  @var ScrollType STEP_BACKWARD
 * Step backward.
 * 
 *  @var ScrollType STEP_FORWARD
 * Step forward.
 * 
 *  @var ScrollType PAGE_BACKWARD
 * Page backward.
 * 
 *  @var ScrollType PAGE_FORWARD
 * Page forward.
 * 
 *  @var ScrollType STEP_UP
 * Step up.
 * 
 *  @var ScrollType STEP_DOWN
 * Step down.
 * 
 *  @var ScrollType PAGE_UP
 * Page up.
 * 
 *  @var ScrollType PAGE_DOWN
 * Page down.
 * 
 *  @var ScrollType STEP_LEFT
 * Step to the left.
 * 
 *  @var ScrollType STEP_RIGHT
 * Step to the right.
 * 
 *  @var ScrollType PAGE_LEFT
 * Page to the left.
 * 
 *  @var ScrollType PAGE_RIGHT
 * Page to the right.
 * 
 *  @var ScrollType START
 * Scroll to start.
 * 
 *  @var ScrollType END
 * Scroll to end.
 * 
 *  @enum ScrollType
 * 
 * Scrolling types.
 *
 * @ingroup gtkmmEnums
 */
enum class ScrollType
{
  NONE,
  JUMP,
  STEP_BACKWARD,
  STEP_FORWARD,
  PAGE_BACKWARD,
  PAGE_FORWARD,
  STEP_UP,
  STEP_DOWN,
  PAGE_UP,
  PAGE_DOWN,
  STEP_LEFT,
  STEP_RIGHT,
  PAGE_LEFT,
  PAGE_RIGHT,
  START,
  END
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ScrollType> : public Glib::Value_Enum<Gtk::ScrollType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SelectionMode NONE
 * No selection is possible.
 * 
 *  @var SelectionMode SINGLE
 * Zero or one element may be selected.
 * 
 *  @var SelectionMode BROWSE
 * Exactly one element is selected.
 * In some circumstances, such as initially or during a search
 * operation, it’s possible for no element to be selected with
 * Gtk::SelectionMode::BROWSE. What is really enforced is that the user
 * can’t deselect a currently selected element except by selecting
 * another element.
 * 
 *  @var SelectionMode MULTIPLE
 * Any number of elements may be selected.
 * The Ctrl key may be used to enlarge the selection, and Shift
 * key to select between the focus and the child pointed to.
 * Some widgets may also allow Click-drag to select a range of elements.
 * 
 *  @enum SelectionMode
 * 
 * Used to control what selections users are allowed to make.
 *
 * @ingroup gtkmmEnums
 */
enum class SelectionMode
{
  NONE,
  SINGLE,
  BROWSE,
  MULTIPLE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SelectionMode> : public Glib::Value_Enum<Gtk::SelectionMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ShadowType NONE
 * No outline.
 * 
 *  @var ShadowType IN
 * The outline is bevelled inwards.
 * 
 *  @var ShadowType OUT
 * The outline is bevelled outwards like a button.
 * 
 *  @var ShadowType ETCHED_IN
 * The outline has a sunken 3d appearance.
 * 
 *  @var ShadowType ETCHED_OUT
 * The outline has a raised 3d appearance.
 * 
 *  @enum ShadowType
 * 
 * Used to change the appearance of an outline typically provided by a Gtk::Frame.
 * 
 * Note that many themes do not differentiate the appearance of the
 * various shadow types: Either their is no visible shadow ( @a GTK_SHADOW_NONE),
 * or there is (any other value).
 *
 * @ingroup gtkmmEnums
 */
enum class ShadowType
{
  NONE,
  IN,
  OUT,
  ETCHED_IN,
  ETCHED_OUT
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ShadowType> : public Glib::Value_Enum<Gtk::ShadowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var StackTransitionType NONE
 * No transition.
 * 
 *  @var StackTransitionType CROSSFADE
 * A cross-fade.
 * 
 *  @var StackTransitionType SLIDE_RIGHT
 * Slide from left to right.
 * 
 *  @var StackTransitionType SLIDE_LEFT
 * Slide from right to left.
 * 
 *  @var StackTransitionType SLIDE_UP
 * Slide from bottom up.
 * 
 *  @var StackTransitionType SLIDE_DOWN
 * Slide from top down.
 * 
 *  @var StackTransitionType SLIDE_LEFT_RIGHT
 * Slide from left or right according to the children order.
 * 
 *  @var StackTransitionType SLIDE_UP_DOWN
 * Slide from top down or bottom up according to the order.
 * 
 *  @var StackTransitionType OVER_UP
 * Cover the old page by sliding up.
 * 
 *  @var StackTransitionType OVER_DOWN
 * Cover the old page by sliding down.
 * 
 *  @var StackTransitionType OVER_LEFT
 * Cover the old page by sliding to the left.
 * 
 *  @var StackTransitionType OVER_RIGHT
 * Cover the old page by sliding to the right.
 * 
 *  @var StackTransitionType UNDER_UP
 * Uncover the new page by sliding up.
 * 
 *  @var StackTransitionType UNDER_DOWN
 * Uncover the new page by sliding down.
 * 
 *  @var StackTransitionType UNDER_LEFT
 * Uncover the new page by sliding to the left.
 * 
 *  @var StackTransitionType UNDER_RIGHT
 * Uncover the new page by sliding to the right.
 * 
 *  @var StackTransitionType OVER_UP_DOWN
 * Cover the old page sliding up or uncover the new page sliding down, according to order.
 * 
 *  @var StackTransitionType OVER_DOWN_UP
 * Cover the old page sliding down or uncover the new page sliding up, according to order.
 * 
 *  @var StackTransitionType OVER_LEFT_RIGHT
 * Cover the old page sliding left or uncover the new page sliding right, according to order.
 * 
 *  @var StackTransitionType OVER_RIGHT_LEFT
 * Cover the old page sliding right or uncover the new page sliding left, according to order.
 * 
 *  @enum StackTransitionType
 * 
 * These enumeration values describe the possible transitions
 * between pages in a Gtk::Stack widget.
 * 
 * New values may be added to this enumeration over time.
 *
 * @ingroup gtkmmEnums
 */
enum class StackTransitionType
{
  NONE,
  CROSSFADE,
  SLIDE_RIGHT,
  SLIDE_LEFT,
  SLIDE_UP,
  SLIDE_DOWN,
  SLIDE_LEFT_RIGHT,
  SLIDE_UP_DOWN,
  OVER_UP,
  OVER_DOWN,
  OVER_LEFT,
  OVER_RIGHT,
  UNDER_UP,
  UNDER_DOWN,
  UNDER_LEFT,
  UNDER_RIGHT,
  OVER_UP_DOWN,
  OVER_DOWN_UP,
  OVER_LEFT_RIGHT,
  OVER_RIGHT_LEFT
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StackTransitionType> : public Glib::Value_Enum<Gtk::StackTransitionType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var ToolbarStyle ICONS
 * Buttons display only icons in the toolbar.
 * 
 *  @var ToolbarStyle TEXT
 * Buttons display only text labels in the toolbar.
 * 
 *  @var ToolbarStyle BOTH
 * Buttons display text and icons in the toolbar.
 * 
 *  @var ToolbarStyle BOTH_HORIZ
 * Buttons display icons and text alongside each
 * other, rather than vertically stacked.
 * 
 *  @enum ToolbarStyle
 * 
 * Used to customize the appearance of a Gtk::Toolbar. Note that
 * setting the toolbar style overrides the user’s preferences
 * for the default toolbar style.  Note that if the button has only
 * a label set and GTK_TOOLBAR_ICONS is used, the label will be
 * visible, and vice versa.
 *
 * @ingroup gtkmmEnums
 */
enum class ToolbarStyle
{
  ICONS,
  TEXT,
  BOTH,
  BOTH_HORIZ
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::ToolbarStyle> : public Glib::Value_Enum<Gtk::ToolbarStyle>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var WindowPosition NONE
 * No influence is made on placement.
 * 
 *  @var WindowPosition CENTER
 * Windows should be placed in the center of the screen.
 * 
 *  @var WindowPosition MOUSE
 * Windows should be placed at the current mouse position.
 * 
 *  @var WindowPosition CENTER_ALWAYS
 * Keep window centered as it changes size, etc.
 * 
 *  @var WindowPosition CENTER_ON_PARENT
 * Center the window on its transient
 * parent (see Gtk::Window::set_transient_for()).
 * 
 *  @enum WindowPosition
 * 
 * Window placement can be influenced using this enumeration. Note that
 * using Gtk::WindowPosition::CENTER_ALWAYS is almost always a bad idea.
 * It won’t necessarily work well with all window managers or on all windowing systems.
 *
 * @ingroup gtkmmEnums
 */
enum class WindowPosition
{
  NONE,
  CENTER,
  MOUSE,
  CENTER_ALWAYS,
  CENTER_ON_PARENT
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowPosition> : public Glib::Value_Enum<Gtk::WindowPosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var WindowType TOPLEVEL
 * A regular window, such as a dialog.
 * 
 *  @var WindowType POPUP
 * A special window such as a tooltip.
 * 
 *  @enum WindowType
 * 
 * A Gtk::Window can be one of these types. Most things you’d consider a
 * “window” should have type Gtk::WindowType::TOPLEVEL; windows with this type
 * are managed by the window manager and have a frame by default (call
 * Gtk::Window::set_decorated() to toggle the frame).  Windows with type
 * Gtk::WindowType::POPUP are ignored by the window manager; window manager
 * keybindings won’t work on them, the window manager won’t decorate the
 * window with a frame, many GTK+ features that rely on the window
 * manager will not work (e.g. maximization/minimization).
 * Gtk::WindowType::POPUP is used to implement
 * widgets such as Gtk::Menu or tooltips that you normally don’t think of
 * as windows per se. Nearly all windows should be Gtk::WindowType::TOPLEVEL.
 * In particular, do not use Gtk::WindowType::POPUP just to turn off
 * the window borders; use Gtk::Window::set_decorated() for that.
 *
 * @ingroup gtkmmEnums
 */
enum class WindowType
{
  TOPLEVEL,
  POPUP
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WindowType> : public Glib::Value_Enum<Gtk::WindowType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var WrapMode NONE
 * Do not wrap lines; just make the text area wider.
 * 
 *  @var WrapMode CHAR
 * Wrap text, breaking lines anywhere the cursor can
 * appear (between characters, usually - if you want to be technical,
 * between graphemes, see pango_get_log_attrs()).
 * 
 *  @var WrapMode WORD
 * Wrap text, breaking lines in between words.
 * 
 *  @var WrapMode WORD_CHAR
 * Wrap text, breaking lines in between words, or if
 * that is not enough, also between graphemes.
 * 
 *  @enum WrapMode
 * 
 * Describes a type of line wrapping.
 *
 * @ingroup gtkmmEnums
 */
enum class WrapMode
{
  NONE,
  CHAR,
  WORD,
  WORD_CHAR
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::WrapMode> : public Glib::Value_Enum<Gtk::WrapMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SortType ASCENDING
 * Sorting is in ascending order.
 * 
 *  @var SortType DESCENDING
 * Sorting is in descending order.
 * 
 *  @enum SortType
 * 
 * Determines the direction of a sort.
 *
 * @ingroup gtkmmEnums
 */
enum class SortType
{
  ASCENDING,
  DESCENDING
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SortType> : public Glib::Value_Enum<Gtk::SortType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var PageOrientation PORTRAIT
 * Portrait mode.
 * 
 *  @var PageOrientation LANDSCAPE
 * Landscape mode.
 * 
 *  @var PageOrientation REVERSE_PORTRAIT
 * Reverse portrait mode.
 * 
 *  @var PageOrientation REVERSE_LANDSCAPE
 * Reverse landscape mode.
 * 
 *  @enum PageOrientation
 * 
 * See also Gtk::PrintSettings::set_orientation().
 *
 * @ingroup gtkmmEnums
 */
enum class PageOrientation
{
  PORTRAIT,
  LANDSCAPE,
  REVERSE_PORTRAIT,
  REVERSE_LANDSCAPE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::PageOrientation> : public Glib::Value_Enum<Gtk::PageOrientation>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SensitivityType AUTO
 * The arrow is made insensitive if the
 * thumb is at the end.
 * 
 *  @var SensitivityType ON
 * The arrow is always sensitive.
 * 
 *  @var SensitivityType OFF
 * The arrow is always insensitive.
 * 
 *  @enum SensitivityType
 * 
 * Determines how GTK+ handles the sensitivity of stepper arrows
 * at the end of range widgets.
 *
 * @ingroup gtkmmEnums
 */
enum class SensitivityType
{
  AUTO,
  ON,
  OFF
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SensitivityType> : public Glib::Value_Enum<Gtk::SensitivityType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var SizeRequestMode HEIGHT_FOR_WIDTH
 * Prefer height-for-width geometry management.
 * 
 *  @var SizeRequestMode WIDTH_FOR_HEIGHT
 * Prefer width-for-height geometry management.
 * 
 *  @var SizeRequestMode CONSTANT_SIZE
 * Don’t trade height-for-width or width-for-height.
 * 
 *  @enum SizeRequestMode
 * 
 * Specifies a preference for height-for-width or
 * width-for-height geometry management.
 *
 * @ingroup gtkmmEnums
 */
enum class SizeRequestMode
{
  HEIGHT_FOR_WIDTH,
  WIDTH_FOR_HEIGHT,
  CONSTANT_SIZE
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::SizeRequestMode> : public Glib::Value_Enum<Gtk::SizeRequestMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var StateFlags NORMAL
 * State during normal operation.
 * 
 *  @var StateFlags ACTIVE
 * Widget is active.
 * 
 *  @var StateFlags PRELIGHT
 * Widget has a mouse pointer over it.
 * 
 *  @var StateFlags SELECTED
 * Widget is selected.
 * 
 *  @var StateFlags INSENSITIVE
 * Widget is insensitive.
 * 
 *  @var StateFlags INCONSISTENT
 * Widget is inconsistent.
 * 
 *  @var StateFlags FOCUSED
 * Widget has the keyboard focus.
 * 
 *  @var StateFlags BACKDROP
 * Widget is in a background toplevel window.
 * 
 *  @var StateFlags DIR_LTR
 * Widget is in left-to-right text direction.
 * 
 *  @var StateFlags DIR_RTL
 * Widget is in right-to-left text direction.
 * 
 *  @var StateFlags LINK
 * Widget is a link.
 * 
 *  @var StateFlags VISITED
 * The location the widget points to has already been visited.
 * 
 *  @var StateFlags CHECKED
 * Widget is checked.
 * 
 *  @var StateFlags DROP_ACTIVE
 * Widget is highlighted as a drop target for DND.
 * 
 *  @var StateFlags FOCUS_VISIBLE
 * Widget has the visible focus.
 * 
 *  @enum StateFlags
 * 
 * Describes a widget state. Widget states are used to match the widget
 * against CSS pseudo-classes. Note that GTK extends the regular CSS
 * classes and sometimes uses different names.
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>StateFlags operator|(StateFlags, StateFlags)</tt><br>
 * <tt>StateFlags operator&(StateFlags, StateFlags)</tt><br>
 * <tt>StateFlags operator^(StateFlags, StateFlags)</tt><br>
 * <tt>StateFlags operator~(StateFlags)</tt><br>
 * <tt>StateFlags& operator|=(StateFlags&, StateFlags)</tt><br>
 * <tt>StateFlags& operator&=(StateFlags&, StateFlags)</tt><br>
 * <tt>StateFlags& operator^=(StateFlags&, StateFlags)</tt><br>
 */
enum class StateFlags
{
  NORMAL = 0x0,
  ACTIVE = 1 << 0,
  PRELIGHT = 1 << 1,
  SELECTED = 1 << 2,
  INSENSITIVE = 1 << 3,
  INCONSISTENT = 1 << 4,
  FOCUSED = 1 << 5,
  BACKDROP = 1 << 6,
  DIR_LTR = 1 << 7,
  DIR_RTL = 1 << 8,
  LINK = 1 << 9,
  VISITED = 1 << 10,
  CHECKED = 1 << 11,
  DROP_ACTIVE = 1 << 12,
  FOCUS_VISIBLE = 1 << 13
};

/** @ingroup gtkmmEnums */
inline StateFlags operator|(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator&(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator^(StateFlags lhs, StateFlags rhs)
  { return static_cast<StateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline StateFlags operator~(StateFlags flags)
  { return static_cast<StateFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator|=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator&=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline StateFlags& operator^=(StateFlags& lhs, StateFlags rhs)
  { return (lhs = static_cast<StateFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::StateFlags> : public Glib::Value_Flags<Gtk::StateFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var InputPurpose FREE_FORM
 * Allow any character.
 * 
 *  @var InputPurpose ALPHA
 * Allow only alphabetic characters.
 * 
 *  @var InputPurpose DIGITS
 * Allow only digits.
 * 
 *  @var InputPurpose NUMBER
 * Edited field expects numbers.
 * 
 *  @var InputPurpose PHONE
 * Edited field expects phone number.
 * 
 *  @var InputPurpose URL
 * Edited field expects URL.
 * 
 *  @var InputPurpose EMAIL
 * Edited field expects email address.
 * 
 *  @var InputPurpose NAME
 * Edited field expects the name of a person.
 * 
 *  @var InputPurpose PASSWORD
 * Like @a GTK_INPUT_PURPOSE_FREE_FORM, but characters are hidden.
 * 
 *  @var InputPurpose PIN
 * Like @a GTK_INPUT_PURPOSE_DIGITS, but characters are hidden.
 * 
 *  @enum InputPurpose
 * 
 * Describes primary purpose of the input widget. This information is
 * useful for on-screen keyboards and similar input methods to decide
 * which keys should be presented to the user.
 * 
 * Note that the purpose is not meant to impose a totally strict rule
 * about allowed characters, and does not replace input validation.
 * It is fine for an on-screen keyboard to let the user override the
 * character set restriction that is expressed by the purpose. The
 * application is expected to validate the entry contents, even if
 * it specified a purpose.
 * 
 * The difference between @a GTK_INPUT_PURPOSE_DIGITS and
 *  @a GTK_INPUT_PURPOSE_NUMBER is that the former accepts only digits
 * while the latter also some punctuation (like commas or points, plus,
 * minus) and “e” or “E” as in 3.14E+000.
 * 
 * This enumeration may be extended in the future; input methods should
 * interpret unknown values as “free form”.
 *
 * @ingroup gtkmmEnums
 */
enum class InputPurpose
{
  FREE_FORM,
  ALPHA,
  DIGITS,
  NUMBER,
  PHONE,
  URL,
  EMAIL,
  NAME,
  PASSWORD,
  PIN
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::InputPurpose> : public Glib::Value_Enum<Gtk::InputPurpose>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var InputHints NONE
 * No special behaviour suggested.
 * 
 *  @var InputHints SPELLCHECK
 * Suggest checking for typos.
 * 
 *  @var InputHints NO_SPELLCHECK
 * Suggest not checking for typos.
 * 
 *  @var InputHints WORD_COMPLETION
 * Suggest word completion.
 * 
 *  @var InputHints LOWERCASE
 * Suggest to convert all text to lowercase.
 * 
 *  @var InputHints UPPERCASE_CHARS
 * Suggest to capitalize all text.
 * 
 *  @var InputHints UPPERCASE_WORDS
 * Suggest to capitalize the first
 * character of each word.
 * 
 *  @var InputHints UPPERCASE_SENTENCES
 * Suggest to capitalize the
 * first word of each sentence.
 * 
 *  @var InputHints INHIBIT_OSK
 * Suggest to not show an onscreen keyboard
 * (e.g for a calculator that already has all the keys).
 * 
 *  @var InputHints VERTICAL_WRITING
 * The text is vertical. @newin{3,18}
 * 
 *  @var InputHints EMOJI
 * Suggest offering Emoji support. @newin{3,22,20}
 * 
 *  @var InputHints NO_EMOJI
 * Suggest not offering Emoji support. @newin{3,22,20}
 * 
 *  @enum InputHints
 * 
 * Describes hints that might be taken into account by input methods
 * or applications. Note that input methods may already tailor their
 * behaviour according to the Gtk::InputPurpose of the entry.
 * 
 * Some common sense is expected when using these flags - mixing
 *  @a GTK_INPUT_HINT_LOWERCASE with any of the uppercase hints makes no sense.
 * 
 * This enumeration may be extended in the future; input methods should
 * ignore unknown values.
 *
 * @ingroup gtkmmEnums
 * @par Bitwise operators:
 * <tt>InputHints operator|(InputHints, InputHints)</tt><br>
 * <tt>InputHints operator&(InputHints, InputHints)</tt><br>
 * <tt>InputHints operator^(InputHints, InputHints)</tt><br>
 * <tt>InputHints operator~(InputHints)</tt><br>
 * <tt>InputHints& operator|=(InputHints&, InputHints)</tt><br>
 * <tt>InputHints& operator&=(InputHints&, InputHints)</tt><br>
 * <tt>InputHints& operator^=(InputHints&, InputHints)</tt><br>
 */
enum class InputHints
{
  NONE = 0x0,
  SPELLCHECK = 1 << 0,
  NO_SPELLCHECK = 1 << 1,
  WORD_COMPLETION = 1 << 2,
  LOWERCASE = 1 << 3,
  UPPERCASE_CHARS = 1 << 4,
  UPPERCASE_WORDS = 1 << 5,
  UPPERCASE_SENTENCES = 1 << 6,
  INHIBIT_OSK = 1 << 7,
  VERTICAL_WRITING = 1 << 8,
  EMOJI = 1 << 9,
  NO_EMOJI = 1 << 10
};

/** @ingroup gtkmmEnums */
inline InputHints operator|(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator&(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator^(InputHints lhs, InputHints rhs)
  { return static_cast<InputHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gtkmmEnums */
inline InputHints operator~(InputHints flags)
  { return static_cast<InputHints>(~static_cast<unsigned>(flags)); }

/** @ingroup gtkmmEnums */
inline InputHints& operator|=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline InputHints& operator&=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gtkmmEnums */
inline InputHints& operator^=(InputHints& lhs, InputHints rhs)
  { return (lhs = static_cast<InputHints>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::InputHints> : public Glib::Value_Flags<Gtk::InputHints>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{

/** 
 *  @var BaselinePosition TOP
 * Align the baseline at the top.
 * 
 *  @var BaselinePosition CENTER
 * Center the baseline.
 * 
 *  @var BaselinePosition BOTTOM
 * Align the baseline at the bottom.
 * 
 *  @enum BaselinePosition
 * 
 * Whenever a container has some form of natural row it may align
 * children in that row along a common typographical baseline. If
 * the amount of verical space in the row is taller than the total
 * requested height of the baseline-aligned children then it can use a
 * Gtk::BaselinePosition to select where to put the baseline inside the
 * extra availible space.
 *
 * @ingroup gtkmmEnums
 */
enum class BaselinePosition
{
  TOP,
  CENTER,
  BOTTOM
};


} // namespace Gtk

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gtk::BaselinePosition> : public Glib::Value_Enum<Gtk::BaselinePosition>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gtk
{


#ifndef DOXYGEN_SHOULD_SKIP_THIS
//We need this because we can't just use floats for enum value.
float _gtkmm_align_float_from_enum(Align value);
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} //namespace Gtk


#endif /* _GTKMM_ENUMS_H */

