// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!


#include <glibmm.h>

#include <gtkmm/widget.h>
#include <gtkmm/private/widget_p.h>

#include <gtk/gtk.h>

/* Copyright 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glibmm/vectorutils.h>

#include <gtkmm/adjustment.h>
#include <gtkmm/window.h>
#include <gtkmm/accelgroup.h>
#include <gtkmm/settings.h>
#include <gtkmm/container.h>
#include <gtkmm/selectiondata_private.h>
#include <gtkmm/tooltip.h>
#include <gtkmm/snapshot.h>
#include <gtk/gtk.h>


namespace //anonymous
{

// This signal callback is custom implemented, so that we can refrain from calling
// the signal handler if the C++ wrapper is being deleted.
// https://bugzilla.gnome.org/show_bug.cgi?id=605728#c5
void Widget_signal_hide_callback(GObject* self, void* data)
{
  const auto obj = Glib::ObjectBase::_get_current_wrapper(self);

  // Do not try to call a signal on a disassociated wrapper.
  // This function might be invoked recursively if the signal_hide() handler
  // deletes the object.
  // Therefore we have to test for cpp_destruction_in_progress_ at this point.
  if(obj && !obj->_cpp_destruction_is_in_progress())
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<sigc::slot<void()>*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

//These signal callbacks are custom implemented, so that we can create a temporary SelectionData instance.
//To do this, we used the optional custom_c_callback paramater to _WRAP_SIGNAL() in the .hg file.
static void Widget_signal_drag_data_get_callback(GtkWidget* self, GdkDragContext* p0,GtkSelectionData* p1,guint p2,guint p3,void* data)
{
  using namespace Gtk;
  typedef sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&,SelectionData&,guint,guint)> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
      {
        SelectionData_WithoutOwnership temp_instance(p1);
        (*static_cast<SlotType*>(slot))( Glib::wrap(p0, true), temp_instance, p2, p3 );
      }
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

static void Widget_signal_selection_get_callback(GtkWidget* self, GtkSelectionData* p0,guint p1,guint p2,void* data)
{
  using namespace Gtk;
  typedef sigc::slot<void(SelectionData&, guint, guint)> SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    try
    {
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
      {
        SelectionData_WithoutOwnership temp_instance(p0);
        (*static_cast<SlotType*>(slot))( temp_instance, p1, p2 );
      }
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
}

// The reinterpret_cast works because Event is a standard-layout class
// whose only data member is a GdkEvent pointer.
Gdk::Event& wrap_event_any(GdkEventAny*& event)
{
  return reinterpret_cast<Gdk::Event&>(event);
}

} //anonymous

namespace Gtk
{

// This default handler callback is custom implemented, so that we can refrain
// from calling an on_hide() override, if the C++ wrapper is being deleted.
void Widget_Class::hide_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  // This function might be invoked recursively if an on_hide() override
  // deletes the object.
  // Therefore we test for cpp_destruction_in_progress_ at this point.
  // (Not sure if it's necessary, but it feels safer. Perhaps the following
  // dynamic_cast catches all dangerous cases. /Kjell Ahlstedt)
  if(obj_base && obj_base->is_derived_() && !obj_base->_cpp_destruction_is_in_progress())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_hide();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->hide)
    (*base->hide)(self);
}

//These default handler callbacks are custom implemented, so that we can create a temporary SelectionData instance.
//To do this, we used the optional custom_c_callback paramater to _WRAP_SIGNAL() in the .hg file.
void Widget_Class::selection_get_callback(GtkWidget* self, GtkSelectionData* p0, guint p1, guint p2)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      SelectionData_WithoutOwnership temp_instance(p0);
      obj->on_selection_get(temp_instance, p1, p2);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->selection_get)
      (*base->selection_get)(self, p0, p1, p2);
  }
}

void Widget_Class::drag_data_get_callback(GtkWidget* self, GdkDragContext* p0, GtkSelectionData* p1, guint p2, guint p3)
{
  const auto obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj && obj->is_derived_())
  {
    try // Trap C++ exceptions which would normally be lost because this is a C callback.
    {
      // Call the virtual member method, which derived classes might override.
      SelectionData_WithoutOwnership temp_instance(p1);
      obj->on_drag_data_get(Glib::wrap(p0, true), temp_instance, p2, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    // Call the original underlying C function:
    if(base && base->drag_data_get)
      (*base->drag_data_get)(self, p0, p1, p2, p3);
  }
}

// This vfunc callback is custom implemented because we want the output
// arguments of the C++ vfunc to be int& (not int*), and the vfunc_callback
// function may be called from gtk+ with NULL pointers.
void Widget_Class::measure_vfunc_callback(GtkWidget* self, GtkOrientation orientation, int for_size,
  int* minimum, int* natural, int* minimum_baseline, int* natural_baseline)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        int no_minimum = 0;
        int no_natural = 0;
        int no_minimum_baseline = 0;
        int no_natural_baseline = 0;
        obj->measure_vfunc((Orientation)orientation, for_size,
          (minimum ? *minimum : no_minimum),
          (natural ? *natural : no_natural),
          (minimum_baseline ? *minimum_baseline : no_minimum_baseline),
          (natural_baseline ? *natural_baseline : no_natural_baseline));
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->measure)
    (*base->measure)(self, orientation, for_size, minimum, natural, minimum_baseline, natural_baseline);
}

// This vfunc callback and the corresponding vfunc are custom implemented because we want
// the output arguments of the C++ vfunc to be bool& (not gboolean* or gboolean&).
void Widget_Class::compute_expand_vfunc_callback(GtkWidget* self, gboolean* hexpand_p, gboolean* vexpand_p)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        bool hexpand_pcxx = hexpand_p ? *hexpand_p : false;
        bool vexpand_pcxx = vexpand_p ? *vexpand_p : false;
        obj->compute_expand_vfunc(hexpand_pcxx, vexpand_pcxx);
        if (hexpand_p)
          *hexpand_p = hexpand_pcxx;
        if (vexpand_p)
          *vexpand_p = vexpand_pcxx;
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->compute_expand)
    (*base->compute_expand)(self, hexpand_p, vexpand_p);
}

void Gtk::Widget::compute_expand_vfunc(bool& hexpand_p, bool& vexpand_p)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->compute_expand)
  {
    gboolean hexpand_pc = hexpand_p;
    gboolean vexpand_pc = vexpand_p;
    (*base->compute_expand)(gobj(), &hexpand_pc, &vexpand_pc);
    hexpand_p = hexpand_pc;
    vexpand_p = vexpand_pc;
  }
}


Widget::~Widget() noexcept
{}

void Widget::reparent(Container& new_parent)
{
  auto old_parent = get_parent();
  g_return_if_fail(old_parent != nullptr); // if the widget is not in a Container

  if (old_parent != &new_parent)
  {
    reference();
    old_parent->remove(*this);
    new_parent.add(*this);
    unreference();
  }
}

bool Widget::intersect(const Gdk::Rectangle& area) const
{
  return gtk_widget_intersect(
      const_cast<GtkWidget*>(gobj()), const_cast<GdkRectangle*>(area.gobj()), nullptr);
}

void Widget::unset_name()
{
  gtk_widget_set_name(gobj(), nullptr);
}

void Widget::realize_if_needed()
{
  if(!get_realized())
    realize();
}

void Widget::add_modal_grab()
{
  gtk_grab_add(gobj());
}

void Widget::remove_modal_grab()
{
  gtk_grab_remove(gobj());
}

Widget* Widget::get_current_modal_grab()
{
  return Glib::wrap(gtk_grab_get_current());
}

void Widget::set_window(const Glib::RefPtr<Gdk::Window>& window)
{
  gtk_widget_set_window(gobj(), Glib::unwrap(window));
  if (window)
    window->reference(); // gtk_widget_set_window does not add a ref.
}

Allocation Widget::get_clip() const
{
  Allocation allocation;
  gtk_widget_get_clip(const_cast<GtkWidget*>(gobj()), allocation.gobj());
  return allocation;
}


Allocation Widget::get_allocation() const
{
  Allocation allocation;
  gtk_widget_get_allocation(const_cast<GtkWidget*>(gobj()), allocation.gobj());
  return allocation;
}

int Widget::get_width() const
  { return get_allocation().get_width(); }

int Widget::get_height() const
  { return get_allocation().get_height(); }


void Widget::drag_dest_set(DestDefaults flags, Gdk::DragAction actions)
{
  gtk_drag_dest_set(gobj(), (GtkDestDefaults)flags, nullptr, 0, (GdkDragAction)actions);
}

void Widget::drag_dest_set(const std::vector<TargetEntry>& targets,
                           DestDefaults flags, Gdk::DragAction actions)
{
  // I've used Gdk::ACTION_COPY as the default, because Gdk::ACTION_DEFAULT means that
  // it's never a drag destination, so it would seem like this method didn't work. murrayc.
  gtk_drag_dest_set(
      gobj(), (GtkDestDefaults)flags,
      Glib::ArrayHandler<TargetEntry, TargetEntryTraits>::vector_to_array(targets).data(),
      targets.size(), (GdkDragAction)actions);
}

void Widget::drag_source_set(const std::vector<TargetEntry>& targets,
                             Gdk::ModifierType start_button_mask, Gdk::DragAction actions)
{
  // I've used Gdk::MODIFIER_MASK as the default, because it seems
  // to mean 'whatever is possible in the context'. murrayc.
  gtk_drag_source_set(
      gobj(), (GdkModifierType)start_button_mask,
      Glib::ArrayHandler<TargetEntry, TargetEntryTraits>::vector_to_array(targets).data(),
      targets.size(), (GdkDragAction)actions);
}

Widget* Widget::drag_get_source_widget(const Glib::RefPtr<Gdk::DragContext>& context) //static
{
  return Glib::wrap( gtk_drag_get_source_widget(Glib::unwrap(context)) );
}

void Widget::drag_set_as_icon(const Glib::RefPtr<Gdk::DragContext>& context, int hot_x, int hot_y)
{
  gtk_drag_set_icon_widget(Glib::unwrap(context), gobj(), hot_x, hot_y);
}

void Widget_Class::hierarchy_changed_callback_custom(GtkWidget* self, GtkWidget* p0)
{
  //GTKMM_LIFECYCLE
  //Don't call wrap() on a GTK+ instance whose gtkmm instance has been deleted - just call the original C callback.
  bool gtkmm_child_already_deleted = Glib::_gobject_cppinstance_already_deleted((GObject*)p0);

  if(!gtkmm_child_already_deleted)
  {
    //Call the regular, generated callback:
    Widget_Class::hierarchy_changed_callback(self, p0);
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->hierarchy_changed)
      (*base->hierarchy_changed)(self, p0);
  }
}

void Widget_Class::parent_set_callback_custom(GtkWidget* self, GtkWidget* p0)
{
  //GTKMM_LIFECYCLE
  //Don't call wrap() on a GTK+ instance whose gtkmm instance has been deleted - just call the original C callback.
  bool gtkmm_p0_already_deleted = Glib::_gobject_cppinstance_already_deleted((GObject*)p0);

  if(!gtkmm_p0_already_deleted)
  {
    //Call the regular, generated callback:
    Widget_Class::parent_set_callback(self, p0);
  }
  else
  {
    const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

    //Call the original underlying C function:
    if(base && base->parent_set)
      (*base->parent_set)(self, p0);
  }
}

void Widget_Class::dispose_vfunc_callback(GObject* self)
{
  //Avoid disposal. See also Window_Class::dispose_vfunc_callback().

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): gobject_: %p\n", (void*)self);
  //if(self)
   //g_warning("  gtypename: %s\n", G_OBJECT_TYPE_NAME(self));
  #endif

  const auto obj = dynamic_cast<Widget*>(
      Glib::ObjectBase::_get_current_wrapper(self));

  // This function might be invoked recursively because we're triggering
  // several signal emissions, particularly signal_hide().  Therefore we
  // have to test for cpp_destruction_in_progress_ at this point.

  if(obj && !obj->_cpp_destruction_is_in_progress()) //When it should really be destroyed, we zero gobj_.
  {
    const auto pWidget = obj->gobj();
    g_return_if_fail(pWidget == GTK_WIDGET(self));

    // Abort dispose if the widget isn't managed, in order to prevent
    // the nasty self-destroying behaviour of GTK+.  This applies to
    // any widget inside a GtkContainer on gtk_container_destroy()
    // See also Window_Class::dispose_vfunc_callback().

    if(obj->referenced_) //Not managed
    {
      // GTKMM_LIFECYCLE
      // Remove the widget from its parent container so that it
      // won't be destroyed later by gtk_container_destroy().
      GtkWidget* parent = gtk_widget_get_parent(pWidget);
      if(parent)
      {
        // Normally, we would have to ref the child widget because
        // gtk_container_remove() unrefs it.  But since we only remove
        // non-managed objects here, the container just releases the
        // reference it has acquired before in gtk_container_add().

        #ifdef GLIBMM_DEBUG_REFCOUNTING
        g_warning("Widget_Class::dispose_vfunc_callback(): removing gobject_: %p from parent: %p", (void*)self, (void*)parent);
        #endif

        gtk_container_remove(GTK_CONTAINER(parent), pWidget);

        #ifdef GLIBMM_DEBUG_REFCOUNTING
        g_warning("Widget_Class::dispose_vfunc_callback(): after removing from parent.");
        #endif
      }
      // Special case for GtkMenu because gtk_menu_attach_to_widget does
      // not set widget->parent but gtk_menu_item_destroy() destroys the menu
      // like gtk_container_destroy()
      // Gtk::Menu does not use a parent widget because it must
      // be contained in its Gtk::Window so that it can be displayed as a popup.
      else if (GTK_IS_MENU(pWidget) && GTK_IS_MENU_ITEM(gtk_menu_get_attach_widget(GTK_MENU(pWidget))))
      {
         gtk_menu_detach(GTK_MENU(pWidget));
      }

      #ifdef GLIBMM_DEBUG_REFCOUNTING
      g_warning("Widget_Class::dispose_vfunc_callback(): before gtk_widget_hide().");
      #endif

      // Now hide the widget.  The C++ object must _not_ be accessed anymore
      // after this call, because a signal_hide() handler might delete it.
      gtk_widget_hide(pWidget);

      #ifdef GLIBMM_DEBUG_REFCOUNTING
      g_warning("Widget_Class::dispose_vfunc_callback(): after gtk_widget_hide().");
      #endif

      // GTKMM_LIFECYCLE
      return; // Prevent calling of normal C dispose vfunc (see below)
    }

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Widget_Class::dispose_vfunc_callback(): unreferenced: before gtk_widget_hide().");
    #endif

    // Always hide widgets on object destruction, regardless of whether
    // the widget is managed or not.  This is done for consistency so that
    // connecting to signal_hide() is guaranteed to work.
    gtk_widget_hide(pWidget);

    #ifdef GLIBMM_DEBUG_REFCOUNTING
    g_warning("Widget_Class::dispose_vfunc_callback(): unreferenced:  after gtk_widget_hide().");
    #endif
  }

  const auto base = static_cast<GObjectClass*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)));

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): before calling base->dispose.");
  #endif

  if(base->dispose)
    (*base->dispose)(self);

  #ifdef GLIBMM_DEBUG_REFCOUNTING
  g_warning("Widget_Class::dispose_vfunc_callback(): after calling base->dispose.");
  #endif
}

Glib::ustring Widget::drag_dest_find_target(const Glib::RefPtr<Gdk::DragContext>& context) const
{
  return Gdk::AtomString::to_cpp_type(gtk_drag_dest_find_target(const_cast<GtkWidget*>(gobj()), Glib::unwrap(context), nullptr /* See GTK+ docs */));
}

void Widget::unset_font_options()
{
  gtk_widget_set_font_options(gobj(), nullptr);
}

void Widget::remove_action_group(const Glib::ustring& name)
{
  gtk_widget_insert_action_group(gobj(), name.c_str(), nullptr /* see C docs */);
}

void Widget::set_margin(int margin)
{
  property_margin() = margin;
}

} // namespace Gtk

namespace
{


static const Glib::SignalProxyInfo Widget_signal_show_info =
{
  "show",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_hide_info =
{
  "hide",
  (GCallback) &Widget_signal_hide_callback,
  (GCallback) &Widget_signal_hide_callback
};


static const Glib::SignalProxyInfo Widget_signal_map_info =
{
  "map",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_unmap_info =
{
  "unmap",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_realize_info =
{
  "realize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Widget_signal_unrealize_info =
{
  "unrealize",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Widget_signal_size_allocate_callback(GtkWidget* self, const GdkRectangle* p0,gint p1,GdkRectangle* p2,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Allocation&, int, Allocation&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
, p1
, Glib::wrap(p2)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_size_allocate_info =
{
  "size_allocate",
  (GCallback) &Widget_signal_size_allocate_callback,
  (GCallback) &Widget_signal_size_allocate_callback
};


static void Widget_signal_state_flags_changed_callback(GtkWidget* self, GtkStateFlags p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gtk::StateFlags)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<Gtk::StateFlags>(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_state_flags_changed_info =
{
  "state-flags-changed",
  (GCallback) &Widget_signal_state_flags_changed_callback,
  (GCallback) &Widget_signal_state_flags_changed_callback
};


static void Widget_signal_parent_changed_callback(GtkWidget* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Widget*)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_parent_changed_info =
{
  "parent_set",
  (GCallback) &Widget_signal_parent_changed_callback,
  (GCallback) &Widget_signal_parent_changed_callback
};


static void Widget_signal_hierarchy_changed_callback(GtkWidget* self, GtkWidget* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Widget*)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_hierarchy_changed_info =
{
  "hierarchy_changed",
  (GCallback) &Widget_signal_hierarchy_changed_callback,
  (GCallback) &Widget_signal_hierarchy_changed_callback
};


static const Glib::SignalProxyInfo Widget_signal_style_updated_info =
{
  "style_updated",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static void Widget_signal_direction_changed_callback(GtkWidget* self, GtkTextDirection p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(TextDirection)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<TextDirection>(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_direction_changed_info =
{
  "direction_changed",
  (GCallback) &Widget_signal_direction_changed_callback,
  (GCallback) &Widget_signal_direction_changed_callback
};


static void Widget_signal_grab_notify_callback(GtkWidget* self, gboolean p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(bool)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_grab_notify_info =
{
  "grab_notify",
  (GCallback) &Widget_signal_grab_notify_callback,
  (GCallback) &Widget_signal_grab_notify_callback
};


static void Widget_signal_child_notify_callback(GtkWidget* self, GParamSpec* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(GParamSpec*)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_child_notify_info =
{
  "child_notify",
  (GCallback) &Widget_signal_child_notify_callback,
  (GCallback) &Widget_signal_child_notify_callback
};


static gboolean Widget_signal_mnemonic_activate_callback(GtkWidget* self, gboolean p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(bool)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_mnemonic_activate_notify_callback(GtkWidget* self, gboolean p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(bool)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_mnemonic_activate_info =
{
  "mnemonic_activate",
  (GCallback) &Widget_signal_mnemonic_activate_callback,
  (GCallback) &Widget_signal_mnemonic_activate_notify_callback
};


static const Glib::SignalProxyInfo Widget_signal_grab_focus_info =
{
  "grab_focus",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static gboolean Widget_signal_focus_callback(GtkWidget* self, GtkDirectionType p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(DirectionType)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(static_cast<DirectionType>(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_focus_notify_callback(GtkWidget* self, GtkDirectionType p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(DirectionType)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(static_cast<DirectionType>(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_focus_info =
{
  "focus",
  (GCallback) &Widget_signal_focus_callback,
  (GCallback) &Widget_signal_focus_notify_callback
};


static gboolean Widget_signal_event_callback(GtkWidget* self, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_event_notify_callback(GtkWidget* self, GdkEvent* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_event_info =
{
  "event",
  (GCallback) &Widget_signal_event_callback,
  (GCallback) &Widget_signal_event_notify_callback
};


static void Widget_signal_event_after_callback(GtkWidget* self, GdkEvent* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_event_after_info =
{
  "event_after",
  (GCallback) &Widget_signal_event_after_callback,
  (GCallback) &Widget_signal_event_after_callback
};


static gboolean Widget_signal_button_press_event_callback(GtkWidget* self, GdkEventButton* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventButton&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_button_press_event_notify_callback(GtkWidget* self, GdkEventButton* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventButton&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_button_press_event_info =
{
  "button_press_event",
  (GCallback) &Widget_signal_button_press_event_callback,
  (GCallback) &Widget_signal_button_press_event_notify_callback
};


static gboolean Widget_signal_button_release_event_callback(GtkWidget* self, GdkEventButton* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventButton&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_button_release_event_notify_callback(GtkWidget* self, GdkEventButton* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventButton&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_button_release_event_info =
{
  "button_release_event",
  (GCallback) &Widget_signal_button_release_event_callback,
  (GCallback) &Widget_signal_button_release_event_notify_callback
};


static gboolean Widget_signal_scroll_event_callback(GtkWidget* self, GdkEventScroll* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventScroll&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_scroll_event_notify_callback(GtkWidget* self, GdkEventScroll* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventScroll&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_scroll_event_info =
{
  "scroll_event",
  (GCallback) &Widget_signal_scroll_event_callback,
  (GCallback) &Widget_signal_scroll_event_notify_callback
};


static gboolean Widget_signal_motion_notify_event_callback(GtkWidget* self, GdkEventMotion* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventMotion&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_motion_notify_event_notify_callback(GtkWidget* self, GdkEventMotion* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventMotion&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_motion_notify_event_info =
{
  "motion_notify_event",
  (GCallback) &Widget_signal_motion_notify_event_callback,
  (GCallback) &Widget_signal_motion_notify_event_notify_callback
};


static gboolean Widget_signal_delete_event_callback(GtkWidget* self, GdkEventAny* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(wrap_event_any(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_delete_event_notify_callback(GtkWidget* self, GdkEventAny* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(wrap_event_any(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_delete_event_info =
{
  "delete_event",
  (GCallback) &Widget_signal_delete_event_callback,
  (GCallback) &Widget_signal_delete_event_notify_callback
};


static gboolean Widget_signal_key_press_event_callback(GtkWidget* self, GdkEventKey* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventKey&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_key_press_event_notify_callback(GtkWidget* self, GdkEventKey* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventKey&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_key_press_event_info =
{
  "key_press_event",
  (GCallback) &Widget_signal_key_press_event_callback,
  (GCallback) &Widget_signal_key_press_event_notify_callback
};


static gboolean Widget_signal_key_release_event_callback(GtkWidget* self, GdkEventKey* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventKey&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_key_release_event_notify_callback(GtkWidget* self, GdkEventKey* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventKey&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_key_release_event_info =
{
  "key_release_event",
  (GCallback) &Widget_signal_key_release_event_callback,
  (GCallback) &Widget_signal_key_release_event_notify_callback
};


static gboolean Widget_signal_enter_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventCrossing&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_enter_notify_event_notify_callback(GtkWidget* self, GdkEventCrossing* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventCrossing&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_enter_notify_event_info =
{
  "enter_notify_event",
  (GCallback) &Widget_signal_enter_notify_event_callback,
  (GCallback) &Widget_signal_enter_notify_event_notify_callback
};


static gboolean Widget_signal_leave_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventCrossing&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_leave_notify_event_notify_callback(GtkWidget* self, GdkEventCrossing* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventCrossing&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_leave_notify_event_info =
{
  "leave_notify_event",
  (GCallback) &Widget_signal_leave_notify_event_callback,
  (GCallback) &Widget_signal_leave_notify_event_notify_callback
};


static gboolean Widget_signal_configure_event_callback(GtkWidget* self, GdkEventConfigure* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventConfigure&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_configure_event_notify_callback(GtkWidget* self, GdkEventConfigure* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventConfigure&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_configure_event_info =
{
  "configure_event",
  (GCallback) &Widget_signal_configure_event_callback,
  (GCallback) &Widget_signal_configure_event_notify_callback
};


static gboolean Widget_signal_focus_in_event_callback(GtkWidget* self, GdkEventFocus* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventFocus&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_focus_in_event_notify_callback(GtkWidget* self, GdkEventFocus* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventFocus&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_focus_in_event_info =
{
  "focus_in_event",
  (GCallback) &Widget_signal_focus_in_event_callback,
  (GCallback) &Widget_signal_focus_in_event_notify_callback
};


static gboolean Widget_signal_focus_out_event_callback(GtkWidget* self, GdkEventFocus* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventFocus&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_focus_out_event_notify_callback(GtkWidget* self, GdkEventFocus* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventFocus&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_focus_out_event_info =
{
  "focus_out_event",
  (GCallback) &Widget_signal_focus_out_event_callback,
  (GCallback) &Widget_signal_focus_out_event_notify_callback
};


static gboolean Widget_signal_map_event_callback(GtkWidget* self, GdkEventAny* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(wrap_event_any(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_map_event_notify_callback(GtkWidget* self, GdkEventAny* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(wrap_event_any(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_map_event_info =
{
  "map_event",
  (GCallback) &Widget_signal_map_event_callback,
  (GCallback) &Widget_signal_map_event_notify_callback
};


static gboolean Widget_signal_unmap_event_callback(GtkWidget* self, GdkEventAny* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(wrap_event_any(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_unmap_event_notify_callback(GtkWidget* self, GdkEventAny* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::Event&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(wrap_event_any(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_unmap_event_info =
{
  "unmap_event",
  (GCallback) &Widget_signal_unmap_event_callback,
  (GCallback) &Widget_signal_unmap_event_notify_callback
};


static gboolean Widget_signal_property_notify_event_callback(GtkWidget* self, GdkEventProperty* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventProperty&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_property_notify_event_notify_callback(GtkWidget* self, GdkEventProperty* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventProperty&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_property_notify_event_info =
{
  "property_notify_event",
  (GCallback) &Widget_signal_property_notify_event_callback,
  (GCallback) &Widget_signal_property_notify_event_notify_callback
};


static gboolean Widget_signal_selection_clear_event_callback(GtkWidget* self, GdkEventSelection* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventSelection&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_selection_clear_event_notify_callback(GtkWidget* self, GdkEventSelection* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventSelection&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_selection_clear_event_info =
{
  "selection_clear_event",
  (GCallback) &Widget_signal_selection_clear_event_callback,
  (GCallback) &Widget_signal_selection_clear_event_notify_callback
};


static gboolean Widget_signal_selection_request_event_callback(GtkWidget* self, GdkEventSelection* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventSelection&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_selection_request_event_notify_callback(GtkWidget* self, GdkEventSelection* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventSelection&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_selection_request_event_info =
{
  "selection_request_event",
  (GCallback) &Widget_signal_selection_request_event_callback,
  (GCallback) &Widget_signal_selection_request_event_notify_callback
};


static gboolean Widget_signal_selection_notify_event_callback(GtkWidget* self, GdkEventSelection* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventSelection&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_selection_notify_event_notify_callback(GtkWidget* self, GdkEventSelection* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventSelection&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_selection_notify_event_info =
{
  "selection_notify_event",
  (GCallback) &Widget_signal_selection_notify_event_callback,
  (GCallback) &Widget_signal_selection_notify_event_notify_callback
};


static gboolean Widget_signal_proximity_in_event_callback(GtkWidget* self, GdkEventProximity* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventProximity&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_proximity_in_event_notify_callback(GtkWidget* self, GdkEventProximity* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventProximity&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_proximity_in_event_info =
{
  "proximity_in_event",
  (GCallback) &Widget_signal_proximity_in_event_callback,
  (GCallback) &Widget_signal_proximity_in_event_notify_callback
};


static gboolean Widget_signal_proximity_out_event_callback(GtkWidget* self, GdkEventProximity* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventProximity&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_proximity_out_event_notify_callback(GtkWidget* self, GdkEventProximity* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventProximity&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_proximity_out_event_info =
{
  "proximity_out_event",
  (GCallback) &Widget_signal_proximity_out_event_callback,
  (GCallback) &Widget_signal_proximity_out_event_notify_callback
};


static gboolean Widget_signal_window_state_event_callback(GtkWidget* self, GdkEventWindowState* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventWindowState&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_window_state_event_notify_callback(GtkWidget* self, GdkEventWindowState* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventWindowState&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_window_state_event_info =
{
  "window_state_event",
  (GCallback) &Widget_signal_window_state_event_callback,
  (GCallback) &Widget_signal_window_state_event_notify_callback
};


static const Glib::SignalProxyInfo Widget_signal_selection_get_info =
{
  "selection_get",
  (GCallback) &Widget_signal_selection_get_callback,
  (GCallback) &Widget_signal_selection_get_callback
};


static void Widget_signal_selection_received_callback(GtkWidget* self, GtkSelectionData* p0,guint p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const SelectionData&, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(SelectionData_WithoutOwnership(p0)
, p1);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_selection_received_info =
{
  "selection_received",
  (GCallback) &Widget_signal_selection_received_callback,
  (GCallback) &Widget_signal_selection_received_callback
};


static void Widget_signal_drag_begin_callback(GtkWidget* self, GdkDragContext* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_begin_info =
{
  "drag_begin",
  (GCallback) &Widget_signal_drag_begin_callback,
  (GCallback) &Widget_signal_drag_begin_callback
};


static void Widget_signal_drag_end_callback(GtkWidget* self, GdkDragContext* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_end_info =
{
  "drag_end",
  (GCallback) &Widget_signal_drag_end_callback,
  (GCallback) &Widget_signal_drag_end_callback
};


static const Glib::SignalProxyInfo Widget_signal_drag_data_get_info =
{
  "drag_data_get",
  (GCallback) &Widget_signal_drag_data_get_callback,
  (GCallback) &Widget_signal_drag_data_get_callback
};


static void Widget_signal_drag_data_delete_callback(GtkWidget* self, GdkDragContext* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_data_delete_info =
{
  "drag_data_delete",
  (GCallback) &Widget_signal_drag_data_delete_callback,
  (GCallback) &Widget_signal_drag_data_delete_callback
};


static gboolean Widget_signal_drag_failed_callback(GtkWidget* self, GdkDragContext* p0,GtkDragResult p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(const Glib::RefPtr<Gdk::DragContext>&, DragResult)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, static_cast<DragResult>(p1)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_drag_failed_notify_callback(GtkWidget* self, GdkDragContext* p0,GtkDragResult p1, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&, DragResult)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, static_cast<DragResult>(p1)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_drag_failed_info =
{
  "drag_failed",
  (GCallback) &Widget_signal_drag_failed_callback,
  (GCallback) &Widget_signal_drag_failed_notify_callback
};


static void Widget_signal_drag_leave_callback(GtkWidget* self, GdkDragContext* p0,guint p1,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_leave_info =
{
  "drag_leave",
  (GCallback) &Widget_signal_drag_leave_callback,
  (GCallback) &Widget_signal_drag_leave_callback
};


static gboolean Widget_signal_drag_motion_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_drag_motion_notify_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_drag_motion_info =
{
  "drag_motion",
  (GCallback) &Widget_signal_drag_motion_callback,
  (GCallback) &Widget_signal_drag_motion_notify_callback
};


static gboolean Widget_signal_drag_drop_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_drag_drop_notify_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,guint p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, p3);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_drag_drop_info =
{
  "drag_drop",
  (GCallback) &Widget_signal_drag_drop_callback,
  (GCallback) &Widget_signal_drag_drop_notify_callback
};


static void Widget_signal_drag_data_received_callback(GtkWidget* self, GdkDragContext* p0,gint p1,gint p2,GtkSelectionData* p3,guint p4,guint p5,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::DragContext>&, int, int, const SelectionData&, guint, guint)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
, p1
, p2
, SelectionData_WithoutOwnership(p3)
, p4, p5);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_drag_data_received_info =
{
  "drag_data_received",
  (GCallback) &Widget_signal_drag_data_received_callback,
  (GCallback) &Widget_signal_drag_data_received_callback
};


static void Widget_signal_screen_changed_callback(GtkWidget* self, GdkScreen* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(const Glib::RefPtr<Gdk::Screen>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }
}

static const Glib::SignalProxyInfo Widget_signal_screen_changed_info =
{
  "screen_changed",
  (GCallback) &Widget_signal_screen_changed_callback,
  (GCallback) &Widget_signal_screen_changed_callback
};


static gboolean Widget_signal_popup_menu_callback(GtkWidget* self, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool()>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))());
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_popup_menu_notify_callback(GtkWidget* self,  void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void()>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_popup_menu_info =
{
  "popup_menu",
  (GCallback) &Widget_signal_popup_menu_callback,
  (GCallback) &Widget_signal_popup_menu_notify_callback
};


static gboolean Widget_signal_query_tooltip_callback(GtkWidget* self, gint p0,gint p1,gboolean p2,GtkTooltip* p3,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(int, int, bool, const Glib::RefPtr<Tooltip>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(p0
, p1
, p2
, Glib::wrap(p3, true)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_query_tooltip_notify_callback(GtkWidget* self, gint p0,gint p1,gboolean p2,GtkTooltip* p3, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(int, int, bool, const Glib::RefPtr<Tooltip>&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(p0
, p1
, p2
, Glib::wrap(p3, true)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_query_tooltip_info =
{
  "query_tooltip",
  (GCallback) &Widget_signal_query_tooltip_callback,
  (GCallback) &Widget_signal_query_tooltip_notify_callback
};


static gboolean Widget_signal_grab_broken_event_callback(GtkWidget* self, GdkEventGrabBroken* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventGrabBroken&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_grab_broken_event_notify_callback(GtkWidget* self, GdkEventGrabBroken* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventGrabBroken&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_grab_broken_event_info =
{
  "grab_broken_event",
  (GCallback) &Widget_signal_grab_broken_event_callback,
  (GCallback) &Widget_signal_grab_broken_event_notify_callback
};


static gboolean Widget_signal_touch_event_callback(GtkWidget* self, GdkEventTouch* p0,void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<bool(Gdk::EventTouch&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        return static_cast<int>((*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
));
    }
    catch(...)
    {
       Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static gboolean Widget_signal_touch_event_notify_callback(GtkWidget* self, GdkEventTouch* p0, void* data)
{
  using namespace Gtk;
  using SlotType = sigc::slot<void(Gdk::EventTouch&)>;

  auto obj = dynamic_cast<Widget*>(Glib::ObjectBase::_get_current_wrapper((GObject*) self));
  // Do not try to call a signal on a disassociated wrapper.
  if(obj)
  {
    try
    {
      if(const auto slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Gdk::wrap_event(p0)
);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }

  using RType = gboolean;
  return RType();
}

static const Glib::SignalProxyInfo Widget_signal_touch_event_info =
{
  "touch_event",
  (GCallback) &Widget_signal_touch_event_callback,
  (GCallback) &Widget_signal_touch_event_notify_callback
};


} // anonymous namespace

// static
GType Glib::Value<Gtk::DestDefaults>::value_type()
{
  return gtk_dest_defaults_get_type();
}

// static
GType Glib::Value<Gtk::DragResult>::value_type()
{
  return gtk_drag_result_get_type();
}


namespace Glib
{

Gtk::Widget* wrap(GtkWidget* object, bool take_copy)
{
  return dynamic_cast<Gtk::Widget *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gtk
{


/* The *_Class implementation: */

const Glib::Class& Widget_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Widget_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gtk_widget_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:
  Buildable::add_interface(get_type());
#ifdef GTKMM_ATKMM_ENABLED
  Atk::Implementor::add_interface(get_type());

#endif // GTKMM_ATKMM_ENABLED

  }

  return *this;
}


void Widget_Class::class_init_function(void* g_class, void* class_data)
{
  const auto klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

    reinterpret_cast<GObjectClass*>(klass)->dispose = &dispose_vfunc_callback;
    klass->dispatch_child_properties_changed = &dispatch_child_properties_changed_vfunc_callback;
  klass->get_request_mode = &get_request_mode_vfunc_callback;
  klass->measure = &measure_vfunc_callback;
#ifdef GTKMM_ATKMM_ENABLED
  klass->get_accessible = &get_accessible_vfunc_callback;
#endif // GTKMM_ATKMM_ENABLED
  klass->compute_expand = &compute_expand_vfunc_callback;

  klass->show = &show_callback;
  klass->hide = &hide_callback;
  klass->map = &map_callback;
  klass->unmap = &unmap_callback;
  klass->realize = &realize_callback;
  klass->unrealize = &unrealize_callback;
  klass->size_allocate = &size_allocate_callback;
  klass->state_flags_changed = &state_flags_changed_callback;
  klass->parent_set = &parent_set_callback;
  klass->hierarchy_changed = &hierarchy_changed_callback;
  klass->style_updated = &style_updated_callback;
  klass->direction_changed = &direction_changed_callback;
  klass->grab_notify = &grab_notify_callback;
  klass->child_notify = &child_notify_callback;
  klass->mnemonic_activate = &mnemonic_activate_callback;
  klass->grab_focus = &grab_focus_callback;
  klass->focus = &focus_callback;
  klass->event = &event_callback;
  klass->button_press_event = &button_press_event_callback;
  klass->button_release_event = &button_release_event_callback;
  klass->scroll_event = &scroll_event_callback;
  klass->motion_notify_event = &motion_notify_event_callback;
  klass->delete_event = &delete_event_callback;
  klass->key_press_event = &key_press_event_callback;
  klass->key_release_event = &key_release_event_callback;
  klass->enter_notify_event = &enter_notify_event_callback;
  klass->leave_notify_event = &leave_notify_event_callback;
  klass->configure_event = &configure_event_callback;
  klass->focus_in_event = &focus_in_event_callback;
  klass->focus_out_event = &focus_out_event_callback;
  klass->map_event = &map_event_callback;
  klass->unmap_event = &unmap_event_callback;
  klass->property_notify_event = &property_notify_event_callback;
  klass->selection_clear_event = &selection_clear_event_callback;
  klass->selection_request_event = &selection_request_event_callback;
  klass->selection_notify_event = &selection_notify_event_callback;
  klass->proximity_in_event = &proximity_in_event_callback;
  klass->proximity_out_event = &proximity_out_event_callback;
  klass->window_state_event = &window_state_event_callback;
  klass->selection_get = &selection_get_callback;
  klass->selection_received = &selection_received_callback;
  klass->drag_begin = &drag_begin_callback;
  klass->drag_end = &drag_end_callback;
  klass->drag_data_get = &drag_data_get_callback;
  klass->drag_data_delete = &drag_data_delete_callback;
  klass->drag_failed = &drag_failed_callback;
  klass->drag_leave = &drag_leave_callback;
  klass->drag_motion = &drag_motion_callback;
  klass->drag_drop = &drag_drop_callback;
  klass->drag_data_received = &drag_data_received_callback;
  klass->screen_changed = &screen_changed_callback;
  klass->popup_menu = &popup_menu_callback;
  klass->query_tooltip = &query_tooltip_callback;
  klass->grab_broken_event = &grab_broken_event_callback;
  klass->touch_event = &touch_event_callback;
    klass->hierarchy_changed = &hierarchy_changed_callback_custom;
      klass->parent_set = &parent_set_callback_custom;
  }

void Widget_Class::dispatch_child_properties_changed_vfunc_callback(GtkWidget* self, guint n_pspecs, GParamSpec** pspecs)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->dispatch_child_properties_changed_vfunc(n_pspecs, pspecs);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->dispatch_child_properties_changed)
    (*base->dispatch_child_properties_changed)(self, n_pspecs, pspecs);
}
GtkSizeRequestMode Widget_Class::get_request_mode_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<GtkSizeRequestMode>(obj->get_request_mode_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_request_mode)
    return (*base->get_request_mode)(self);

  using RType = GtkSizeRequestMode;
  return RType();
}
#ifdef GTKMM_ATKMM_ENABLED
AtkObject* Widget_Class::get_accessible_vfunc_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return Glib::unwrap(obj->get_accessible_vfunc());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
  );

  // Call the original underlying C function:
  if(base && base->get_accessible)
    return (*base->get_accessible)(self);

  using RType = AtkObject*;
  return RType();
}
#endif // GTKMM_ATKMM_ENABLED

void Widget_Class::show_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_show();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->show)
    (*base->show)(self);
}
void Widget_Class::map_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_map();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->map)
    (*base->map)(self);
}
void Widget_Class::unmap_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_unmap();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unmap)
    (*base->unmap)(self);
}
void Widget_Class::realize_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_realize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->realize)
    (*base->realize)(self);
}
void Widget_Class::unrealize_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_unrealize();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unrealize)
    (*base->unrealize)(self);
}
void Widget_Class::size_allocate_callback(GtkWidget* self, const GdkRectangle* p0, gint p1, GdkRectangle* p2)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_size_allocate(Glib::wrap(p0)
, p1
, Glib::wrap(p2)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->size_allocate)
    (*base->size_allocate)(self, p0, p1, p2);
}
void Widget_Class::state_flags_changed_callback(GtkWidget* self, GtkStateFlags p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_state_flags_changed(static_cast<Gtk::StateFlags>(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->state_flags_changed)
    (*base->state_flags_changed)(self, p0);
}
void Widget_Class::parent_set_callback(GtkWidget* self, GtkWidget* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_parent_changed(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->parent_set)
    (*base->parent_set)(self, p0);
}
void Widget_Class::hierarchy_changed_callback(GtkWidget* self, GtkWidget* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_hierarchy_changed(Glib::wrap(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->hierarchy_changed)
    (*base->hierarchy_changed)(self, p0);
}
void Widget_Class::style_updated_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_style_updated();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->style_updated)
    (*base->style_updated)(self);
}
void Widget_Class::direction_changed_callback(GtkWidget* self, GtkTextDirection p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_direction_changed(static_cast<TextDirection>(p0)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->direction_changed)
    (*base->direction_changed)(self, p0);
}
void Widget_Class::grab_notify_callback(GtkWidget* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_grab_notify(p0
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->grab_notify)
    (*base->grab_notify)(self, p0);
}
void Widget_Class::child_notify_callback(GtkWidget* self, GParamSpec* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_child_notify(p0);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->child_notify)
    (*base->child_notify)(self, p0);
}
gboolean Widget_Class::mnemonic_activate_callback(GtkWidget* self, gboolean p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_mnemonic_activate(p0
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->mnemonic_activate)
    return (*base->mnemonic_activate)(self, p0);

  using RType = gboolean;
  return RType();
}
void Widget_Class::grab_focus_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_grab_focus();
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->grab_focus)
    (*base->grab_focus)(self);
}
gboolean Widget_Class::focus_callback(GtkWidget* self, GtkDirectionType p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus(static_cast<DirectionType>(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->focus)
    return (*base->focus)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::event_callback(GtkWidget* self, GdkEvent* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->event)
    return (*base->event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::button_press_event_callback(GtkWidget* self, GdkEventButton* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_press_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->button_press_event)
    return (*base->button_press_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::button_release_event_callback(GtkWidget* self, GdkEventButton* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_button_release_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->button_release_event)
    return (*base->button_release_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::scroll_event_callback(GtkWidget* self, GdkEventScroll* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_scroll_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->scroll_event)
    return (*base->scroll_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::motion_notify_event_callback(GtkWidget* self, GdkEventMotion* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_motion_notify_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->motion_notify_event)
    return (*base->motion_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::delete_event_callback(GtkWidget* self, GdkEventAny* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_delete_event(wrap_event_any(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->delete_event)
    return (*base->delete_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::key_press_event_callback(GtkWidget* self, GdkEventKey* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_press_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_press_event)
    return (*base->key_press_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::key_release_event_callback(GtkWidget* self, GdkEventKey* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_key_release_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->key_release_event)
    return (*base->key_release_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::enter_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_enter_notify_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->enter_notify_event)
    return (*base->enter_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::leave_notify_event_callback(GtkWidget* self, GdkEventCrossing* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_leave_notify_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->leave_notify_event)
    return (*base->leave_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::configure_event_callback(GtkWidget* self, GdkEventConfigure* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_configure_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->configure_event)
    return (*base->configure_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::focus_in_event_callback(GtkWidget* self, GdkEventFocus* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus_in_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->focus_in_event)
    return (*base->focus_in_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::focus_out_event_callback(GtkWidget* self, GdkEventFocus* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_focus_out_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->focus_out_event)
    return (*base->focus_out_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::map_event_callback(GtkWidget* self, GdkEventAny* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_map_event(wrap_event_any(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->map_event)
    return (*base->map_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::unmap_event_callback(GtkWidget* self, GdkEventAny* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_unmap_event(wrap_event_any(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->unmap_event)
    return (*base->unmap_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::property_notify_event_callback(GtkWidget* self, GdkEventProperty* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_property_notify_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->property_notify_event)
    return (*base->property_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::selection_clear_event_callback(GtkWidget* self, GdkEventSelection* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_selection_clear_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_clear_event)
    return (*base->selection_clear_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::selection_request_event_callback(GtkWidget* self, GdkEventSelection* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_selection_request_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_request_event)
    return (*base->selection_request_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::selection_notify_event_callback(GtkWidget* self, GdkEventSelection* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_selection_notify_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_notify_event)
    return (*base->selection_notify_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::proximity_in_event_callback(GtkWidget* self, GdkEventProximity* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_proximity_in_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->proximity_in_event)
    return (*base->proximity_in_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::proximity_out_event_callback(GtkWidget* self, GdkEventProximity* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_proximity_out_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->proximity_out_event)
    return (*base->proximity_out_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::window_state_event_callback(GtkWidget* self, GdkEventWindowState* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_window_state_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->window_state_event)
    return (*base->window_state_event)(self, p0);

  using RType = gboolean;
  return RType();
}
void Widget_Class::selection_received_callback(GtkWidget* self, GtkSelectionData* p0, guint p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_selection_received(SelectionData_WithoutOwnership(p0)
, p1);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->selection_received)
    (*base->selection_received)(self, p0, p1);
}
void Widget_Class::drag_begin_callback(GtkWidget* self, GdkDragContext* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_begin(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_begin)
    (*base->drag_begin)(self, p0);
}
void Widget_Class::drag_end_callback(GtkWidget* self, GdkDragContext* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_end(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_end)
    (*base->drag_end)(self, p0);
}
void Widget_Class::drag_data_delete_callback(GtkWidget* self, GdkDragContext* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_data_delete(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_data_delete)
    (*base->drag_data_delete)(self, p0);
}
gboolean Widget_Class::drag_failed_callback(GtkWidget* self, GdkDragContext* p0, GtkDragResult p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_drag_failed(Glib::wrap(p0, true)
, static_cast<DragResult>(p1)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_failed)
    return (*base->drag_failed)(self, p0, p1);

  using RType = gboolean;
  return RType();
}
void Widget_Class::drag_leave_callback(GtkWidget* self, GdkDragContext* p0, guint p1)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_leave(Glib::wrap(p0, true)
, p1);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_leave)
    (*base->drag_leave)(self, p0, p1);
}
gboolean Widget_Class::drag_motion_callback(GtkWidget* self, GdkDragContext* p0, gint p1, gint p2, guint p3)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_drag_motion(Glib::wrap(p0, true)
, p1
, p2
, p3));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_motion)
    return (*base->drag_motion)(self, p0, p1, p2, p3);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::drag_drop_callback(GtkWidget* self, GdkDragContext* p0, gint p1, gint p2, guint p3)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_drag_drop(Glib::wrap(p0, true)
, p1
, p2
, p3));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_drop)
    return (*base->drag_drop)(self, p0, p1, p2, p3);

  using RType = gboolean;
  return RType();
}
void Widget_Class::drag_data_received_callback(GtkWidget* self, GdkDragContext* p0, gint p1, gint p2, GtkSelectionData* p3, guint p4, guint p5)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_drag_data_received(Glib::wrap(p0, true)
, p1
, p2
, SelectionData_WithoutOwnership(p3)
, p4, p5);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->drag_data_received)
    (*base->drag_data_received)(self, p0, p1, p2, p3, p4, p5);
}
void Widget_Class::screen_changed_callback(GtkWidget* self, GdkScreen* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        obj->on_screen_changed(Glib::wrap(p0, true)
);
        return;
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->screen_changed)
    (*base->screen_changed)(self, p0);
}
gboolean Widget_Class::popup_menu_callback(GtkWidget* self)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_popup_menu());
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->popup_menu)
    return (*base->popup_menu)(self);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::query_tooltip_callback(GtkWidget* self, gint p0, gint p1, gboolean p2, GtkTooltip* p3)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_query_tooltip(p0
, p1
, p2
, Glib::wrap(p3, true)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->query_tooltip)
    return (*base->query_tooltip)(self, p0, p1, p2, p3);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::grab_broken_event_callback(GtkWidget* self, GdkEventGrabBroken* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_grab_broken_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->grab_broken_event)
    return (*base->grab_broken_event)(self, p0);

  using RType = gboolean;
  return RType();
}
gboolean Widget_Class::touch_event_callback(GtkWidget* self, GdkEventTouch* p0)
{
  const auto obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    const auto obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
        // Call the virtual member method, which derived classes might override.
        return static_cast<int>(obj->on_touch_event(Gdk::wrap_event(p0)
));
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
    }
  }

  const auto base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->touch_event)
    return (*base->touch_event)(self, p0);

  using RType = gboolean;
  return RType();
}


Glib::ObjectBase* Widget_Class::wrap_new(GObject* o)
{
  return manage(new Widget((GtkWidget*)(o)));

}


/* The implementation: */

Widget::Widget(const Glib::ConstructParams& construct_params)
:
  Object(construct_params)
{
  }

Widget::Widget(GtkWidget* castitem)
:
  Object((GObject*)(castitem))
{
  }


Widget::Widget(Widget&& src) noexcept
: Object(std::move(src))
  , Buildable(std::move(src))
#ifdef GTKMM_ATKMM_ENABLED
  , Atk::Implementor(std::move(src))

#endif // GTKMM_ATKMM_ENABLED
{}

Widget& Widget::operator=(Widget&& src) noexcept
{
  Object::operator=(std::move(src));
  Buildable::operator=(std::move(src));
#ifdef GTKMM_ATKMM_ENABLED
  Atk::Implementor::operator=(std::move(src));

#endif // GTKMM_ATKMM_ENABLED
  return *this;
}

Widget::CppClassType Widget::widget_class_; // initialize static member

GType Widget::get_type()
{
  return widget_class_.init().get_type();
}


GType Widget::get_base_type()
{
  return gtk_widget_get_type();
}


void Widget::show()
{
  gtk_widget_show(gobj());
}

void Widget::show_now()
{
  gtk_widget_show_now(gobj());
}

void Widget::hide()
{
  gtk_widget_hide(gobj());
}

void Widget::queue_draw()
{
  gtk_widget_queue_draw(gobj());
}

void Widget::queue_draw_area(int x, int y, int width, int height)
{
  gtk_widget_queue_draw_area(gobj(), x, y, width, height);
}

void Widget::queue_draw_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gtk_widget_queue_draw_region(gobj(), ((region) ? (region)->cobj() : nullptr));
}

void Widget::queue_resize()
{
  gtk_widget_queue_resize(gobj());
}

void Widget::queue_allocate()
{
  gtk_widget_queue_allocate(gobj());
}

void Widget::size_allocate(const Allocation& allocation, int baseline, Allocation& out_clip)
{
  gtk_widget_size_allocate(gobj(), (allocation.gobj()), baseline, (GtkAllocation*)(out_clip.gobj()));
}

SizeRequestMode Widget::get_request_mode() const
{
  return static_cast<SizeRequestMode>(gtk_widget_get_request_mode(const_cast<GtkWidget*>(gobj())));
}

void Widget::measure(Orientation orientation, int for_size, int& minimum, int& natural, int& minimum_baseline, int& natural_baseline) const
{
  gtk_widget_measure(const_cast<GtkWidget*>(gobj()), static_cast<GtkOrientation>(orientation), for_size, &(minimum), &(natural), &(minimum_baseline), &(natural_baseline));
}

void Widget::get_preferred_size(Requisition& minimum_size, Requisition& natural_size) const
{
  gtk_widget_get_preferred_size(const_cast<GtkWidget*>(gobj()), (GtkRequisition*)(&minimum_size), (GtkRequisition*)(&natural_size));
}

void Widget::add_accelerator(const Glib::ustring& accel_signal, const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods, AccelFlags accel_flags)
{
  gtk_widget_add_accelerator(gobj(), accel_signal.c_str(), Glib::unwrap(accel_group), accel_key, static_cast<GdkModifierType>(accel_mods), static_cast<GtkAccelFlags>(accel_flags));
}

bool Widget::remove_accelerator(const Glib::RefPtr<AccelGroup>& accel_group, guint accel_key, Gdk::ModifierType accel_mods)
{
  return gtk_widget_remove_accelerator(gobj(), Glib::unwrap(accel_group), accel_key, static_cast<GdkModifierType>(accel_mods));
}

void Widget::set_accel_path(const Glib::ustring& accel_path, const Glib::RefPtr<AccelGroup>& accel_group)
{
  gtk_widget_set_accel_path(gobj(), accel_path.c_str(), Glib::unwrap(accel_group));
}

bool Widget::mnemonic_activate(bool group_cycling)
{
  return gtk_widget_mnemonic_activate(gobj(), static_cast<int>(group_cycling));
}

bool Widget::event(const Gdk::Event& gdk_event)
{
  return gtk_widget_event(gobj(), (gdk_event).gobj());
}

bool Widget::send_focus_change(Gdk::EventFocus& gdk_event)
{
  return gtk_widget_send_focus_change(gobj(), (gdk_event).Event::gobj());
}

bool Widget::activate()
{
  return gtk_widget_activate(gobj());
}

bool Widget::intersect(const Gdk::Rectangle& area, Gdk::Rectangle& intersection) const
{
  return gtk_widget_intersect(const_cast<GtkWidget*>(gobj()), (area).gobj(), (intersection).gobj());
}

void Widget::freeze_child_notify()
{
  gtk_widget_freeze_child_notify(gobj());
}

void Widget::child_notify(const Glib::ustring& child_property)
{
  gtk_widget_child_notify(gobj(), child_property.c_str());
}

void Widget::thaw_child_notify()
{
  gtk_widget_thaw_child_notify(gobj());
}

void Widget::set_can_focus(bool can_focus)
{
  gtk_widget_set_can_focus(gobj(), static_cast<int>(can_focus));
}

bool Widget::get_can_focus() const
{
  return gtk_widget_get_can_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_focus() const
{
  return gtk_widget_has_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_focus() const
{
  return gtk_widget_is_focus(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_visible_focus() const
{
  return gtk_widget_has_visible_focus(const_cast<GtkWidget*>(gobj()));
}

void Widget::grab_focus()
{
  gtk_widget_grab_focus(gobj());
}

void Widget::set_focus_on_click(bool focus_on_click)
{
  gtk_widget_set_focus_on_click(gobj(), static_cast<int>(focus_on_click));
}

bool Widget::get_focus_on_click() const
{
  return gtk_widget_get_focus_on_click(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_can_default(bool can_default)
{
  gtk_widget_set_can_default(gobj(), static_cast<int>(can_default));
}

bool Widget::get_can_default() const
{
  return gtk_widget_get_can_default(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_default() const
{
  return gtk_widget_has_default(const_cast<GtkWidget*>(gobj()));
}

void Widget::grab_default()
{
  gtk_widget_grab_default(gobj());
}

void Widget::set_receives_default(bool receives_default)
{
  gtk_widget_set_receives_default(gobj(), static_cast<int>(receives_default));
}

bool Widget::get_receives_default() const
{
  return gtk_widget_get_receives_default(const_cast<GtkWidget*>(gobj()));
}

bool Widget::has_grab() const
{
  return gtk_widget_has_grab(const_cast<GtkWidget*>(gobj()));
}

bool Widget::device_is_shadowed(const Glib::RefPtr<const Gdk::Device>& device)
{
  return gtk_widget_device_is_shadowed(gobj(), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)));
}

void Widget::set_name(const Glib::ustring& name)
{
  gtk_widget_set_name(gobj(), name.c_str());
}

Glib::ustring Widget::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gtk_widget_get_name(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_state_flags(StateFlags flags, bool clear)
{
  gtk_widget_set_state_flags(gobj(), static_cast<GtkStateFlags>(flags), static_cast<int>(clear));
}

void Widget::unset_state_flags(StateFlags flags)
{
  gtk_widget_unset_state_flags(gobj(), static_cast<GtkStateFlags>(flags));
}

StateFlags Widget::get_state_flags() const
{
  return static_cast<StateFlags>(gtk_widget_get_state_flags(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_sensitive(bool sensitive)
{
  gtk_widget_set_sensitive(gobj(), static_cast<int>(sensitive));
}

bool Widget::get_sensitive() const
{
  return gtk_widget_get_sensitive(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_sensitive() const
{
  return gtk_widget_is_sensitive(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_visible(bool visible)
{
  gtk_widget_set_visible(gobj(), static_cast<int>(visible));
}

bool Widget::get_visible() const
{
  return gtk_widget_get_visible(const_cast<GtkWidget*>(gobj()));
}

bool Widget::is_visible() const
{
  return gtk_widget_is_visible(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_has_window() const
{
  return gtk_widget_get_has_window(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_is_toplevel() const
{
  return gtk_widget_is_toplevel(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_is_drawable() const
{
  return gtk_widget_is_drawable(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_realized() const
{
  return gtk_widget_get_realized(const_cast<GtkWidget*>(gobj()));
}

bool Widget::get_mapped() const
{
  return gtk_widget_get_mapped(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_child_visible(bool visible)
{
  gtk_widget_set_child_visible(gobj(), static_cast<int>(visible));
}

bool Widget::get_child_visible() const
{
  return gtk_widget_get_child_visible(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<Gdk::Window> Widget::get_window()
{
  auto retvalue = Glib::wrap(gtk_widget_get_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Window> Widget::get_window() const
{
  return const_cast<Widget*>(this)->get_window();
}

void Widget::register_window(const Glib::RefPtr<Gdk::Window>& window)
{
  gtk_widget_register_window(gobj(), Glib::unwrap(window));
}

void Widget::unregister_window(const Glib::RefPtr<Gdk::Window>& window)
{
  gtk_widget_unregister_window(gobj(), Glib::unwrap(window));
}

int Widget::get_allocated_width() const
{
  return gtk_widget_get_allocated_width(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_height() const
{
  return gtk_widget_get_allocated_height(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_allocated_baseline() const
{
  return gtk_widget_get_allocated_baseline(const_cast<GtkWidget*>(gobj()));
}

void Widget::get_allocated_size(Allocation& allocation, int& baseline) const
{
  gtk_widget_get_allocated_size(const_cast<GtkWidget*>(gobj()), (GtkAllocation*)(allocation.gobj()), &(baseline));
}

Container* Widget::get_parent()
{
  return Glib::wrap((GtkContainer*)(gtk_widget_get_parent(gobj())));
}

const Container* Widget::get_parent() const
{
  return const_cast<Widget*>(this)->get_parent();
}

Glib::RefPtr<Gdk::Window> Widget::get_parent_window()
{
  auto retvalue = Glib::wrap(gtk_widget_get_parent_window(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Window> Widget::get_parent_window() const
{
  return const_cast<Widget*>(this)->get_parent_window();
}

void Widget::set_parent_window(const Glib::RefPtr<const Gdk::Window>& parent_window)
{
  gtk_widget_set_parent_window(gobj(), const_cast<GdkWindow*>(Glib::unwrap<Gdk::Window>(parent_window)));
}

bool Widget::child_focus(DirectionType direction)
{
  return gtk_widget_child_focus(gobj(), static_cast<GtkDirectionType>(direction));
}

bool Widget::keynav_failed(DirectionType direction)
{
  return gtk_widget_keynav_failed(gobj(), static_cast<GtkDirectionType>(direction));
}

void Widget::error_bell()
{
  gtk_widget_error_bell(gobj());
}

void Widget::set_size_request(int width, int height)
{
  gtk_widget_set_size_request(gobj(), width, height);
}

void Widget::get_size_request(int& width, int& height) const
{
  gtk_widget_get_size_request(const_cast<GtkWidget*>(gobj()), &(width), &(height));
}

void Widget::set_opacity(double opacity)
{
  gtk_widget_set_opacity(gobj(), opacity);
}

double Widget::get_opacity() const
{
  return gtk_widget_get_opacity(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_device_enabled(const Glib::RefPtr<Gdk::Device>& device, bool enabled)
{
  gtk_widget_set_device_enabled(gobj(), Glib::unwrap(device), static_cast<int>(enabled));
}

bool Widget::get_device_enabled(const Glib::RefPtr<const Gdk::Device>& device) const
{
  return gtk_widget_get_device_enabled(const_cast<GtkWidget*>(gobj()), const_cast<GdkDevice*>(Glib::unwrap<Gdk::Device>(device)));
}

Container* Widget::get_toplevel()
{
  return Glib::wrap((GtkContainer*)(gtk_widget_get_toplevel(gobj())));
}

const Container* Widget::get_toplevel() const
{
  return const_cast<Widget*>(this)->get_toplevel();
}

Widget* Widget::get_ancestor(GType widget_type)
{
  return Glib::wrap(gtk_widget_get_ancestor(gobj(), widget_type));
}

const Widget* Widget::get_ancestor(GType widget_type) const
{
  return const_cast<Widget*>(this)->get_ancestor(widget_type);
}

Glib::RefPtr<Gdk::Screen> Widget::get_screen()
{
  auto retvalue = Glib::wrap(gtk_widget_get_screen(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Screen> Widget::get_screen() const
{
  return const_cast<Widget*>(this)->get_screen();
}

bool Widget::has_screen() const
{
  return gtk_widget_has_screen(const_cast<GtkWidget*>(gobj()));
}

int Widget::get_scale_factor() const
{
  return gtk_widget_get_scale_factor(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<Gdk::Display> Widget::get_display()
{
  auto retvalue = Glib::wrap(gtk_widget_get_display(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gdk::Display> Widget::get_display() const
{
  return const_cast<Widget*>(this)->get_display();
}

Glib::RefPtr<Settings> Widget::get_settings()
{
  auto retvalue = Glib::wrap(gtk_widget_get_settings(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Clipboard> Widget::get_clipboard(const Glib::ustring& selection)
{
  auto retvalue = Glib::wrap(gtk_widget_get_clipboard(gobj(), Gdk::AtomString::to_c_type(selection)));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Clipboard> Widget::get_clipboard(const Glib::ustring& selection) const
{
  return const_cast<Widget*>(this)->get_clipboard(selection);
}

bool Widget::get_hexpand() const
{
  return gtk_widget_get_hexpand(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_hexpand(bool expand)
{
  gtk_widget_set_hexpand(gobj(), static_cast<int>(expand));
}

bool Widget::get_hexpand_set() const
{
  return gtk_widget_get_hexpand_set(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_hexpand_set(bool set)
{
  gtk_widget_set_hexpand_set(gobj(), static_cast<int>(set));
}

bool Widget::get_vexpand() const
{
  return gtk_widget_get_vexpand(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_vexpand(bool expand)
{
  gtk_widget_set_vexpand(gobj(), static_cast<int>(expand));
}

bool Widget::get_vexpand_set() const
{
  return gtk_widget_get_vexpand_set(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_vexpand_set(bool set)
{
  gtk_widget_set_vexpand_set(gobj(), static_cast<int>(set));
}

void Widget::queue_compute_expand()
{
  gtk_widget_queue_compute_expand(gobj());
}

bool Widget::compute_expand(Orientation orientation)
{
  return gtk_widget_compute_expand(gobj(), static_cast<GtkOrientation>(orientation));
}

bool Widget::get_support_multidevice() const
{
  return gtk_widget_get_support_multidevice(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_support_multidevice(bool support_multidevice)
{
  gtk_widget_set_support_multidevice(gobj(), static_cast<int>(support_multidevice));
}

#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<Atk::Object> Widget::get_accessible()
{
  auto retvalue = Glib::wrap(gtk_widget_get_accessible(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}
#endif // GTKMM_ATKMM_ENABLED

#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<const Atk::Object> Widget::get_accessible() const
{
  return const_cast<Widget*>(this)->get_accessible();
}
#endif // GTKMM_ATKMM_ENABLED

Align Widget::get_halign() const
{
  return static_cast<Align>(gtk_widget_get_halign(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_halign(Align align)
{
  gtk_widget_set_halign(gobj(), static_cast<GtkAlign>(align));
}

Align Widget::get_valign() const
{
  return static_cast<Align>(gtk_widget_get_valign(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_valign(Align align)
{
  gtk_widget_set_valign(gobj(), static_cast<GtkAlign>(align));
}

int Widget::get_margin_start() const
{
  return gtk_widget_get_margin_start(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_start(int margin)
{
  gtk_widget_set_margin_start(gobj(), margin);
}

int Widget::get_margin_end() const
{
  return gtk_widget_get_margin_end(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_end(int margin)
{
  gtk_widget_set_margin_end(gobj(), margin);
}

int Widget::get_margin_top() const
{
  return gtk_widget_get_margin_top(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_top(int margin)
{
  gtk_widget_set_margin_top(gobj(), margin);
}

int Widget::get_margin_bottom() const
{
  return gtk_widget_get_margin_bottom(const_cast<GtkWidget*>(gobj()));
}

void Widget::set_margin_bottom(int margin)
{
  gtk_widget_set_margin_bottom(gobj(), margin);
}

bool Widget::is_ancestor(Widget & ancestor) const
{
  return gtk_widget_is_ancestor(const_cast<GtkWidget*>(gobj()), (ancestor).gobj());
}

bool Widget::translate_coordinates(Widget& dest_widget, int src_x, int src_y, int& dest_x, int& dest_y)
{
  return gtk_widget_translate_coordinates(gobj(), (dest_widget).gobj(), src_x, src_y, &(dest_x), &(dest_y));
}

void Widget::reset_style()
{
  gtk_widget_reset_style(gobj());
}

Glib::RefPtr<Pango::Context> Widget::create_pango_context()
{
  return Glib::wrap(gtk_widget_create_pango_context(gobj()));
}

Glib::RefPtr<Pango::Context> Widget::get_pango_context()
{
  auto retvalue = Glib::wrap(gtk_widget_get_pango_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

void Widget::set_font_options(const ::Cairo::FontOptions& options)
{
  gtk_widget_set_font_options(gobj(), (options).cobj());
}

::Cairo::FontOptions Widget::get_font_options() const
{
  return ::Cairo::FontOptions(const_cast<cairo_font_options_t*>(gtk_widget_get_font_options(const_cast<GtkWidget*>(gobj()))), false /* take_ownership */);
}

Glib::RefPtr<Pango::Layout> Widget::create_pango_layout(const Glib::ustring& text)
{
  return Glib::wrap(gtk_widget_create_pango_layout(gobj(), text.c_str()));
}

void Widget::set_direction(TextDirection dir)
{
  gtk_widget_set_direction(gobj(), static_cast<GtkTextDirection>(dir));
}

TextDirection Widget::get_direction() const
{
  return static_cast<TextDirection>(gtk_widget_get_direction(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_default_direction(TextDirection dir)
{
  gtk_widget_set_default_direction(static_cast<GtkTextDirection>(dir));
}

TextDirection Widget::get_default_direction()
{
  return static_cast<TextDirection>(gtk_widget_get_default_direction());
}

void Widget::shape_combine_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gtk_widget_shape_combine_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

void Widget::input_shape_combine_region(const ::Cairo::RefPtr<const ::Cairo::Region>& region)
{
  gtk_widget_input_shape_combine_region(gobj(), const_cast<cairo_region_t*>((region) ? (region)->cobj() : nullptr));
}

WidgetPath Widget::get_path() const
{
  return Glib::wrap(gtk_widget_get_path(const_cast<GtkWidget*>(gobj())), true);
}

std::vector<Widget*> Widget::list_mnemonic_labels()
{
  return Glib::ListHandler<Widget*>::list_to_vector(gtk_widget_list_mnemonic_labels(gobj()), Glib::OWNERSHIP_SHALLOW);
}

std::vector<const Widget*> Widget::list_mnemonic_labels() const
{
  return Glib::ListHandler<const Widget*>::list_to_vector(gtk_widget_list_mnemonic_labels(const_cast<GtkWidget*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Widget::add_mnemonic_label(Widget& label)
{
  gtk_widget_add_mnemonic_label(gobj(), (label).gobj());
}

void Widget::remove_mnemonic_label(Widget& label)
{
  gtk_widget_remove_mnemonic_label(gobj(), (label).gobj());
}

void Widget::drag_get_data(const Glib::RefPtr<Gdk::DragContext>& context, const Glib::ustring& target, guint32 time)
{
  gtk_drag_get_data(gobj(), Glib::unwrap(context), Gdk::AtomString::to_c_type(target), time);
}

void Widget::drag_highlight()
{
  gtk_drag_highlight(gobj());
}

void Widget::drag_unhighlight()
{
  gtk_drag_unhighlight(gobj());
}

void Widget::drag_dest_unset()
{
  gtk_drag_dest_unset(gobj());
}

Glib::ustring Widget::drag_dest_find_target(const Glib::RefPtr<Gdk::DragContext>& context, const Glib::RefPtr<TargetList>& target_list) const
{
  return Gdk::AtomString::to_cpp_type(gtk_drag_dest_find_target(const_cast<GtkWidget*>(gobj()), Glib::unwrap(context), const_cast<GtkTargetList*>(Glib::unwrap(target_list))));
}

Glib::RefPtr<TargetList> Widget::drag_dest_get_target_list()
{
  auto retvalue = Glib::wrap(gtk_drag_dest_get_target_list(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const TargetList> Widget::drag_dest_get_target_list() const
{
  return const_cast<Widget*>(this)->drag_dest_get_target_list();
}

void Widget::drag_dest_set_target_list(const Glib::RefPtr<TargetList>& target_list)
{
  gtk_drag_dest_set_target_list(gobj(), const_cast<GtkTargetList*>(Glib::unwrap(target_list)));
}

void Widget::drag_dest_add_text_targets()
{
  gtk_drag_dest_add_text_targets(gobj());
}

void Widget::drag_dest_add_image_targets()
{
  gtk_drag_dest_add_image_targets(gobj());
}

void Widget::drag_dest_add_uri_targets()
{
  gtk_drag_dest_add_uri_targets(gobj());
}

void Widget::drag_source_unset()
{
  gtk_drag_source_unset(gobj());
}

void Widget::drag_source_set_icon(const Glib::RefPtr<Gdk::Pixbuf>& pixbuf)
{
  gtk_drag_source_set_icon_pixbuf(gobj(), Glib::unwrap(pixbuf));
}

void Widget::drag_source_set_icon(const Glib::ustring& icon_name)
{
  gtk_drag_source_set_icon_name(gobj(), icon_name.c_str());
}

void Widget::drag_source_add_text_targets()
{
  gtk_drag_source_add_text_targets(gobj());
}

void Widget::drag_source_add_uri_targets()
{
  gtk_drag_source_add_uri_targets(gobj());
}

void Widget::drag_source_add_image_targets()
{
  gtk_drag_source_add_image_targets(gobj());
}

Glib::RefPtr<Gdk::DragContext> Widget::drag_begin(const Glib::RefPtr<TargetList>& targets, Gdk::DragAction actions, int button, Gdk::Event& gdk_event, int x, int y)
{
  auto retvalue = Glib::wrap(gtk_drag_begin_with_coordinates(gobj(), const_cast<GtkTargetList*>(Glib::unwrap(targets)), static_cast<GdkDragAction>(actions), button, (gdk_event).gobj(), x, y));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

bool Widget::drag_check_threshold(int start_x, int start_y, int current_x, int current_y)
{
  return gtk_drag_check_threshold(gobj(), start_x, start_y, current_x, current_y);
}

void Widget::queue_resize_no_redraw()
{
  gtk_widget_queue_resize_no_redraw(gobj());
}

void Widget::set_parent(Widget& parent)
{
  gtk_widget_set_parent(gobj(), (parent).gobj());
}

void Widget::unparent()
{
  gtk_widget_unparent(gobj());
}

void Widget::map()
{
  gtk_widget_map(gobj());
}

void Widget::unmap()
{
  gtk_widget_unmap(gobj());
}

void Widget::set_tooltip_window(Window& custom_window)
{
  gtk_widget_set_tooltip_window(gobj(), (custom_window).gobj());
}

Window* Widget::get_tooltip_window()
{
  return Glib::wrap(gtk_widget_get_tooltip_window(gobj()));
}

void Widget::trigger_tooltip_query()
{
  gtk_widget_trigger_tooltip_query(gobj());
}

void Widget::set_tooltip_text(const Glib::ustring& text)
{
  gtk_widget_set_tooltip_text(gobj(), text.c_str());
}

Glib::ustring Widget::get_tooltip_text() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_tooltip_text(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_tooltip_markup(const Glib::ustring& markup)
{
  gtk_widget_set_tooltip_markup(gobj(), markup.c_str());
}

Glib::ustring Widget::get_tooltip_markup() const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gtk_widget_get_tooltip_markup(const_cast<GtkWidget*>(gobj())));
}

void Widget::set_has_tooltip(bool has_tooltip)
{
  gtk_widget_set_has_tooltip(gobj(), static_cast<int>(has_tooltip));
}

bool Widget::get_has_tooltip() const
{
  return gtk_widget_get_has_tooltip(const_cast<GtkWidget*>(gobj()));
}

bool Widget::in_destruction() const
{
  return gtk_widget_in_destruction(const_cast<GtkWidget*>(gobj()));
}

Glib::RefPtr<StyleContext> Widget::get_style_context()
{
  auto retvalue = Glib::wrap(gtk_widget_get_style_context(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<Gtk::StyleContext> Widget::get_style_context() const
{
  return const_cast<Widget*>(this)->get_style_context();
}

Gdk::ModifierType Widget::get_modifier_mask(Gdk::ModifierIntent intent)
{
  return static_cast<Gdk::ModifierType>(gtk_widget_get_modifier_mask(gobj(), static_cast<GdkModifierIntent>(intent)));
}

void Widget::insert_action_group(const Glib::ustring& name, const Glib::RefPtr<Gio::ActionGroup>& group)
{
  gtk_widget_insert_action_group(gobj(), name.c_str(), const_cast<GActionGroup*>(Glib::unwrap<Gio::ActionGroup>(group)));
}

Glib::RefPtr<Gio::ActionGroup> Widget::get_action_group(const Glib::ustring& prefix)
{
  auto retvalue = Glib::wrap(gtk_widget_get_action_group(gobj(), prefix.c_str()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Gio::ActionGroup> Widget::get_action_group(const Glib::ustring& prefix) const
{
  return const_cast<Widget*>(this)->get_action_group(prefix);
}

std::vector<Glib::ustring> Widget::list_action_prefixes() const
{
  return Glib::ArrayHandler<Glib::ustring>::array_to_vector(gtk_widget_list_action_prefixes(const_cast<GtkWidget*>(gobj())), Glib::OWNERSHIP_SHALLOW);
}

void Widget::set_font_map(const Glib::RefPtr<Pango::FontMap>& font_map)
{
  gtk_widget_set_font_map(gobj(), Glib::unwrap(font_map));
}

Glib::RefPtr<Pango::FontMap> Widget::get_font_map()
{
  auto retvalue = Glib::wrap(gtk_widget_get_font_map(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;
}

Glib::RefPtr<const Pango::FontMap> Widget::get_font_map() const
{
  return const_cast<Widget*>(this)->get_font_map();
}

Widget* Widget::get_first_child()
{
  return Glib::wrap(gtk_widget_get_first_child(gobj()));
}

const Widget* Widget::get_first_child() const
{
  return const_cast<Widget*>(this)->get_first_child();
}

Widget* Widget::get_last_child()
{
  return Glib::wrap(gtk_widget_get_last_child(gobj()));
}

const Widget* Widget::get_last_child() const
{
  return const_cast<Widget*>(this)->get_last_child();
}

Widget* Widget::get_next_sibling()
{
  return Glib::wrap(gtk_widget_get_next_sibling(gobj()));
}

const Widget* Widget::get_next_sibling() const
{
  return const_cast<Widget*>(this)->get_next_sibling();
}

Widget* Widget::get_prev_sibling()
{
  return Glib::wrap(gtk_widget_get_prev_sibling(gobj()));
}

const Widget* Widget::get_prev_sibling() const
{
  return const_cast<Widget*>(this)->get_prev_sibling();
}

void Widget::insert_after(Widget& parent, Widget& previous_sibling)
{
  gtk_widget_insert_after(gobj(), (parent).gobj(), (previous_sibling).gobj());
}

void Widget::insert_after(Widget& parent)
{
  gtk_widget_insert_after(gobj(), (parent).gobj(), nullptr);
}

void Widget::insert_before(Widget& parent, Widget& next_sibling)
{
  gtk_widget_insert_before(gobj(), (parent).gobj(), (next_sibling).gobj());
}

void Widget::insert_before(Widget& parent)
{
  gtk_widget_insert_before(gobj(), (parent).gobj(), nullptr);
}

void Widget::snapshot_child(Widget& child, Snapshot& snapshot)
{
  gtk_widget_snapshot_child(gobj(), (child).gobj(), (snapshot).gobj());
}

Widget::Widget()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(nullptr),
  Object(Glib::ConstructParams(widget_class_.init()))
{
  

}

void Widget::realize()
{
  gtk_widget_realize(gobj());
}

void Widget::unrealize()
{
  gtk_widget_unrealize(gobj());
}

void Widget::draw(const ::Cairo::RefPtr< ::Cairo::Context>& cr)
{
  gtk_widget_draw(gobj(), (cr)->cobj());
}

void Widget::set_realized(bool realized)
{
  gtk_widget_set_realized(gobj(), static_cast<int>(realized));
}

void Widget::set_has_window(bool has_window)
{
  gtk_widget_set_has_window(gobj(), static_cast<int>(has_window));
}


Glib::SignalProxy<void()> Widget::signal_show()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_show_info);
}


Glib::SignalProxy<void()> Widget::signal_hide()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_hide_info);
}


Glib::SignalProxy<void()> Widget::signal_map()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_map_info);
}


Glib::SignalProxy<void()> Widget::signal_unmap()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_unmap_info);
}


Glib::SignalProxy<void()> Widget::signal_realize()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_realize_info);
}


Glib::SignalProxy<void()> Widget::signal_unrealize()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_unrealize_info);
}


Glib::SignalProxy<void(const Allocation&, int, Allocation&)> Widget::signal_size_allocate()
{
  return Glib::SignalProxy<void(const Allocation&, int, Allocation&) >(this, &Widget_signal_size_allocate_info);
}


Glib::SignalProxy<void(Gtk::StateFlags)> Widget::signal_state_flags_changed()
{
  return Glib::SignalProxy<void(Gtk::StateFlags) >(this, &Widget_signal_state_flags_changed_info);
}


Glib::SignalProxy<void(Widget*)> Widget::signal_parent_changed()
{
  return Glib::SignalProxy<void(Widget*) >(this, &Widget_signal_parent_changed_info);
}


Glib::SignalProxy<void(Widget*)> Widget::signal_hierarchy_changed()
{
  return Glib::SignalProxy<void(Widget*) >(this, &Widget_signal_hierarchy_changed_info);
}


Glib::SignalProxy<void()> Widget::signal_style_updated()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_style_updated_info);
}


Glib::SignalProxy<void(TextDirection)> Widget::signal_direction_changed()
{
  return Glib::SignalProxy<void(TextDirection) >(this, &Widget_signal_direction_changed_info);
}


Glib::SignalProxy<void(bool)> Widget::signal_grab_notify()
{
  return Glib::SignalProxy<void(bool) >(this, &Widget_signal_grab_notify_info);
}


Glib::SignalProxy<void(GParamSpec*)> Widget::signal_child_notify()
{
  return Glib::SignalProxy<void(GParamSpec*) >(this, &Widget_signal_child_notify_info);
}


Glib::SignalProxy<bool(bool)> Widget::signal_mnemonic_activate()
{
  return Glib::SignalProxy<bool(bool) >(this, &Widget_signal_mnemonic_activate_info);
}


Glib::SignalProxy<void()> Widget::signal_grab_focus()
{
  return Glib::SignalProxy<void() >(this, &Widget_signal_grab_focus_info);
}


Glib::SignalProxy<bool(DirectionType)> Widget::signal_focus()
{
  return Glib::SignalProxy<bool(DirectionType) >(this, &Widget_signal_focus_info);
}


Glib::SignalProxy<bool(Gdk::Event&)> Widget::signal_event()
{
  return Glib::SignalProxy<bool(Gdk::Event&) >(this, &Widget_signal_event_info);
}


Glib::SignalProxy<void(Gdk::Event&)> Widget::signal_event_after()
{
  return Glib::SignalProxy<void(Gdk::Event&) >(this, &Widget_signal_event_after_info);
}


Glib::SignalProxy<bool(Gdk::EventButton&)> Widget::signal_button_press_event()
{
  return Glib::SignalProxy<bool(Gdk::EventButton&) >(this, &Widget_signal_button_press_event_info);
}


Glib::SignalProxy<bool(Gdk::EventButton&)> Widget::signal_button_release_event()
{
  return Glib::SignalProxy<bool(Gdk::EventButton&) >(this, &Widget_signal_button_release_event_info);
}


Glib::SignalProxy<bool(Gdk::EventScroll&)> Widget::signal_scroll_event()
{
  return Glib::SignalProxy<bool(Gdk::EventScroll&) >(this, &Widget_signal_scroll_event_info);
}


Glib::SignalProxy<bool(Gdk::EventMotion&)> Widget::signal_motion_notify_event()
{
  return Glib::SignalProxy<bool(Gdk::EventMotion&) >(this, &Widget_signal_motion_notify_event_info);
}


Glib::SignalProxy<bool(Gdk::Event&)> Widget::signal_delete_event()
{
  return Glib::SignalProxy<bool(Gdk::Event&) >(this, &Widget_signal_delete_event_info);
}


Glib::SignalProxy<bool(Gdk::EventKey&)> Widget::signal_key_press_event()
{
  return Glib::SignalProxy<bool(Gdk::EventKey&) >(this, &Widget_signal_key_press_event_info);
}


Glib::SignalProxy<bool(Gdk::EventKey&)> Widget::signal_key_release_event()
{
  return Glib::SignalProxy<bool(Gdk::EventKey&) >(this, &Widget_signal_key_release_event_info);
}


Glib::SignalProxy<bool(Gdk::EventCrossing&)> Widget::signal_enter_notify_event()
{
  return Glib::SignalProxy<bool(Gdk::EventCrossing&) >(this, &Widget_signal_enter_notify_event_info);
}


Glib::SignalProxy<bool(Gdk::EventCrossing&)> Widget::signal_leave_notify_event()
{
  return Glib::SignalProxy<bool(Gdk::EventCrossing&) >(this, &Widget_signal_leave_notify_event_info);
}


Glib::SignalProxy<bool(Gdk::EventConfigure&)> Widget::signal_configure_event()
{
  return Glib::SignalProxy<bool(Gdk::EventConfigure&) >(this, &Widget_signal_configure_event_info);
}


Glib::SignalProxy<bool(Gdk::EventFocus&)> Widget::signal_focus_in_event()
{
  return Glib::SignalProxy<bool(Gdk::EventFocus&) >(this, &Widget_signal_focus_in_event_info);
}


Glib::SignalProxy<bool(Gdk::EventFocus&)> Widget::signal_focus_out_event()
{
  return Glib::SignalProxy<bool(Gdk::EventFocus&) >(this, &Widget_signal_focus_out_event_info);
}


Glib::SignalProxy<bool(Gdk::Event&)> Widget::signal_map_event()
{
  return Glib::SignalProxy<bool(Gdk::Event&) >(this, &Widget_signal_map_event_info);
}


Glib::SignalProxy<bool(Gdk::Event&)> Widget::signal_unmap_event()
{
  return Glib::SignalProxy<bool(Gdk::Event&) >(this, &Widget_signal_unmap_event_info);
}


Glib::SignalProxy<bool(Gdk::EventProperty&)> Widget::signal_property_notify_event()
{
  return Glib::SignalProxy<bool(Gdk::EventProperty&) >(this, &Widget_signal_property_notify_event_info);
}


Glib::SignalProxy<bool(Gdk::EventSelection&)> Widget::signal_selection_clear_event()
{
  return Glib::SignalProxy<bool(Gdk::EventSelection&) >(this, &Widget_signal_selection_clear_event_info);
}


Glib::SignalProxy<bool(Gdk::EventSelection&)> Widget::signal_selection_request_event()
{
  return Glib::SignalProxy<bool(Gdk::EventSelection&) >(this, &Widget_signal_selection_request_event_info);
}


Glib::SignalProxy<bool(Gdk::EventSelection&)> Widget::signal_selection_notify_event()
{
  return Glib::SignalProxy<bool(Gdk::EventSelection&) >(this, &Widget_signal_selection_notify_event_info);
}


Glib::SignalProxy<bool(Gdk::EventProximity&)> Widget::signal_proximity_in_event()
{
  return Glib::SignalProxy<bool(Gdk::EventProximity&) >(this, &Widget_signal_proximity_in_event_info);
}


Glib::SignalProxy<bool(Gdk::EventProximity&)> Widget::signal_proximity_out_event()
{
  return Glib::SignalProxy<bool(Gdk::EventProximity&) >(this, &Widget_signal_proximity_out_event_info);
}


Glib::SignalProxy<bool(Gdk::EventWindowState&)> Widget::signal_window_state_event()
{
  return Glib::SignalProxy<bool(Gdk::EventWindowState&) >(this, &Widget_signal_window_state_event_info);
}


Glib::SignalProxy<void(SelectionData&, guint, guint)> Widget::signal_selection_get()
{
  return Glib::SignalProxy<void(SelectionData&, guint, guint) >(this, &Widget_signal_selection_get_info);
}


Glib::SignalProxy<void(const SelectionData&, guint)> Widget::signal_selection_received()
{
  return Glib::SignalProxy<void(const SelectionData&, guint) >(this, &Widget_signal_selection_received_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&)> Widget::signal_drag_begin()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&) >(this, &Widget_signal_drag_begin_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&)> Widget::signal_drag_end()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&) >(this, &Widget_signal_drag_end_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&, SelectionData&, guint, guint)> Widget::signal_drag_data_get()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&, SelectionData&, guint, guint) >(this, &Widget_signal_drag_data_get_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&)> Widget::signal_drag_data_delete()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&) >(this, &Widget_signal_drag_data_delete_info);
}


Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::DragContext>&, DragResult)> Widget::signal_drag_failed()
{
  return Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::DragContext>&, DragResult) >(this, &Widget_signal_drag_failed_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&, guint)> Widget::signal_drag_leave()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&, guint) >(this, &Widget_signal_drag_leave_info);
}


Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint)> Widget::signal_drag_motion()
{
  return Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint) >(this, &Widget_signal_drag_motion_info);
}


Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint)> Widget::signal_drag_drop()
{
  return Glib::SignalProxy<bool(const Glib::RefPtr<Gdk::DragContext>&, int, int, guint) >(this, &Widget_signal_drag_drop_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&, int, int, const SelectionData&, guint, guint)> Widget::signal_drag_data_received()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::DragContext>&, int, int, const SelectionData&, guint, guint) >(this, &Widget_signal_drag_data_received_info);
}


Glib::SignalProxy<void(const Glib::RefPtr<Gdk::Screen>&)> Widget::signal_screen_changed()
{
  return Glib::SignalProxy<void(const Glib::RefPtr<Gdk::Screen>&) >(this, &Widget_signal_screen_changed_info);
}


Glib::SignalProxy<bool()> Widget::signal_popup_menu()
{
  return Glib::SignalProxy<bool() >(this, &Widget_signal_popup_menu_info);
}


Glib::SignalProxy<bool(int, int, bool, const Glib::RefPtr<Tooltip>&)> Widget::signal_query_tooltip()
{
  return Glib::SignalProxy<bool(int, int, bool, const Glib::RefPtr<Tooltip>&) >(this, &Widget_signal_query_tooltip_info);
}


Glib::SignalProxy<bool(Gdk::EventGrabBroken&)> Widget::signal_grab_broken_event()
{
  return Glib::SignalProxy<bool(Gdk::EventGrabBroken&) >(this, &Widget_signal_grab_broken_event_info);
}


Glib::SignalProxy<bool(Gdk::EventTouch&)> Widget::signal_touch_event()
{
  return Glib::SignalProxy<bool(Gdk::EventTouch&) >(this, &Widget_signal_touch_event_info);
}


Glib::PropertyProxy< Glib::ustring > Widget::property_name() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "name");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "name");
}

Glib::PropertyProxy< Container* > Widget::property_parent() 
{
  return Glib::PropertyProxy< Container* >(this, "parent");
}

Glib::PropertyProxy_ReadOnly< Container* > Widget::property_parent() const
{
  return Glib::PropertyProxy_ReadOnly< Container* >(this, "parent");
}

Glib::PropertyProxy< int > Widget::property_width_request() 
{
  return Glib::PropertyProxy< int >(this, "width-request");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_width_request() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "width-request");
}

Glib::PropertyProxy< int > Widget::property_height_request() 
{
  return Glib::PropertyProxy< int >(this, "height-request");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_height_request() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "height-request");
}

Glib::PropertyProxy< bool > Widget::property_visible() 
{
  return Glib::PropertyProxy< bool >(this, "visible");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_visible() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "visible");
}

Glib::PropertyProxy< bool > Widget::property_sensitive() 
{
  return Glib::PropertyProxy< bool >(this, "sensitive");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_sensitive() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "sensitive");
}

Glib::PropertyProxy< bool > Widget::property_can_focus() 
{
  return Glib::PropertyProxy< bool >(this, "can-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_can_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-focus");
}

Glib::PropertyProxy< bool > Widget::property_has_focus() 
{
  return Glib::PropertyProxy< bool >(this, "has-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-focus");
}

Glib::PropertyProxy< bool > Widget::property_is_focus() 
{
  return Glib::PropertyProxy< bool >(this, "is-focus");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_is_focus() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "is-focus");
}

Glib::PropertyProxy< bool > Widget::property_focus_on_click() 
{
  return Glib::PropertyProxy< bool >(this, "focus-on-click");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_focus_on_click() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "focus-on-click");
}

Glib::PropertyProxy< bool > Widget::property_can_default() 
{
  return Glib::PropertyProxy< bool >(this, "can-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_can_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "can-default");
}

Glib::PropertyProxy< bool > Widget::property_has_default() 
{
  return Glib::PropertyProxy< bool >(this, "has-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-default");
}

Glib::PropertyProxy< bool > Widget::property_receives_default() 
{
  return Glib::PropertyProxy< bool >(this, "receives-default");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_receives_default() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "receives-default");
}

Glib::PropertyProxy< bool > Widget::property_has_tooltip() 
{
  return Glib::PropertyProxy< bool >(this, "has-tooltip");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_has_tooltip() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "has-tooltip");
}

Glib::PropertyProxy< Glib::ustring > Widget::property_tooltip_markup() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "tooltip-markup");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_tooltip_markup() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "tooltip-markup");
}

Glib::PropertyProxy< Glib::ustring > Widget::property_tooltip_text() 
{
  return Glib::PropertyProxy< Glib::ustring >(this, "tooltip-text");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_tooltip_text() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "tooltip-text");
}

Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Window> > Widget::property_window() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<Gdk::Window> >(this, "window");
}

Glib::PropertyProxy< Align > Widget::property_halign() 
{
  return Glib::PropertyProxy< Align >(this, "halign");
}

Glib::PropertyProxy_ReadOnly< Align > Widget::property_halign() const
{
  return Glib::PropertyProxy_ReadOnly< Align >(this, "halign");
}

Glib::PropertyProxy< Align > Widget::property_valign() 
{
  return Glib::PropertyProxy< Align >(this, "valign");
}

Glib::PropertyProxy_ReadOnly< Align > Widget::property_valign() const
{
  return Glib::PropertyProxy_ReadOnly< Align >(this, "valign");
}

Glib::PropertyProxy< int > Widget::property_margin_start() 
{
  return Glib::PropertyProxy< int >(this, "margin-start");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_start() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-start");
}

Glib::PropertyProxy< int > Widget::property_margin_end() 
{
  return Glib::PropertyProxy< int >(this, "margin-end");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_end() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-end");
}

Glib::PropertyProxy< int > Widget::property_margin_top() 
{
  return Glib::PropertyProxy< int >(this, "margin-top");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_top() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-top");
}

Glib::PropertyProxy< int > Widget::property_margin_bottom() 
{
  return Glib::PropertyProxy< int >(this, "margin-bottom");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin_bottom() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin-bottom");
}

Glib::PropertyProxy< int > Widget::property_margin() 
{
  return Glib::PropertyProxy< int >(this, "margin");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_margin() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "margin");
}

Glib::PropertyProxy< bool > Widget::property_hexpand() 
{
  return Glib::PropertyProxy< bool >(this, "hexpand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_hexpand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hexpand");
}

Glib::PropertyProxy< bool > Widget::property_hexpand_set() 
{
  return Glib::PropertyProxy< bool >(this, "hexpand-set");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_hexpand_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "hexpand-set");
}

Glib::PropertyProxy< bool > Widget::property_vexpand() 
{
  return Glib::PropertyProxy< bool >(this, "vexpand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_vexpand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "vexpand");
}

Glib::PropertyProxy< bool > Widget::property_vexpand_set() 
{
  return Glib::PropertyProxy< bool >(this, "vexpand-set");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_vexpand_set() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "vexpand-set");
}

Glib::PropertyProxy< bool > Widget::property_expand() 
{
  return Glib::PropertyProxy< bool >(this, "expand");
}

Glib::PropertyProxy_ReadOnly< bool > Widget::property_expand() const
{
  return Glib::PropertyProxy_ReadOnly< bool >(this, "expand");
}

Glib::PropertyProxy< double > Widget::property_opacity() 
{
  return Glib::PropertyProxy< double >(this, "opacity");
}

Glib::PropertyProxy_ReadOnly< double > Widget::property_opacity() const
{
  return Glib::PropertyProxy_ReadOnly< double >(this, "opacity");
}

Glib::PropertyProxy_ReadOnly< int > Widget::property_scale_factor() const
{
  return Glib::PropertyProxy_ReadOnly< int >(this, "scale-factor");
}

Glib::PropertyProxy_ReadOnly< Glib::ustring > Widget::property_css_name() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::ustring >(this, "css-name");
}


void Gtk::Widget::on_show()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->show)
    (*base->show)(gobj());
}
void Gtk::Widget::on_hide()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hide)
    (*base->hide)(gobj());
}
void Gtk::Widget::on_map()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->map)
    (*base->map)(gobj());
}
void Gtk::Widget::on_unmap()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unmap)
    (*base->unmap)(gobj());
}
void Gtk::Widget::on_realize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->realize)
    (*base->realize)(gobj());
}
void Gtk::Widget::on_unrealize()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unrealize)
    (*base->unrealize)(gobj());
}
void Gtk::Widget::on_size_allocate(const Allocation& allocation, int baseline, Allocation& out_clip)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->size_allocate)
    (*base->size_allocate)(gobj(),(allocation.gobj()),baseline,(out_clip.gobj()));
}
void Gtk::Widget::on_state_flags_changed(Gtk::StateFlags previous_state_flags)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->state_flags_changed)
    (*base->state_flags_changed)(gobj(),static_cast<GtkStateFlags>(previous_state_flags));
}
void Gtk::Widget::on_parent_changed(Widget* previous_parent)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->parent_set)
    (*base->parent_set)(gobj(),(GtkWidget*)Glib::unwrap(previous_parent));
}
void Gtk::Widget::on_hierarchy_changed(Widget* previous_toplevel)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->hierarchy_changed)
    (*base->hierarchy_changed)(gobj(),(GtkWidget*)Glib::unwrap(previous_toplevel));
}
void Gtk::Widget::on_style_updated()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->style_updated)
    (*base->style_updated)(gobj());
}
void Gtk::Widget::on_direction_changed(TextDirection direction)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->direction_changed)
    (*base->direction_changed)(gobj(),static_cast<GtkTextDirection>(direction));
}
void Gtk::Widget::on_grab_notify(bool was_grabbed)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_notify)
    (*base->grab_notify)(gobj(),static_cast<int>(was_grabbed));
}
void Gtk::Widget::on_child_notify(GParamSpec* pspec)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->child_notify)
    (*base->child_notify)(gobj(),pspec);
}
bool Gtk::Widget::on_mnemonic_activate(bool group_cycling)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->mnemonic_activate)
    return (*base->mnemonic_activate)(gobj(),static_cast<int>(group_cycling));

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_grab_focus()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_focus)
    (*base->grab_focus)(gobj());
}
bool Gtk::Widget::on_focus(DirectionType direction)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus)
    return (*base->focus)(gobj(),static_cast<GtkDirectionType>(direction));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_event(Gdk::Event& gdk_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->event)
    return (*base->event)(gobj(),(gdk_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_button_press_event(Gdk::EventButton& button_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->button_press_event)
    return (*base->button_press_event)(gobj(),(button_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_button_release_event(Gdk::EventButton& release_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->button_release_event)
    return (*base->button_release_event)(gobj(),(release_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_scroll_event(Gdk::EventScroll& scroll_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->scroll_event)
    return (*base->scroll_event)(gobj(),(scroll_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_motion_notify_event(Gdk::EventMotion& motion_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->motion_notify_event)
    return (*base->motion_notify_event)(gobj(),(motion_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_delete_event(Gdk::Event& any_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->delete_event)
    return (*base->delete_event)(gobj(),reinterpret_cast<GdkEventAny*>((any_event).gobj()));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_key_press_event(Gdk::EventKey& key_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_press_event)
    return (*base->key_press_event)(gobj(),(key_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_key_release_event(Gdk::EventKey& key_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->key_release_event)
    return (*base->key_release_event)(gobj(),(key_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_enter_notify_event(Gdk::EventCrossing& crossing_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->enter_notify_event)
    return (*base->enter_notify_event)(gobj(),(crossing_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_leave_notify_event(Gdk::EventCrossing& crossing_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->leave_notify_event)
    return (*base->leave_notify_event)(gobj(),(crossing_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_configure_event(Gdk::EventConfigure& configure_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->configure_event)
    return (*base->configure_event)(gobj(),(configure_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_focus_in_event(Gdk::EventFocus& focus_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus_in_event)
    return (*base->focus_in_event)(gobj(),(focus_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_focus_out_event(Gdk::EventFocus& gdk_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->focus_out_event)
    return (*base->focus_out_event)(gobj(),(gdk_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_map_event(Gdk::Event& any_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->map_event)
    return (*base->map_event)(gobj(),reinterpret_cast<GdkEventAny*>((any_event).gobj()));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_unmap_event(Gdk::Event& any_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->unmap_event)
    return (*base->unmap_event)(gobj(),reinterpret_cast<GdkEventAny*>((any_event).gobj()));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_property_notify_event(Gdk::EventProperty& property_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->property_notify_event)
    return (*base->property_notify_event)(gobj(),(property_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_selection_clear_event(Gdk::EventSelection& selection_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_clear_event)
    return (*base->selection_clear_event)(gobj(),(selection_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_selection_request_event(Gdk::EventSelection& selection_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_request_event)
    return (*base->selection_request_event)(gobj(),(selection_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_selection_notify_event(Gdk::EventSelection& selection_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_notify_event)
    return (*base->selection_notify_event)(gobj(),(selection_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_proximity_in_event(Gdk::EventProximity& proximity_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->proximity_in_event)
    return (*base->proximity_in_event)(gobj(),(proximity_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_proximity_out_event(Gdk::EventProximity& proximity_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->proximity_out_event)
    return (*base->proximity_out_event)(gobj(),(proximity_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_window_state_event(Gdk::EventWindowState& window_state_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->window_state_event)
    return (*base->window_state_event)(gobj(),(window_state_event).gobj());

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_selection_get(SelectionData& selection_data, guint info, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_get)
    (*base->selection_get)(gobj(),(selection_data).gobj(),info,time);
}
void Gtk::Widget::on_selection_received(const SelectionData& selection_data, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->selection_received)
    (*base->selection_received)(gobj(),const_cast<GtkSelectionData*>((selection_data).gobj()),time);
}
void Gtk::Widget::on_drag_begin(const Glib::RefPtr<Gdk::DragContext>& context)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_begin)
    (*base->drag_begin)(gobj(),Glib::unwrap(context));
}
void Gtk::Widget::on_drag_end(const Glib::RefPtr<Gdk::DragContext>& context)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_end)
    (*base->drag_end)(gobj(),Glib::unwrap(context));
}
void Gtk::Widget::on_drag_data_get(const Glib::RefPtr<Gdk::DragContext>& context, SelectionData& selection_data, guint info, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_data_get)
    (*base->drag_data_get)(gobj(),Glib::unwrap(context),(selection_data).gobj(),info,time);
}
void Gtk::Widget::on_drag_data_delete(const Glib::RefPtr<Gdk::DragContext>& context)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_data_delete)
    (*base->drag_data_delete)(gobj(),Glib::unwrap(context));
}
bool Gtk::Widget::on_drag_failed(const Glib::RefPtr<Gdk::DragContext>& context, DragResult result)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_failed)
    return (*base->drag_failed)(gobj(),Glib::unwrap(context),static_cast<GtkDragResult>(result));

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_drag_leave(const Glib::RefPtr<Gdk::DragContext>& context, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_leave)
    (*base->drag_leave)(gobj(),Glib::unwrap(context),time);
}
bool Gtk::Widget::on_drag_motion(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_motion)
    return (*base->drag_motion)(gobj(),Glib::unwrap(context),x,y,time);

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_drag_drop(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_drop)
    return (*base->drag_drop)(gobj(),Glib::unwrap(context),x,y,time);

  using RType = bool;
  return RType();
}
void Gtk::Widget::on_drag_data_received(const Glib::RefPtr<Gdk::DragContext>& context, int x, int y, const SelectionData& selection_data, guint info, guint time)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->drag_data_received)
    (*base->drag_data_received)(gobj(),Glib::unwrap(context),x,y,const_cast<GtkSelectionData*>((selection_data).gobj()),info,time);
}
void Gtk::Widget::on_screen_changed(const Glib::RefPtr<Gdk::Screen>& previous_screen)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->screen_changed)
    (*base->screen_changed)(gobj(),Glib::unwrap(previous_screen));
}
bool Gtk::Widget::on_popup_menu()
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->popup_menu)
    return (*base->popup_menu)(gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_query_tooltip(int x, int y, bool keyboard_tooltip, const Glib::RefPtr<Tooltip>& tooltip)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->query_tooltip)
    return (*base->query_tooltip)(gobj(),x,y,static_cast<int>(keyboard_tooltip),Glib::unwrap(tooltip));

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_grab_broken_event(Gdk::EventGrabBroken& grab_broken_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->grab_broken_event)
    return (*base->grab_broken_event)(gobj(),(grab_broken_event).gobj());

  using RType = bool;
  return RType();
}
bool Gtk::Widget::on_touch_event(Gdk::EventTouch& touch_event)
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->touch_event)
    return (*base->touch_event)(gobj(),(touch_event).gobj());

  using RType = bool;
  return RType();
}

void Gtk::Widget::dispatch_child_properties_changed_vfunc(guint p1, GParamSpec** p2) 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->dispatch_child_properties_changed)
  {
    (*base->dispatch_child_properties_changed)(gobj(),p1,p2);
  }
}
SizeRequestMode Gtk::Widget::get_request_mode_vfunc() const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_request_mode)
  {
    SizeRequestMode retval(static_cast<SizeRequestMode>((*base->get_request_mode)(const_cast<GtkWidget*>(gobj()))));
    return retval;
  }

  using RType = SizeRequestMode;
  return RType();
}
void Gtk::Widget::measure_vfunc(Orientation orientation, int for_size, int& minimum, int& natural, int& minimum_baseline, int& natural_baseline) const
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->measure)
  {
    (*base->measure)(const_cast<GtkWidget*>(gobj()),static_cast<GtkOrientation>(orientation),for_size,&(minimum),&(natural),&(minimum_baseline),&(natural_baseline));
  }
}
#ifdef GTKMM_ATKMM_ENABLED
Glib::RefPtr<Atk::Object> Gtk::Widget::get_accessible_vfunc() 
{
  const auto base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->get_accessible)
  {
    Glib::RefPtr<Atk::Object> retval(Glib::wrap((*base->get_accessible)(gobj()), true));
    return retval;
  }

  using RType = Glib::RefPtr<Atk::Object>;
  return RType();
}
#endif // GTKMM_ATKMM_ENABLED


} // namespace Gtk


