/* contacts-contact.c generated by valac 0.36.4, the Vala compiler
 * generated from contacts-contact.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 * Copyright (C) 2011 Alexander Larsson <alexl@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks-telepathy.h>
#include <gio/gio.h>
#include <geocode-glib/geocode-glib.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <contacts-esd-setup.h>
#include <telepathy-glib/telepathy-glib.h>
#include <folks/folks-eds.h>
#include <gobject/gvaluecollector.h>


#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;

#define CONTACTS_CONTACT_TYPE_IM_DISPLAY (contacts_contact_im_display_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define CONTACTS_TYPE_FAKE_PERSONA (contacts_fake_persona_get_type ())
#define CONTACTS_FAKE_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_FAKE_PERSONA, ContactsFakePersona))
#define CONTACTS_FAKE_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_FAKE_PERSONA, ContactsFakePersonaClass))
#define CONTACTS_IS_FAKE_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_FAKE_PERSONA))
#define CONTACTS_IS_FAKE_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_FAKE_PERSONA))
#define CONTACTS_FAKE_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_FAKE_PERSONA, ContactsFakePersonaClass))

typedef struct _ContactsFakePersona ContactsFakePersona;
typedef struct _ContactsFakePersonaClass ContactsFakePersonaClass;
typedef struct _Block1Data Block1Data;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _ContactsContactGeocodeAddressData ContactsContactGeocodeAddressData;

#define CONTACTS_CONTACT_TYPE_IM_DATA (contacts_contact_im_data_get_type ())
typedef struct _ContactsContactImData ContactsContactImData;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define CONTACTS_TYPE_TYPESET (contacts_typeset_get_type ())
#define CONTACTS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSet))
#define CONTACTS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))
#define CONTACTS_IS_TYPESET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_TYPESET))
#define CONTACTS_IS_TYPESET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_TYPESET))
#define CONTACTS_TYPESET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_TYPESET, ContactsTypeSetClass))

typedef struct _ContactsTypeSet ContactsTypeSet;
typedef struct _ContactsTypeSetClass ContactsTypeSetClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
typedef struct _ContactsContactRemovePersonasData ContactsContactRemovePersonasData;
typedef struct _ContactsContactEnsurePrimaryPersonaData ContactsContactEnsurePrimaryPersonaData;
typedef struct _ContactsContactSetIndividualPropertyData ContactsContactSetIndividualPropertyData;
typedef struct _ContactsContactCreatePrimaryPersonaForDetailsData ContactsContactCreatePrimaryPersonaForDetailsData;
typedef struct _ContactsContactSetPersonaPropertyData ContactsContactSetPersonaPropertyData;
typedef struct _Block2Data Block2Data;
enum  {
	CONTACTS_CONTACT_CHANGED_SIGNAL,
	CONTACTS_CONTACT_PERSONAS_CHANGED_SIGNAL,
	CONTACTS_CONTACT_LAST_SIGNAL
};
static guint contacts_contact_signals[CONTACTS_CONTACT_LAST_SIGNAL] = {0};

#define CONTACTS_TYPE_FAKE_PERSONA_STORE (contacts_fake_persona_store_get_type ())
#define CONTACTS_FAKE_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_FAKE_PERSONA_STORE, ContactsFakePersonaStore))
#define CONTACTS_FAKE_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_FAKE_PERSONA_STORE, ContactsFakePersonaStoreClass))
#define CONTACTS_IS_FAKE_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_FAKE_PERSONA_STORE))
#define CONTACTS_IS_FAKE_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_FAKE_PERSONA_STORE))
#define CONTACTS_FAKE_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_FAKE_PERSONA_STORE, ContactsFakePersonaStoreClass))

typedef struct _ContactsFakePersonaStore ContactsFakePersonaStore;
typedef struct _ContactsFakePersonaStoreClass ContactsFakePersonaStoreClass;
typedef struct _ContactsFakePersonaStorePrivate ContactsFakePersonaStorePrivate;
typedef struct _ContactsFakePersonaStorePrepareData ContactsFakePersonaStorePrepareData;
typedef struct _ContactsFakePersonaStoreAddPersonaFromDetailsData ContactsFakePersonaStoreAddPersonaFromDetailsData;
typedef struct _ContactsFakePersonaStoreRemovePersonaData ContactsFakePersonaStoreRemovePersonaData;
typedef struct _ContactsFakePersonaPrivate ContactsFakePersonaPrivate;

#define CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL (contacts_fake_persona_prop_val_get_type ())
#define CONTACTS_FAKE_PERSONA_PROP_VAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL, ContactsFakePersonaPropVal))
#define CONTACTS_FAKE_PERSONA_PROP_VAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL, ContactsFakePersonaPropValClass))
#define CONTACTS_FAKE_PERSONA_IS_PROP_VAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL))
#define CONTACTS_FAKE_PERSONA_IS_PROP_VAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL))
#define CONTACTS_FAKE_PERSONA_PROP_VAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL, ContactsFakePersonaPropValClass))

typedef struct _ContactsFakePersonaPropVal ContactsFakePersonaPropVal;
typedef struct _ContactsFakePersonaPropValClass ContactsFakePersonaPropValClass;
typedef struct _ContactsFakePersonaPropValPrivate ContactsFakePersonaPropValPrivate;
#define _contacts_fake_persona_prop_val_unref0(var) ((var == NULL) ? NULL : (var = (contacts_fake_persona_prop_val_unref (var), NULL)))
typedef struct _ContactsFakePersonaMakeRealAndSetData ContactsFakePersonaMakeRealAndSetData;
typedef struct _ContactsFakePersonaParamSpecPropVal ContactsFakePersonaParamSpecPropVal;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	CONTACT_ERROR_NOT_IMPLEMENTED,
	CONTACT_ERROR_NO_PRIMARY
} ContactError;
#define CONTACT_ERROR contact_error_quark ()
struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _ContactsContactPrivate {
	guint changed_id;
	gboolean changed_personas;
	GdkPixbuf* _small_avatar;
	GVariant* _avatar_icon_data;
	gchar* filter_data;
	gboolean _is_hidden;
	gboolean _is_hidden_uptodate;
	gboolean _is_hidden_to_delete;
};

typedef enum  {
	CONTACTS_CONTACT_IM_DISPLAY_DEFAULT,
	CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE
} ContactsContactImDisplay;

struct _Block1Data {
	int _ref_count_;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	GeocodePlace* place;
	GeocodeForward* forward;
	gpointer _async_data_;
};

struct _ContactsContactGeocodeAddressData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPostalAddress* addr;
	GeocodePlace* result;
	Block1Data* _data1_;
	GHashTable* params;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	FolksPostalAddress* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean _tmp6_;
	GHashTable* _tmp7_;
	gchar* _tmp8_;
	FolksPostalAddress* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GValue* _tmp12_;
	FolksPostalAddress* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	GHashTable* _tmp17_;
	gchar* _tmp18_;
	FolksPostalAddress* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	GValue* _tmp22_;
	FolksPostalAddress* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	GHashTable* _tmp27_;
	gchar* _tmp28_;
	FolksPostalAddress* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GValue* _tmp32_;
	FolksPostalAddress* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gboolean _tmp36_;
	GHashTable* _tmp37_;
	gchar* _tmp38_;
	FolksPostalAddress* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	GValue* _tmp42_;
	GHashTable* _tmp43_;
	GeocodeForward* _tmp44_;
	GeocodePlace* _tmp45_;
};

struct _ContactsContactImData {
	const gchar* service;
	const gchar* display_name;
	ContactsContactImDisplay display;
};

struct _ContactsContactRemovePersonasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContact* self;
	GeeHashSet* personas;
	GeeHashSet* _tmp0_;
	GeeIterator* _p_it;
	FolksIndividual* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	gboolean _tmp6_;
	FolksPersona* p;
	GeeIterator* _tmp7_;
	gpointer _tmp8_;
	gboolean _tmp9_;
	FolksPersona* _tmp10_;
	FolksPersonaStore* _tmp11_;
	FolksPersonaStore* _tmp12_;
	FolksMaybeBool _tmp13_;
	FolksMaybeBool _tmp14_;
	FolksPersona* _tmp15_;
	GeeHashSet* _tmp16_;
	FolksPersona* _tmp17_;
	GeeIterator* _persona_it;
	GeeHashSet* _tmp18_;
	GeeIterator* _tmp19_;
	GeeIterator* _tmp20_;
	gboolean _tmp21_;
	FolksPersona* persona;
	GeeIterator* _tmp22_;
	gpointer _tmp23_;
	FolksPersona* _tmp24_;
	FolksPersonaStore* _tmp25_;
	FolksPersonaStore* _tmp26_;
	FolksPersona* _tmp27_;
	GError * _inner_error_;
};

struct _ContactsContactEnsurePrimaryPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContact* self;
	FolksPersona* result;
	FolksPersona* p;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeHashSet* persona_set;
	GeeHashSet* _tmp2_;
	GeeHashSet* _tmp3_;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeHashSet* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GeeHashSet* _tmp10_;
	ContactsFakePersona* _tmp11_;
	ContactsFakePersona* _tmp12_;
	ContactsStore* _tmp13_;
	FolksIndividualAggregator* _tmp14_;
	FolksIndividualAggregator* _tmp15_;
	GeeHashSet* _tmp16_;
	FolksPersona* _tmp17_;
	FolksPersona* _tmp18_;
	GError* _tmp19_;
	GError * _inner_error_;
};

struct _ContactsContactSetIndividualPropertyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsContact* contact;
	gchar* property_name;
	GValue value;
	FolksPersona* result;
	gboolean did_set;
	FolksPersona** personas_copy;
	ContactsContact* _tmp0_;
	FolksIndividual* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gpointer* _tmp5_;
	gint personas_copy_length1;
	gint _personas_copy_size_;
	FolksPersona** _tmp6_;
	gint _tmp6__length1;
	FolksPersona** p_collection;
	gint p_collection_length1;
	gint _p_collection_size_;
	gint p_it;
	FolksPersona* _tmp7_;
	FolksPersona* p;
	const gchar* _tmp8_;
	FolksPersona* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	FolksPersona* _tmp12_;
	const gchar* _tmp13_;
	GValue _tmp14_;
	gboolean _tmp15_;
	ContactsFakePersona* fake;
	ContactsContact* _tmp16_;
	ContactsFakePersona* _tmp17_;
	FolksPersona* _tmp18_;
	ContactsFakePersona* _tmp19_;
	const gchar* _tmp20_;
	GValue _tmp21_;
	FolksPersona* _tmp22_;
	FolksPersona* _tmp23_;
	GError * _inner_error_;
};

struct _ContactsContactCreatePrimaryPersonaForDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPersonaStore* store;
	GHashTable* details;
	FolksPersona* result;
	FolksPersona* p;
	FolksPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	FolksPersona* _tmp2_;
	GError * _inner_error_;
};

struct _ContactsContactSetPersonaPropertyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FolksPersona* persona;
	gchar* property_name;
	GValue new_value;
	FolksPersona* _tmp0_;
	ContactsFakePersona* fake;
	FolksPersona* _tmp1_;
	ContactsFakePersona* _tmp2_;
	ContactsFakePersona* _tmp3_;
	const gchar* _tmp4_;
	GValue _tmp5_;
	FolksPersona* _tmp6_;
	FolksPersona* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GQuark _tmp11_;
	FolksPersona* _tmp12_;
	GValue _tmp13_;
	FolksPersona* _tmp14_;
	GValue _tmp15_;
	FolksPersona* _tmp16_;
	GValue _tmp17_;
	FolksPersona* _tmp18_;
	GValue _tmp19_;
	FolksPersona* _tmp20_;
	GValue _tmp21_;
	FolksPersona* _tmp22_;
	GValue _tmp23_;
	FolksPersona* _tmp24_;
	GValue _tmp25_;
	FolksPersona* _tmp26_;
	GValue _tmp27_;
	FolksPersona* _tmp28_;
	GValue _tmp29_;
	FolksPersona* _tmp30_;
	GValue _tmp31_;
	FolksPersona* _tmp32_;
	GValue _tmp33_;
	FolksPersona* _tmp34_;
	GValue _tmp35_;
	FolksPersona* _tmp36_;
	GValue _tmp37_;
	FolksPersona* _tmp38_;
	GValue _tmp39_;
	FolksPersona* _tmp40_;
	GValue _tmp41_;
	FolksPersona* _tmp42_;
	GValue _tmp43_;
	FolksPersona* _tmp44_;
	GValue _tmp45_;
	FolksPersona* _tmp46_;
	GValue _tmp47_;
	FolksPersona* _tmp48_;
	GValue _tmp49_;
	const gchar* _tmp50_;
	GError * _inner_error_;
};

struct _Block2Data {
	int _ref_count_;
	ContactsContact* self;
	gulong id;
	GtkWidget* w;
	GtkCallback callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
};

struct _ContactsFakePersonaStore {
	FolksPersonaStore parent_instance;
	ContactsFakePersonaStorePrivate * priv;
};

struct _ContactsFakePersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _ContactsFakePersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	gchar** _always_writeable_properties;
	gint _always_writeable_properties_length1;
	gint __always_writeable_properties_size_;
};

struct _ContactsFakePersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsFakePersonaStore* self;
};

struct _ContactsFakePersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsFakePersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
};

struct _ContactsFakePersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsFakePersonaStore* self;
	FolksPersona* persona;
};

struct _ContactsFakePersona {
	FolksPersona parent_instance;
	ContactsFakePersonaPrivate * priv;
	ContactsContact* contact;
};

struct _ContactsFakePersonaClass {
	FolksPersonaClass parent_class;
};

struct _ContactsFakePersonaPrivate {
	GeeArrayList* prop_vals;
	gboolean now_real;
	gboolean has_full_name;
};

struct _ContactsFakePersonaPropVal {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ContactsFakePersonaPropValPrivate * priv;
	gchar* property;
	GValue value;
};

struct _ContactsFakePersonaPropValClass {
	GTypeClass parent_class;
	void (*finalize) (ContactsFakePersonaPropVal *self);
};

struct _ContactsFakePersonaMakeRealAndSetData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsFakePersona* self;
	gchar* property;
	GValue value;
	FolksPersona* result;
	ContactsFakePersonaPropVal* v;
	ContactsFakePersonaPropVal* _tmp0_;
	ContactsFakePersonaPropVal* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	ContactsFakePersonaPropVal* _tmp4_;
	GValue _tmp5_;
	GValue _tmp6_;
	const gchar* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	ContactsFakePersonaPropVal* _tmp11_;
	FolksPersona* p;
	ContactsContact* _tmp12_;
	FolksPersona* _tmp13_;
	gboolean _tmp14_;
	FolksPersona* _tmp15_;
	ContactsContact* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	GeeArrayList* _pv_list;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	gint _pv_size;
	GeeArrayList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _pv_index;
	gint _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	ContactsFakePersonaPropVal* pv;
	GeeArrayList* _tmp27_;
	gint _tmp28_;
	gpointer _tmp29_;
	FolksPersona* _tmp30_;
	ContactsFakePersonaPropVal* _tmp31_;
	const gchar* _tmp32_;
	ContactsFakePersonaPropVal* _tmp33_;
	GValue _tmp34_;
	gboolean _tmp35_;
	GeeArrayList* _tmp36_;
	ContactsFakePersonaPropVal* _tmp37_;
	GError * _inner_error_;
};

struct _ContactsFakePersonaParamSpecPropVal {
	GParamSpec parent_instance;
};


static gpointer contacts_contact_parent_class = NULL;
static GdkPixbuf* contacts_contact_fallback_pixbuf_default;
static GdkPixbuf* contacts_contact_fallback_pixbuf_default = NULL;
extern gchar** contacts_contact_sorted_properties;
extern gint contacts_contact_sorted_properties_length1;
gchar** contacts_contact_sorted_properties = NULL;
gint contacts_contact_sorted_properties_length1 = 0;
static gpointer contacts_fake_persona_store_parent_class = NULL;
extern ContactsFakePersonaStore* contacts_fake_persona_store__the_store;
ContactsFakePersonaStore* contacts_fake_persona_store__the_store = NULL;
static gpointer contacts_fake_persona_parent_class = NULL;
static gpointer contacts_fake_persona_prop_val_parent_class = NULL;

GQuark contact_error_quark (void);
GType contacts_contact_get_type (void) G_GNUC_CONST;
GType contacts_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_CONTACT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_CONTACT, ContactsContactPrivate))
enum  {
	CONTACTS_CONTACT_DUMMY_PROPERTY,
	CONTACTS_CONTACT_SMALL_AVATAR,
	CONTACTS_CONTACT_AVATAR_ICON_DATA,
	CONTACTS_CONTACT_DISPLAY_NAME,
	CONTACTS_CONTACT_INITIAL_LETTER,
	CONTACTS_CONTACT_IS_HIDDEN
};
GType contacts_contact_im_display_get_type (void) G_GNUC_CONST;
#define CONTACTS_CONTACT_LIST_AVATAR_SIZE 48
#define CONTACTS_CONTACT_SMALL_AVATAR_SIZE 54
gboolean contacts_contact_persona_has_writable_property (FolksPersona* persona, const gchar* property);
GType contacts_fake_persona_get_type (void) G_GNUC_CONST;
gchar* contacts_contact_get_display_name_for_persona (FolksPersona* persona);
gboolean contacts_is_set (const gchar* str);
static gboolean _contacts_contact_get_is_hidden (ContactsContact* self);
void contacts_contact_hide (ContactsContact* self);
void contacts_contact_queue_changed (ContactsContact* self, gboolean is_persona_change);
void contacts_contact_show (ContactsContact* self);
ContactsContact* contacts_contact_from_individual (FolksIndividual* i);
static void contacts_contact_persona_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void contacts_contact_connect_persona (ContactsContact* self, FolksPersona* p);
static void _contacts_contact_persona_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void contacts_contact_disconnect_persona (ContactsContact* self, FolksPersona* p);
gboolean contacts_contact_persona_is_main (FolksPersona* persona);
gboolean contacts_contact_persona_is_google_other (FolksPersona* persona);
static gboolean contacts_contact_calc_is_main (ContactsContact* self);
ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i);
ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i);
static void __lambda16_ (ContactsContact* self, GeeSet* added, GeeSet* removed);
static void ___lambda16__folks_individual_personas_changed (FolksIndividual* _sender, GeeSet* added, GeeSet* removed, gpointer self);
static void contacts_contact_update (ContactsContact* self);
static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec);
static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void contacts_contact_replace_individual (ContactsContact* self, FolksIndividual* new_individual);
void contacts_contact_remove (ContactsContact* self);
static void contacts_contact_unqueue_changed (ContactsContact* self);
gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address);
gboolean contacts_contact_has_birthday (ContactsContact* self);
gboolean contacts_contact_has_nickname (ContactsContact* self);
gboolean contacts_contact_has_notes (ContactsContact* self);
GeeList* contacts_contact_get_personas_for_display (ContactsContact* self);
gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1);
static gboolean contacts_contact_has_pref (FolksAbstractFieldDetails* details);
gpointer contacts_utils_get_first (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* collection);
gint contacts_contact_compare_fields (void* _a, void* _b);
GeeArrayList* contacts_contact_sort_fields (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* fields);
static gint _contacts_contact_compare_fields_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void contacts_contact_geocode_address_data_free (gpointer _data);
void contacts_contact_geocode_address (FolksPostalAddress* addr, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeocodePlace* contacts_contact_geocode_address_finish (GAsyncResult* _res_);
static gboolean contacts_contact_geocode_address_co (ContactsContactGeocodeAddressData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _contacts_contact_geocode_address_co_gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static void __lambda17_ (Block1Data* _data1_, GObject* object, GAsyncResult* res);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void ___lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value);
TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address);
gchar* contacts_contact_format_im_service (const gchar* service, ContactsContactImDisplay* display);
static GType contacts_contact_im_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self);
static void contacts_contact_im_data_free (ContactsContactImData* self);
static gboolean contacts_contact_changed_cb (ContactsContact* self);
static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self);
static void contacts_contact_update_filter_data (ContactsContact* self);
gchar* contacts_utils_canonicalize_for_search (const gchar* str);
GType contacts_typeset_get_type (void) G_GNUC_CONST;
ContactsTypeSet* contacts_typeset_get_general (void);
void contacts_typeset_type_seen (ContactsTypeSet* self, FolksAbstractFieldDetails* detail);
ContactsTypeSet* contacts_typeset_get_phone (void);
static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GLoadableIcon* file, gint size);
GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon);
void contacts_utils_cairo_rounded_box (cairo_t* cr, gint x, gint y, gint width, gint height, gint radius);
GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size, ContactsContact* contact);
gboolean contacts_contact_can_remove_personas (ContactsContact* self);
static void contacts_contact_remove_personas_data_free (gpointer _data);
void contacts_contact_remove_personas (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_contact_remove_personas_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static gboolean contacts_contact_remove_personas_co (ContactsContactRemovePersonasData* _data_);
static void contacts_contact_remove_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void contacts_contact_ensure_primary_persona_data_free (gpointer _data);
void contacts_contact_ensure_primary_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_contact_ensure_primary_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error);
static gboolean contacts_contact_ensure_primary_persona_co (ContactsContactEnsurePrimaryPersonaData* _data_);
FolksPersona* contacts_contact_find_primary_persona (ContactsContact* self);
ContactsFakePersona* contacts_fake_persona_new (ContactsContact* contact);
ContactsFakePersona* contacts_fake_persona_construct (GType object_type, ContactsContact* contact);
FolksIndividualAggregator* contacts_store_get_aggregator (ContactsStore* self);
static void contacts_contact_ensure_primary_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksPersona* contacts_contact_find_persona_from_store (ContactsContact* self, FolksPersonaStore* store);
static gint __lambda4_ (ContactsContact* self, FolksPersona* a, FolksPersona* b);
static gboolean contacts_contact_persona_is_google (FolksPersona* persona);
static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
FolksPersona* contacts_contact_find_persona_from_uid (ContactsContact* self, const gchar* uid);
gchar* contacts_contact_format_persona_stores (ContactsContact* self);
gchar* contacts_contact_format_persona_store_name_for_contact (FolksPersona* persona);
gchar* contacts_contact_format_persona_store_name (FolksPersonaStore* store);
gboolean contacts_contact_has_mainable_persona (ContactsContact* self);
static gboolean contacts_contact_non_linkable (ContactsContact* self);
gboolean contacts_contact_persona_is_google_profile (FolksPersona* persona);
gboolean contacts_contact_suggest_link_to (ContactsContact* self, ContactsContact* other);
gboolean contacts_store_may_suggest_link (ContactsStore* self, ContactsContact* a, ContactsContact* b);
gchar** contacts_contact_sort_persona_properties (gchar** props, int props_length1, int* result_length1);
static gint __lambda18_ (const gchar* a, const gchar* b);
static gint ___lambda18__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void contacts_contact_set_individual_property_data_free (gpointer _data);
void contacts_contact_set_individual_property (ContactsContact* contact, const gchar* property_name, GValue* value, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_contact_set_individual_property_finish (GAsyncResult* _res_, GError** error);
static gboolean contacts_contact_set_individual_property_co (ContactsContactSetIndividualPropertyData* _data_);
static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle);
void contacts_contact_set_persona_property (FolksPersona* persona, const gchar* property_name, GValue* new_value, GAsyncReadyCallback _callback_, gpointer _user_data_);
void contacts_contact_set_persona_property_finish (GAsyncResult* _res_, GError** error);
static void contacts_contact_set_individual_property_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void contacts_fake_persona_make_real_and_set (ContactsFakePersona* self, const gchar* property, GValue* value, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_fake_persona_make_real_and_set_finish (ContactsFakePersona* self, GAsyncResult* _res_, GError** error);
TpAccount* contacts_contact_is_callable (ContactsContact* self, const gchar* proto, const gchar* id);
static void contacts_contact_create_primary_persona_for_details_data_free (gpointer _data);
void contacts_contact_create_primary_persona_for_details (FolksPersonaStore* store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* contacts_contact_create_primary_persona_for_details_finish (GAsyncResult* _res_, GError** error);
static gboolean contacts_contact_create_primary_persona_for_details_co (ContactsContactCreatePrimaryPersonaForDetailsData* _data_);
static void contacts_contact_create_primary_persona_for_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void contacts_contact_set_persona_property_data_free (gpointer _data);
static gboolean contacts_contact_set_persona_property_co (ContactsContactSetPersonaPropertyData* _data_);
static void contacts_contact_set_persona_property_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda19_ (Block2Data* _data2_);
static void ___lambda19__contacts_contact_changed (ContactsContact* _sender, gpointer self);
static void __lambda20_ (Block2Data* _data2_);
static void ___lambda20__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
void contacts_contact_fetch_contact_info (ContactsContact* self);
GdkPixbuf* contacts_contact_get_small_avatar (ContactsContact* self);
GVariant* contacts_contact_get_avatar_icon_data (ContactsContact* self);
const gchar* contacts_contact_get_display_name (ContactsContact* self);
gunichar contacts_contact_get_initial_letter (ContactsContact* self);
gboolean contacts_contact_get_is_hidden (ContactsContact* self);
static void contacts_contact_finalize (GObject * obj);
static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType contacts_fake_persona_store_get_type (void) G_GNUC_CONST;
#define CONTACTS_FAKE_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_FAKE_PERSONA_STORE, ContactsFakePersonaStorePrivate))
enum  {
	CONTACTS_FAKE_PERSONA_STORE_DUMMY_PROPERTY,
	CONTACTS_FAKE_PERSONA_STORE_TYPE_ID,
	CONTACTS_FAKE_PERSONA_STORE_PERSONAS,
	CONTACTS_FAKE_PERSONA_STORE_CAN_ADD_PERSONAS,
	CONTACTS_FAKE_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	CONTACTS_FAKE_PERSONA_STORE_CAN_GROUP_PERSONAS,
	CONTACTS_FAKE_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	CONTACTS_FAKE_PERSONA_STORE_IS_PREPARED,
	CONTACTS_FAKE_PERSONA_STORE_IS_QUIESCENT,
	CONTACTS_FAKE_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES
};
ContactsFakePersonaStore* contacts_fake_persona_store_the_store (void);
ContactsFakePersonaStore* contacts_fake_persona_store_new (void);
ContactsFakePersonaStore* contacts_fake_persona_store_construct (GType object_type);
static void contacts_fake_persona_store_real_prepare_data_free (gpointer _data);
static void contacts_fake_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean contacts_fake_persona_store_real_prepare_co (ContactsFakePersonaStorePrepareData* _data_);
static void contacts_fake_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void contacts_fake_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean contacts_fake_persona_store_real_add_persona_from_details_co (ContactsFakePersonaStoreAddPersonaFromDetailsData* _data_);
static void contacts_fake_persona_store_real_remove_persona_data_free (gpointer _data);
static void contacts_fake_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean contacts_fake_persona_store_real_remove_persona_co (ContactsFakePersonaStoreRemovePersonaData* _data_);
static void contacts_fake_persona_store_finalize (GObject * obj);
static void _vala_contacts_fake_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static gpointer contacts_fake_persona_prop_val_ref (gpointer instance);
static void contacts_fake_persona_prop_val_unref (gpointer instance);
static GParamSpec* contacts_fake_persona_param_spec_prop_val (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void contacts_fake_persona_value_set_prop_val (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void contacts_fake_persona_value_take_prop_val (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer contacts_fake_persona_value_get_prop_val (const GValue* value) G_GNUC_UNUSED;
static GType contacts_fake_persona_prop_val_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define CONTACTS_FAKE_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_FAKE_PERSONA, ContactsFakePersonaPrivate))
enum  {
	CONTACTS_FAKE_PERSONA_DUMMY_PROPERTY,
	CONTACTS_FAKE_PERSONA_LINKABLE_PROPERTIES,
	CONTACTS_FAKE_PERSONA_WRITEABLE_PROPERTIES
};
ContactsFakePersona* contacts_fake_persona_maybe_create_for (ContactsContact* contact);
static void contacts_fake_persona_make_real_and_set_data_free (gpointer _data);
static gboolean contacts_fake_persona_make_real_and_set_co (ContactsFakePersonaMakeRealAndSetData* _data_);
static ContactsFakePersonaPropVal* contacts_fake_persona_prop_val_new (void);
static ContactsFakePersonaPropVal* contacts_fake_persona_prop_val_construct (GType object_type);
static void contacts_fake_persona_make_real_and_set_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
enum  {
	CONTACTS_FAKE_PERSONA_PROP_VAL_DUMMY_PROPERTY
};
static void contacts_fake_persona_prop_val_finalize (ContactsFakePersonaPropVal * obj);
static void contacts_fake_persona_finalize (GObject * obj);
static void _vala_contacts_fake_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static GRegex* _tmp_regex_0 = NULL;
static const gchar* CONTACTS_FAKE_PERSONA__linkable_properties[0] = {};
static const gchar* CONTACTS_FAKE_PERSONA__writeable_properties[0] = {};

GQuark contact_error_quark (void) {
	return g_quark_from_static_string ("contact_error-quark");
}


GType contacts_contact_im_display_get_type (void) {
	static volatile gsize contacts_contact_im_display_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_display_type_id__volatile)) {
		static const GEnumValue values[] = {{CONTACTS_CONTACT_IM_DISPLAY_DEFAULT, "CONTACTS_CONTACT_IM_DISPLAY_DEFAULT", "default"}, {CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE, "CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE", "alias-service"}, {0, NULL, NULL}};
		GType contacts_contact_im_display_type_id;
		contacts_contact_im_display_type_id = g_enum_register_static ("ContactsContactImDisplay", values);
		g_once_init_leave (&contacts_contact_im_display_type_id__volatile, contacts_contact_im_display_type_id);
	}
	return contacts_contact_im_display_type_id__volatile;
}


gboolean contacts_contact_persona_has_writable_property (FolksPersona* persona, const gchar* property) {
	gboolean result = FALSE;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (persona != NULL, FALSE);
	g_return_val_if_fail (property != NULL, FALSE);
	_tmp0_ = persona;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, CONTACTS_TYPE_FAKE_PERSONA)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = persona;
	_tmp2_ = folks_persona_get_writeable_properties (_tmp1_, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp3_;
		p_collection_length1 = _tmp3__length1;
		for (p_it = 0; p_it < _tmp3__length1; p_it = p_it + 1) {
			const gchar* p = NULL;
			p = p_collection[p_it];
			{
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				_tmp4_ = p;
				_tmp5_ = property;
				if (g_strcmp0 (_tmp4_, _tmp5_) == 0) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* contacts_contact_get_display_name_for_persona (FolksPersona* persona) {
	gchar* result = NULL;
	FolksNameDetails* name_details = NULL;
	FolksPersona* _tmp0_;
	FolksNameDetails* _tmp1_;
	FolksAliasDetails* alias_details = NULL;
	FolksPersona* _tmp2_;
	FolksAliasDetails* _tmp3_;
	FolksEmailDetails* email_details = NULL;
	FolksPersona* _tmp4_;
	FolksEmailDetails* _tmp5_;
	FolksNameDetails* _tmp6_;
	FolksAliasDetails* _tmp14_;
	FolksNameDetails* _tmp22_;
	FolksEmailDetails* _tmp30_;
	gchar* _tmp45_;
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _tmp0_) : NULL);
	name_details = _tmp1_;
	_tmp2_ = persona;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, FOLKS_TYPE_ALIAS_DETAILS) ? ((FolksAliasDetails*) _tmp2_) : NULL);
	alias_details = _tmp3_;
	_tmp4_ = persona;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _tmp4_) : NULL);
	email_details = _tmp5_;
	_tmp6_ = name_details;
	if (_tmp6_ != NULL) {
		const gchar* name = NULL;
		FolksNameDetails* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp7_ = name_details;
		_tmp8_ = folks_name_details_get_full_name (_tmp7_);
		_tmp9_ = _tmp8_;
		name = _tmp9_;
		_tmp10_ = name;
		_tmp11_ = contacts_is_set (_tmp10_);
		if (_tmp11_) {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			_g_object_unref0 (email_details);
			_g_object_unref0 (alias_details);
			_g_object_unref0 (name_details);
			return result;
		}
	}
	_tmp14_ = alias_details;
	if (_tmp14_ != NULL) {
		const gchar* alias = NULL;
		FolksAliasDetails* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean _tmp19_;
		_tmp15_ = alias_details;
		_tmp16_ = folks_alias_details_get_alias (_tmp15_);
		_tmp17_ = _tmp16_;
		alias = _tmp17_;
		_tmp18_ = alias;
		_tmp19_ = contacts_is_set (_tmp18_);
		if (_tmp19_) {
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp20_ = alias;
			_tmp21_ = g_strdup (_tmp20_);
			result = _tmp21_;
			_g_object_unref0 (email_details);
			_g_object_unref0 (alias_details);
			_g_object_unref0 (name_details);
			return result;
		}
	}
	_tmp22_ = name_details;
	if (_tmp22_ != NULL) {
		const gchar* nickname = NULL;
		FolksNameDetails* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gboolean _tmp27_;
		_tmp23_ = name_details;
		_tmp24_ = folks_name_details_get_nickname (_tmp23_);
		_tmp25_ = _tmp24_;
		nickname = _tmp25_;
		_tmp26_ = nickname;
		_tmp27_ = contacts_is_set (_tmp26_);
		if (_tmp27_) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = nickname;
			_tmp29_ = g_strdup (_tmp28_);
			result = _tmp29_;
			_g_object_unref0 (email_details);
			_g_object_unref0 (alias_details);
			_g_object_unref0 (name_details);
			return result;
		}
	}
	_tmp30_ = email_details;
	if (_tmp30_ != NULL) {
		{
			GeeIterator* _email_it = NULL;
			FolksEmailDetails* _tmp31_;
			GeeSet* _tmp32_;
			GeeSet* _tmp33_;
			GeeIterator* _tmp34_;
			_tmp31_ = email_details;
			_tmp32_ = folks_email_details_get_email_addresses (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = gee_iterable_iterator ((GeeIterable*) _tmp33_);
			_email_it = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_;
				gboolean _tmp36_;
				FolksEmailFieldDetails* email = NULL;
				GeeIterator* _tmp37_;
				gpointer _tmp38_;
				gchar* e = NULL;
				FolksEmailFieldDetails* _tmp39_;
				gconstpointer _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				const gchar* _tmp43_;
				gboolean _tmp44_;
				_tmp35_ = _email_it;
				_tmp36_ = gee_iterator_next (_tmp35_);
				if (!_tmp36_) {
					break;
				}
				_tmp37_ = _email_it;
				_tmp38_ = gee_iterator_get (_tmp37_);
				email = (FolksEmailFieldDetails*) _tmp38_;
				_tmp39_ = email;
				_tmp40_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup ((const gchar*) _tmp41_);
				e = _tmp42_;
				_tmp43_ = e;
				_tmp44_ = contacts_is_set (_tmp43_);
				if (_tmp44_) {
					result = e;
					_g_object_unref0 (email);
					_g_object_unref0 (_email_it);
					_g_object_unref0 (email_details);
					_g_object_unref0 (alias_details);
					_g_object_unref0 (name_details);
					return result;
				}
				_g_free0 (e);
				_g_object_unref0 (email);
			}
			_g_object_unref0 (_email_it);
		}
	}
	_tmp45_ = g_strdup ("");
	result = _tmp45_;
	_g_object_unref0 (email_details);
	_g_object_unref0 (alias_details);
	_g_object_unref0 (name_details);
	return result;
}


static gboolean _contacts_contact_get_is_hidden (ContactsContact* self) {
	gboolean result = FALSE;
	FolksIndividual* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GeeSet* personas = NULL;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeIterator* i = NULL;
	GeeSet* _tmp8_;
	GeeIterator* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GeeIterator* _tmp11_;
	gboolean _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->individual;
	_tmp1_ = folks_individual_get_is_user (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->_is_hidden_to_delete;
	if (_tmp3_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = self->individual;
	_tmp5_ = folks_individual_get_personas (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	personas = _tmp7_;
	_tmp8_ = personas;
	_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
	i = _tmp9_;
	_tmp11_ = i;
	_tmp12_ = gee_iterator_next (_tmp11_);
	if (_tmp12_) {
		GeeIterator* _tmp13_;
		gboolean _tmp14_;
		_tmp13_ = i;
		_tmp14_ = gee_iterator_has_next (_tmp13_);
		_tmp10_ = !_tmp14_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		FolksPersona* persona = NULL;
		GeeIterator* _tmp15_;
		gpointer _tmp16_;
		FolksPersonaStore* store = NULL;
		FolksPersona* _tmp17_;
		FolksPersonaStore* _tmp18_;
		FolksPersonaStore* _tmp19_;
		FolksPersonaStore* _tmp20_;
		FolksPersonaStore* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gboolean _tmp24_ = FALSE;
		FolksPersonaStore* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		_tmp15_ = i;
		_tmp16_ = gee_iterator_get (_tmp15_);
		persona = (FolksPersona*) _tmp16_;
		_tmp17_ = persona;
		_tmp18_ = folks_persona_get_store (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		store = _tmp20_;
		_tmp21_ = store;
		_tmp22_ = folks_persona_store_get_type_id (_tmp21_);
		_tmp23_ = _tmp22_;
		if (g_strcmp0 (_tmp23_, "key-file") == 0) {
			result = TRUE;
			_g_object_unref0 (store);
			_g_object_unref0 (persona);
			_g_object_unref0 (i);
			_g_object_unref0 (personas);
			return result;
		}
		_tmp25_ = store;
		_tmp26_ = folks_persona_store_get_type_id (_tmp25_);
		_tmp27_ = _tmp26_;
		if (g_strcmp0 (_tmp27_, "telepathy") == 0) {
			FolksPersonaStore* _tmp28_;
			FolksPersonaStoreTrust _tmp29_;
			FolksPersonaStoreTrust _tmp30_;
			_tmp28_ = store;
			_tmp29_ = folks_persona_store_get_trust_level (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp24_ = _tmp30_ == FOLKS_PERSONA_STORE_TRUST_NONE;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			result = TRUE;
			_g_object_unref0 (store);
			_g_object_unref0 (persona);
			_g_object_unref0 (i);
			_g_object_unref0 (personas);
			return result;
		}
		_g_object_unref0 (store);
		_g_object_unref0 (persona);
	}
	result = FALSE;
	_g_object_unref0 (i);
	_g_object_unref0 (personas);
	return result;
}


void contacts_contact_hide (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	self->priv->_is_hidden_to_delete = TRUE;
	contacts_contact_queue_changed (self, FALSE);
}


void contacts_contact_show (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	self->priv->_is_hidden_to_delete = FALSE;
	contacts_contact_queue_changed (self, FALSE);
}


ContactsContact* contacts_contact_from_individual (FolksIndividual* i) {
	ContactsContact* result = NULL;
	FolksIndividual* _tmp0_;
	gconstpointer _tmp1_;
	ContactsContact* _tmp2_;
	g_return_val_if_fail (i != NULL, NULL);
	_tmp0_ = i;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "contact");
	_tmp2_ = _g_object_ref0 ((ContactsContact*) _tmp1_);
	result = _tmp2_;
	return result;
}


static void contacts_contact_persona_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	contacts_contact_queue_changed (self, FALSE);
}


static void _contacts_contact_persona_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_persona_notify_cb ((ContactsContact*) self, pspec);
}


static void contacts_contact_connect_persona (ContactsContact* self, FolksPersona* p) {
	TpfPersona* tp = NULL;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	gboolean _tmp2_ = FALSE;
	TpfPersona* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = p;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TPF_TYPE_PERSONA) ? ((TpfPersona*) _tmp0_) : NULL);
	tp = _tmp1_;
	_tmp3_ = tp;
	if (_tmp3_ != NULL) {
		TpfPersona* _tmp4_;
		TpContact* _tmp5_;
		TpContact* _tmp6_;
		_tmp4_ = tp;
		_tmp5_ = tpf_persona_get_contact (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		TpfPersona* _tmp7_;
		TpContact* _tmp8_;
		TpContact* _tmp9_;
		_tmp7_ = tp;
		_tmp8_ = tpf_persona_get_contact (_tmp7_);
		_tmp9_ = _tmp8_;
		g_signal_connect_object ((GObject*) _tmp9_, "notify::client-types", (GCallback) _contacts_contact_persona_notify_cb_g_object_notify, self, 0);
	}
	_g_object_unref0 (tp);
}


static void contacts_contact_disconnect_persona (ContactsContact* self, FolksPersona* p) {
	FolksIndividual* _tmp0_;
	TpfPersona* tp = NULL;
	FolksPersona* _tmp1_;
	TpfPersona* _tmp2_;
	gboolean _tmp3_ = FALSE;
	TpfPersona* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->individual;
	g_signal_handlers_disconnect_by_func (_tmp0_, (void*) contacts_contact_persona_notify_cb, self);
	_tmp1_ = p;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TPF_TYPE_PERSONA) ? ((TpfPersona*) _tmp1_) : NULL);
	tp = _tmp2_;
	_tmp4_ = tp;
	if (_tmp4_ != NULL) {
		TpfPersona* _tmp5_;
		TpContact* _tmp6_;
		TpContact* _tmp7_;
		_tmp5_ = tp;
		_tmp6_ = tpf_persona_get_contact (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		TpfPersona* _tmp8_;
		TpContact* _tmp9_;
		TpContact* _tmp10_;
		_tmp8_ = tp;
		_tmp9_ = tpf_persona_get_contact (_tmp8_);
		_tmp10_ = _tmp9_;
		g_signal_handlers_disconnect_by_func (_tmp10_, (void*) contacts_contact_persona_notify_cb, self);
	}
	_g_object_unref0 (tp);
}


gboolean contacts_contact_persona_is_main (FolksPersona* persona) {
	gboolean result = FALSE;
	FolksPersonaStore* store = NULL;
	FolksPersona* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FolksPersona* _tmp7_;
	gboolean _tmp8_;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_store (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	store = _tmp3_;
	_tmp4_ = store;
	_tmp5_ = folks_persona_store_get_is_primary_store (_tmp4_);
	_tmp6_ = _tmp5_;
	if (!_tmp6_) {
		result = FALSE;
		_g_object_unref0 (store);
		return result;
	}
	_tmp7_ = persona;
	_tmp8_ = contacts_contact_persona_is_google_other (_tmp7_);
	if (_tmp8_) {
		result = FALSE;
		_g_object_unref0 (store);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (store);
	return result;
}


static gboolean contacts_contact_calc_is_main (ContactsContact* self) {
	gboolean result = FALSE;
	gboolean res = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	res = FALSE;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			gboolean _tmp9_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = contacts_contact_persona_is_main (_tmp8_);
			if (_tmp9_) {
				res = TRUE;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = res;
	return result;
}


static void __lambda16_ (ContactsContact* self, GeeSet* added, GeeSet* removed) {
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = added;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_p_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp4_;
			gpointer _tmp5_;
			FolksPersona* _tmp6_;
			_tmp2_ = _p_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			p = (FolksPersona*) _tmp5_;
			_tmp6_ = p;
			contacts_contact_connect_persona (self, _tmp6_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	{
		GeeIterator* _p_it = NULL;
		GeeSet* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp7_ = removed;
		_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
		_p_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			gboolean _tmp10_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp11_;
			gpointer _tmp12_;
			FolksPersona* _tmp13_;
			_tmp9_ = _p_it;
			_tmp10_ = gee_iterator_next (_tmp9_);
			if (!_tmp10_) {
				break;
			}
			_tmp11_ = _p_it;
			_tmp12_ = gee_iterator_get (_tmp11_);
			p = (FolksPersona*) _tmp12_;
			_tmp13_ = p;
			contacts_contact_disconnect_persona (self, _tmp13_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	contacts_contact_queue_changed (self, TRUE);
}


static void ___lambda16__folks_individual_personas_changed (FolksIndividual* _sender, GeeSet* added, GeeSet* removed, gpointer self) {
	__lambda16_ ((ContactsContact*) self, added, removed);
}


static void _contacts_contact_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	contacts_contact_notify_cb ((ContactsContact*) self, pspec);
}


ContactsContact* contacts_contact_construct (GType object_type, ContactsStore* store, FolksIndividual* i) {
	ContactsContact * self = NULL;
	ContactsStore* _tmp0_;
	ContactsStore* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	FolksIndividual* _tmp4_;
	ContactsContact* _tmp5_;
	gboolean _tmp6_;
	FolksIndividual* _tmp16_;
	FolksIndividual* _tmp17_;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (ContactsContact*) g_object_new (object_type, NULL);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->store);
	self->store = _tmp1_;
	_tmp2_ = i;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->individual);
	self->individual = _tmp3_;
	_tmp4_ = self->individual;
	_tmp5_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) _tmp4_, "contact", _tmp5_, g_object_unref);
	_tmp6_ = contacts_contact_calc_is_main (self);
	self->is_main = _tmp6_;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp7_ = self->individual;
		_tmp8_ = folks_individual_get_personas (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_iterable_iterator ((GeeIterable*) _tmp9_);
		_p_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			gboolean _tmp12_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			FolksPersona* _tmp15_;
			_tmp11_ = _p_it;
			_tmp12_ = gee_iterator_next (_tmp11_);
			if (!_tmp12_) {
				break;
			}
			_tmp13_ = _p_it;
			_tmp14_ = gee_iterator_get (_tmp13_);
			p = (FolksPersona*) _tmp14_;
			_tmp15_ = p;
			contacts_contact_connect_persona (self, _tmp15_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp16_ = self->individual;
	g_signal_connect_object (_tmp16_, "personas-changed", (GCallback) ___lambda16__folks_individual_personas_changed, self, 0);
	contacts_contact_update (self);
	_tmp17_ = self->individual;
	g_signal_connect_object ((GObject*) _tmp17_, "notify", (GCallback) _contacts_contact_notify_cb_g_object_notify, self, 0);
	return self;
}


ContactsContact* contacts_contact_new (ContactsStore* store, FolksIndividual* i) {
	return contacts_contact_construct (CONTACTS_TYPE_CONTACT, store, i);
}


void contacts_contact_replace_individual (ContactsContact* self, FolksIndividual* new_individual) {
	FolksIndividual* _tmp9_;
	guint _tmp10_;
	FolksIndividual* _tmp11_;
	FolksIndividual* _tmp12_;
	FolksIndividual* _tmp13_;
	ContactsContact* _tmp14_;
	FolksIndividual* _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_individual != NULL);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			contacts_contact_disconnect_persona (self, _tmp8_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp9_ = self->individual;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _contacts_contact_notify_cb_g_object_notify, self);
	_tmp11_ = new_individual;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->individual);
	self->individual = _tmp12_;
	_tmp13_ = self->individual;
	_tmp14_ = _g_object_ref0 (self);
	g_object_set_data_full ((GObject*) _tmp13_, "contact", _tmp14_, g_object_unref);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_;
		_tmp15_ = self->individual;
		_tmp16_ = folks_individual_get_personas (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_p_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			gboolean _tmp20_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp21_;
			gpointer _tmp22_;
			FolksPersona* _tmp23_;
			_tmp19_ = _p_it;
			_tmp20_ = gee_iterator_next (_tmp19_);
			if (!_tmp20_) {
				break;
			}
			_tmp21_ = _p_it;
			_tmp22_ = gee_iterator_get (_tmp21_);
			p = (FolksPersona*) _tmp22_;
			_tmp23_ = p;
			contacts_contact_connect_persona (self, _tmp23_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_g_object_unref0 (self->priv->_small_avatar);
	self->priv->_small_avatar = NULL;
	_g_variant_unref0 (self->priv->_avatar_icon_data);
	self->priv->_avatar_icon_data = NULL;
	_tmp24_ = self->individual;
	g_signal_connect_object ((GObject*) _tmp24_, "notify", (GCallback) _contacts_contact_notify_cb_g_object_notify, self, 0);
	contacts_contact_queue_changed (self, TRUE);
}


void contacts_contact_remove (ContactsContact* self) {
	FolksIndividual* _tmp9_;
	guint _tmp10_;
	g_return_if_fail (self != NULL);
	contacts_contact_unqueue_changed (self);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			contacts_contact_disconnect_persona (self, _tmp8_);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp9_ = self->individual;
	g_signal_parse_name ("notify", G_TYPE_OBJECT, &_tmp10_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _contacts_contact_notify_cb_g_object_notify, self);
}


gboolean contacts_contact_has_email (ContactsContact* self, const gchar* email_address) {
	gboolean result = FALSE;
	GeeSet* addrs = NULL;
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (email_address != NULL, FALSE);
	_tmp0_ = self->individual;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	addrs = _tmp3_;
	{
		GeeIterator* _detail_it = NULL;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp4_ = addrs;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_detail_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_;
			FolksEmailFieldDetails* detail = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			FolksEmailFieldDetails* _tmp10_;
			gconstpointer _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = _detail_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _detail_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			detail = (FolksEmailFieldDetails*) _tmp9_;
			_tmp10_ = detail;
			_tmp11_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = email_address;
			if (g_strcmp0 ((const gchar*) _tmp12_, _tmp13_) == 0) {
				result = TRUE;
				_g_object_unref0 (detail);
				_g_object_unref0 (_detail_it);
				_g_object_unref0 (addrs);
				return result;
			}
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	result = FALSE;
	_g_object_unref0 (addrs);
	return result;
}


gboolean contacts_contact_has_birthday (ContactsContact* self) {
	gboolean result = FALSE;
	FolksIndividual* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->individual;
	_tmp1_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != NULL;
	return result;
}


gboolean contacts_contact_has_nickname (ContactsContact* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->individual;
	_tmp2_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		FolksIndividual* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->individual;
		_tmp5_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = g_strcmp0 (_tmp6_, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean contacts_contact_has_notes (ContactsContact* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeList* _p_list = NULL;
		GeeList* _tmp0_;
		gint _p_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = contacts_contact_get_personas_for_display (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			FolksPersona* p = NULL;
			GeeList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			FolksNoteDetails* note_details = NULL;
			FolksPersona* _tmp10_;
			FolksNoteDetails* _tmp11_;
			FolksNoteDetails* _tmp12_;
			_tmp4_ = _p_index;
			_p_index = _tmp4_ + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = _p_index;
			_tmp9_ = gee_list_get (_tmp7_, _tmp8_);
			p = (FolksPersona*) _tmp9_;
			_tmp10_ = p;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _tmp10_) : NULL);
			note_details = _tmp11_;
			_tmp12_ = note_details;
			if (_tmp12_ != NULL) {
				{
					GeeIterator* _note_it = NULL;
					FolksNoteDetails* _tmp13_;
					GeeSet* _tmp14_;
					GeeSet* _tmp15_;
					GeeIterator* _tmp16_;
					_tmp13_ = note_details;
					_tmp14_ = folks_note_details_get_notes (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
					_note_it = _tmp16_;
					while (TRUE) {
						GeeIterator* _tmp17_;
						gboolean _tmp18_;
						FolksNoteFieldDetails* note = NULL;
						GeeIterator* _tmp19_;
						gpointer _tmp20_;
						FolksNoteFieldDetails* _tmp21_;
						gconstpointer _tmp22_;
						const gchar* _tmp23_;
						_tmp17_ = _note_it;
						_tmp18_ = gee_iterator_next (_tmp17_);
						if (!_tmp18_) {
							break;
						}
						_tmp19_ = _note_it;
						_tmp20_ = gee_iterator_get (_tmp19_);
						note = (FolksNoteFieldDetails*) _tmp20_;
						_tmp21_ = note;
						_tmp22_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp21_);
						_tmp23_ = _tmp22_;
						if (g_strcmp0 ((const gchar*) _tmp23_, "") != 0) {
							result = TRUE;
							_g_object_unref0 (note);
							_g_object_unref0 (_note_it);
							_g_object_unref0 (note_details);
							_g_object_unref0 (p);
							_g_object_unref0 (_p_list);
							return result;
						}
						_g_object_unref0 (note);
					}
					_g_object_unref0 (_note_it);
				}
			}
			_g_object_unref0 (note_details);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_list);
	}
	result = FALSE;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


gboolean contacts_contact_contains_strings (ContactsContact* self, gchar** strings, int strings_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = strings;
	_tmp0__length1 = strings_length1;
	{
		gchar** i_collection = NULL;
		gint i_collection_length1 = 0;
		gint _i_collection_size_ = 0;
		gint i_it = 0;
		i_collection = _tmp0_;
		i_collection_length1 = _tmp0__length1;
		for (i_it = 0; i_it < _tmp0__length1; i_it = i_it + 1) {
			gchar* _tmp1_;
			gchar* i = NULL;
			_tmp1_ = g_strdup (i_collection[i_it]);
			i = _tmp1_;
			{
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp2_ = self->priv->filter_data;
				_tmp3_ = i;
				_tmp4_ = string_contains (_tmp2_, _tmp3_);
				if (!_tmp4_) {
					result = FALSE;
					_g_free0 (i);
					return result;
				}
				_g_free0 (i);
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean contacts_contact_has_pref (FolksAbstractFieldDetails* details) {
	gboolean result = FALSE;
	GeeCollection* evolution_pref = NULL;
	FolksAbstractFieldDetails* _tmp0_;
	GeeCollection* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GeeCollection* _tmp3_;
	g_return_val_if_fail (details != NULL, FALSE);
	_tmp0_ = details;
	_tmp1_ = folks_abstract_field_details_get_parameter_values (_tmp0_, "x-evolution-ui-slot");
	evolution_pref = _tmp1_;
	_tmp3_ = evolution_pref;
	if (_tmp3_ != NULL) {
		GeeCollection* _tmp4_;
		gpointer _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = evolution_pref;
		_tmp5_ = contacts_utils_get_first (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp4_);
		_tmp6_ = (gchar*) _tmp5_;
		_tmp2_ = g_strcmp0 (_tmp6_, "1") == 0;
		_g_free0 (_tmp6_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_object_unref0 (evolution_pref);
		return result;
	}
	{
		GeeIterator* _param_it = NULL;
		FolksAbstractFieldDetails* _tmp7_;
		GeeMultiMap* _tmp8_;
		GeeMultiMap* _tmp9_;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp7_ = details;
		_tmp8_ = folks_abstract_field_details_get_parameters (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = gee_multi_map_get (_tmp9_, "type");
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator ((GeeIterable*) _tmp11_);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_param_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			gboolean _tmp15_;
			gchar* param = NULL;
			GeeIterator* _tmp16_;
			gpointer _tmp17_;
			const gchar* _tmp18_;
			gint _tmp19_;
			_tmp14_ = _param_it;
			_tmp15_ = gee_iterator_next (_tmp14_);
			if (!_tmp15_) {
				break;
			}
			_tmp16_ = _param_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			param = (gchar*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = g_ascii_strcasecmp (_tmp18_, "PREF");
			if (_tmp19_ == 0) {
				result = TRUE;
				_g_free0 (param);
				_g_object_unref0 (_param_it);
				_g_object_unref0 (evolution_pref);
				return result;
			}
			_g_free0 (param);
		}
		_g_object_unref0 (_param_it);
	}
	result = FALSE;
	_g_object_unref0 (evolution_pref);
	return result;
}


gint contacts_contact_compare_fields (void* _a, void* _b) {
	gint result = 0;
	FolksAbstractFieldDetails* a = NULL;
	void* _tmp0_;
	FolksAbstractFieldDetails* b = NULL;
	void* _tmp1_;
	gboolean first_a = FALSE;
	FolksAbstractFieldDetails* _tmp2_;
	gboolean _tmp3_;
	gboolean first_b = FALSE;
	FolksAbstractFieldDetails* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp9_ = FALSE;
	FolksAbstractFieldDetails* _tmp10_;
	_tmp0_ = _a;
	a = (FolksAbstractFieldDetails*) _tmp0_;
	_tmp1_ = _b;
	b = (FolksAbstractFieldDetails*) _tmp1_;
	_tmp2_ = a;
	_tmp3_ = contacts_contact_has_pref (_tmp2_);
	first_a = _tmp3_;
	_tmp4_ = b;
	_tmp5_ = contacts_contact_has_pref (_tmp4_);
	first_b = _tmp5_;
	_tmp6_ = first_a;
	_tmp7_ = first_b;
	if (_tmp6_ != _tmp7_) {
		gboolean _tmp8_;
		_tmp8_ = first_a;
		if (_tmp8_) {
			result = -1;
			return result;
		} else {
			result = 1;
			return result;
		}
	}
	_tmp10_ = a;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, FOLKS_TYPE_EMAIL_FIELD_DETAILS)) {
		_tmp9_ = TRUE;
	} else {
		FolksAbstractFieldDetails* _tmp11_;
		_tmp11_ = a;
		_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, FOLKS_TYPE_PHONE_FIELD_DETAILS);
	}
	if (_tmp9_) {
		FolksAbstractFieldDetails* aa = NULL;
		FolksAbstractFieldDetails* _tmp12_;
		FolksAbstractFieldDetails* _tmp13_;
		FolksAbstractFieldDetails* bb = NULL;
		FolksAbstractFieldDetails* _tmp14_;
		FolksAbstractFieldDetails* _tmp15_;
		GCompareFunc _tmp16_;
		FolksAbstractFieldDetails* _tmp17_;
		gconstpointer _tmp18_;
		const gchar* _tmp19_;
		FolksAbstractFieldDetails* _tmp20_;
		gconstpointer _tmp21_;
		const gchar* _tmp22_;
		gint _tmp23_;
		_tmp12_ = a;
		_tmp13_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS) ? ((FolksAbstractFieldDetails*) _tmp12_) : NULL);
		aa = _tmp13_;
		_tmp14_ = b;
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS) ? ((FolksAbstractFieldDetails*) _tmp14_) : NULL);
		bb = _tmp15_;
		_tmp16_ = g_strcmp0;
		_tmp17_ = aa;
		_tmp18_ = folks_abstract_field_details_get_value (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = bb;
		_tmp21_ = folks_abstract_field_details_get_value (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp16_ ((const gchar*) _tmp19_, (const gchar*) _tmp22_);
		result = _tmp23_;
		_g_object_unref0 (bb);
		_g_object_unref0 (aa);
		return result;
	}
	g_warning ("contacts-contact.vala:368: Unsupported AbstractFieldDetails value type");
	result = 0;
	return result;
}


static gint _contacts_contact_compare_fields_gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = contacts_contact_compare_fields (a, b);
	return result;
}


GeeArrayList* contacts_contact_sort_fields (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GeeCollection* fields) {
	GeeArrayList* result = NULL;
	GeeArrayList* res = NULL;
	GeeArrayList* _tmp0_;
	GeeCollection* _tmp1_;
	g_return_val_if_fail (fields != NULL, NULL);
	_tmp0_ = gee_array_list_new (t_type, (GBoxedCopyFunc) t_dup_func, (GDestroyNotify) t_destroy_func, NULL, NULL, NULL);
	res = _tmp0_;
	_tmp1_ = fields;
	gee_array_list_add_all (res, _tmp1_);
	gee_list_sort ((GeeList*) res, _contacts_contact_compare_fields_gcompare_data_func, NULL, NULL);
	result = res;
	return result;
}


static void contacts_contact_geocode_address_data_free (gpointer _data) {
	ContactsContactGeocodeAddressData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->addr);
	_g_object_unref0 (_data_->result);
	g_slice_free (ContactsContactGeocodeAddressData, _data_);
}


void contacts_contact_geocode_address (FolksPostalAddress* addr, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactGeocodeAddressData* _data_;
	FolksPostalAddress* _tmp0_;
	FolksPostalAddress* _tmp1_;
	_data_ = g_slice_new0 (ContactsContactGeocodeAddressData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_geocode_address_data_free);
	_tmp0_ = addr;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->addr);
	_data_->addr = _tmp1_;
	contacts_contact_geocode_address_co (_data_);
}


GeocodePlace* contacts_contact_geocode_address_finish (GAsyncResult* _res_) {
	GeocodePlace* result;
	ContactsContactGeocodeAddressData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->forward);
		_g_object_unref0 (_data1_->place);
		(_data1_->callback_target_destroy_notify == NULL) ? NULL : (_data1_->callback_target_destroy_notify (_data1_->callback_target), NULL);
		_data1_->callback = NULL;
		_data1_->callback_target = NULL;
		_data1_->callback_target_destroy_notify = NULL;
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _contacts_contact_geocode_address_co_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_contact_geocode_address_co (self);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void __lambda17_ (Block1Data* _data1_, GObject* object, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GList* places = NULL;
		GAsyncResult* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		GeocodePlace* _tmp3_;
		GSourceFunc _tmp4_;
		void* _tmp4__target;
		_tmp0_ = res;
		_tmp1_ = geocode_forward_search_finish (_data1_->forward, _tmp0_, &_inner_error_);
		places = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_list_nth_data (places, (guint) 0);
		_tmp3_ = _g_object_ref0 ((GeocodePlace*) _tmp2_);
		_g_object_unref0 (_data1_->place);
		_data1_->place = _tmp3_;
		_tmp4_ = _data1_->callback;
		_tmp4__target = _data1_->callback_target;
		_tmp4_ (_tmp4__target);
		__g_list_free__g_object_unref0_0 (places);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GSourceFunc _tmp5_;
		void* _tmp5__target;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("contacts-contact.vala:405: No geocode result found for contact");
		_tmp5_ = _data1_->callback;
		_tmp5__target = _data1_->callback_target;
		_tmp5_ (_tmp5__target);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda17__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda17_ (self, source_object, res);
	block1_data_unref (self);
}


static gboolean contacts_contact_geocode_address_co (ContactsContactGeocodeAddressData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->callback = _contacts_contact_geocode_address_co_gsource_func;
	_data_->_data1_->callback_target = _data_;
	_data_->_data1_->callback_target_destroy_notify = NULL;
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, __vala_GValue_free0_);
	_data_->params = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->addr;
	_data_->_tmp4_ = folks_postal_address_get_street (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = contacts_is_set (_data_->_tmp5_);
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->params;
		_data_->_tmp8_ = g_strdup ("street");
		_data_->_tmp9_ = _data_->addr;
		_data_->_tmp10_ = folks_postal_address_get_street (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->_tmp10_;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = g_new0 (GValue, 1);
		g_value_init (_data_->_tmp12_, G_TYPE_STRING);
		g_value_set_string (_data_->_tmp12_, _data_->_tmp11_);
		g_hash_table_insert (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp12_);
	}
	_data_->_tmp13_ = _data_->addr;
	_data_->_tmp14_ = folks_postal_address_get_locality (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = contacts_is_set (_data_->_tmp15_);
	if (_data_->_tmp16_) {
		_data_->_tmp17_ = _data_->params;
		_data_->_tmp18_ = g_strdup ("locality");
		_data_->_tmp19_ = _data_->addr;
		_data_->_tmp20_ = folks_postal_address_get_locality (_data_->_tmp19_);
		_data_->_tmp21_ = _data_->_tmp20_;
		_data_->_tmp22_ = NULL;
		_data_->_tmp22_ = g_new0 (GValue, 1);
		g_value_init (_data_->_tmp22_, G_TYPE_STRING);
		g_value_set_string (_data_->_tmp22_, _data_->_tmp21_);
		g_hash_table_insert (_data_->_tmp17_, _data_->_tmp18_, _data_->_tmp22_);
	}
	_data_->_tmp23_ = _data_->addr;
	_data_->_tmp24_ = folks_postal_address_get_region (_data_->_tmp23_);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = contacts_is_set (_data_->_tmp25_);
	if (_data_->_tmp26_) {
		_data_->_tmp27_ = _data_->params;
		_data_->_tmp28_ = g_strdup ("region");
		_data_->_tmp29_ = _data_->addr;
		_data_->_tmp30_ = folks_postal_address_get_region (_data_->_tmp29_);
		_data_->_tmp31_ = _data_->_tmp30_;
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = g_new0 (GValue, 1);
		g_value_init (_data_->_tmp32_, G_TYPE_STRING);
		g_value_set_string (_data_->_tmp32_, _data_->_tmp31_);
		g_hash_table_insert (_data_->_tmp27_, _data_->_tmp28_, _data_->_tmp32_);
	}
	_data_->_tmp33_ = _data_->addr;
	_data_->_tmp34_ = folks_postal_address_get_country (_data_->_tmp33_);
	_data_->_tmp35_ = _data_->_tmp34_;
	_data_->_tmp36_ = contacts_is_set (_data_->_tmp35_);
	if (_data_->_tmp36_) {
		_data_->_tmp37_ = _data_->params;
		_data_->_tmp38_ = g_strdup ("country");
		_data_->_tmp39_ = _data_->addr;
		_data_->_tmp40_ = folks_postal_address_get_country (_data_->_tmp39_);
		_data_->_tmp41_ = _data_->_tmp40_;
		_data_->_tmp42_ = NULL;
		_data_->_tmp42_ = g_new0 (GValue, 1);
		g_value_init (_data_->_tmp42_, G_TYPE_STRING);
		g_value_set_string (_data_->_tmp42_, _data_->_tmp41_);
		g_hash_table_insert (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp42_);
	}
	_data_->_data1_->place = NULL;
	_data_->_tmp43_ = _data_->params;
	_data_->_tmp44_ = geocode_forward_new_for_params (_data_->_tmp43_);
	_data_->_data1_->forward = _data_->_tmp44_;
	geocode_forward_search_async (_data_->_data1_->forward, NULL, ___lambda17__gasync_ready_callback, block1_data_ref (_data_->_data1_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp45_ = _g_object_ref0 (_data_->_data1_->place);
	_data_->result = _data_->_tmp45_;
	_g_hash_table_unref0 (_data_->params);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gchar** contacts_contact_format_address (FolksPostalAddress* addr, int* result_length1) {
	gchar** result = NULL;
	gchar** lines = NULL;
	gchar** _tmp0_;
	gint lines_length1;
	gint _lines_size_;
	FolksPostalAddress* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	FolksPostalAddress* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gboolean _tmp13_;
	FolksPostalAddress* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_;
	FolksPostalAddress* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gboolean _tmp31_;
	FolksPostalAddress* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gboolean _tmp40_;
	FolksPostalAddress* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gboolean _tmp49_;
	FolksPostalAddress* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	gboolean _tmp58_;
	FolksPostalAddress* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gboolean _tmp67_;
	gchar** _tmp73_;
	gint _tmp73__length1;
	g_return_val_if_fail (addr != NULL, NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	lines = _tmp0_;
	lines_length1 = 0;
	_lines_size_ = lines_length1;
	_tmp1_ = addr;
	_tmp2_ = folks_postal_address_get_street (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_is_set (_tmp3_);
	if (_tmp4_) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		FolksPostalAddress* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = lines;
		_tmp5__length1 = lines_length1;
		_tmp6_ = addr;
		_tmp7_ = folks_postal_address_get_street (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_vala_array_add1 (&lines, &lines_length1, &_lines_size_, _tmp9_);
	}
	_tmp10_ = addr;
	_tmp11_ = folks_postal_address_get_extension (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = contacts_is_set (_tmp12_);
	if (_tmp13_) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		FolksPostalAddress* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp14_ = lines;
		_tmp14__length1 = lines_length1;
		_tmp15_ = addr;
		_tmp16_ = folks_postal_address_get_extension (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strdup (_tmp17_);
		_vala_array_add2 (&lines, &lines_length1, &_lines_size_, _tmp18_);
	}
	_tmp19_ = addr;
	_tmp20_ = folks_postal_address_get_locality (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = contacts_is_set (_tmp21_);
	if (_tmp22_) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		FolksPostalAddress* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp23_ = lines;
		_tmp23__length1 = lines_length1;
		_tmp24_ = addr;
		_tmp25_ = folks_postal_address_get_locality (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strdup (_tmp26_);
		_vala_array_add3 (&lines, &lines_length1, &_lines_size_, _tmp27_);
	}
	_tmp28_ = addr;
	_tmp29_ = folks_postal_address_get_region (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = contacts_is_set (_tmp30_);
	if (_tmp31_) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		FolksPostalAddress* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp32_ = lines;
		_tmp32__length1 = lines_length1;
		_tmp33_ = addr;
		_tmp34_ = folks_postal_address_get_region (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strdup (_tmp35_);
		_vala_array_add4 (&lines, &lines_length1, &_lines_size_, _tmp36_);
	}
	_tmp37_ = addr;
	_tmp38_ = folks_postal_address_get_postal_code (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = contacts_is_set (_tmp39_);
	if (_tmp40_) {
		gchar** _tmp41_;
		gint _tmp41__length1;
		FolksPostalAddress* _tmp42_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp41_ = lines;
		_tmp41__length1 = lines_length1;
		_tmp42_ = addr;
		_tmp43_ = folks_postal_address_get_postal_code (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strdup (_tmp44_);
		_vala_array_add5 (&lines, &lines_length1, &_lines_size_, _tmp45_);
	}
	_tmp46_ = addr;
	_tmp47_ = folks_postal_address_get_po_box (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = contacts_is_set (_tmp48_);
	if (_tmp49_) {
		gchar** _tmp50_;
		gint _tmp50__length1;
		FolksPostalAddress* _tmp51_;
		const gchar* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp50_ = lines;
		_tmp50__length1 = lines_length1;
		_tmp51_ = addr;
		_tmp52_ = folks_postal_address_get_po_box (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strdup (_tmp53_);
		_vala_array_add6 (&lines, &lines_length1, &_lines_size_, _tmp54_);
	}
	_tmp55_ = addr;
	_tmp56_ = folks_postal_address_get_country (_tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = contacts_is_set (_tmp57_);
	if (_tmp58_) {
		gchar** _tmp59_;
		gint _tmp59__length1;
		FolksPostalAddress* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		gchar* _tmp63_;
		_tmp59_ = lines;
		_tmp59__length1 = lines_length1;
		_tmp60_ = addr;
		_tmp61_ = folks_postal_address_get_country (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strdup (_tmp62_);
		_vala_array_add7 (&lines, &lines_length1, &_lines_size_, _tmp63_);
	}
	_tmp64_ = addr;
	_tmp65_ = folks_postal_address_get_address_format (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = contacts_is_set (_tmp66_);
	if (_tmp67_) {
		gchar** _tmp68_;
		gint _tmp68__length1;
		FolksPostalAddress* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		gchar* _tmp72_;
		_tmp68_ = lines;
		_tmp68__length1 = lines_length1;
		_tmp69_ = addr;
		_tmp70_ = folks_postal_address_get_address_format (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = g_strdup (_tmp71_);
		_vala_array_add8 (&lines, &lines_length1, &_lines_size_, _tmp72_);
	}
	_tmp73_ = lines;
	_tmp73__length1 = lines_length1;
	if (result_length1) {
		*result_length1 = _tmp73__length1;
	}
	result = _tmp73_;
	return result;
}


TpfPersona* contacts_contact_find_im_persona (ContactsContact* self, const gchar* protocol, const gchar* im_address) {
	TpfPersona* result = NULL;
	gchar* iid = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	g_return_val_if_fail (im_address != NULL, NULL);
	_tmp0_ = protocol;
	_tmp1_ = g_strconcat (_tmp0_, ":", NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = im_address;
	_tmp4_ = g_strconcat (_tmp2_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp2_);
	iid = _tmp5_;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_;
		_tmp6_ = self->individual;
		_tmp7_ = folks_individual_get_personas (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_p_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			TpfPersona* tp = NULL;
			FolksPersona* _tmp14_;
			TpfPersona* _tmp15_;
			gboolean _tmp16_ = FALSE;
			TpfPersona* _tmp17_;
			_tmp10_ = _p_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _p_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			p = (FolksPersona*) _tmp13_;
			_tmp14_ = p;
			_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TPF_TYPE_PERSONA) ? ((TpfPersona*) _tmp14_) : NULL);
			tp = _tmp15_;
			_tmp17_ = tp;
			if (_tmp17_ != NULL) {
				TpfPersona* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp18_ = tp;
				_tmp19_ = folks_persona_get_iid ((FolksPersona*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = iid;
				_tmp16_ = g_strcmp0 (_tmp20_, _tmp21_) == 0;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				result = tp;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				_g_free0 (iid);
				return result;
			}
			_g_object_unref0 (tp);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	_g_free0 (iid);
	return result;
}


gchar* contacts_contact_format_im_service (const gchar* service, ContactsContactImDisplay* display) {
	ContactsContactImDisplay _vala_display = 0;
	gchar* result = NULL;
	static const ContactsContactImData data[] = {{"google-talk", N_ ("Google Talk")}, {"ovi-chat", N_ ("Ovi Chat")}, {"facebook", N_ ("Facebook"), CONTACTS_CONTACT_IM_DISPLAY_ALIAS_SERVICE}, {"lj-talk", N_ ("Livejournal")}, {"aim", N_ ("AOL Instant Messenger")}, {"gadugadu", N_ ("Gadu-Gadu")}, {"groupwise", N_ ("Novell Groupwise")}, {"icq", N_ ("ICQ")}, {"irc", N_ ("IRC")}, {"jabber", N_ ("Jabber")}, {"local-xmpp", N_ ("Local network")}, {"msn", N_ ("Windows Live Messenger")}, {"myspace", N_ ("MySpace")}, {"mxit", N_ ("MXit")}, {"napster", N_ ("Napster")}, {"qq", N_ ("Tencent QQ")}, {"sametime", N_ ("IBM Lotus Sametime")}, {"silc", N_ ("SILC")}, {"sip", N_ ("sip")}, {"skype", N_ ("Skype")}, {"tel", N_ ("Telephony")}, {"trepia", N_ ("Trepia")}, {"yahoo", N_ ("Yahoo! Messenger")}, {"yahoojp", N_ ("Yahoo! Messenger")}, {"zephyr", N_ ("Zephyr")}};
	const gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_val_if_fail (service != NULL, NULL);
	{
		ContactsContactImData* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
		d_collection = data;
		d_collection_length1 = G_N_ELEMENTS (data);
		for (d_it = 0; d_it < G_N_ELEMENTS (data); d_it = d_it + 1) {
			ContactsContactImData d = {0};
			d = d_collection[d_it];
			{
				ContactsContactImData _tmp0_;
				const gchar* _tmp1_;
				const gchar* _tmp2_;
				_tmp0_ = d;
				_tmp1_ = _tmp0_.service;
				_tmp2_ = service;
				if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
					ContactsContactImData _tmp3_;
					ContactsContactImDisplay _tmp4_;
					ContactsContactImData _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp3_ = d;
					_tmp4_ = _tmp3_.display;
					_vala_display = _tmp4_;
					_tmp5_ = d;
					_tmp6_ = _tmp5_.display_name;
					_tmp7_ = g_strdup (g_dgettext (GETTEXT_PACKAGE, _tmp6_));
					result = _tmp7_;
					if (display) {
						*display = _vala_display;
					}
					return result;
				}
			}
		}
	}
	_vala_display = CONTACTS_CONTACT_IM_DISPLAY_DEFAULT;
	_tmp8_ = service;
	_tmp9_ = g_strdup (_tmp8_);
	result = _tmp9_;
	if (display) {
		*display = _vala_display;
	}
	return result;
}


static gboolean contacts_contact_changed_cb (ContactsContact* self) {
	gboolean result = FALSE;
	gboolean changed_personas = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->changed_id = (guint) 0;
	_tmp0_ = self->priv->changed_personas;
	changed_personas = _tmp0_;
	self->priv->changed_personas = FALSE;
	_tmp1_ = contacts_contact_calc_is_main (self);
	self->is_main = _tmp1_;
	contacts_contact_update (self);
	g_signal_emit (self, contacts_contact_signals[CONTACTS_CONTACT_CHANGED_SIGNAL], 0);
	_tmp2_ = changed_personas;
	if (_tmp2_) {
		g_signal_emit (self, contacts_contact_signals[CONTACTS_CONTACT_PERSONAS_CHANGED_SIGNAL], 0);
	}
	result = FALSE;
	return result;
}


static void contacts_contact_unqueue_changed (ContactsContact* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->changed_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->changed_id;
		g_source_remove (_tmp1_);
		self->priv->changed_id = (guint) 0;
	}
}


static gboolean _contacts_contact_changed_cb_gsource_func (gpointer self) {
	gboolean result;
	result = contacts_contact_changed_cb ((ContactsContact*) self);
	return result;
}


void contacts_contact_queue_changed (ContactsContact* self, gboolean is_persona_change) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_is_hidden_uptodate = FALSE;
	_tmp0_ = self->priv->changed_personas;
	_tmp1_ = is_persona_change;
	self->priv->changed_personas = _tmp0_ | _tmp1_;
	_tmp2_ = self->priv->changed_id;
	if (_tmp2_ != ((guint) 0)) {
		return;
	}
	_tmp3_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _contacts_contact_changed_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->changed_id = _tmp3_;
}


static void contacts_contact_notify_cb (ContactsContact* self, GParamSpec* pspec) {
	GParamSpec* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = pspec;
	_tmp1_ = g_param_spec_get_name (_tmp0_);
	if (g_strcmp0 (_tmp1_, "avatar") == 0) {
		_g_object_unref0 (self->priv->_small_avatar);
		self->priv->_small_avatar = NULL;
		_g_variant_unref0 (self->priv->_avatar_icon_data);
		self->priv->_avatar_icon_data = NULL;
	}
	contacts_contact_queue_changed (self, FALSE);
}


static void contacts_contact_update_filter_data (ContactsContact* self) {
	GString* builder = NULL;
	GString* _tmp0_;
	FolksIndividual* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	FolksIndividual* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GeeMultiMap* im_addresses = NULL;
	FolksIndividual* _tmp31_;
	GeeMultiMap* _tmp32_;
	GeeMultiMap* _tmp33_;
	GeeMultiMap* _tmp34_;
	GeeSet* emails = NULL;
	FolksIndividual* _tmp53_;
	GeeSet* _tmp54_;
	GeeSet* _tmp55_;
	GeeSet* _tmp56_;
	GeeSet* phone_numbers = NULL;
	FolksIndividual* _tmp70_;
	GeeSet* _tmp71_;
	GeeSet* _tmp72_;
	GeeSet* _tmp73_;
	GString* _tmp87_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->individual;
	_tmp2_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GString* _tmp4_;
		FolksIndividual* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GString* _tmp10_;
		_tmp4_ = builder;
		_tmp5_ = self->individual;
		_tmp6_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = contacts_utils_canonicalize_for_search (_tmp7_);
		_tmp9_ = _tmp8_;
		g_string_append (_tmp4_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = builder;
		g_string_append_unichar (_tmp10_, (gunichar) ' ');
	}
	_tmp11_ = self->individual;
	_tmp12_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		GString* _tmp14_;
		FolksIndividual* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GString* _tmp20_;
		_tmp14_ = builder;
		_tmp15_ = self->individual;
		_tmp16_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = contacts_utils_canonicalize_for_search (_tmp17_);
		_tmp19_ = _tmp18_;
		g_string_append (_tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
		_tmp20_ = builder;
		g_string_append_unichar (_tmp20_, (gunichar) ' ');
	}
	_tmp21_ = self->individual;
	_tmp22_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != NULL) {
		GString* _tmp24_;
		FolksIndividual* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GString* _tmp30_;
		_tmp24_ = builder;
		_tmp25_ = self->individual;
		_tmp26_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = contacts_utils_canonicalize_for_search (_tmp27_);
		_tmp29_ = _tmp28_;
		g_string_append (_tmp24_, _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = builder;
		g_string_append_unichar (_tmp30_, (gunichar) ' ');
	}
	_tmp31_ = self->individual;
	_tmp32_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	im_addresses = _tmp34_;
	{
		GeeIterator* _detail_it = NULL;
		GeeMultiMap* _tmp35_;
		GeeCollection* _tmp36_;
		GeeCollection* _tmp37_;
		GeeIterator* _tmp38_;
		GeeIterator* _tmp39_;
		_tmp35_ = im_addresses;
		_tmp36_ = gee_multi_map_get_values (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = gee_iterable_iterator ((GeeIterable*) _tmp37_);
		_tmp39_ = _tmp38_;
		_g_object_unref0 (_tmp37_);
		_detail_it = _tmp39_;
		while (TRUE) {
			GeeIterator* _tmp40_;
			gboolean _tmp41_;
			FolksImFieldDetails* detail = NULL;
			GeeIterator* _tmp42_;
			gpointer _tmp43_;
			gchar* addr = NULL;
			FolksImFieldDetails* _tmp44_;
			gconstpointer _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			GString* _tmp48_;
			const gchar* _tmp49_;
			gchar* _tmp50_;
			gchar* _tmp51_;
			GString* _tmp52_;
			_tmp40_ = _detail_it;
			_tmp41_ = gee_iterator_next (_tmp40_);
			if (!_tmp41_) {
				break;
			}
			_tmp42_ = _detail_it;
			_tmp43_ = gee_iterator_get (_tmp42_);
			detail = (FolksImFieldDetails*) _tmp43_;
			_tmp44_ = detail;
			_tmp45_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup ((const gchar*) _tmp46_);
			addr = _tmp47_;
			_tmp48_ = builder;
			_tmp49_ = addr;
			_tmp50_ = g_utf8_casefold (_tmp49_, (gssize) -1);
			_tmp51_ = _tmp50_;
			g_string_append (_tmp48_, _tmp51_);
			_g_free0 (_tmp51_);
			_tmp52_ = builder;
			g_string_append_unichar (_tmp52_, (gunichar) ' ');
			_g_free0 (addr);
			_g_object_unref0 (detail);
		}
		_g_object_unref0 (_detail_it);
	}
	_tmp53_ = self->individual;
	_tmp54_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = _g_object_ref0 (_tmp55_);
	emails = _tmp56_;
	{
		GeeIterator* _email_it = NULL;
		GeeSet* _tmp57_;
		GeeIterator* _tmp58_;
		_tmp57_ = emails;
		_tmp58_ = gee_iterable_iterator ((GeeIterable*) _tmp57_);
		_email_it = _tmp58_;
		while (TRUE) {
			GeeIterator* _tmp59_;
			gboolean _tmp60_;
			FolksEmailFieldDetails* email = NULL;
			GeeIterator* _tmp61_;
			gpointer _tmp62_;
			GString* _tmp63_;
			FolksEmailFieldDetails* _tmp64_;
			gconstpointer _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			GString* _tmp69_;
			_tmp59_ = _email_it;
			_tmp60_ = gee_iterator_next (_tmp59_);
			if (!_tmp60_) {
				break;
			}
			_tmp61_ = _email_it;
			_tmp62_ = gee_iterator_get (_tmp61_);
			email = (FolksEmailFieldDetails*) _tmp62_;
			_tmp63_ = builder;
			_tmp64_ = email;
			_tmp65_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_utf8_casefold ((const gchar*) _tmp66_, (gssize) -1);
			_tmp68_ = _tmp67_;
			g_string_append (_tmp63_, _tmp68_);
			_g_free0 (_tmp68_);
			_tmp69_ = builder;
			g_string_append_unichar (_tmp69_, (gunichar) ' ');
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	_tmp70_ = self->individual;
	_tmp71_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = _g_object_ref0 (_tmp72_);
	phone_numbers = _tmp73_;
	{
		GeeIterator* _phone_it = NULL;
		GeeSet* _tmp74_;
		GeeIterator* _tmp75_;
		_tmp74_ = phone_numbers;
		_tmp75_ = gee_iterable_iterator ((GeeIterable*) _tmp74_);
		_phone_it = _tmp75_;
		while (TRUE) {
			GeeIterator* _tmp76_;
			gboolean _tmp77_;
			FolksPhoneFieldDetails* phone = NULL;
			GeeIterator* _tmp78_;
			gpointer _tmp79_;
			GString* _tmp80_;
			FolksPhoneFieldDetails* _tmp81_;
			gconstpointer _tmp82_;
			const gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			GString* _tmp86_;
			_tmp76_ = _phone_it;
			_tmp77_ = gee_iterator_next (_tmp76_);
			if (!_tmp77_) {
				break;
			}
			_tmp78_ = _phone_it;
			_tmp79_ = gee_iterator_get (_tmp78_);
			phone = (FolksPhoneFieldDetails*) _tmp79_;
			_tmp80_ = builder;
			_tmp81_ = phone;
			_tmp82_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = g_utf8_casefold ((const gchar*) _tmp83_, (gssize) -1);
			_tmp85_ = _tmp84_;
			g_string_append (_tmp80_, _tmp85_);
			_g_free0 (_tmp85_);
			_tmp86_ = builder;
			g_string_append_unichar (_tmp86_, (gunichar) ' ');
			_g_object_unref0 (phone);
		}
		_g_object_unref0 (_phone_it);
	}
	_tmp87_ = builder;
	_tmp88_ = _tmp87_->str;
	_tmp89_ = g_strdup (_tmp88_);
	_g_free0 (self->priv->filter_data);
	self->priv->filter_data = _tmp89_;
	_g_object_unref0 (phone_numbers);
	_g_object_unref0 (emails);
	_g_object_unref0 (im_addresses);
	_g_string_free0 (builder);
}


static void contacts_contact_update (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _email_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_email_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksEmailFieldDetails* email = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			ContactsTypeSet* _tmp8_;
			ContactsTypeSet* _tmp9_;
			FolksEmailFieldDetails* _tmp10_;
			_tmp4_ = _email_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _email_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			email = (FolksEmailFieldDetails*) _tmp7_;
			_tmp8_ = contacts_typeset_get_general ();
			_tmp9_ = _tmp8_;
			_tmp10_ = email;
			contacts_typeset_type_seen (_tmp9_, (FolksAbstractFieldDetails*) _tmp10_);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	{
		GeeIterator* _phone_it = NULL;
		FolksIndividual* _tmp11_;
		GeeSet* _tmp12_;
		GeeSet* _tmp13_;
		GeeIterator* _tmp14_;
		_tmp11_ = self->individual;
		_tmp12_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
		_phone_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gboolean _tmp16_;
			FolksPhoneFieldDetails* phone = NULL;
			GeeIterator* _tmp17_;
			gpointer _tmp18_;
			ContactsTypeSet* _tmp19_;
			ContactsTypeSet* _tmp20_;
			FolksPhoneFieldDetails* _tmp21_;
			_tmp15_ = _phone_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _phone_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			phone = (FolksPhoneFieldDetails*) _tmp18_;
			_tmp19_ = contacts_typeset_get_phone ();
			_tmp20_ = _tmp19_;
			_tmp21_ = phone;
			contacts_typeset_type_seen (_tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
			_g_object_unref0 (phone);
		}
		_g_object_unref0 (_phone_it);
	}
	contacts_contact_update_filter_data (self);
}


static GdkPixbuf* contacts_contact_load_icon (ContactsContact* self, GLoadableIcon* file, gint size) {
	GdkPixbuf* result = NULL;
	GdkPixbuf* res = NULL;
	GLoadableIcon* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	res = NULL;
	_tmp0_ = file;
	if (_tmp0_ != NULL) {
		{
			GCancellable* c = NULL;
			GCancellable* _tmp1_;
			GInputStream* stream = NULL;
			GLoadableIcon* _tmp2_;
			gint _tmp3_;
			GCancellable* _tmp4_;
			GInputStream* _tmp5_;
			GdkPixbuf* _tmp6_ = NULL;
			GInputStream* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			GCancellable* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp1_ = g_cancellable_new ();
			c = _tmp1_;
			_tmp2_ = file;
			_tmp3_ = size;
			_tmp4_ = c;
			_tmp5_ = g_loadable_icon_load (_tmp2_, _tmp3_, NULL, _tmp4_, &_inner_error_);
			stream = _tmp5_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (c);
				goto __catch1_g_error;
			}
			_tmp7_ = stream;
			_tmp8_ = size;
			_tmp9_ = size;
			_tmp10_ = c;
			_tmp11_ = gdk_pixbuf_new_from_stream_at_scale (_tmp7_, _tmp8_, _tmp9_, TRUE, _tmp10_, &_inner_error_);
			_tmp6_ = _tmp11_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (stream);
				_g_object_unref0 (c);
				goto __catch1_g_error;
			}
			_tmp12_ = _tmp6_;
			_tmp6_ = NULL;
			_g_object_unref0 (res);
			res = _tmp12_;
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (stream);
			_g_object_unref0 (c);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp13_;
			const gchar* _tmp14_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp13_ = e;
			_tmp14_ = _tmp13_->message;
			g_warning ("contacts-contact.vala:596: error loading avatar %s\n", _tmp14_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (res);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = res;
	return result;
}


GdkPixbuf* contacts_contact_frame_icon (GdkPixbuf* icon) {
	GdkPixbuf* result = NULL;
	gint w = 0;
	GdkPixbuf* _tmp0_;
	gint _tmp1_;
	gint h = 0;
	GdkPixbuf* _tmp2_;
	gint _tmp3_;
	cairo_surface_t* cst = NULL;
	cairo_surface_t* _tmp4_;
	cairo_t* cr = NULL;
	cairo_t* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	g_return_val_if_fail (icon != NULL, NULL);
	_tmp0_ = icon;
	_tmp1_ = gdk_pixbuf_get_width (_tmp0_);
	w = _tmp1_;
	_tmp2_ = icon;
	_tmp3_ = gdk_pixbuf_get_height (_tmp2_);
	h = _tmp3_;
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, w, h);
	cst = _tmp4_;
	_tmp5_ = cairo_create (cst);
	cr = _tmp5_;
	cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_rectangle (cr, (gdouble) 0, (gdouble) 0, (gdouble) w, (gdouble) h);
	cairo_fill (cr);
	_tmp6_ = icon;
	gdk_cairo_set_source_pixbuf (cr, _tmp6_, (gdouble) 0, (gdouble) 0);
	contacts_utils_cairo_rounded_box (cr, 0, 0, w, h, 4);
	cairo_fill (cr);
	_tmp7_ = gdk_pixbuf_get_from_surface (cst, 0, 0, w, h);
	result = _tmp7_;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (cst);
	return result;
}


GdkPixbuf* contacts_contact_draw_fallback_avatar (gint size, ContactsContact* contact) {
	GdkPixbuf* result = NULL;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	GdkPixbuf* pixbuf = NULL;
	gint _tmp42_;
	GdkPixbuf* _tmp45_;
	cairo_surface_t* cst = NULL;
	gint _tmp46_;
	gint _tmp47_;
	cairo_surface_t* _tmp48_;
	cairo_surface_t* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GdkPixbuf* _tmp52_;
	GError * _inner_error_ = NULL;
	_tmp1_ = size;
	if (_tmp1_ == CONTACTS_CONTACT_SMALL_AVATAR_SIZE) {
		GdkPixbuf* _tmp2_;
		_tmp2_ = contacts_contact_fallback_pixbuf_default;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp3_ = contacts_contact_fallback_pixbuf_default;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		return result;
	}
	pixbuf = NULL;
	{
		cairo_surface_t* cst = NULL;
		gint _tmp5_;
		gint _tmp6_;
		cairo_surface_t* _tmp7_;
		cairo_t* cr = NULL;
		cairo_surface_t* _tmp8_;
		cairo_t* _tmp9_;
		cairo_pattern_t* pat = NULL;
		gint _tmp10_;
		cairo_pattern_t* _tmp11_;
		cairo_pattern_t* _tmp12_;
		cairo_pattern_t* _tmp13_;
		cairo_t* _tmp14_;
		cairo_pattern_t* _tmp15_;
		cairo_t* _tmp16_;
		gint avatar_size = 0;
		gint _tmp17_;
		GtkIconInfo* icon_info = NULL;
		GtkIconTheme* _tmp18_;
		gint _tmp19_;
		GtkIconInfo* _tmp20_;
		GtkIconInfo* _tmp21_;
		cairo_surface_t* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		GdkPixbuf* _tmp41_;
		_tmp5_ = size;
		_tmp6_ = size;
		_tmp7_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp5_, _tmp6_);
		cst = _tmp7_;
		_tmp8_ = cst;
		_tmp9_ = cairo_create (_tmp8_);
		cr = _tmp9_;
		_tmp10_ = size;
		_tmp11_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) _tmp10_);
		pat = _tmp11_;
		_tmp12_ = pat;
		cairo_pattern_add_color_stop_rgb (_tmp12_, (gdouble) 0, 0.937, 0.937, 0.937);
		_tmp13_ = pat;
		cairo_pattern_add_color_stop_rgb (_tmp13_, (gdouble) 1, 0.969, 0.969, 0.969);
		_tmp14_ = cr;
		_tmp15_ = pat;
		cairo_set_source (_tmp14_, _tmp15_);
		_tmp16_ = cr;
		cairo_paint (_tmp16_);
		_tmp17_ = size;
		avatar_size = (gint) (_tmp17_ * 0.3);
		_tmp18_ = gtk_icon_theme_get_default ();
		_tmp19_ = avatar_size;
		_tmp20_ = gtk_icon_theme_lookup_icon (_tmp18_, "avatar-default-symbolic", _tmp19_, GTK_ICON_LOOKUP_GENERIC_FALLBACK);
		icon_info = _tmp20_;
		_tmp21_ = icon_info;
		if (_tmp21_ != NULL) {
			GdkPixbuf* _tmp22_ = NULL;
			GtkIconInfo* _tmp23_;
			GdkPixbuf* _tmp24_;
			cairo_t* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			cairo_t* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			cairo_t* _tmp37_;
			_tmp23_ = icon_info;
			_tmp24_ = gtk_icon_info_load_icon (_tmp23_, &_inner_error_);
			_tmp22_ = _tmp24_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_gtk_icon_info_free0 (icon_info);
				_cairo_pattern_destroy0 (pat);
				_cairo_destroy0 (cr);
				_cairo_surface_destroy0 (cst);
				goto __catch2_g_error;
			}
			_tmp25_ = cr;
			_tmp26_ = size;
			_tmp27_ = avatar_size;
			_tmp28_ = size;
			_tmp29_ = avatar_size;
			gdk_cairo_set_source_pixbuf (_tmp25_, _tmp22_, (gdouble) ((_tmp26_ - _tmp27_) / 2), (gdouble) ((_tmp28_ - _tmp29_) / 2));
			_tmp30_ = cr;
			_tmp31_ = size;
			_tmp32_ = avatar_size;
			_tmp33_ = size;
			_tmp34_ = avatar_size;
			_tmp35_ = avatar_size;
			_tmp36_ = avatar_size;
			cairo_rectangle (_tmp30_, (gdouble) ((_tmp31_ - _tmp32_) / 2), (gdouble) ((_tmp33_ - _tmp34_) / 2), (gdouble) _tmp35_, (gdouble) _tmp36_);
			_tmp37_ = cr;
			cairo_fill (_tmp37_);
			_g_object_unref0 (_tmp22_);
		}
		_tmp38_ = cst;
		_tmp39_ = size;
		_tmp40_ = size;
		_tmp41_ = gdk_pixbuf_get_from_surface (_tmp38_, 0, 0, _tmp39_, _tmp40_);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp41_;
		_gtk_icon_info_free0 (icon_info);
		_cairo_pattern_destroy0 (pat);
		_cairo_destroy0 (cr);
		_cairo_surface_destroy0 (cst);
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp42_ = size;
	if (_tmp42_ == CONTACTS_CONTACT_SMALL_AVATAR_SIZE) {
		GdkPixbuf* _tmp43_;
		GdkPixbuf* _tmp44_;
		_tmp43_ = pixbuf;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		_g_object_unref0 (contacts_contact_fallback_pixbuf_default);
		contacts_contact_fallback_pixbuf_default = _tmp44_;
	}
	_tmp45_ = pixbuf;
	if (_tmp45_ != NULL) {
		result = pixbuf;
		return result;
	}
	_tmp46_ = size;
	_tmp47_ = size;
	_tmp48_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp46_, _tmp47_);
	cst = _tmp48_;
	_tmp49_ = cst;
	_tmp50_ = size;
	_tmp51_ = size;
	_tmp52_ = gdk_pixbuf_get_from_surface (_tmp49_, 0, 0, _tmp50_, _tmp51_);
	result = _tmp52_;
	_cairo_surface_destroy0 (cst);
	_g_object_unref0 (pixbuf);
	return result;
}


gboolean contacts_contact_can_remove_personas (ContactsContact* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FolksPersona* _tmp9_;
			FolksPersonaStore* _tmp10_;
			FolksPersonaStore* _tmp11_;
			FolksMaybeBool _tmp12_;
			FolksMaybeBool _tmp13_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp9_ = p;
			_tmp10_ = folks_persona_get_store (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = folks_persona_store_get_can_remove_personas (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ == FOLKS_MAYBE_BOOL_TRUE) {
				FolksPersona* _tmp14_;
				_tmp14_ = p;
				_tmp8_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, TPF_TYPE_PERSONA);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = FALSE;
	return result;
}


static void contacts_contact_remove_personas_data_free (gpointer _data) {
	ContactsContactRemovePersonasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactRemovePersonasData, _data_);
}


void contacts_contact_remove_personas (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactRemovePersonasData* _data_;
	ContactsContact* _tmp0_;
	_data_ = g_slice_new0 (ContactsContactRemovePersonasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_remove_personas_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_contact_remove_personas_co (_data_);
}


void contacts_contact_remove_personas_finish (ContactsContact* self, GAsyncResult* _res_, GError** error) {
	ContactsContactRemovePersonasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void contacts_contact_remove_personas_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsContactRemovePersonasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_remove_personas_co (_data_);
}


static gboolean contacts_contact_remove_personas_co (ContactsContactRemovePersonasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->personas = _data_->_tmp0_;
	{
		_data_->_tmp1_ = _data_->self->individual;
		_data_->_tmp2_ = folks_individual_get_personas (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp3_);
		_data_->_p_it = _data_->_tmp4_;
		while (TRUE) {
			_data_->_tmp5_ = _data_->_p_it;
			_data_->_tmp6_ = gee_iterator_next (_data_->_tmp5_);
			if (!_data_->_tmp6_) {
				break;
			}
			_data_->_tmp7_ = _data_->_p_it;
			_data_->_tmp8_ = gee_iterator_get (_data_->_tmp7_);
			_data_->p = (FolksPersona*) _data_->_tmp8_;
			_data_->_tmp10_ = _data_->p;
			_data_->_tmp11_ = folks_persona_get_store (_data_->_tmp10_);
			_data_->_tmp12_ = _data_->_tmp11_;
			_data_->_tmp13_ = folks_persona_store_get_can_remove_personas (_data_->_tmp12_);
			_data_->_tmp14_ = _data_->_tmp13_;
			if (_data_->_tmp14_ == FOLKS_MAYBE_BOOL_TRUE) {
				_data_->_tmp15_ = _data_->p;
				_data_->_tmp9_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp15_, TPF_TYPE_PERSONA);
			} else {
				_data_->_tmp9_ = FALSE;
			}
			if (_data_->_tmp9_) {
				_data_->_tmp16_ = _data_->personas;
				_data_->_tmp17_ = _data_->p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp16_, _data_->_tmp17_);
			}
			_g_object_unref0 (_data_->p);
		}
		_g_object_unref0 (_data_->_p_it);
	}
	{
		_data_->_tmp18_ = _data_->personas;
		_data_->_tmp19_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp18_);
		_data_->_persona_it = _data_->_tmp19_;
		while (TRUE) {
			_data_->_tmp20_ = _data_->_persona_it;
			_data_->_tmp21_ = gee_iterator_next (_data_->_tmp20_);
			if (!_data_->_tmp21_) {
				break;
			}
			_data_->_tmp22_ = _data_->_persona_it;
			_data_->_tmp23_ = gee_iterator_get (_data_->_tmp22_);
			_data_->persona = (FolksPersona*) _data_->_tmp23_;
			_data_->_tmp24_ = _data_->persona;
			_data_->_tmp25_ = folks_persona_get_store (_data_->_tmp24_);
			_data_->_tmp26_ = _data_->_tmp25_;
			_data_->_tmp27_ = _data_->persona;
			_data_->_state_ = 1;
			folks_persona_store_remove_persona (_data_->_tmp26_, _data_->_tmp27_, contacts_contact_remove_personas_ready, _data_);
			return FALSE;
			_state_1:
			folks_persona_store_remove_persona_finish (_data_->_tmp26_, _data_->_res_, &_data_->_inner_error_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
					g_task_return_error (_data_->_async_result, _data_->_inner_error_);
					_g_object_unref0 (_data_->persona);
					_g_object_unref0 (_data_->_persona_it);
					_g_object_unref0 (_data_->personas);
					g_object_unref (_data_->_async_result);
					return FALSE;
				} else {
					_g_object_unref0 (_data_->persona);
					_g_object_unref0 (_data_->_persona_it);
					_g_object_unref0 (_data_->personas);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
			_g_object_unref0 (_data_->persona);
		}
		_g_object_unref0 (_data_->_persona_it);
	}
	_g_object_unref0 (_data_->personas);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_contact_ensure_primary_persona_data_free (gpointer _data) {
	ContactsContactEnsurePrimaryPersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsContactEnsurePrimaryPersonaData, _data_);
}


void contacts_contact_ensure_primary_persona (ContactsContact* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactEnsurePrimaryPersonaData* _data_;
	ContactsContact* _tmp0_;
	_data_ = g_slice_new0 (ContactsContactEnsurePrimaryPersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_ensure_primary_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_contact_ensure_primary_persona_co (_data_);
}


FolksPersona* contacts_contact_ensure_primary_persona_finish (ContactsContact* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsContactEnsurePrimaryPersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void contacts_contact_ensure_primary_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsContactEnsurePrimaryPersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_ensure_primary_persona_co (_data_);
}


static gboolean contacts_contact_ensure_primary_persona_co (ContactsContactEnsurePrimaryPersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_contact_find_primary_persona (_data_->self);
	_data_->p = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->p;
	if (_data_->_tmp1_ != NULL) {
		_data_->result = _data_->p;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->persona_set = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->persona_set;
	_data_->_tmp4_ = _data_->self->individual;
	_data_->_tmp5_ = folks_individual_get_personas (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_collection_add_all ((GeeCollection*) _data_->_tmp3_, (GeeCollection*) _data_->_tmp6_);
	_data_->_tmp7_ = _data_->persona_set;
	_data_->_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	if (_data_->_tmp9_ == 1) {
		_data_->_tmp10_ = _data_->persona_set;
		_data_->_tmp11_ = contacts_fake_persona_new (_data_->self);
		_data_->_tmp12_ = _data_->_tmp11_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp10_, (FolksPersona*) _data_->_tmp12_);
		_g_object_unref0 (_data_->_tmp12_);
	}
	_data_->_tmp13_ = _data_->self->store;
	_data_->_tmp14_ = contacts_store_get_aggregator (_data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->persona_set;
	_data_->_state_ = 1;
	folks_individual_aggregator_link_personas (_data_->_tmp15_, (GeeSet*) _data_->_tmp16_, contacts_contact_ensure_primary_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_individual_aggregator_link_personas_finish (_data_->_tmp15_, _data_->_res_, &_data_->_inner_error_);
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		if (((_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->persona_set);
			_g_object_unref0 (_data_->p);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona_set);
			_g_object_unref0 (_data_->p);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp17_ = contacts_contact_find_primary_persona (_data_->self);
	_g_object_unref0 (_data_->p);
	_data_->p = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->p;
	if (_data_->_tmp18_ == NULL) {
		_data_->_tmp19_ = g_error_new_literal (CONTACT_ERROR, CONTACT_ERROR_NO_PRIMARY, _ ("Unexpected internal error: created contact was not found"));
		_data_->_inner_error_ = _data_->_tmp19_;
		if (((_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->persona_set);
			_g_object_unref0 (_data_->p);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona_set);
			_g_object_unref0 (_data_->p);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->result = _data_->p;
	_g_object_unref0 (_data_->persona_set);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


FolksPersona* contacts_contact_find_persona_from_store (ContactsContact* self, FolksPersonaStore* store) {
	FolksPersona* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			FolksPersonaStore* _tmp9_;
			FolksPersonaStore* _tmp10_;
			FolksPersonaStore* _tmp11_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = folks_persona_get_store (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = store;
			if (_tmp10_ == _tmp11_) {
				result = p;
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = NULL;
	return result;
}


static gint __lambda4_ (ContactsContact* self, FolksPersona* a, FolksPersona* b) {
	gint result = 0;
	FolksPersona* persona_a = NULL;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* persona_b = NULL;
	FolksPersona* _tmp2_;
	FolksPersona* _tmp3_;
	FolksPersonaStore* store_a = NULL;
	FolksPersona* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* _tmp6_;
	FolksPersonaStore* _tmp7_;
	FolksPersonaStore* store_b = NULL;
	FolksPersona* _tmp8_;
	FolksPersonaStore* _tmp9_;
	FolksPersonaStore* _tmp10_;
	FolksPersonaStore* _tmp11_;
	FolksPersonaStore* _tmp12_;
	FolksPersonaStore* _tmp13_;
	gboolean _tmp26_ = FALSE;
	FolksPersonaStore* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_;
	FolksPersonaStore* _tmp33_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	FolksPersonaStore* _tmp36_;
	gboolean _tmp37_;
	gboolean _tmp38_;
	gboolean _tmp39_ = FALSE;
	FolksPersonaStore* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	FolksPersonaStore* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	FolksPersonaStore* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	GCompareFunc _tmp60_;
	FolksPersonaStore* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	FolksPersonaStore* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gint _tmp67_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 ((FolksPersona*) _tmp0_);
	persona_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _g_object_ref0 ((FolksPersona*) _tmp2_);
	persona_b = _tmp3_;
	_tmp4_ = persona_a;
	_tmp5_ = folks_persona_get_store (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	store_a = _tmp7_;
	_tmp8_ = persona_b;
	_tmp9_ = folks_persona_get_store (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	store_b = _tmp11_;
	_tmp12_ = store_a;
	_tmp13_ = store_b;
	if (_tmp12_ == _tmp13_) {
		FolksPersona* _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = persona_a;
		_tmp15_ = contacts_contact_persona_is_google (_tmp14_);
		if (_tmp15_) {
			gboolean _tmp16_ = FALSE;
			FolksPersona* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp21_ = FALSE;
			FolksPersona* _tmp22_;
			gboolean _tmp23_;
			_tmp17_ = persona_a;
			_tmp18_ = contacts_contact_persona_is_google_other (_tmp17_);
			if (_tmp18_) {
				FolksPersona* _tmp19_;
				gboolean _tmp20_;
				_tmp19_ = persona_b;
				_tmp20_ = contacts_contact_persona_is_google_other (_tmp19_);
				_tmp16_ = !_tmp20_;
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				result = 1;
				_g_object_unref0 (store_b);
				_g_object_unref0 (store_a);
				_g_object_unref0 (persona_b);
				_g_object_unref0 (persona_a);
				return result;
			}
			_tmp22_ = persona_a;
			_tmp23_ = contacts_contact_persona_is_google_other (_tmp22_);
			if (!_tmp23_) {
				FolksPersona* _tmp24_;
				gboolean _tmp25_;
				_tmp24_ = persona_b;
				_tmp25_ = contacts_contact_persona_is_google_other (_tmp24_);
				_tmp21_ = _tmp25_;
			} else {
				_tmp21_ = FALSE;
			}
			if (_tmp21_) {
				result = -1;
				_g_object_unref0 (store_b);
				_g_object_unref0 (store_a);
				_g_object_unref0 (persona_b);
				_g_object_unref0 (persona_a);
				return result;
			}
		}
		result = 0;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp27_ = store_a;
	_tmp28_ = folks_persona_store_get_is_primary_store (_tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_) {
		FolksPersonaStore* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		_tmp30_ = store_b;
		_tmp31_ = folks_persona_store_get_is_primary_store (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp26_ = _tmp32_;
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		result = 0;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp33_ = store_a;
	_tmp34_ = folks_persona_store_get_is_primary_store (_tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_) {
		result = -1;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp36_ = store_b;
	_tmp37_ = folks_persona_store_get_is_primary_store (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_) {
		result = 1;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp40_ = store_a;
	_tmp41_ = folks_persona_store_get_type_id (_tmp40_);
	_tmp42_ = _tmp41_;
	if (g_strcmp0 (_tmp42_, "eds") == 0) {
		FolksPersonaStore* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp43_ = store_b;
		_tmp44_ = folks_persona_store_get_type_id (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp39_ = g_strcmp0 (_tmp45_, "eds") == 0;
	} else {
		_tmp39_ = FALSE;
	}
	if (_tmp39_) {
		GCompareFunc _tmp46_;
		FolksPersonaStore* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		FolksPersonaStore* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		gint _tmp53_;
		_tmp46_ = g_strcmp0;
		_tmp47_ = store_a;
		_tmp48_ = folks_persona_store_get_id (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = store_b;
		_tmp51_ = folks_persona_store_get_id (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _tmp46_ (_tmp49_, _tmp52_);
		result = _tmp53_;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp54_ = store_a;
	_tmp55_ = folks_persona_store_get_type_id (_tmp54_);
	_tmp56_ = _tmp55_;
	if (g_strcmp0 (_tmp56_, "eds") == 0) {
		result = -1;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp57_ = store_b;
	_tmp58_ = folks_persona_store_get_type_id (_tmp57_);
	_tmp59_ = _tmp58_;
	if (g_strcmp0 (_tmp59_, "eds") == 0) {
		result = 1;
		_g_object_unref0 (store_b);
		_g_object_unref0 (store_a);
		_g_object_unref0 (persona_b);
		_g_object_unref0 (persona_a);
		return result;
	}
	_tmp60_ = g_strcmp0;
	_tmp61_ = store_a;
	_tmp62_ = folks_persona_store_get_id (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = store_b;
	_tmp65_ = folks_persona_store_get_id (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = _tmp60_ (_tmp63_, _tmp66_);
	result = _tmp67_;
	_g_object_unref0 (store_b);
	_g_object_unref0 (store_a);
	_g_object_unref0 (persona_b);
	_g_object_unref0 (persona_a);
	return result;
}


static gint ___lambda4__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda4_ ((ContactsContact*) self, (FolksPersona*) a, (FolksPersona*) b);
	return result;
}


GeeList* contacts_contact_get_personas_for_display (ContactsContact* self) {
	GeeList* result = NULL;
	GCompareDataFunc compare_persona_by_store = NULL;
	void* compare_persona_by_store_target;
	GDestroyNotify compare_persona_by_store_target_destroy_notify;
	GeeArrayList* persona_list = NULL;
	GeeArrayList* _tmp0_;
	gint i = 0;
	GeeArrayList* _tmp1_;
	FolksIndividual* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeArrayList* _tmp23_;
	GCompareDataFunc _tmp24_;
	void* _tmp24__target;
	GDestroyNotify _tmp24__target_destroy_notify;
	g_return_val_if_fail (self != NULL, NULL);
	compare_persona_by_store = ___lambda4__gcompare_data_func;
	compare_persona_by_store_target = g_object_ref (self);
	compare_persona_by_store_target_destroy_notify = g_object_unref;
	_tmp0_ = gee_array_list_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	persona_list = _tmp0_;
	i = 0;
	_tmp1_ = persona_list;
	_tmp2_ = self->individual;
	_tmp3_ = folks_individual_get_personas (_tmp2_);
	_tmp4_ = _tmp3_;
	gee_array_list_add_all (_tmp1_, (GeeCollection*) _tmp4_);
	while (TRUE) {
		gint _tmp5_;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gpointer _tmp11_;
		FolksPersona* _tmp12_;
		FolksPersonaStore* _tmp13_;
		FolksPersonaStore* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_;
		_tmp5_ = i;
		_tmp6_ = persona_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (!(_tmp5_ < _tmp8_)) {
			break;
		}
		_tmp9_ = persona_list;
		_tmp10_ = i;
		_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
		_tmp12_ = (FolksPersona*) _tmp11_;
		_tmp13_ = folks_persona_get_store (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = folks_persona_store_get_type_id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strcmp0 (_tmp16_, "key-file") == 0;
		_g_object_unref0 (_tmp12_);
		if (_tmp17_) {
			GeeArrayList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			FolksPersona* _tmp21_;
			_tmp18_ = persona_list;
			_tmp19_ = i;
			_tmp20_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp18_, _tmp19_);
			_tmp21_ = (FolksPersona*) _tmp20_;
			_g_object_unref0 (_tmp21_);
		} else {
			gint _tmp22_;
			_tmp22_ = i;
			i = _tmp22_ + 1;
		}
	}
	_tmp23_ = persona_list;
	_tmp24_ = compare_persona_by_store;
	_tmp24__target = compare_persona_by_store_target;
	_tmp24__target_destroy_notify = compare_persona_by_store_target_destroy_notify;
	compare_persona_by_store = NULL;
	compare_persona_by_store_target = NULL;
	compare_persona_by_store_target_destroy_notify = NULL;
	gee_list_sort ((GeeList*) _tmp23_, _tmp24_, _tmp24__target, _tmp24__target_destroy_notify);
	result = (GeeList*) persona_list;
	(compare_persona_by_store_target_destroy_notify == NULL) ? NULL : (compare_persona_by_store_target_destroy_notify (compare_persona_by_store_target), NULL);
	compare_persona_by_store = NULL;
	compare_persona_by_store_target = NULL;
	compare_persona_by_store_target_destroy_notify = NULL;
	return result;
}


FolksPersona* contacts_contact_find_primary_persona (ContactsContact* self) {
	FolksPersona* result = NULL;
	ContactsStore* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	FolksIndividualAggregator* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	ContactsStore* _tmp5_;
	FolksIndividualAggregator* _tmp6_;
	FolksIndividualAggregator* _tmp7_;
	FolksPersonaStore* _tmp8_;
	FolksPersonaStore* _tmp9_;
	FolksPersona* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->store;
	_tmp1_ = contacts_store_get_aggregator (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_individual_aggregator_get_primary_store (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp5_ = self->store;
	_tmp6_ = contacts_store_get_aggregator (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = folks_individual_aggregator_get_primary_store (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = contacts_contact_find_persona_from_store (self, _tmp9_);
	result = _tmp10_;
	return result;
}


FolksPersona* contacts_contact_find_persona_from_uid (ContactsContact* self, const gchar* uid) {
	FolksPersona* result = NULL;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			FolksPersona* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = folks_persona_get_uid (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = uid;
			if (g_strcmp0 (_tmp10_, _tmp11_) == 0) {
				result = p;
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp13_ = uid;
	if (g_strcmp0 (_tmp13_, "uid-fake-persona") == 0) {
		FolksPersona* _tmp14_;
		_tmp14_ = self->fake_persona;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		FolksPersona* _tmp15_;
		FolksPersona* _tmp16_;
		_tmp15_ = self->fake_persona;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		result = _tmp16_;
		return result;
	}
	result = NULL;
	return result;
}


gchar* contacts_contact_format_persona_stores (ContactsContact* self) {
	gchar* result = NULL;
	gchar* stores = NULL;
	gchar* _tmp0_;
	gboolean first = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	stores = _tmp0_;
	first = TRUE;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp1_ = self->individual;
		_tmp2_ = folks_individual_get_personas (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_p_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			gboolean _tmp6_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_;
			const gchar* _tmp12_;
			FolksPersona* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp5_ = _p_it;
			_tmp6_ = gee_iterator_next (_tmp5_);
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _p_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			p = (FolksPersona*) _tmp8_;
			_tmp9_ = first;
			if (!_tmp9_) {
				const gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp10_ = stores;
				_tmp11_ = g_strconcat (_tmp10_, ", ", NULL);
				_g_free0 (stores);
				stores = _tmp11_;
			}
			_tmp12_ = stores;
			_tmp13_ = p;
			_tmp14_ = contacts_contact_format_persona_store_name_for_contact (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp12_, _tmp15_, NULL);
			_g_free0 (stores);
			stores = _tmp16_;
			_g_free0 (_tmp15_);
			first = FALSE;
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = stores;
	return result;
}


gchar* contacts_contact_format_persona_store_name (FolksPersonaStore* store) {
	gchar* result = NULL;
	FolksPersonaStore* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	FolksPersonaStore* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = store;
	_tmp1_ = folks_persona_store_get_type_id (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "eds") == 0) {
		const gchar* eds_name = NULL;
		FolksPersonaStore* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp3_ = store;
		_tmp4_ = folks_persona_store_get_id (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = contacts_lookup_esource_name_by_uid (_tmp5_);
		eds_name = _tmp6_;
		_tmp7_ = eds_name;
		if (_tmp7_ != NULL) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = eds_name;
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			return result;
		}
	}
	_tmp10_ = store;
	_tmp11_ = folks_persona_store_get_type_id (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp12_, "telepathy") == 0) {
		TpAccount* account = NULL;
		FolksPersonaStore* _tmp13_;
		TpAccount* _tmp14_;
		TpAccount* _tmp15_;
		TpAccount* _tmp16_;
		TpAccount* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp13_ = store;
		_tmp14_ = tpf_persona_store_get_account (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp13_) : NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = _g_object_ref0 (_tmp15_);
		account = _tmp16_;
		_tmp17_ = account;
		_tmp18_ = tp_account_get_service (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = contacts_contact_format_im_service (_tmp19_, NULL);
		result = _tmp20_;
		_g_object_unref0 (account);
		return result;
	}
	_tmp21_ = store;
	_tmp22_ = folks_persona_store_get_display_name (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup (_tmp23_);
	result = _tmp24_;
	return result;
}


gboolean contacts_contact_has_mainable_persona (ContactsContact* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FolksPersona* _tmp9_;
			FolksPersonaStore* _tmp10_;
			FolksPersonaStore* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp9_ = p;
			_tmp10_ = folks_persona_get_store (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = folks_persona_store_get_type_id (_tmp11_);
			_tmp13_ = _tmp12_;
			if (g_strcmp0 (_tmp13_, "eds") == 0) {
				FolksPersona* _tmp14_;
				gboolean _tmp15_;
				_tmp14_ = p;
				_tmp15_ = contacts_contact_persona_is_google_other (_tmp14_);
				_tmp8_ = !_tmp15_;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				result = TRUE;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = FALSE;
	return result;
}


static gboolean contacts_contact_non_linkable (ContactsContact* self) {
	gboolean result = FALSE;
	gboolean all_unlinkable = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	all_unlinkable = TRUE;
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			FolksPersona* _tmp9_;
			gboolean _tmp10_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp9_ = p;
			_tmp10_ = contacts_contact_persona_is_google_other (_tmp9_);
			if (!_tmp10_) {
				_tmp8_ = TRUE;
			} else {
				FolksPersona* _tmp11_;
				gboolean _tmp12_;
				_tmp11_ = p;
				_tmp12_ = contacts_contact_persona_is_google_profile (_tmp11_);
				_tmp8_ = _tmp12_;
			}
			if (_tmp8_) {
				all_unlinkable = FALSE;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	result = all_unlinkable;
	return result;
}


gboolean contacts_contact_suggest_link_to (ContactsContact* self, ContactsContact* other) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ContactsStore* _tmp4_;
	ContactsContact* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp1_ = contacts_contact_non_linkable (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		ContactsContact* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = other;
		_tmp3_ = contacts_contact_non_linkable (_tmp2_);
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->store;
	_tmp5_ = other;
	_tmp6_ = contacts_store_may_suggest_link (_tmp4_, self, _tmp5_);
	if (!_tmp6_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->is_main;
	if (!_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		ContactsContact* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = other;
		_tmp10_ = contacts_contact_has_mainable_persona (_tmp9_);
		_tmp7_ = !_tmp10_;
	}
	result = _tmp7_;
	return result;
}


static gboolean contacts_contact_persona_is_google (FolksPersona* persona) {
	gboolean result = FALSE;
	FolksPersonaStore* store = NULL;
	FolksPersona* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	gboolean _tmp4_ = FALSE;
	FolksPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_store (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	store = _tmp3_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_type_id (_tmp5_);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp7_, "eds") == 0) {
		FolksPersonaStore* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = store;
		_tmp9_ = folks_persona_store_get_id (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = contacts_esource_uid_is_google (_tmp10_);
		_tmp4_ = _tmp11_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		result = TRUE;
		_g_object_unref0 (store);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (store);
	return result;
}


/**
   * Return true only for personas which are in a Google address book, but which
   * are not in the user's "My Contacts" group in the address book.
   */
gboolean contacts_contact_persona_is_google_other (FolksPersona* persona) {
	gboolean result = FALSE;
	FolksPersona* _tmp0_;
	gboolean _tmp1_;
	EdsfPersona* p = NULL;
	FolksPersona* _tmp2_;
	EdsfPersona* _tmp3_;
	EdsfPersona* _tmp4_;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = contacts_contact_persona_is_google (_tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = persona;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, EDSF_TYPE_PERSONA) ? ((EdsfPersona*) _tmp2_) : NULL);
	p = _tmp3_;
	_tmp4_ = p;
	if (_tmp4_ != NULL) {
		EdsfPersona* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = p;
		_tmp6_ = edsf_persona_get_in_google_personal_group (_tmp5_);
		_tmp7_ = _tmp6_;
		result = !_tmp7_;
		_g_object_unref0 (p);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (p);
	return result;
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


gboolean contacts_contact_persona_is_google_profile (FolksPersona* persona) {
	gboolean result = FALSE;
	FolksPersona* _tmp0_;
	gboolean _tmp1_;
	FolksUrlDetails* u = NULL;
	FolksPersona* _tmp2_;
	FolksUrlDetails* _tmp3_;
	gboolean _tmp4_ = FALSE;
	FolksUrlDetails* _tmp5_;
	g_return_val_if_fail (persona != NULL, FALSE);
	_tmp0_ = persona;
	_tmp1_ = contacts_contact_persona_is_google_other (_tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = persona;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _tmp2_) : NULL);
	u = _tmp3_;
	_tmp5_ = u;
	if (_tmp5_ != NULL) {
		FolksUrlDetails* _tmp6_;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = u;
		_tmp7_ = folks_url_details_get_urls (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_ == 1;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		{
			GeeIterator* _url_it = NULL;
			FolksUrlDetails* _tmp11_;
			GeeSet* _tmp12_;
			GeeSet* _tmp13_;
			GeeIterator* _tmp14_;
			_tmp11_ = u;
			_tmp12_ = folks_url_details_get_urls (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = gee_iterable_iterator ((GeeIterable*) _tmp13_);
			_url_it = _tmp14_;
			while (TRUE) {
				GeeIterator* _tmp15_;
				gboolean _tmp16_;
				FolksUrlFieldDetails* url = NULL;
				GeeIterator* _tmp17_;
				gpointer _tmp18_;
				FolksUrlFieldDetails* _tmp19_;
				gconstpointer _tmp20_;
				const gchar* _tmp21_;
				gboolean _tmp22_;
				_tmp15_ = _url_it;
				_tmp16_ = gee_iterator_next (_tmp15_);
				if (!_tmp16_) {
					break;
				}
				_tmp17_ = _url_it;
				_tmp18_ = gee_iterator_get (_tmp17_);
				url = (FolksUrlFieldDetails*) _tmp18_;
				_tmp19_ = url;
				_tmp20_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_0, "https?:\\/\\/www.google.com\\/profiles\\/[0-9]+$", 0), (const gchar*) _tmp21_, 0, NULL);
				if (_tmp22_) {
					result = TRUE;
					_g_object_unref0 (url);
					_g_object_unref0 (_url_it);
					_g_object_unref0 (u);
					return result;
				}
				_g_object_unref0 (url);
			}
			_g_object_unref0 (_url_it);
		}
	}
	result = FALSE;
	_g_object_unref0 (u);
	return result;
}


gchar* contacts_contact_format_persona_store_name_for_contact (FolksPersona* persona) {
	gchar* result = NULL;
	FolksPersonaStore* store = NULL;
	FolksPersona* _tmp0_;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* _tmp2_;
	FolksPersonaStore* _tmp3_;
	FolksPersonaStore* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	FolksPersonaStore* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	FolksPersonaStore* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	g_return_val_if_fail (persona != NULL, NULL);
	_tmp0_ = persona;
	_tmp1_ = folks_persona_get_store (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	store = _tmp3_;
	_tmp4_ = store;
	_tmp5_ = folks_persona_store_get_type_id (_tmp4_);
	_tmp6_ = _tmp5_;
	if (g_strcmp0 (_tmp6_, "eds") == 0) {
		FolksPersona* _tmp7_;
		gboolean _tmp8_;
		const gchar* eds_name = NULL;
		FolksPersonaStore* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp7_ = persona;
		_tmp8_ = contacts_contact_persona_is_google_profile (_tmp7_);
		if (_tmp8_) {
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Google Circles"));
			result = _tmp9_;
			_g_object_unref0 (store);
			return result;
		} else {
			FolksPersona* _tmp10_;
			gboolean _tmp11_;
			_tmp10_ = persona;
			_tmp11_ = contacts_contact_persona_is_google_other (_tmp10_);
			if (_tmp11_) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup (_ ("Google"));
				result = _tmp12_;
				_g_object_unref0 (store);
				return result;
			}
		}
		_tmp13_ = store;
		_tmp14_ = folks_persona_store_get_id (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = contacts_lookup_esource_name_by_uid_for_contact (_tmp15_);
		eds_name = _tmp16_;
		_tmp17_ = eds_name;
		if (_tmp17_ != NULL) {
			const gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp18_ = eds_name;
			_tmp19_ = g_strdup (_tmp18_);
			result = _tmp19_;
			_g_object_unref0 (store);
			return result;
		}
	}
	_tmp20_ = store;
	_tmp21_ = folks_persona_store_get_type_id (_tmp20_);
	_tmp22_ = _tmp21_;
	if (g_strcmp0 (_tmp22_, "telepathy") == 0) {
		TpAccount* account = NULL;
		FolksPersonaStore* _tmp23_;
		TpAccount* _tmp24_;
		TpAccount* _tmp25_;
		TpAccount* _tmp26_;
		TpAccount* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp23_ = store;
		_tmp24_ = tpf_persona_store_get_account (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp23_) : NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = _g_object_ref0 (_tmp25_);
		account = _tmp26_;
		_tmp27_ = account;
		_tmp28_ = tp_account_get_service (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = contacts_contact_format_im_service (_tmp29_, NULL);
		result = _tmp30_;
		_g_object_unref0 (account);
		_g_object_unref0 (store);
		return result;
	}
	_tmp31_ = store;
	_tmp32_ = folks_persona_store_get_display_name (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strdup (_tmp33_);
	result = _tmp34_;
	_g_object_unref0 (store);
	return result;
}


static gint __lambda18_ (const gchar* a, const gchar* b) {
	gint result = 0;
	GeeHashMap* sorted_map = NULL;
	GeeHashMap* _tmp0_;
	gint i = 0;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* a_str = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* b_str = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gboolean _tmp11_ = FALSE;
	GeeHashMap* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	sorted_map = _tmp0_;
	i = 0;
	_tmp1_ = contacts_contact_sorted_properties;
	_tmp1__length1 = contacts_contact_sorted_properties_length1;
	{
		gchar** p_collection = NULL;
		gint p_collection_length1 = 0;
		gint _p_collection_size_ = 0;
		gint p_it = 0;
		p_collection = _tmp1_;
		p_collection_length1 = _tmp1__length1;
		for (p_it = 0; p_it < _tmp1__length1; p_it = p_it + 1) {
			gchar* _tmp2_;
			gchar* p = NULL;
			_tmp2_ = g_strdup (p_collection[p_it]);
			p = _tmp2_;
			{
				GeeHashMap* _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				_tmp3_ = sorted_map;
				_tmp4_ = p;
				_tmp5_ = i;
				i = _tmp5_ + 1;
				_tmp6_ = i;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, _tmp4_, _tmp6_);
				_g_free0 (p);
			}
		}
	}
	_tmp7_ = a;
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	a_str = _tmp8_;
	_tmp9_ = b;
	_tmp10_ = g_strdup ((const gchar*) _tmp9_);
	b_str = _tmp10_;
	_tmp12_ = sorted_map;
	_tmp13_ = a_str;
	_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, _tmp13_);
	if (_tmp14_) {
		GeeHashMap* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = sorted_map;
		_tmp16_ = b_str;
		_tmp17_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp15_, _tmp16_);
		_tmp11_ = _tmp17_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GeeHashMap* _tmp18_;
		const gchar* _tmp19_;
		gpointer _tmp20_;
		GeeHashMap* _tmp21_;
		const gchar* _tmp22_;
		gpointer _tmp23_;
		GeeHashMap* _tmp24_;
		const gchar* _tmp25_;
		gpointer _tmp26_;
		GeeHashMap* _tmp27_;
		const gchar* _tmp28_;
		gpointer _tmp29_;
		_tmp18_ = sorted_map;
		_tmp19_ = a_str;
		_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp18_, _tmp19_);
		_tmp21_ = sorted_map;
		_tmp22_ = b_str;
		_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp22_);
		if (((gint) ((gintptr) _tmp20_)) < ((gint) ((gintptr) _tmp23_))) {
			result = -1;
			_g_free0 (b_str);
			_g_free0 (a_str);
			_g_object_unref0 (sorted_map);
			return result;
		}
		_tmp24_ = sorted_map;
		_tmp25_ = a_str;
		_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
		_tmp27_ = sorted_map;
		_tmp28_ = b_str;
		_tmp29_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp27_, _tmp28_);
		if (((gint) ((gintptr) _tmp26_)) > ((gint) ((gintptr) _tmp29_))) {
			result = 1;
			_g_free0 (b_str);
			_g_free0 (a_str);
			_g_object_unref0 (sorted_map);
			return result;
		}
		result = 0;
		_g_free0 (b_str);
		_g_free0 (a_str);
		_g_object_unref0 (sorted_map);
		return result;
	} else {
		GeeHashMap* _tmp30_;
		const gchar* _tmp31_;
		gboolean _tmp32_;
		_tmp30_ = sorted_map;
		_tmp31_ = a_str;
		_tmp32_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp30_, _tmp31_);
		if (_tmp32_) {
			result = -1;
			_g_free0 (b_str);
			_g_free0 (a_str);
			_g_object_unref0 (sorted_map);
			return result;
		} else {
			GeeHashMap* _tmp33_;
			const gchar* _tmp34_;
			gboolean _tmp35_;
			_tmp33_ = sorted_map;
			_tmp34_ = b_str;
			_tmp35_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp33_, _tmp34_);
			if (_tmp35_) {
				result = 1;
				_g_free0 (b_str);
				_g_free0 (a_str);
				_g_object_unref0 (sorted_map);
				return result;
			} else {
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				_tmp36_ = a_str;
				_tmp37_ = b_str;
				if (g_strcmp0 (_tmp36_, _tmp37_) < 0) {
					result = -1;
					_g_free0 (b_str);
					_g_free0 (a_str);
					_g_object_unref0 (sorted_map);
					return result;
				}
				_tmp38_ = a_str;
				_tmp39_ = b_str;
				if (g_strcmp0 (_tmp38_, _tmp39_) > 0) {
					result = 1;
					_g_free0 (b_str);
					_g_free0 (a_str);
					_g_object_unref0 (sorted_map);
					return result;
				}
				result = 0;
				_g_free0 (b_str);
				_g_free0 (a_str);
				_g_object_unref0 (sorted_map);
				return result;
			}
		}
	}
	_g_free0 (b_str);
	_g_free0 (a_str);
	_g_object_unref0 (sorted_map);
}


static gint ___lambda18__gcompare_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gint result;
	result = __lambda18_ ((const gchar*) a, (const gchar*) b);
	return result;
}


gchar** contacts_contact_sort_persona_properties (gchar** props, int props_length1, int* result_length1) {
	gchar** result = NULL;
	GCompareDataFunc compare_properties = NULL;
	void* compare_properties_target;
	GDestroyNotify compare_properties_target_destroy_notify;
	GeeArrayList* sorted_props = NULL;
	GeeArrayList* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GeeArrayList* _tmp5_;
	GCompareDataFunc _tmp6_;
	void* _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	GeeArrayList* _tmp7_;
	gint _tmp8_;
	gpointer* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	compare_properties = ___lambda18__gcompare_data_func;
	compare_properties_target = NULL;
	compare_properties_target_destroy_notify = NULL;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	sorted_props = _tmp0_;
	_tmp1_ = props;
	_tmp1__length1 = props_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _tmp1__length1;
		for (s_it = 0; s_it < _tmp1__length1; s_it = s_it + 1) {
			gchar* _tmp2_;
			gchar* s = NULL;
			_tmp2_ = g_strdup (s_collection[s_it]);
			s = _tmp2_;
			{
				GeeArrayList* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = sorted_props;
				_tmp4_ = s;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, _tmp4_);
				_g_free0 (s);
			}
		}
	}
	_tmp5_ = sorted_props;
	_tmp6_ = compare_properties;
	_tmp6__target = compare_properties_target;
	_tmp6__target_destroy_notify = compare_properties_target_destroy_notify;
	compare_properties = NULL;
	compare_properties_target = NULL;
	compare_properties_target_destroy_notify = NULL;
	gee_list_sort ((GeeList*) _tmp5_, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify);
	_tmp7_ = sorted_props;
	_tmp9_ = gee_collection_to_array ((GeeCollection*) _tmp7_, &_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	_g_object_unref0 (sorted_props);
	(compare_properties_target_destroy_notify == NULL) ? NULL : (compare_properties_target_destroy_notify (compare_properties_target), NULL);
	compare_properties = NULL;
	compare_properties_target = NULL;
	compare_properties_target_destroy_notify = NULL;
	return result;
}


static void contacts_contact_set_individual_property_data_free (gpointer _data) {
	ContactsContactSetIndividualPropertyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->contact);
	_g_free0 (_data_->property_name);
	G_IS_VALUE (&_data_->value) ? (g_value_unset (&_data_->value), NULL) : NULL;
	_g_object_unref0 (_data_->result);
	g_slice_free (ContactsContactSetIndividualPropertyData, _data_);
}


void contacts_contact_set_individual_property (ContactsContact* contact, const gchar* property_name, GValue* value, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactSetIndividualPropertyData* _data_;
	ContactsContact* _tmp0_;
	ContactsContact* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GValue _tmp4_;
	GValue _tmp5_ = {0};
	_data_ = g_slice_new0 (ContactsContactSetIndividualPropertyData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_set_individual_property_data_free);
	_tmp0_ = contact;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->contact);
	_data_->contact = _tmp1_;
	_tmp2_ = property_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp3_;
	_tmp4_ = *value;
	if (G_IS_VALUE (&_tmp4_)) {
		g_value_init (&_tmp5_, G_VALUE_TYPE (&_tmp4_));
		g_value_copy (&_tmp4_, &_tmp5_);
	} else {
		_tmp5_ = _tmp4_;
	}
	G_IS_VALUE (&_data_->value) ? (g_value_unset (&_data_->value), NULL) : NULL;
	_data_->value = _tmp5_;
	contacts_contact_set_individual_property_co (_data_);
}


FolksPersona* contacts_contact_set_individual_property_finish (GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsContactSetIndividualPropertyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean _vala_string_array_contains (gchar* * stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void contacts_contact_set_individual_property_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsContactSetIndividualPropertyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_set_individual_property_co (_data_);
}


static gboolean contacts_contact_set_individual_property_co (ContactsContactSetIndividualPropertyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->did_set = FALSE;
	_data_->_tmp0_ = _data_->contact;
	_data_->_tmp1_ = _data_->_tmp0_->individual;
	_data_->_tmp2_ = folks_individual_get_personas (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp5_ = gee_collection_to_array ((GeeCollection*) _data_->_tmp3_, &_data_->_tmp4_);
	_data_->personas_copy = _data_->_tmp5_;
	_data_->personas_copy_length1 = _data_->_tmp4_;
	_data_->_personas_copy_size_ = _data_->personas_copy_length1;
	_data_->_tmp6_ = _data_->personas_copy;
	_data_->_tmp6__length1 = _data_->personas_copy_length1;
	{
		_data_->p_collection_length1 = 0;
		_data_->_p_collection_size_ = 0;
		_data_->p_collection = _data_->_tmp6_;
		_data_->p_collection_length1 = _data_->_tmp6__length1;
		for (_data_->p_it = 0; _data_->p_it < _data_->_tmp6__length1; _data_->p_it = _data_->p_it + 1) {
			_data_->_tmp7_ = _g_object_ref0 (_data_->p_collection[_data_->p_it]);
			_data_->p = _data_->_tmp7_;
			{
				_data_->_tmp8_ = _data_->property_name;
				_data_->_tmp9_ = _data_->p;
				_data_->_tmp10_ = folks_persona_get_writeable_properties (_data_->_tmp9_, &_data_->_tmp10__length1);
				_data_->_tmp11_ = _data_->_tmp10_;
				_data_->_tmp11__length1 = _data_->_tmp10__length1;
				if (_vala_string_array_contains (_data_->_tmp11_, _data_->_tmp11__length1, _data_->_tmp8_)) {
					_data_->did_set = TRUE;
					_data_->_tmp12_ = _data_->p;
					_data_->_tmp13_ = _data_->property_name;
					_data_->_tmp14_ = _data_->value;
					_data_->_state_ = 1;
					contacts_contact_set_persona_property (_data_->_tmp12_, _data_->_tmp13_, &_data_->_tmp14_, contacts_contact_set_individual_property_ready, _data_);
					return FALSE;
					_state_1:
					contacts_contact_set_persona_property_finish (_data_->_res_, &_data_->_inner_error_);
					if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						_g_object_unref0 (_data_->p);
						_data_->personas_copy = (_vala_array_free (_data_->personas_copy, _data_->personas_copy_length1, (GDestroyNotify) g_object_unref), NULL);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_g_object_unref0 (_data_->p);
			}
		}
	}
	_data_->_tmp15_ = _data_->did_set;
	if (!_data_->_tmp15_) {
		_data_->_tmp16_ = _data_->contact;
		_data_->_tmp17_ = contacts_fake_persona_new (_data_->_tmp16_);
		_data_->fake = _data_->_tmp17_;
		_data_->_tmp19_ = _data_->fake;
		_data_->_tmp20_ = _data_->property_name;
		_data_->_tmp21_ = _data_->value;
		_data_->_state_ = 2;
		contacts_fake_persona_make_real_and_set (_data_->_tmp19_, _data_->_tmp20_, &_data_->_tmp21_, contacts_contact_set_individual_property_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp22_ = contacts_fake_persona_make_real_and_set_finish (_data_->_tmp19_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp18_ = _data_->_tmp22_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
			_g_object_unref0 (_data_->fake);
			_data_->personas_copy = (_vala_array_free (_data_->personas_copy, _data_->personas_copy_length1, (GDestroyNotify) g_object_unref), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp23_ = _data_->_tmp18_;
		_data_->_tmp18_ = NULL;
		_data_->result = _data_->_tmp23_;
		_g_object_unref0 (_data_->_tmp18_);
		_g_object_unref0 (_data_->fake);
		_data_->personas_copy = (_vala_array_free (_data_->personas_copy, _data_->personas_copy_length1, (GDestroyNotify) g_object_unref), NULL);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	_data_->personas_copy = (_vala_array_free (_data_->personas_copy, _data_->personas_copy_length1, (GDestroyNotify) g_object_unref), NULL);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


TpAccount* contacts_contact_is_callable (ContactsContact* self, const gchar* proto, const gchar* id) {
	TpAccount* result = NULL;
	TpfPersona* t_persona = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	TpfPersona* _tmp2_;
	gboolean _tmp3_ = FALSE;
	TpfPersona* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (proto != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = proto;
	_tmp1_ = id;
	_tmp2_ = contacts_contact_find_im_persona (self, _tmp0_, _tmp1_);
	t_persona = _tmp2_;
	_tmp4_ = t_persona;
	if (_tmp4_ != NULL) {
		TpfPersona* _tmp5_;
		TpContact* _tmp6_;
		TpContact* _tmp7_;
		_tmp5_ = t_persona;
		_tmp6_ = tpf_persona_get_contact (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		TpCapabilities* caps = NULL;
		TpfPersona* _tmp8_;
		TpContact* _tmp9_;
		TpContact* _tmp10_;
		TpCapabilities* _tmp11_;
		TpCapabilities* _tmp12_;
		gboolean _tmp13_;
		_tmp8_ = t_persona;
		_tmp9_ = tpf_persona_get_contact (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = tp_contact_get_capabilities (_tmp10_);
		caps = _tmp11_;
		_tmp12_ = caps;
		_tmp13_ = tp_capabilities_supports_audio_call (_tmp12_, TP_HANDLE_TYPE_CONTACT);
		if (_tmp13_) {
			TpfPersona* _tmp14_;
			FolksPersonaStore* _tmp15_;
			FolksPersonaStore* _tmp16_;
			TpAccount* _tmp17_;
			TpAccount* _tmp18_;
			TpAccount* _tmp19_;
			_tmp14_ = t_persona;
			_tmp15_ = folks_persona_get_store ((FolksPersona*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = tpf_persona_store_get_account (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, TPF_TYPE_PERSONA_STORE) ? ((TpfPersonaStore*) _tmp16_) : NULL);
			_tmp18_ = _tmp17_;
			_tmp19_ = _g_object_ref0 (_tmp18_);
			result = _tmp19_;
			_g_object_unref0 (t_persona);
			return result;
		}
	}
	result = NULL;
	_g_object_unref0 (t_persona);
	return result;
}


static void contacts_contact_create_primary_persona_for_details_data_free (gpointer _data) {
	ContactsContactCreatePrimaryPersonaForDetailsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->store);
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	g_slice_free (ContactsContactCreatePrimaryPersonaForDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void contacts_contact_create_primary_persona_for_details (FolksPersonaStore* store, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactCreatePrimaryPersonaForDetailsData* _data_;
	FolksPersonaStore* _tmp0_;
	FolksPersonaStore* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	_data_ = g_slice_new0 (ContactsContactCreatePrimaryPersonaForDetailsData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_create_primary_persona_for_details_data_free);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->store);
	_data_->store = _tmp1_;
	_tmp2_ = details;
	_tmp3_ = _g_hash_table_ref0 (_tmp2_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp3_;
	contacts_contact_create_primary_persona_for_details_co (_data_);
}


FolksPersona* contacts_contact_create_primary_persona_for_details_finish (GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsContactCreatePrimaryPersonaForDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void contacts_contact_create_primary_persona_for_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsContactCreatePrimaryPersonaForDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_create_primary_persona_for_details_co (_data_);
}


static gboolean contacts_contact_create_primary_persona_for_details_co (ContactsContactCreatePrimaryPersonaForDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->store;
	_data_->_tmp1_ = _data_->details;
	_data_->_state_ = 1;
	folks_persona_store_add_persona_from_details (_data_->_tmp0_, _data_->_tmp1_, contacts_contact_create_primary_persona_for_details_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = folks_persona_store_add_persona_from_details_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error_);
	_data_->p = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->p;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_contact_set_persona_property_data_free (gpointer _data) {
	ContactsContactSetPersonaPropertyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->property_name);
	G_IS_VALUE (&_data_->new_value) ? (g_value_unset (&_data_->new_value), NULL) : NULL;
	g_slice_free (ContactsContactSetPersonaPropertyData, _data_);
}


void contacts_contact_set_persona_property (FolksPersona* persona, const gchar* property_name, GValue* new_value, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsContactSetPersonaPropertyData* _data_;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GValue _tmp4_;
	GValue _tmp5_ = {0};
	_data_ = g_slice_new0 (ContactsContactSetPersonaPropertyData);
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_contact_set_persona_property_data_free);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp1_;
	_tmp2_ = property_name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->property_name);
	_data_->property_name = _tmp3_;
	_tmp4_ = *new_value;
	if (G_IS_VALUE (&_tmp4_)) {
		g_value_init (&_tmp5_, G_VALUE_TYPE (&_tmp4_));
		g_value_copy (&_tmp4_, &_tmp5_);
	} else {
		_tmp5_ = _tmp4_;
	}
	G_IS_VALUE (&_data_->new_value) ? (g_value_unset (&_data_->new_value), NULL) : NULL;
	_data_->new_value = _tmp5_;
	contacts_contact_set_persona_property_co (_data_);
}


void contacts_contact_set_persona_property_finish (GAsyncResult* _res_, GError** error) {
	ContactsContactSetPersonaPropertyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static void contacts_contact_set_persona_property_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsContactSetPersonaPropertyData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_contact_set_persona_property_co (_data_);
}


static gboolean contacts_contact_set_persona_property_co (ContactsContactSetPersonaPropertyData* _data_) {
	static GQuark _tmp10_label0 = 0;
	static GQuark _tmp10_label1 = 0;
	static GQuark _tmp10_label2 = 0;
	static GQuark _tmp10_label3 = 0;
	static GQuark _tmp10_label4 = 0;
	static GQuark _tmp10_label5 = 0;
	static GQuark _tmp10_label6 = 0;
	static GQuark _tmp10_label7 = 0;
	static GQuark _tmp10_label8 = 0;
	static GQuark _tmp10_label9 = 0;
	static GQuark _tmp10_label10 = 0;
	static GQuark _tmp10_label11 = 0;
	static GQuark _tmp10_label12 = 0;
	static GQuark _tmp10_label13 = 0;
	static GQuark _tmp10_label14 = 0;
	static GQuark _tmp10_label15 = 0;
	static GQuark _tmp10_label16 = 0;
	static GQuark _tmp10_label17 = 0;
	static GQuark _tmp10_label18 = 0;
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		case 7:
		goto _state_7;
		case 8:
		goto _state_8;
		case 9:
		goto _state_9;
		case 10:
		goto _state_10;
		case 11:
		goto _state_11;
		case 12:
		goto _state_12;
		case 13:
		goto _state_13;
		case 14:
		goto _state_14;
		case 15:
		goto _state_15;
		case 16:
		goto _state_16;
		case 17:
		goto _state_17;
		case 18:
		goto _state_18;
		case 19:
		goto _state_19;
		case 20:
		goto _state_20;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp0_, CONTACTS_TYPE_FAKE_PERSONA)) {
		_data_->_tmp1_ = _data_->persona;
		_data_->_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, CONTACTS_TYPE_FAKE_PERSONA) ? ((ContactsFakePersona*) _data_->_tmp1_) : NULL);
		_data_->fake = _data_->_tmp2_;
		_data_->_tmp3_ = _data_->fake;
		_data_->_tmp4_ = _data_->property_name;
		_data_->_tmp5_ = _data_->new_value;
		_data_->_state_ = 1;
		contacts_fake_persona_make_real_and_set (_data_->_tmp3_, _data_->_tmp4_, &_data_->_tmp5_, contacts_contact_set_persona_property_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp6_ = contacts_fake_persona_make_real_and_set_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp7_ = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp7_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_g_object_unref0 (_data_->fake);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_g_object_unref0 (_data_->fake);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_g_object_unref0 (_data_->fake);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->property_name;
	_data_->_tmp11_ = 0U;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp11_ = (NULL == _data_->_tmp9_) ? 0 : g_quark_from_string (_data_->_tmp9_);
	if (_data_->_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("alias")))) {
		switch (0) {
			default:
			{
				_data_->_tmp12_ = _data_->persona;
				_data_->_tmp13_ = _data_->new_value;
				_data_->_state_ = 2;
				folks_alias_details_change_alias (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, FOLKS_TYPE_ALIAS_DETAILS) ? ((FolksAliasDetails*) _data_->_tmp12_) : NULL, g_value_get_string (&_data_->_tmp13_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_2:
				folks_alias_details_change_alias_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp12_, FOLKS_TYPE_ALIAS_DETAILS) ? ((FolksAliasDetails*) _data_->_tmp12_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("avatar")))) {
		switch (0) {
			default:
			{
				_data_->_tmp14_ = _data_->persona;
				_data_->_tmp15_ = _data_->new_value;
				_data_->_state_ = 3;
				folks_avatar_details_change_avatar (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _data_->_tmp14_) : NULL, g_value_get_object (&_data_->_tmp15_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_3:
				folks_avatar_details_change_avatar_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp14_, FOLKS_TYPE_AVATAR_DETAILS) ? ((FolksAvatarDetails*) _data_->_tmp14_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("birthday")))) {
		switch (0) {
			default:
			{
				_data_->_tmp16_ = _data_->persona;
				_data_->_tmp17_ = _data_->new_value;
				_data_->_state_ = 4;
				folks_birthday_details_change_birthday (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _data_->_tmp16_) : NULL, g_value_get_boxed (&_data_->_tmp17_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_4:
				folks_birthday_details_change_birthday_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp16_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _data_->_tmp16_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("calendar-event-id")))) {
		switch (0) {
			default:
			{
				_data_->_tmp18_ = _data_->persona;
				_data_->_tmp19_ = _data_->new_value;
				_data_->_state_ = 5;
				folks_birthday_details_change_calendar_event_id (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _data_->_tmp18_) : NULL, g_value_get_string (&_data_->_tmp19_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_5:
				folks_birthday_details_change_calendar_event_id_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp18_, FOLKS_TYPE_BIRTHDAY_DETAILS) ? ((FolksBirthdayDetails*) _data_->_tmp18_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("email-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp20_ = _data_->persona;
				_data_->_tmp21_ = _data_->new_value;
				_data_->_state_ = 6;
				folks_email_details_change_email_addresses (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _data_->_tmp20_) : NULL, g_value_get_object (&_data_->_tmp21_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_6:
				folks_email_details_change_email_addresses_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp20_, FOLKS_TYPE_EMAIL_DETAILS) ? ((FolksEmailDetails*) _data_->_tmp20_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("is-favourite")))) {
		switch (0) {
			default:
			{
				_data_->_tmp22_ = _data_->persona;
				_data_->_tmp23_ = _data_->new_value;
				_data_->_state_ = 7;
				folks_favourite_details_change_is_favourite (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp22_, FOLKS_TYPE_FAVOURITE_DETAILS) ? ((FolksFavouriteDetails*) _data_->_tmp22_) : NULL, g_value_get_boolean (&_data_->_tmp23_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_7:
				folks_favourite_details_change_is_favourite_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp22_, FOLKS_TYPE_FAVOURITE_DETAILS) ? ((FolksFavouriteDetails*) _data_->_tmp22_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label6) ? _tmp10_label6 : (_tmp10_label6 = g_quark_from_static_string ("gender")))) {
		switch (0) {
			default:
			{
				_data_->_tmp24_ = _data_->persona;
				_data_->_tmp25_ = _data_->new_value;
				_data_->_state_ = 8;
				folks_gender_details_change_gender (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp24_, FOLKS_TYPE_GENDER_DETAILS) ? ((FolksGenderDetails*) _data_->_tmp24_) : NULL, g_value_get_enum (&_data_->_tmp25_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_8:
				folks_gender_details_change_gender_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp24_, FOLKS_TYPE_GENDER_DETAILS) ? ((FolksGenderDetails*) _data_->_tmp24_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label7) ? _tmp10_label7 : (_tmp10_label7 = g_quark_from_static_string ("groups")))) {
		switch (0) {
			default:
			{
				_data_->_tmp26_ = _data_->persona;
				_data_->_tmp27_ = _data_->new_value;
				_data_->_state_ = 9;
				folks_group_details_change_groups (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, FOLKS_TYPE_GROUP_DETAILS) ? ((FolksGroupDetails*) _data_->_tmp26_) : NULL, g_value_get_object (&_data_->_tmp27_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_9:
				folks_group_details_change_groups_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp26_, FOLKS_TYPE_GROUP_DETAILS) ? ((FolksGroupDetails*) _data_->_tmp26_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label8) ? _tmp10_label8 : (_tmp10_label8 = g_quark_from_static_string ("im-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp28_ = _data_->persona;
				_data_->_tmp29_ = _data_->new_value;
				_data_->_state_ = 10;
				folks_im_details_change_im_addresses (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp28_, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) _data_->_tmp28_) : NULL, g_value_get_object (&_data_->_tmp29_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_10:
				folks_im_details_change_im_addresses_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp28_, FOLKS_TYPE_IM_DETAILS) ? ((FolksImDetails*) _data_->_tmp28_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label9) ? _tmp10_label9 : (_tmp10_label9 = g_quark_from_static_string ("local-ids")))) {
		switch (0) {
			default:
			{
				_data_->_tmp30_ = _data_->persona;
				_data_->_tmp31_ = _data_->new_value;
				_data_->_state_ = 11;
				folks_local_id_details_change_local_ids (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, FOLKS_TYPE_LOCAL_ID_DETAILS) ? ((FolksLocalIdDetails*) _data_->_tmp30_) : NULL, g_value_get_object (&_data_->_tmp31_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_11:
				folks_local_id_details_change_local_ids_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp30_, FOLKS_TYPE_LOCAL_ID_DETAILS) ? ((FolksLocalIdDetails*) _data_->_tmp30_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label10) ? _tmp10_label10 : (_tmp10_label10 = g_quark_from_static_string ("structured-name")))) {
		switch (0) {
			default:
			{
				_data_->_tmp32_ = _data_->persona;
				_data_->_tmp33_ = _data_->new_value;
				_data_->_state_ = 12;
				folks_name_details_change_structured_name (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp32_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp32_) : NULL, g_value_get_object (&_data_->_tmp33_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_12:
				folks_name_details_change_structured_name_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp32_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp32_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label11) ? _tmp10_label11 : (_tmp10_label11 = g_quark_from_static_string ("full-name")))) {
		switch (0) {
			default:
			{
				_data_->_tmp34_ = _data_->persona;
				_data_->_tmp35_ = _data_->new_value;
				_data_->_state_ = 13;
				folks_name_details_change_full_name (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp34_) : NULL, g_value_get_string (&_data_->_tmp35_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_13:
				folks_name_details_change_full_name_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp34_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp34_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label12) ? _tmp10_label12 : (_tmp10_label12 = g_quark_from_static_string ("nickname")))) {
		switch (0) {
			default:
			{
				_data_->_tmp36_ = _data_->persona;
				_data_->_tmp37_ = _data_->new_value;
				_data_->_state_ = 14;
				folks_name_details_change_nickname (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp36_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp36_) : NULL, g_value_get_string (&_data_->_tmp37_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_14:
				folks_name_details_change_nickname_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp36_, FOLKS_TYPE_NAME_DETAILS) ? ((FolksNameDetails*) _data_->_tmp36_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label13) ? _tmp10_label13 : (_tmp10_label13 = g_quark_from_static_string ("notes")))) {
		switch (0) {
			default:
			{
				_data_->_tmp38_ = _data_->persona;
				_data_->_tmp39_ = _data_->new_value;
				_data_->_state_ = 15;
				folks_note_details_change_notes (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp38_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _data_->_tmp38_) : NULL, g_value_get_object (&_data_->_tmp39_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_15:
				folks_note_details_change_notes_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp38_, FOLKS_TYPE_NOTE_DETAILS) ? ((FolksNoteDetails*) _data_->_tmp38_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label14) ? _tmp10_label14 : (_tmp10_label14 = g_quark_from_static_string ("phone-numbers")))) {
		switch (0) {
			default:
			{
				_data_->_tmp40_ = _data_->persona;
				_data_->_tmp41_ = _data_->new_value;
				_data_->_state_ = 16;
				folks_phone_details_change_phone_numbers (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp40_, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) _data_->_tmp40_) : NULL, g_value_get_object (&_data_->_tmp41_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_16:
				folks_phone_details_change_phone_numbers_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp40_, FOLKS_TYPE_PHONE_DETAILS) ? ((FolksPhoneDetails*) _data_->_tmp40_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label15) ? _tmp10_label15 : (_tmp10_label15 = g_quark_from_static_string ("postal-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp42_ = _data_->persona;
				_data_->_tmp43_ = _data_->new_value;
				_data_->_state_ = 17;
				folks_postal_address_details_change_postal_addresses (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp42_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) _data_->_tmp42_) : NULL, g_value_get_object (&_data_->_tmp43_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_17:
				folks_postal_address_details_change_postal_addresses_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp42_, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS) ? ((FolksPostalAddressDetails*) _data_->_tmp42_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label16) ? _tmp10_label16 : (_tmp10_label16 = g_quark_from_static_string ("roles")))) {
		switch (0) {
			default:
			{
				_data_->_tmp44_ = _data_->persona;
				_data_->_tmp45_ = _data_->new_value;
				_data_->_state_ = 18;
				folks_role_details_change_roles (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp44_, FOLKS_TYPE_ROLE_DETAILS) ? ((FolksRoleDetails*) _data_->_tmp44_) : NULL, g_value_get_object (&_data_->_tmp45_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_18:
				folks_role_details_change_roles_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp44_, FOLKS_TYPE_ROLE_DETAILS) ? ((FolksRoleDetails*) _data_->_tmp44_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label17) ? _tmp10_label17 : (_tmp10_label17 = g_quark_from_static_string ("urls")))) {
		switch (0) {
			default:
			{
				_data_->_tmp46_ = _data_->persona;
				_data_->_tmp47_ = _data_->new_value;
				_data_->_state_ = 19;
				folks_url_details_change_urls (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp46_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _data_->_tmp46_) : NULL, g_value_get_object (&_data_->_tmp47_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_19:
				folks_url_details_change_urls_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp46_, FOLKS_TYPE_URL_DETAILS) ? ((FolksUrlDetails*) _data_->_tmp46_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else if (_data_->_tmp11_ == ((0 != _tmp10_label18) ? _tmp10_label18 : (_tmp10_label18 = g_quark_from_static_string ("web-service-addresses")))) {
		switch (0) {
			default:
			{
				_data_->_tmp48_ = _data_->persona;
				_data_->_tmp49_ = _data_->new_value;
				_data_->_state_ = 20;
				folks_web_service_details_change_web_service_addresses (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp48_, FOLKS_TYPE_WEB_SERVICE_DETAILS) ? ((FolksWebServiceDetails*) _data_->_tmp48_) : NULL, g_value_get_object (&_data_->_tmp49_), contacts_contact_set_persona_property_ready, _data_);
				return FALSE;
				_state_20:
				folks_web_service_details_change_web_service_addresses_finish (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp48_, FOLKS_TYPE_WEB_SERVICE_DETAILS) ? ((FolksWebServiceDetails*) _data_->_tmp48_) : NULL, _data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if ((((_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) || (_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR)) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_data_->_tmp50_ = _data_->property_name;
				g_critical ("contacts-contact.vala:1059: Unknown property '%s' in Contact.set_perso" \
"na_property().", _data_->_tmp50_);
				break;
			}
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ContactsContact* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->w);
		(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
		_data2_->callback = NULL;
		_data2_->callback_target = NULL;
		_data2_->callback_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda19_ (Block2Data* _data2_) {
	ContactsContact* self;
	GtkCallback _tmp0_;
	void* _tmp0__target;
	GtkWidget* _tmp1_;
	self = _data2_->self;
	_tmp0_ = _data2_->callback;
	_tmp0__target = _data2_->callback_target;
	_tmp1_ = _data2_->w;
	_tmp0_ (_tmp1_, _tmp0__target);
}


static void ___lambda19__contacts_contact_changed (ContactsContact* _sender, gpointer self) {
	__lambda19_ (self);
}


static void __lambda20_ (Block2Data* _data2_) {
	ContactsContact* self;
	self = _data2_->self;
	g_signal_handler_disconnect ((GObject*) self, _data2_->id);
}


static void ___lambda20__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
	__lambda20_ (self);
}


void contacts_contact_keep_widget_uptodate (ContactsContact* self, GtkWidget* w, GtkCallback callback, void* callback_target, GDestroyNotify callback_target_destroy_notify) {
	Block2Data* _data2_;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkCallback _tmp2_;
	void* _tmp2__target;
	GtkCallback _tmp3_;
	void* _tmp3__target;
	GtkWidget* _tmp4_;
	gulong _tmp5_;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = w;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->w);
	_data2_->w = _tmp1_;
	_tmp2_ = callback;
	_tmp2__target = callback_target;
	(_data2_->callback_target_destroy_notify == NULL) ? NULL : (_data2_->callback_target_destroy_notify (_data2_->callback_target), NULL);
	_data2_->callback = NULL;
	_data2_->callback_target = NULL;
	_data2_->callback_target_destroy_notify = NULL;
	_data2_->callback = _tmp2_;
	_data2_->callback_target = _tmp2__target;
	_data2_->callback_target_destroy_notify = callback_target_destroy_notify;
	_tmp3_ = _data2_->callback;
	_tmp3__target = _data2_->callback_target;
	_tmp4_ = _data2_->w;
	_tmp3_ (_tmp4_, _tmp3__target);
	_tmp5_ = g_signal_connect_data (self, "changed", (GCallback) ___lambda19__contacts_contact_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_data2_->id = _tmp5_;
	_tmp6_ = _data2_->w;
	g_signal_connect_data (_tmp6_, "destroy", (GCallback) ___lambda20__gtk_widget_destroy, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


void contacts_contact_fetch_contact_info (ContactsContact* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _p_it = NULL;
		FolksIndividual* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = self->individual;
		_tmp1_ = folks_individual_get_personas (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_p_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			TpfPersona* tp = NULL;
			FolksPersona* _tmp8_;
			TpfPersona* _tmp9_;
			TpfPersona* _tmp10_;
			_tmp4_ = _p_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _p_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			p = (FolksPersona*) _tmp7_;
			_tmp8_ = p;
			_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TPF_TYPE_PERSONA) ? ((TpfPersona*) _tmp8_) : NULL);
			tp = _tmp9_;
			_tmp10_ = tp;
			if (_tmp10_ != NULL) {
				TpfPersona* _tmp11_;
				TpContact* _tmp12_;
				TpContact* _tmp13_;
				_tmp11_ = tp;
				_tmp12_ = tpf_persona_get_contact (_tmp11_);
				_tmp13_ = _tmp12_;
				tp_contact_request_contact_info_async (_tmp13_, NULL, NULL, NULL);
			}
			_g_object_unref0 (tp);
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
}


GdkPixbuf* contacts_contact_get_small_avatar (ContactsContact* self) {
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_small_avatar;
	if (_tmp0_ == NULL) {
		GdkPixbuf* pixbuf = NULL;
		FolksIndividual* _tmp1_;
		GLoadableIcon* _tmp2_;
		GLoadableIcon* _tmp3_;
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp1_ = self->individual;
		_tmp2_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = contacts_contact_load_icon (self, _tmp3_, CONTACTS_CONTACT_SMALL_AVATAR_SIZE);
		pixbuf = _tmp4_;
		_tmp5_ = pixbuf;
		if (_tmp5_ == NULL) {
			GdkPixbuf* _tmp6_;
			_tmp6_ = contacts_contact_draw_fallback_avatar (CONTACTS_CONTACT_SMALL_AVATAR_SIZE, self);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp6_;
		}
		_tmp7_ = pixbuf;
		_tmp8_ = contacts_contact_frame_icon (_tmp7_);
		_g_object_unref0 (self->priv->_small_avatar);
		self->priv->_small_avatar = _tmp8_;
		_g_object_unref0 (pixbuf);
	}
	_tmp9_ = self->priv->_small_avatar;
	result = _tmp9_;
	return result;
}


GVariant* contacts_contact_get_avatar_icon_data (ContactsContact* self) {
	GVariant* result;
	FolksIndividual* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->individual;
	_tmp1_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->_avatar_icon_data;
	if (_tmp3_ == NULL) {
		GdkPixbuf* _tmp4_;
		GdkPixbuf* _tmp5_;
		GdkPixbuf* _tmp6_;
		GdkPixbuf* _tmp7_;
		GVariant* _tmp8_;
		_tmp4_ = contacts_contact_get_small_avatar (self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ == NULL) {
			result = NULL;
			return result;
		}
		_tmp6_ = contacts_contact_get_small_avatar (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_icon_serialize ((GIcon*) _tmp7_);
		_g_variant_unref0 (self->priv->_avatar_icon_data);
		self->priv->_avatar_icon_data = _tmp8_;
	}
	_tmp9_ = self->priv->_avatar_icon_data;
	result = _tmp9_;
	return result;
}


const gchar* contacts_contact_get_display_name (ContactsContact* self) {
	const gchar* result;
	const gchar* name = NULL;
	FolksIndividual* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	const gchar* alias = NULL;
	FolksIndividual* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	const gchar* nickname = NULL;
	FolksIndividual* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->individual;
	_tmp1_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = contacts_is_set (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		_tmp5_ = name;
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->individual;
	_tmp7_ = folks_alias_details_get_alias ((FolksAliasDetails*) _tmp6_);
	_tmp8_ = _tmp7_;
	alias = _tmp8_;
	_tmp9_ = alias;
	_tmp10_ = contacts_is_set (_tmp9_);
	if (_tmp10_) {
		const gchar* _tmp11_;
		_tmp11_ = alias;
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->individual;
	_tmp13_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp12_);
	_tmp14_ = _tmp13_;
	nickname = _tmp14_;
	_tmp15_ = nickname;
	_tmp16_ = contacts_is_set (_tmp15_);
	if (_tmp16_) {
		const gchar* _tmp17_;
		_tmp17_ = nickname;
		result = _tmp17_;
		return result;
	}
	{
		GeeIterator* _email_it = NULL;
		FolksIndividual* _tmp18_;
		GeeSet* _tmp19_;
		GeeSet* _tmp20_;
		GeeIterator* _tmp21_;
		_tmp18_ = self->individual;
		_tmp19_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_email_it = _tmp21_;
		while (TRUE) {
			GeeIterator* _tmp22_;
			gboolean _tmp23_;
			FolksEmailFieldDetails* email = NULL;
			GeeIterator* _tmp24_;
			gpointer _tmp25_;
			gchar* e = NULL;
			FolksEmailFieldDetails* _tmp26_;
			gconstpointer _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_;
			_tmp22_ = _email_it;
			_tmp23_ = gee_iterator_next (_tmp22_);
			if (!_tmp23_) {
				break;
			}
			_tmp24_ = _email_it;
			_tmp25_ = gee_iterator_get (_tmp24_);
			email = (FolksEmailFieldDetails*) _tmp25_;
			_tmp26_ = email;
			_tmp27_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strdup ((const gchar*) _tmp28_);
			e = _tmp29_;
			_tmp30_ = e;
			_tmp31_ = contacts_is_set (_tmp30_);
			if (_tmp31_) {
				FolksEmailFieldDetails* _tmp32_;
				gconstpointer _tmp33_;
				const gchar* _tmp34_;
				_tmp32_ = email;
				_tmp33_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp32_);
				_tmp34_ = _tmp33_;
				result = (const gchar*) _tmp34_;
				_g_free0 (e);
				_g_object_unref0 (email);
				_g_object_unref0 (_email_it);
				return result;
			}
			_g_free0 (e);
			_g_object_unref0 (email);
		}
		_g_object_unref0 (_email_it);
	}
	result = "";
	return result;
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_;
	gunichar _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


gunichar contacts_contact_get_initial_letter (ContactsContact* self) {
	gunichar result;
	gchar* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gunichar _tmp7_;
	gunichar _tmp8_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = contacts_contact_get_display_name (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		result = (gunichar) 0;
		_g_free0 (name);
		return result;
	}
	_tmp6_ = name;
	_tmp7_ = string_get_char (_tmp6_, (glong) 0);
	_tmp8_ = g_unichar_totitle (_tmp7_);
	result = _tmp8_;
	_g_free0 (name);
	return result;
}


gboolean contacts_contact_get_is_hidden (ContactsContact* self) {
	gboolean result;
	gboolean _tmp0_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_hidden_uptodate;
	if (!_tmp0_) {
		gboolean _tmp1_;
		_tmp1_ = _contacts_contact_get_is_hidden (self);
		self->priv->_is_hidden = _tmp1_;
		self->priv->_is_hidden_uptodate = TRUE;
	}
	_tmp2_ = self->priv->_is_hidden;
	result = _tmp2_;
	return result;
}


static ContactsContactImData* contacts_contact_im_data_dup (const ContactsContactImData* self) {
	ContactsContactImData* dup;
	dup = g_new0 (ContactsContactImData, 1);
	memcpy (dup, self, sizeof (ContactsContactImData));
	return dup;
}


static void contacts_contact_im_data_free (ContactsContactImData* self) {
	g_free (self);
}


static GType contacts_contact_im_data_get_type (void) {
	static volatile gsize contacts_contact_im_data_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_im_data_type_id__volatile)) {
		GType contacts_contact_im_data_type_id;
		contacts_contact_im_data_type_id = g_boxed_type_register_static ("ContactsContactImData", (GBoxedCopyFunc) contacts_contact_im_data_dup, (GBoxedFreeFunc) contacts_contact_im_data_free);
		g_once_init_leave (&contacts_contact_im_data_type_id__volatile, contacts_contact_im_data_type_id);
	}
	return contacts_contact_im_data_type_id__volatile;
}


static void contacts_contact_class_init (ContactsContactClass * klass) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	contacts_contact_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsContactPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_contact_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_contact_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_SMALL_AVATAR, g_param_spec_object ("small-avatar", "small-avatar", "small-avatar", gdk_pixbuf_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_AVATAR_ICON_DATA, g_param_spec_variant ("avatar-icon-data", "avatar-icon-data", "avatar-icon-data", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_INITIAL_LETTER, g_param_spec_uint ("initial-letter", "initial-letter", "initial-letter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CONTACT_IS_HIDDEN, g_param_spec_boolean ("is-hidden", "is-hidden", "is-hidden", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	contacts_contact_signals[CONTACTS_CONTACT_CHANGED_SIGNAL] = g_signal_new ("changed", CONTACTS_TYPE_CONTACT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	contacts_contact_signals[CONTACTS_CONTACT_PERSONAS_CHANGED_SIGNAL] = g_signal_new ("personas_changed", CONTACTS_TYPE_CONTACT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_strdup ("email-addresses");
	_tmp1_ = g_strdup ("phone-numbers");
	_tmp2_ = g_strdup ("im-addresses");
	_tmp3_ = g_strdup ("urls");
	_tmp4_ = g_strdup ("nickname");
	_tmp5_ = g_strdup ("birthday");
	_tmp6_ = g_strdup ("notes");
	_tmp7_ = g_strdup ("postal-addresses");
	_tmp8_ = g_new0 (gchar*, 8 + 1);
	_tmp8_[0] = _tmp0_;
	_tmp8_[1] = _tmp1_;
	_tmp8_[2] = _tmp2_;
	_tmp8_[3] = _tmp3_;
	_tmp8_[4] = _tmp4_;
	_tmp8_[5] = _tmp5_;
	_tmp8_[6] = _tmp6_;
	_tmp8_[7] = _tmp7_;
	contacts_contact_sorted_properties = _tmp8_;
	contacts_contact_sorted_properties_length1 = 8;
}


static void contacts_contact_instance_init (ContactsContact * self) {
	self->priv = CONTACTS_CONTACT_GET_PRIVATE (self);
	self->fake_persona = NULL;
}


static void contacts_contact_finalize (GObject * obj) {
	ContactsContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CONTACT, ContactsContact);
	_g_object_unref0 (self->store);
	_g_object_unref0 (self->individual);
	_g_object_unref0 (self->fake_persona);
	_g_object_unref0 (self->priv->_small_avatar);
	_g_variant_unref0 (self->priv->_avatar_icon_data);
	_g_free0 (self->priv->filter_data);
	G_OBJECT_CLASS (contacts_contact_parent_class)->finalize (obj);
}


GType contacts_contact_get_type (void) {
	static volatile gsize contacts_contact_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_contact_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsContactClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_contact_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsContact), 0, (GInstanceInitFunc) contacts_contact_instance_init, NULL };
		GType contacts_contact_type_id;
		contacts_contact_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsContact", &g_define_type_info, 0);
		g_once_init_leave (&contacts_contact_type_id__volatile, contacts_contact_type_id);
	}
	return contacts_contact_type_id__volatile;
}


static void _vala_contacts_contact_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsContact * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CONTACT, ContactsContact);
	switch (property_id) {
		case CONTACTS_CONTACT_SMALL_AVATAR:
		g_value_set_object (value, contacts_contact_get_small_avatar (self));
		break;
		case CONTACTS_CONTACT_AVATAR_ICON_DATA:
		g_value_set_variant (value, contacts_contact_get_avatar_icon_data (self));
		break;
		case CONTACTS_CONTACT_DISPLAY_NAME:
		g_value_set_string (value, contacts_contact_get_display_name (self));
		break;
		case CONTACTS_CONTACT_INITIAL_LETTER:
		g_value_set_uint (value, contacts_contact_get_initial_letter (self));
		break;
		case CONTACTS_CONTACT_IS_HIDDEN:
		g_value_set_boolean (value, contacts_contact_get_is_hidden (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ContactsFakePersonaStore* contacts_fake_persona_store_the_store (void) {
	ContactsFakePersonaStore* result = NULL;
	ContactsFakePersonaStore* _tmp0_;
	ContactsFakePersonaStore* _tmp2_;
	ContactsFakePersonaStore* _tmp3_;
	_tmp0_ = contacts_fake_persona_store__the_store;
	if (_tmp0_ == NULL) {
		ContactsFakePersonaStore* _tmp1_;
		_tmp1_ = contacts_fake_persona_store_new ();
		_g_object_unref0 (contacts_fake_persona_store__the_store);
		contacts_fake_persona_store__the_store = _tmp1_;
	}
	_tmp2_ = contacts_fake_persona_store__the_store;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


ContactsFakePersonaStore* contacts_fake_persona_store_construct (GType object_type) {
	ContactsFakePersonaStore * self = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeMap* _tmp2_;
	GeeMap* _tmp3_;
	self = (ContactsFakePersonaStore*) g_object_new (object_type, "id", "uri", "display-name", "fake store", NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	return self;
}


ContactsFakePersonaStore* contacts_fake_persona_store_new (void) {
	return contacts_fake_persona_store_construct (CONTACTS_TYPE_FAKE_PERSONA_STORE);
}


static void contacts_fake_persona_store_real_prepare_data_free (gpointer _data) {
	ContactsFakePersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsFakePersonaStorePrepareData, _data_);
}


static void contacts_fake_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsFakePersonaStore * self;
	ContactsFakePersonaStorePrepareData* _data_;
	ContactsFakePersonaStore* _tmp0_;
	self = (ContactsFakePersonaStore*) base;
	_data_ = g_slice_new0 (ContactsFakePersonaStorePrepareData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_fake_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_fake_persona_store_real_prepare_co (_data_);
}


static void contacts_fake_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	ContactsFakePersonaStorePrepareData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean contacts_fake_persona_store_real_prepare_co (ContactsFakePersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_fake_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	ContactsFakePersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsFakePersonaStoreAddPersonaFromDetailsData, _data_);
}


static void contacts_fake_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsFakePersonaStore * self;
	ContactsFakePersonaStoreAddPersonaFromDetailsData* _data_;
	ContactsFakePersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self = (ContactsFakePersonaStore*) base;
	_data_ = g_slice_new0 (ContactsFakePersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_fake_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp2_;
	contacts_fake_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* contacts_fake_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsFakePersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean contacts_fake_persona_store_real_add_persona_from_details_co (ContactsFakePersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void contacts_fake_persona_store_real_remove_persona_data_free (gpointer _data) {
	ContactsFakePersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsFakePersonaStoreRemovePersonaData, _data_);
}


static void contacts_fake_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsFakePersonaStore * self;
	ContactsFakePersonaStoreRemovePersonaData* _data_;
	ContactsFakePersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	self = (ContactsFakePersonaStore*) base;
	_data_ = g_slice_new0 (ContactsFakePersonaStoreRemovePersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_fake_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	contacts_fake_persona_store_real_remove_persona_co (_data_);
}


static void contacts_fake_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	ContactsFakePersonaStoreRemovePersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}


static gboolean contacts_fake_persona_store_real_remove_persona_co (ContactsFakePersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* contacts_fake_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = "fake";
	return result;
}


static GeeMap* contacts_fake_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	ContactsFakePersonaStore* self;
	GeeMap* _tmp0_;
	self = (ContactsFakePersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool contacts_fake_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool contacts_fake_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool contacts_fake_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool contacts_fake_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static gboolean contacts_fake_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = TRUE;
	return result;
}


static gboolean contacts_fake_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	ContactsFakePersonaStore* self;
	self = (ContactsFakePersonaStore*) base;
	result = TRUE;
	return result;
}


static gchar** contacts_fake_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	ContactsFakePersonaStore* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (ContactsFakePersonaStore*) base;
	_tmp0_ = self->priv->_always_writeable_properties;
	_tmp0__length1 = self->priv->_always_writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static void contacts_fake_persona_store_class_init (ContactsFakePersonaStoreClass * klass) {
	contacts_fake_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsFakePersonaStorePrivate));
	((FolksPersonaStoreClass *) klass)->prepare = (void (*) (FolksPersonaStore *, GAsyncReadyCallback, gpointer)) contacts_fake_persona_store_real_prepare;
	((FolksPersonaStoreClass *) klass)->prepare_finish = (void (*) (FolksPersonaStore *, GAsyncResult*, GError**)) contacts_fake_persona_store_real_prepare_finish;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details = (void (*) (FolksPersonaStore *, GHashTable*, GAsyncReadyCallback, gpointer)) contacts_fake_persona_store_real_add_persona_from_details;
	((FolksPersonaStoreClass *) klass)->add_persona_from_details_finish = (FolksPersona* (*) (FolksPersonaStore *, GAsyncResult*, GError**)) contacts_fake_persona_store_real_add_persona_from_details_finish;
	((FolksPersonaStoreClass *) klass)->remove_persona = (void (*) (FolksPersonaStore *, FolksPersona*, GAsyncReadyCallback, gpointer)) contacts_fake_persona_store_real_remove_persona;
	((FolksPersonaStoreClass *) klass)->remove_persona_finish = (void (*) (FolksPersonaStore *, GAsyncResult*, GError**)) contacts_fake_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = contacts_fake_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = contacts_fake_persona_store_real_get_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = contacts_fake_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = contacts_fake_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = contacts_fake_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = contacts_fake_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = contacts_fake_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = contacts_fake_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = contacts_fake_persona_store_real_get_always_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_fake_persona_store_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_fake_persona_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void contacts_fake_persona_store_instance_init (ContactsFakePersonaStore * self) {
	gchar** _tmp0_;
	self->priv = CONTACTS_FAKE_PERSONA_STORE_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_always_writeable_properties = _tmp0_;
	self->priv->_always_writeable_properties_length1 = 0;
	self->priv->__always_writeable_properties_size_ = self->priv->_always_writeable_properties_length1;
}


static void contacts_fake_persona_store_finalize (GObject * obj) {
	ContactsFakePersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_FAKE_PERSONA_STORE, ContactsFakePersonaStore);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_always_writeable_properties = (_vala_array_free (self->priv->_always_writeable_properties, self->priv->_always_writeable_properties_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (contacts_fake_persona_store_parent_class)->finalize (obj);
}


GType contacts_fake_persona_store_get_type (void) {
	static volatile gsize contacts_fake_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_fake_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsFakePersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_fake_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsFakePersonaStore), 0, (GInstanceInitFunc) contacts_fake_persona_store_instance_init, NULL };
		GType contacts_fake_persona_store_type_id;
		contacts_fake_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "ContactsFakePersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&contacts_fake_persona_store_type_id__volatile, contacts_fake_persona_store_type_id);
	}
	return contacts_fake_persona_store_type_id__volatile;
}


static void _vala_contacts_fake_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsFakePersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_FAKE_PERSONA_STORE, ContactsFakePersonaStore);
	switch (property_id) {
		case CONTACTS_FAKE_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case CONTACTS_FAKE_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


ContactsFakePersona* contacts_fake_persona_maybe_create_for (ContactsContact* contact) {
	ContactsFakePersona* result = NULL;
	FolksPersona* primary_persona = NULL;
	ContactsContact* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	ContactsContact* _tmp29_;
	ContactsFakePersona* _tmp30_;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = contacts_contact_find_primary_persona (_tmp0_);
	primary_persona = _tmp1_;
	_tmp2_ = primary_persona;
	if (_tmp2_ != NULL) {
		result = NULL;
		_g_object_unref0 (primary_persona);
		return result;
	}
	{
		GeeIterator* _p_it = NULL;
		ContactsContact* _tmp3_;
		FolksIndividual* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		GeeIterator* _tmp7_;
		_tmp3_ = contact;
		_tmp4_ = _tmp3_->individual;
		_tmp5_ = folks_individual_get_personas (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_p_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_;
			FolksPersona* p = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			FolksPersona* _tmp14_;
			FolksPersonaStore* _tmp15_;
			FolksPersonaStore* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp8_ = _p_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _p_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			p = (FolksPersona*) _tmp11_;
			_tmp14_ = p;
			_tmp15_ = folks_persona_get_store (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = folks_persona_store_get_type_id (_tmp16_);
			_tmp18_ = _tmp17_;
			if (g_strcmp0 (_tmp18_, "eds") == 0) {
				FolksPersona* _tmp19_;
				FolksPersonaStore* _tmp20_;
				FolksPersonaStore* _tmp21_;
				FolksMaybeBool _tmp22_;
				FolksMaybeBool _tmp23_;
				_tmp19_ = p;
				_tmp20_ = folks_persona_get_store (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = folks_persona_store_get_can_add_personas (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp13_ = _tmp23_ == FOLKS_MAYBE_BOOL_TRUE;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				FolksPersona* _tmp24_;
				FolksPersonaStore* _tmp25_;
				FolksPersonaStore* _tmp26_;
				FolksMaybeBool _tmp27_;
				FolksMaybeBool _tmp28_;
				_tmp24_ = p;
				_tmp25_ = folks_persona_get_store (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = folks_persona_store_get_can_remove_personas (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp12_ = _tmp28_ == FOLKS_MAYBE_BOOL_TRUE;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = NULL;
				_g_object_unref0 (p);
				_g_object_unref0 (_p_it);
				_g_object_unref0 (primary_persona);
				return result;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	_tmp29_ = contact;
	_tmp30_ = contacts_fake_persona_new (_tmp29_);
	result = _tmp30_;
	_g_object_unref0 (primary_persona);
	return result;
}


static void contacts_fake_persona_make_real_and_set_data_free (gpointer _data) {
	ContactsFakePersonaMakeRealAndSetData* _data_;
	_data_ = _data;
	_g_free0 (_data_->property);
	G_IS_VALUE (&_data_->value) ? (g_value_unset (&_data_->value), NULL) : NULL;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsFakePersonaMakeRealAndSetData, _data_);
}


void contacts_fake_persona_make_real_and_set (ContactsFakePersona* self, const gchar* property, GValue* value, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ContactsFakePersonaMakeRealAndSetData* _data_;
	ContactsFakePersona* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GValue _tmp3_;
	GValue _tmp4_ = {0};
	_data_ = g_slice_new0 (ContactsFakePersonaMakeRealAndSetData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_fake_persona_make_real_and_set_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = property;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->property);
	_data_->property = _tmp2_;
	_tmp3_ = *value;
	if (G_IS_VALUE (&_tmp3_)) {
		g_value_init (&_tmp4_, G_VALUE_TYPE (&_tmp3_));
		g_value_copy (&_tmp3_, &_tmp4_);
	} else {
		_tmp4_ = _tmp3_;
	}
	G_IS_VALUE (&_data_->value) ? (g_value_unset (&_data_->value), NULL) : NULL;
	_data_->value = _tmp4_;
	contacts_fake_persona_make_real_and_set_co (_data_);
}


FolksPersona* contacts_fake_persona_make_real_and_set_finish (ContactsFakePersona* self, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	ContactsFakePersonaMakeRealAndSetData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void contacts_fake_persona_make_real_and_set_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ContactsFakePersonaMakeRealAndSetData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_fake_persona_make_real_and_set_co (_data_);
}


static gboolean contacts_fake_persona_make_real_and_set_co (ContactsFakePersonaMakeRealAndSetData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_fake_persona_prop_val_new ();
	_data_->v = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->v;
	_data_->_tmp2_ = _data_->property;
	_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
	_g_free0 (_data_->_tmp1_->property);
	_data_->_tmp1_->property = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->v;
	_data_->_tmp5_ = _data_->value;
	memset (&_data_->_tmp6_, 0, sizeof (GValue));
	if (G_IS_VALUE (&_data_->_tmp5_)) {
		g_value_init (&_data_->_tmp6_, G_VALUE_TYPE (&_data_->_tmp5_));
		g_value_copy (&_data_->_tmp5_, &_data_->_tmp6_);
	} else {
		_data_->_tmp6_ = _data_->_tmp5_;
	}
	G_IS_VALUE (&_data_->_tmp4_->value) ? (g_value_unset (&_data_->_tmp4_->value), NULL) : NULL;
	_data_->_tmp4_->value = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->property;
	if (g_strcmp0 (_data_->_tmp7_, "full-name") == 0) {
		_data_->self->priv->has_full_name = TRUE;
	}
	_data_->_tmp8_ = _data_->self->priv->prop_vals;
	if (_data_->_tmp8_ == NULL) {
		_data_->_tmp9_ = gee_array_list_new (CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL, (GBoxedCopyFunc) contacts_fake_persona_prop_val_ref, (GDestroyNotify) contacts_fake_persona_prop_val_unref, NULL, NULL, NULL);
		_g_object_unref0 (_data_->self->priv->prop_vals);
		_data_->self->priv->prop_vals = _data_->_tmp9_;
		_data_->_tmp10_ = _data_->self->priv->prop_vals;
		_data_->_tmp11_ = _data_->v;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp10_, _data_->_tmp11_);
		_data_->_tmp12_ = _data_->self->contact;
		_data_->_state_ = 1;
		contacts_contact_ensure_primary_persona (_data_->_tmp12_, contacts_fake_persona_make_real_and_set_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp13_ = contacts_contact_ensure_primary_persona_finish (_data_->_tmp12_, _data_->_res_, &_data_->_inner_error_);
		_data_->p = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			if (((_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error_);
				_contacts_fake_persona_prop_val_unref0 (_data_->v);
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_contacts_fake_persona_prop_val_unref0 (_data_->v);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
		_data_->_tmp14_ = _data_->self->priv->has_full_name;
		if (!_data_->_tmp14_) {
			_data_->_tmp15_ = _data_->p;
			_data_->_tmp16_ = _data_->self->contact;
			_data_->_tmp17_ = contacts_contact_get_display_name (_data_->_tmp16_);
			_data_->_tmp18_ = _data_->_tmp17_;
			g_object_set ((GObject*) _data_->_tmp15_, "full-name", _data_->_tmp18_, NULL);
		}
		{
			_data_->_tmp19_ = _data_->self->priv->prop_vals;
			_data_->_tmp20_ = _g_object_ref0 (_data_->_tmp19_);
			_data_->_pv_list = _data_->_tmp20_;
			_data_->_tmp21_ = _data_->_pv_list;
			_data_->_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data_->_tmp21_);
			_data_->_tmp23_ = _data_->_tmp22_;
			_data_->_pv_size = _data_->_tmp23_;
			_data_->_pv_index = -1;
			while (TRUE) {
				_data_->_tmp24_ = _data_->_pv_index;
				_data_->_pv_index = _data_->_tmp24_ + 1;
				_data_->_tmp25_ = _data_->_pv_index;
				_data_->_tmp26_ = _data_->_pv_size;
				if (!(_data_->_tmp25_ < _data_->_tmp26_)) {
					break;
				}
				_data_->_tmp27_ = _data_->_pv_list;
				_data_->_tmp28_ = _data_->_pv_index;
				_data_->_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _data_->_tmp27_, _data_->_tmp28_);
				_data_->pv = (ContactsFakePersonaPropVal*) _data_->_tmp29_;
				_data_->_tmp30_ = _data_->p;
				_data_->_tmp31_ = _data_->pv;
				_data_->_tmp32_ = _data_->_tmp31_->property;
				_data_->_tmp33_ = _data_->pv;
				_data_->_tmp34_ = _data_->_tmp33_->value;
				_data_->_state_ = 2;
				contacts_contact_set_persona_property (_data_->_tmp30_, _data_->_tmp32_, &_data_->_tmp34_, contacts_fake_persona_make_real_and_set_ready, _data_);
				return FALSE;
				_state_2:
				contacts_contact_set_persona_property_finish (_data_->_res_, &_data_->_inner_error_);
				if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
					if (((_data_->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) || (_data_->_inner_error_->domain == CONTACT_ERROR)) || (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR)) {
						g_task_return_error (_data_->_async_result, _data_->_inner_error_);
						_contacts_fake_persona_prop_val_unref0 (_data_->pv);
						_g_object_unref0 (_data_->_pv_list);
						_g_object_unref0 (_data_->p);
						_contacts_fake_persona_prop_val_unref0 (_data_->v);
						g_object_unref (_data_->_async_result);
						return FALSE;
					} else {
						_contacts_fake_persona_prop_val_unref0 (_data_->pv);
						_g_object_unref0 (_data_->_pv_list);
						_g_object_unref0 (_data_->p);
						_contacts_fake_persona_prop_val_unref0 (_data_->v);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
						g_clear_error (&_data_->_inner_error_);
						g_object_unref (_data_->_async_result);
						return FALSE;
					}
				}
				_contacts_fake_persona_prop_val_unref0 (_data_->pv);
			}
			_g_object_unref0 (_data_->_pv_list);
		}
		_data_->self->priv->now_real = TRUE;
		_data_->result = _data_->p;
		_contacts_fake_persona_prop_val_unref0 (_data_->v);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp35_ = _data_->self->priv->now_real;
		_vala_assert (!_data_->_tmp35_, "!now_real");
		_data_->_tmp36_ = _data_->self->priv->prop_vals;
		_data_->_tmp37_ = _data_->v;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp36_, _data_->_tmp37_);
		_data_->result = NULL;
		_contacts_fake_persona_prop_val_unref0 (_data_->v);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_contacts_fake_persona_prop_val_unref0 (_data_->v);
}


ContactsFakePersona* contacts_fake_persona_construct (GType object_type, ContactsContact* contact) {
	ContactsFakePersona * self = NULL;
	FolksPersonaStore* _tmp0_ = NULL;
	ContactsContact* _tmp1_;
	ContactsStore* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksPersonaStore* _tmp5_;
	FolksPersonaStore* _tmp6_;
	FolksPersonaStore* _tmp7_;
	FolksPersonaStore* _tmp9_;
	FolksPersonaStore* _tmp10_;
	ContactsContact* _tmp11_;
	ContactsContact* _tmp12_;
	ContactsContact* _tmp13_;
	FolksPersona* _tmp14_;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp1_ = contact;
	_tmp2_ = _tmp1_->store;
	_tmp3_ = contacts_store_get_aggregator (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = folks_individual_aggregator_get_primary_store (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_tmp0_ = _tmp7_;
	if (_tmp0_ == NULL) {
		ContactsFakePersonaStore* _tmp8_;
		_tmp8_ = contacts_fake_persona_store_the_store ();
		_g_object_unref0 (_tmp0_);
		_tmp0_ = (FolksPersonaStore*) _tmp8_;
	}
	_tmp9_ = _tmp0_;
	_tmp0_ = NULL;
	_tmp10_ = _tmp9_;
	self = (ContactsFakePersona*) g_object_new (object_type, "display-id", "display_id", "uid", "uid-fake-persona", "iid", "iid", "store", _tmp10_, "is-user", FALSE, NULL);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = contact;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->contact);
	self->contact = _tmp12_;
	_tmp13_ = self->contact;
	_tmp14_ = _g_object_ref0 ((FolksPersona*) self);
	_g_object_unref0 (_tmp13_->fake_persona);
	_tmp13_->fake_persona = _tmp14_;
	_g_object_unref0 (_tmp0_);
	return self;
}


ContactsFakePersona* contacts_fake_persona_new (ContactsContact* contact) {
	return contacts_fake_persona_construct (CONTACTS_TYPE_FAKE_PERSONA, contact);
}


static gchar** contacts_fake_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	ContactsFakePersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (ContactsFakePersona*) base;
	_tmp0_ = CONTACTS_FAKE_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (CONTACTS_FAKE_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** contacts_fake_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	ContactsFakePersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (ContactsFakePersona*) base;
	_tmp0_ = CONTACTS_FAKE_PERSONA__writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (CONTACTS_FAKE_PERSONA__writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static ContactsFakePersonaPropVal* contacts_fake_persona_prop_val_construct (GType object_type) {
	ContactsFakePersonaPropVal* self = NULL;
	self = (ContactsFakePersonaPropVal*) g_type_create_instance (object_type);
	return self;
}


static ContactsFakePersonaPropVal* contacts_fake_persona_prop_val_new (void) {
	return contacts_fake_persona_prop_val_construct (CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL);
}


static void contacts_fake_persona_value_prop_val_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void contacts_fake_persona_value_prop_val_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		contacts_fake_persona_prop_val_unref (value->data[0].v_pointer);
	}
}


static void contacts_fake_persona_value_prop_val_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = contacts_fake_persona_prop_val_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer contacts_fake_persona_value_prop_val_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* contacts_fake_persona_value_prop_val_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ContactsFakePersonaPropVal * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = contacts_fake_persona_prop_val_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* contacts_fake_persona_value_prop_val_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ContactsFakePersonaPropVal ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = contacts_fake_persona_prop_val_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* contacts_fake_persona_param_spec_prop_val (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ContactsFakePersonaParamSpecPropVal* spec;
	g_return_val_if_fail (g_type_is_a (object_type, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer contacts_fake_persona_value_get_prop_val (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL), NULL);
	return value->data[0].v_pointer;
}


static void contacts_fake_persona_value_set_prop_val (GValue* value, gpointer v_object) {
	ContactsFakePersonaPropVal * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		contacts_fake_persona_prop_val_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_fake_persona_prop_val_unref (old);
	}
}


static void contacts_fake_persona_value_take_prop_val (GValue* value, gpointer v_object) {
	ContactsFakePersonaPropVal * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		contacts_fake_persona_prop_val_unref (old);
	}
}


static void contacts_fake_persona_prop_val_class_init (ContactsFakePersonaPropValClass * klass) {
	contacts_fake_persona_prop_val_parent_class = g_type_class_peek_parent (klass);
	((ContactsFakePersonaPropValClass *) klass)->finalize = contacts_fake_persona_prop_val_finalize;
}


static void contacts_fake_persona_prop_val_instance_init (ContactsFakePersonaPropVal * self) {
	self->ref_count = 1;
}


static void contacts_fake_persona_prop_val_finalize (ContactsFakePersonaPropVal * obj) {
	ContactsFakePersonaPropVal * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_FAKE_PERSONA_TYPE_PROP_VAL, ContactsFakePersonaPropVal);
	g_signal_handlers_destroy (self);
	_g_free0 (self->property);
	G_IS_VALUE (&self->value) ? (g_value_unset (&self->value), NULL) : NULL;
}


static GType contacts_fake_persona_prop_val_get_type (void) {
	static volatile gsize contacts_fake_persona_prop_val_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_fake_persona_prop_val_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { contacts_fake_persona_value_prop_val_init, contacts_fake_persona_value_prop_val_free_value, contacts_fake_persona_value_prop_val_copy_value, contacts_fake_persona_value_prop_val_peek_pointer, "p", contacts_fake_persona_value_prop_val_collect_value, "p", contacts_fake_persona_value_prop_val_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ContactsFakePersonaPropValClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_fake_persona_prop_val_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsFakePersonaPropVal), 0, (GInstanceInitFunc) contacts_fake_persona_prop_val_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType contacts_fake_persona_prop_val_type_id;
		contacts_fake_persona_prop_val_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ContactsFakePersonaPropVal", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&contacts_fake_persona_prop_val_type_id__volatile, contacts_fake_persona_prop_val_type_id);
	}
	return contacts_fake_persona_prop_val_type_id__volatile;
}


static gpointer contacts_fake_persona_prop_val_ref (gpointer instance) {
	ContactsFakePersonaPropVal * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void contacts_fake_persona_prop_val_unref (gpointer instance) {
	ContactsFakePersonaPropVal * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONTACTS_FAKE_PERSONA_PROP_VAL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void contacts_fake_persona_class_init (ContactsFakePersonaClass * klass) {
	contacts_fake_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsFakePersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = contacts_fake_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = contacts_fake_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_fake_persona_get_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_fake_persona_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_LINKABLE_PROPERTIES, g_param_spec_boxed ("linkable-properties", "linkable-properties", "linkable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_FAKE_PERSONA_WRITEABLE_PROPERTIES, g_param_spec_boxed ("writeable-properties", "writeable-properties", "writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void contacts_fake_persona_instance_init (ContactsFakePersona * self) {
	self->priv = CONTACTS_FAKE_PERSONA_GET_PRIVATE (self);
}


static void contacts_fake_persona_finalize (GObject * obj) {
	ContactsFakePersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_FAKE_PERSONA, ContactsFakePersona);
	_g_object_unref0 (self->contact);
	_g_object_unref0 (self->priv->prop_vals);
	G_OBJECT_CLASS (contacts_fake_persona_parent_class)->finalize (obj);
}


GType contacts_fake_persona_get_type (void) {
	static volatile gsize contacts_fake_persona_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_fake_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsFakePersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_fake_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsFakePersona), 0, (GInstanceInitFunc) contacts_fake_persona_instance_init, NULL };
		GType contacts_fake_persona_type_id;
		contacts_fake_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "ContactsFakePersona", &g_define_type_info, 0);
		g_once_init_leave (&contacts_fake_persona_type_id__volatile, contacts_fake_persona_type_id);
	}
	return contacts_fake_persona_type_id__volatile;
}


static void _vala_contacts_fake_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ContactsFakePersona * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_FAKE_PERSONA, ContactsFakePersona);
	switch (property_id) {
		case CONTACTS_FAKE_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case CONTACTS_FAKE_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



